/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.datatypes;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.math.BigDecimal;
import org.hl7.fhir.r4.model.SimpleQuantity;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.UnitCode;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;

@DatatypeDef(name="ChEmedQuantityWithEmedUnits", isSpecialization=true, profileOf=SimpleQuantity.class)
public class ChEmedQuantityWithEmedUnits
extends SimpleQuantity {
    @ExpectsValidResource
    public UnitCode resolveUnitCode() throws InvalidEmedContentException {
        if (!this.hasCode()) {
            throw new InvalidEmedContentException("The coded form of the unit is missing.");
        }
        UnitCode unitCode = UnitCode.getEnum((String)this.getCode());
        if (unitCode != null) {
            return unitCode;
        }
        throw new InvalidEmedContentException("The coded form of the unit is invalid.");
    }

    @ExpectsValidResource
    public BigDecimal resolveQuantity() throws InvalidEmedContentException {
        if (!this.hasValue()) {
            throw new InvalidEmedContentException("The quantity is missing.");
        }
        return this.getValue();
    }

    public ChEmedQuantityWithEmedUnits setUnitCode(UnitCode unitCode) {
        this.setSystem(unitCode.getCodeSystemId()).setCode(unitCode.getCodeValue()).setUnit(unitCode.getDisplayName());
        return this;
    }

    public ChEmedQuantityWithEmedUnits setQuantity(BigDecimal quantity) {
        this.setValue(quantity);
        return this;
    }

    public boolean hasQuantity() {
        return this.hasValue();
    }

    public ChEmedQuantityWithEmedUnits copy() {
        ChEmedQuantityWithEmedUnits copy = new ChEmedQuantityWithEmedUnits();
        this.copyValues(copy);
        return copy;
    }
}

