/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.datatypes;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.RouteOfAdministrationEdqm;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedQuantityWithEmedUnits;
import org.projecthusky.fhir.emed.ch.epr.enums.TimingEventAmbu;
import org.projecthusky.fhir.emed.ch.epr.model.common.AmountPerDuration;
import org.projecthusky.fhir.emed.ch.epr.model.common.AmountQuantity;
import org.projecthusky.fhir.emed.ch.epr.model.common.Dose;
import org.projecthusky.fhir.emed.ch.epr.model.common.Duration;

@DatatypeDef(name="Dosage", isSpecialization=true, profileOf=Dosage.class)
public class ChEmedEprDosage
extends Dosage {
    @ExpectsValidResource
    public List<TimingEventAmbu> resolveWhen() throws InvalidEmedContentException {
        Timing.TimingRepeatComponent repeat = this.getTiming().getRepeat();
        if (!repeat.hasWhen()) {
            return Collections.emptyList();
        }
        ArrayList<TimingEventAmbu> eventTimings = new ArrayList<TimingEventAmbu>(repeat.getWhen().size());
        for (Enumeration event : repeat.getWhen()) {
            TimingEventAmbu eventTiming = TimingEventAmbu.getEnum(event.getCode());
            if (eventTiming == null) {
                throw new InvalidEmedContentException("The event timing '" + event.getCode() + "' is invalid.");
            }
            eventTimings.add(eventTiming);
        }
        return eventTimings;
    }

    @ExpectsValidResource
    public @Nullable RouteOfAdministrationEdqm resolveRouteOfAdministration() throws InvalidEmedContentException {
        if (!this.hasRoute()) {
            return null;
        }
        for (Coding coding : this.getRoute().getCoding()) {
            RouteOfAdministrationEdqm routeOfAdministration = RouteOfAdministrationEdqm.getEnum((Coding)coding);
            if (routeOfAdministration == null) continue;
            return routeOfAdministration;
        }
        throw new InvalidEmedContentException("The route of administration is invalid.");
    }

    @ExpectsValidResource
    public @Nullable Dose resolveDose() throws InvalidEmedContentException {
        if (!this.hasDoseAndRate()) {
            return null;
        }
        return Dose.fromQuantityAndRange(this.getDoseAndRateFirstRep().getDoseQuantity(), this.getDoseAndRateFirstRep().getRateRange());
    }

    public boolean isAsNeeded() {
        if (this.hasAsNeededBooleanType()) {
            return this.getAsNeededBooleanType().booleanValue();
        }
        return this.hasAsNeededCodeableConcept();
    }

    public Period getBoundsPeriod() {
        return this.getTiming().getRepeat().getBoundsPeriod();
    }

    @ExpectsValidResource
    public @Nullable Duration resolveBoundsDuration() {
        if (!this.getTiming().getRepeat().hasBoundsDuration()) {
            return null;
        }
        return Duration.fromQuantity((Quantity)this.getTiming().getRepeat().getBoundsDuration());
    }

    public ChEmedEprDosage setPatientInstruction(String patientInstruction) {
        super.setPatientInstruction(patientInstruction);
        return this;
    }

    public ChEmedEprDosage setBoundsPeriod(Period boundsPeriod) {
        this.getTiming().getRepeat().setBounds((Type)boundsPeriod);
        return this;
    }

    public ChEmedEprDosage setRouteOfAdministration(RouteOfAdministrationEdqm routeOfAdministration) {
        this.getRoute().getCodingFirstRep().setSystem("urn:oid:" + routeOfAdministration.getCodeSystemId()).setCode(routeOfAdministration.getCodeValue()).setDisplay(routeOfAdministration.getDisplayName());
        return this;
    }

    public ChEmedEprDosage setDoseQuantity(ChEmedQuantityWithEmedUnits doseQuantity) {
        this.getDoseAndRateFirstRep().setDose((Type)doseQuantity);
        return this;
    }

    public ChEmedEprDosage setDoseRange(ChEmedQuantityWithEmedUnits doseRange) {
        this.getDoseAndRateFirstRep().setDose((Type)doseRange);
        return this;
    }

    public ChEmedEprDosage addWhen(TimingEventAmbu timing) {
        this.getTiming().getRepeat().addWhen(Timing.EventTiming.fromCode((String)timing.getCodeValue()));
        return this;
    }

    public boolean hasWhen() {
        return this.getTiming().getRepeat().hasWhen();
    }

    public boolean hasBoundsPeriod() {
        return this.getTiming().getRepeat().hasBoundsPeriod();
    }

    public @Nullable Instant getInclusiveStartTime() {
        if (!this.hasBoundsPeriod()) {
            return null;
        }
        Period boundsPeriod = this.getBoundsPeriod();
        if (!boundsPeriod.hasStart()) {
            return null;
        }
        return boundsPeriod.getStart().toInstant();
    }

    public @Nullable Instant getInclusiveEndTime() {
        if (!this.hasBoundsPeriod()) {
            return null;
        }
        Period boundsPeriod = this.getBoundsPeriod();
        if (!boundsPeriod.hasEnd()) {
            return null;
        }
        Hl7Dtm dtm = Hl7Dtm.fromHl7((String)boundsPeriod.getEndElement().getAsV3());
        dtm = DateTimes.completeToLatestInstant((Hl7Dtm)dtm);
        return dtm.toInstant();
    }

    public @Nullable String getSiteText() {
        if (!this.hasSite()) {
            return null;
        }
        if (this.getSite().hasText()) {
            return this.getSite().getText();
        }
        for (Coding code : this.getSite().getCoding()) {
            if (!code.hasDisplay()) continue;
            return code.getDisplay();
        }
        return null;
    }

    @ExpectsValidResource
    public @Nullable AmountPerDuration resolveMaxDosePerPeriod() {
        if (!this.hasMaxDosePerPeriod()) {
            return null;
        }
        return AmountPerDuration.fromRatio(this.getMaxDosePerPeriod());
    }

    @ExpectsValidResource
    public @Nullable AmountQuantity resolveMaxDosePerAdministration() {
        if (!this.hasMaxDosePerAdministration()) {
            return null;
        }
        return AmountQuantity.fromQuantity(this.getMaxDosePerAdministration());
    }

    public ChEmedEprDosage copy() {
        ChEmedEprDosage copy = new ChEmedEprDosage();
        this.copyValues(copy);
        return copy;
    }
}

