/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Identifier;

public class Identifiers {
    private Identifiers() {
    }

    public static @Nullable Identifier getBySystem(List<Identifier> identifiers, String system) {
        for (Identifier identifier : identifiers) {
            if (!system.equals(identifier.getSystem())) continue;
            return identifier;
        }
        return null;
    }

    public static @Nullable String getValueBySystem(List<Identifier> identifiers, String system) {
        Identifier identifier = Identifiers.getBySystem(identifiers, system);
        if (identifier == null || identifier.getValue() == null) {
            return null;
        }
        return identifier.getValue();
    }

    public static Identifier setValueBySystem(List<Identifier> identifiers, String system, String value) {
        Identifier identifier = Identifiers.getBySystem(identifiers, system);
        if (identifier == null) {
            identifier = new Identifier();
            identifier.setSystem(system);
            identifiers.add(identifier);
        }
        identifier.setValue(value);
        return identifier;
    }

    public static List<Identifier> findBySystem(List<Identifier> identifiers, String system) {
        ArrayList<Identifier> foundIdentifiers = new ArrayList<Identifier>(0);
        for (Identifier identifier : identifiers) {
            if (!system.equals(identifier.getSystem())) continue;
            foundIdentifiers.add(identifier);
        }
        return foundIdentifiers;
    }

    public static Identifier fromUuid(UUID uuid) {
        Identifier identifier = new Identifier();
        identifier.setValue("urn:uuid:" + uuid.toString());
        identifier.setSystem("urn:ietf:rfc:3986");
        return identifier;
    }

    public static Identifier fromOid(String oid) {
        Identifier identifier = new Identifier();
        identifier.setValue("urn:oid:" + oid);
        identifier.setSystem("urn:ietf:rfc:3986");
        return identifier;
    }
}

