/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.util;

import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.BaseDateTimeType;

public class FhirDateTimes {
    private FhirDateTimes() {
    }

    public static @Nullable Instant completeToLatestInstant(BaseDateTimeType dateTime) {
        GregorianCalendar calendar = Objects.requireNonNull(dateTime).getValueAsCalendar();
        if (calendar == null) {
            return null;
        }
        switch (dateTime.getPrecision()) {
            case YEAR: {
                calendar.set(2, calendar.getActualMaximum(2));
            }
            case MONTH: {
                calendar.set(5, calendar.getActualMaximum(5));
            }
            case DAY: {
                calendar.set(11, calendar.getActualMaximum(11));
                calendar.set(12, calendar.getActualMaximum(12));
            }
            case MINUTE: {
                calendar.set(13, calendar.getActualMaximum(13));
            }
            case SECOND: {
                calendar.set(14, calendar.getActualMaximum(14));
            }
        }
        return calendar.toInstant();
    }
}

