/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.resource;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.util.Identifiers;

@ResourceDef(profile="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-organization")
public class ChEmedOrganization
extends Organization {
    public @Nullable String resolveBer() {
        return Identifiers.getValueBySystem(this.getIdentifier(), "urn:oid:2.16.756.5.45");
    }

    public @Nullable String resolveUidb() {
        return Identifiers.getValueBySystem(this.getIdentifier(), "urn:oid:2.16.756.5.35");
    }

    public @Nullable String resolveZsr() {
        return Identifiers.getValueBySystem(this.getIdentifier(), "urn:oid:2.16.756.5.30.1.123.100.2.1.1");
    }

    public @Nullable String resolveGln() {
        return Identifiers.getValueBySystem(this.getIdentifier(), "urn:oid:2.51.1.3");
    }

    @ExpectsValidResource
    public Address resolveAddress() throws InvalidEmedContentException {
        if (!this.hasAddress()) {
            throw new InvalidEmedContentException("The organization's address is missing.");
        }
        return (Address)this.getAddress().get(0);
    }

    public boolean hasBer() {
        return this.resolveBer() != null;
    }

    public boolean hasUidb() {
        return this.resolveUidb() != null;
    }

    public boolean hasZsr() {
        return this.resolveZsr() != null;
    }

    public boolean hasGln() {
        return this.resolveGln() != null;
    }

    public boolean hasAddress() {
        return !this.getAddress().isEmpty();
    }

    public Identifier setBer(String ber) {
        return Identifiers.setValueBySystem(this.getIdentifier(), "urn:oid:2.16.756.5.45", ber);
    }

    public Identifier setUidb(String uidb) {
        return Identifiers.setValueBySystem(this.getIdentifier(), "urn:oid:2.16.756.5.35", uidb);
    }

    public Identifier setZsr(String zsr) {
        return Identifiers.setValueBySystem(this.getIdentifier(), "urn:oid:2.16.756.5.30.1.123.100.2.1.1", zsr);
    }

    public Identifier setGln(String gln) {
        return Identifiers.setValueBySystem(this.getIdentifier(), "urn:oid:2.51.1.3", gln);
    }

    public ChEmedOrganization setAddress(Address address) {
        if (this.hasAddress()) {
            this.getAddress().set(0, address);
        } else {
            this.addAddress(address);
        }
        return this;
    }

    public ChEmedOrganization copy() {
        ChEmedOrganization copy = new ChEmedOrganization();
        this.copyValues(copy);
        return copy;
    }
}

