/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.resource;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.BaseDateTimeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.UriType;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.ReligiousAffiliation;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.util.FhirDateTimes;

@ResourceDef(profile="http://fhir.ch/ig/ch-core/StructureDefinition/ch-core-patient-epr")
public class ChCorePatientEpr
extends Patient {
    public static final String LOCAL_PID_TYPE_SYSTEM = "http://terminology.hl7.org/CodeSystem/v2-0203";
    public static final String LOCAL_PID_TYPE_VALUE = "MR";
    @Child(name="religion")
    @Extension(url="http://hl7.org/fhir/StructureDefinition/patient-religion", definedLocally=false)
    protected @Nullable CodeableConcept religion;

    @ExpectsValidResource
    public HumanName resolveName() {
        if (this.hasName()) {
            return (HumanName)this.name.get(0);
        }
        throw new InvalidEmedContentException("The human name is missing");
    }

    @ExpectsValidResource
    public @Nullable Address resolveAddress() {
        if (this.hasAddress()) {
            return (Address)this.address.get(0);
        }
        return null;
    }

    @ExpectsValidResource
    public Enumerations.AdministrativeGender resolveGender() throws InvalidEmedContentException {
        if (!this.hasGender()) {
            throw new InvalidEmedContentException("The gender is not available.");
        }
        return this.getGender();
    }

    public @Nullable ReligiousAffiliation resolveReligion() {
        if (!this.hasReligion()) {
            return null;
        }
        return ReligiousAffiliation.getEnum(this.religion.getCodingFirstRep().getCode());
    }

    public List<Identifier> getLocalIds() throws InvalidEmedContentException {
        return this.getIdentifier().stream().filter(identifier -> identifier.getType() != null && !identifier.getType().getCoding().isEmpty()).filter(identifier -> !identifier.getType().getCodingFirstRep().getSystem().equals(LOCAL_PID_TYPE_SYSTEM)).filter(identifier -> !identifier.getType().getCodingFirstRep().getCode().equals(LOCAL_PID_TYPE_VALUE)).toList();
    }

    @ExpectsValidResource
    public LocalDate resolveBirthDate() throws InvalidEmedContentException {
        if (!this.hasBirthDate()) {
            throw new InvalidEmedContentException("The birthdate is missing.");
        }
        return LocalDate.ofInstant(this.getBirthDate().toInstant(), ZoneId.systemDefault());
    }

    public ChCorePatientEpr setReligion(ReligiousAffiliation religion) {
        OidType system = UriType.fromOid((String)religion.getCodeSystemId());
        Coding coding = new Coding().setCode(religion.getCodeValue()).setSystemElement((UriType)system).setDisplay(religion.getDisplayName());
        this.religion = new CodeableConcept(coding);
        return this;
    }

    public ChCorePatientEpr setBirthDate(LocalDate birthDate) {
        Date date = Date.from(birthDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        super.setBirthDate(date);
        return this;
    }

    public boolean hasReligion() {
        return this.religion != null && !this.religion.isEmpty();
    }

    public Identifier addIdentifier(String system, String value) {
        Coding codingType = new Coding().setSystem(LOCAL_PID_TYPE_SYSTEM).setCode(LOCAL_PID_TYPE_VALUE);
        return this.addIdentifier().setType(new CodeableConcept(codingType)).setSystem(system).setValue(value);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Patient.PatientCommunicationComponent resolveLanguageOfCorrespondence() {
        return this.getCommunication().stream().filter(com -> com != null && com.getPreferred()).findAny().orElse(null);
    }

    public List<@NonNull ContactPoint> resolveEmailAddresses() {
        return this.resolveTelecom(ContactPoint.ContactPointSystem.EMAIL);
    }

    public List<@NonNull String> resolveEmailAddressesAsStrings() {
        return this.resolveEmailAddressesAsStrings(false);
    }

    public List<@NonNull String> resolveEmailAddressesAsStrings(boolean activeOnly) {
        return this.resolveTelecomAsStrings(ContactPoint.ContactPointSystem.EMAIL, activeOnly);
    }

    public List<@NonNull ContactPoint> resolvePhoneNumbers() {
        return this.resolveTelecom(ContactPoint.ContactPointSystem.PHONE);
    }

    public List<@NonNull String> resolvePhoneNumbersAsStrings() {
        return this.resolvePhoneNumbersAsStrings(false);
    }

    public List<@NonNull String> resolvePhoneNumbersAsStrings(boolean activeOnly) {
        return this.resolveTelecomAsStrings(ContactPoint.ContactPointSystem.PHONE, activeOnly);
    }

    private List<@NonNull String> resolveTelecomAsStrings(ContactPoint.ContactPointSystem system, boolean activeOnly) {
        return this.resolveTelecom(system).stream().filter(telecom -> {
            if (!telecom.hasValue()) return false;
            if (!activeOnly) return true;
            if (!telecom.hasPeriod() || !telecom.getPeriod().hasStart() && !telecom.getPeriod().hasEnd()) return true;
            if (telecom.getPeriod().hasStart() && telecom.getPeriod().getStartElement().getValueAsCalendar().after(Calendar.getInstance())) {
                return false;
            }
            if (!telecom.getPeriod().hasEnd() || !FhirDateTimes.completeToLatestInstant((BaseDateTimeType)telecom.getPeriod().getEndElement()).isBefore(Instant.now())) return false;
            return false;
        }).map(ContactPoint::getValue).toList();
    }

    private List<@NonNull ContactPoint> resolveTelecom(ContactPoint.ContactPointSystem system) {
        return this.getTelecom().stream().filter(telecom -> telecom.getSystem() == system).toList();
    }

    public ChCorePatientEpr copy() {
        ChCorePatientEpr copy = new ChCorePatientEpr();
        this.copyValues(copy);
        return copy;
    }

    public void copyValues(Patient dst) {
        super.copyValues(dst);
        if (dst instanceof ChCorePatientEpr) {
            ChCorePatientEpr als = (ChCorePatientEpr)dst;
            als.religion = this.religion == null ? null : this.religion.copy();
        }
    }
}

