/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum UnitCode implements ValueSetEnumInterface,
FhirValueSetEnumInterface
{
    A("a", "http://unitsofmeasure.org", "Year", "a", "a", "a", "a"),
    ACTUATION("732981002", "http://snomed.info/sct", "Actuation (unit of presentation)", "Actuation", "Hub", "bouff\u00e9e", "erogazione"),
    AMPULE("732978007", "http://snomed.info/sct", "Ampule (unit of presentation)", "Ampule", "Ampulle", "ampoule", "fiala"),
    APPLICATION_UNIT_OF_PRODUCT_USAGE_QUALIFIER_VALUE("413568008", "http://snomed.info/sct", "Application - unit of product usage (qualifier value)", "Application - unit of product usage (qualifier value)", "Application - unit of product usage (qualifier value)", "Application - unit of product usage (qualifier value)", "Application - unit of product usage (qualifier value)"),
    APPLICATOR("732980001", "http://snomed.info/sct", "Applicator (unit of presentation)", "Applicator", "Applikator", "applicateur", "applicatore"),
    BAG("732982009", "http://snomed.info/sct", "Bag (unit of presentation)", "Bag", "Tasche", "sac", "sacca"),
    BARREL("732983004", "http://snomed.info/sct", "Barrel (unit of presentation)", "Barrel", "Kanister", "f\u00fbt", "fusto"),
    BLISTER("732984005", "http://snomed.info/sct", "Blister (unit of presentation)", "Blister", "Blisterpackung", "plaquette", "blister"),
    BLOCK("732985006", "http://snomed.info/sct", "Block (unit of presentation)", "Block", "Block", "bloc", "blocco"),
    BOTTLE("732986007", "http://snomed.info/sct", "Bottle (unit of presentation)", "Bottle", "Flasche", "flacon", "flacone"),
    BQ("Bq", "http://unitsofmeasure.org", "Becquerel", "Bq", "Bq", "Bq", "Bq"),
    CACHET("732987003", "http://snomed.info/sct", "Cachet (unit of presentation)", "Cachet", "Oblatenkapsel", "cachet", "cachet"),
    CAPSULE("732937005", "http://snomed.info/sct", "Capsule (unit of presentation)", "Capsule", "Kapsel", "capsule", "capsula"),
    CARTRIDGE("732988008", "http://snomed.info/sct", "Cartridge (unit of presentation)", "Cartridge", "Patrone", "cartouche", "cartuccia"),
    CFU("[CFU]", "http://unitsofmeasure.org", "Colony Forming Units", "CFU", "CFU", "CFU", "CFU"),
    CHEWING_GUM("732989000", "http://snomed.info/sct", "Chewing gum (unit of presentation)", "Chewing gum", "Kaugummi", "gomme \u00e0 m\u00e2cher", "gomma da masticare"),
    CM("cm", "http://unitsofmeasure.org", "centimeter", "cm", "cm", "cm", "cm"),
    CM2("cm2", "http://unitsofmeasure.org", "square centimeter", "cm2", "cm2", "cm2", "cm2"),
    CM3("cm3", "http://unitsofmeasure.org", "cubic centimeter", "cm3", "cm3", "cm3", "cm3"),
    CONTAINER("732990009", "http://snomed.info/sct", "Container (unit of presentation)", "Container", "Beh\u00e4ltnis", "r\u00e9cipient", "contenitore"),
    CUP("732991008", "http://snomed.info/sct", "Cup (unit of presentation)", "Cup", "Messbecher", "godet", "bicchiere dosatore"),
    CYLINDER("732992001", "http://snomed.info/sct", "Cylinder (unit of presentation)", "Cylinder", "Zylinder", "cylindre", "cilindro"),
    D("d", "http://unitsofmeasure.org", "Day", "d", "d", "d", "d"),
    DOSE("408102007", "http://snomed.info/sct", "Dose", "Dose", "Dos", "dose", "dose"),
    DRESSING("732993006", "http://snomed.info/sct", "Dressing (unit of presentation)", "Dressing", "Verband", "compresse", "garza"),
    DROP("732994000", "http://snomed.info/sct", "Drop (unit of presentation)", "Drop", "Tropfen", "goutte", "goccia"),
    FILM("732995004", "http://snomed.info/sct", "Film (unit of presentation)", "Film", "Film", "film", "film"),
    G("g", "http://unitsofmeasure.org", "gram", "g", "g", "g", "g"),
    GBQ("GBq", "http://unitsofmeasure.org", "gigaBecquerel", "GBq", "GBq", "GBq", "GBq"),
    H("h", "http://unitsofmeasure.org", "Hour", "h", "h", "h", "h"),
    IMPLANT("732996003", "http://snomed.info/sct", "Implant (unit of presentation)", "Implant", "Implantat", "implant", "impianto"),
    INHALER("732997007", "http://snomed.info/sct", "Inhaler (unit of presentation)", "Inhaler", "Inhalator", "inhalateur", "inalatore"),
    INSERT("732998002", "http://snomed.info/sct", "Insert (unit of presentation)", "Insert", "Insert", "insert", "inserto"),
    INTERNATIONAL_UNIT("[iU]", "http://unitsofmeasure.org", "international unit", "international unit", "Internationale Einheit", "unit\u00e9(s) internationale(s)", "unit\u00e0 internazionale(i)"),
    JAR("732999005", "http://snomed.info/sct", "Jar (unit of presentation)", "Jar", "Weithalsgef\u00e4ss", "pot", "vasetto"),
    KBQ("kBq", "http://unitsofmeasure.org", "kiloBecquerel", "kBq", "kBq", "kBq", "kBq"),
    KCAL("kcal", "http://unitsofmeasure.org", "kilocalorie", "kcal", "kcal", "kcal", "kcal"),
    KG("kg", "http://unitsofmeasure.org", "kilogram", "kg", "kg", "kg", "kg"),
    KJ("kJ", "http://unitsofmeasure.org", "kilojoule", "kJ", "kJ", "kJ", "kJ"),
    LT("L", "http://unitsofmeasure.org", "liter", "lt", "lt", "lt", "l"),
    LYOPHILISATE("733001005", "http://snomed.info/sct", "Lyophilisate (unit of presentation)", "Lyophilisate", "Lyophilisat", "lyophilisat", "liofilizzato"),
    MATRIX("733002003", "http://snomed.info/sct", "Matrix (unit of presentation)", "Matrix", "Matrix", "matrice", "matrice"),
    MBQ("MBq", "http://unitsofmeasure.org", "megaBecquerel", "MBq", "MBq", "MBq", "MBq"),
    MEQ("meq", "http://unitsofmeasure.org", "milliequivalent", "meq", "meq", "mEq", "mEq"),
    MG("mg", "http://unitsofmeasure.org", "milligram", "mg", "mg", "mg", "mg"),
    MILLIONINTERNATIONALUNIT("10*6.[iU]", "http://unitsofmeasure.org", "MillionInternationalUnit", "MillionInternationalUnit", "MioUI", "MioUI", "MioUI"),
    MIN("min", "http://unitsofmeasure.org", "Minute", "min", "min", "min", "min"),
    MIOU("396186001", "http://snomed.info/sct", "(the number ten for arbitrary powers ^ 6) * Unit", "MioU", "MioU", "MioU", "MioU"),
    ML("mL", "http://unitsofmeasure.org", "milliliter", "ml", "ml", "ml", "ml"),
    MM2("mm2", "http://unitsofmeasure.org", "square millimeter", "mm2", "mm2", "mm2", "mm2"),
    MMOL("mmol", "http://unitsofmeasure.org", "millimole", "mmol", "mmol", "mmol", "mmol"),
    MO("mo", "http://unitsofmeasure.org", "Month", "mo", "mo", "mo", "mo"),
    MOL("mol", "http://unitsofmeasure.org", "mole", "mol", "mol", "mol", "mol"),
    NG("ng", "http://unitsofmeasure.org", "nanogram", "ng", "ng", "ng", "ng"),
    NL("nL", "http://unitsofmeasure.org", "nanoliter", "nl", "nl", "nl", "nl"),
    NMOL("nmol", "http://unitsofmeasure.org", "nanomole", "nmol", "nmol", "nmol", "nmol"),
    PACKAGE("1681000175101", "http://snomed.info/sct", "Package", "Package", "Packung", "emballage", "confezione"),
    PAD("733003008", "http://snomed.info/sct", "Pad (unit of presentation)", "Pad", "Pad", "tampon applicateur", "tampone"),
    PASTILLE("733004002", "http://snomed.info/sct", "Pastille (unit of presentation)", "Pastille", "Pastille", "pastille molle", "pastiglia molle"),
    PATCH("733005001", "http://snomed.info/sct", "Patch (unit of presentation)", "Patch", "Patch", "patch", "cerotto"),
    PEN("733006000", "http://snomed.info/sct", "Pen (unit of presentation)", "Pen", "Pen", "stylo", "penna"),
    PERCENT("%", "http://unitsofmeasure.org", "percent", "%", "%", "%", "%"),
    PESSARY("733007009", "http://snomed.info/sct", "Pessary (unit of presentation)", "Pessary", "Pessar", "ovule", "ovulo"),
    PIECE("246205007", "http://snomed.info/sct", "Quantity (attribute)", "Piece(s)", "Stk", "pce", "pz"),
    PILLULE("733008004", "http://snomed.info/sct", "Pillule (unit of presentation)", "Pillule", "Streuk\u00fcgelchen", "granule", "granuli"),
    PIPETTE("733009007", "http://snomed.info/sct", "Pipette (unit of presentation)", "Pipette", "Pipette", "pipette", "pipetta"),
    PLASTER("733010002", "http://snomed.info/sct", "Plaster (unit of presentation)", "Plaster", "Pflaster", "empl\u00e2tre", "cerotto"),
    PLUG("733011003", "http://snomed.info/sct", "Plug (unit of presentation)", "Plug", "Einsatz", "support poreux", "supporto"),
    POUCH("733012005", "http://snomed.info/sct", "Pouch (unit of presentation)", "Pouch", "Beutelchen", "pochette", "sachetta"),
    PPM("[ppm]", "http://unitsofmeasure.org", "Parts Per Million", "ppm", "ppm", "ppm", "ppm"),
    SACHET("733013000", "http://snomed.info/sct", "Sachet (unit of presentation)", "Sachet", "Beutel", "sachet", "bustina"),
    SEC("s", "http://unitsofmeasure.org", "Second", "sec", "sec", "sec", "sec"),
    SPONGE("733014006", "http://snomed.info/sct", "Sponge (unit of presentation)", "Sponge", "Schw\u00e4mmchen", "eponge", "spugna"),
    SPOONFUL("733015007", "http://snomed.info/sct", "Spoonful (unit of presentation)", "Spoonful", "ein L\u00f6ffel voll", "cuiller\u00e9e", "cucciaio"),
    STICK("733016008", "http://snomed.info/sct", "Stick (unit of presentation)", "Stick", "St\u00e4bchen", "b\u00e2ton", "stick"),
    STRAW("733017004", "http://snomed.info/sct", "Straw (unit of presentation)", "Straw", "Trinkhalm", "paille", "cannuccia"),
    STRIP("733018009", "http://snomed.info/sct", "Strip (unit of presentation)", "Strip", "Streifen", "bandelette", "strip"),
    SUPPOSITORY("733019001", "http://snomed.info/sct", "Suppository (unit of presentation)", "Suppository", "Z\u00e4pfchen", "suppositoire", "supposta"),
    SYRINGE("733020007", "http://snomed.info/sct", "Syringe (unit of presentation)", "Syringe", "Spritze", "seringue", "siringa"),
    SYSTEM("733021006", "http://snomed.info/sct", "System (unit of presentation)", "System", "System", "syst\u00e8me", "sistema"),
    TABLESPOON_METRIC("[tbs_m]", "http://unitsofmeasure.org", "tablespoon - metric", "tablespoon - metric", "Essl\u00f6ffel", "c. \u00e0 soupe", "cucchiaio da minestra"),
    TABLET("732936001", "http://snomed.info/sct", "Tablet (unit of presentation)", "Tablet", "Tablette", "comprim\u00e9", "compressa"),
    TAMPON("733022004", "http://snomed.info/sct", "Tampon (unit of presentation)", "Tampon", "Tampon", "tampon diffuseur", "tampone"),
    TEASPOON_METRIC("[tsp_m]", "http://unitsofmeasure.org", "teaspoon - metric", "teaspoon - metric", "Teel\u00f6ffel", "c. \u00e0 caf\u00e9", "cucchiaino da caff\u00e8"),
    THOUSAND_PER_STAR_UNIT("2011000175108", "http://snomed.info/sct", "Thousand Per * Unit", "Thousand Per * Unit", "Tausend Einheiten", "millier d'unit\u00e9s", "mille per unit\u00e0 *"),
    THREAD("733023009", "http://snomed.info/sct", "Thread (unit of presentation)", "Thread", "Faden", "fil", "filo"),
    TUBE("733024003", "http://snomed.info/sct", "Tube (unit of presentation)", "Tube", "Tube", "tube", "tubo"),
    UG("ug", "http://unitsofmeasure.org", "microgram", "\u00b5g", "\u00b5g", "\u00b5g", "\u00b5g"),
    UL("uL", "http://unitsofmeasure.org", "microliter", "\u00b5l", "\u00b5l", "\u00b5l", "\u00b5l"),
    UMOL("umol", "http://unitsofmeasure.org", "micromole", "\u00b5mol", "\u00b5mol", "\u00b5mol", "\u00b5mol"),
    UNIT("767525000", "http://snomed.info/sct", "Unit", "unit", "Einheit", "unit\u00e9(s)", "unit\u00e0"),
    VESSEL("733025002", "http://snomed.info/sct", "Vessel (unit of presentation)", "Vessel", "Gef\u00e4ss", "r\u00e9cipient \u00e9tanche", "recipiente a tenuta"),
    VIAL("733026001", "http://snomed.info/sct", "Vial (unit of presentation)", "Vial", "Durchstechflasche", "petit flacon", "flaconcino");

    public static final String A_CODE = "a";
    public static final String ACTUATION_CODE = "732981002";
    public static final String AMPULE_CODE = "732978007";
    public static final String APPLICATION_UNIT_OF_PRODUCT_USAGE_QUALIFIER_VALUE_CODE = "413568008";
    public static final String APPLICATOR_CODE = "732980001";
    public static final String BAG_CODE = "732982009";
    public static final String BARREL_CODE = "732983004";
    public static final String BLISTER_CODE = "732984005";
    public static final String BLOCK_CODE = "732985006";
    public static final String BOTTLE_CODE = "732986007";
    public static final String BQ_CODE = "Bq";
    public static final String CACHET_CODE = "732987003";
    public static final String CAPSULE_CODE = "732937005";
    public static final String CARTRIDGE_CODE = "732988008";
    public static final String CFU_CODE = "[CFU]";
    public static final String CHEWING_GUM_CODE = "732989000";
    public static final String CM_CODE = "cm";
    public static final String CM2_CODE = "cm2";
    public static final String CM3_CODE = "cm3";
    public static final String CONTAINER_CODE = "732990009";
    public static final String CUP_CODE = "732991008";
    public static final String CYLINDER_CODE = "732992001";
    public static final String D_CODE = "d";
    public static final String DOSE_CODE = "408102007";
    public static final String DRESSING_CODE = "732993006";
    public static final String DROP_CODE = "732994000";
    public static final String FILM_CODE = "732995004";
    public static final String G_CODE = "g";
    public static final String GBQ_CODE = "GBq";
    public static final String H_CODE = "h";
    public static final String IMPLANT_CODE = "732996003";
    public static final String INHALER_CODE = "732997007";
    public static final String INSERT_CODE = "732998002";
    public static final String INTERNATIONAL_UNIT_CODE = "[iU]";
    public static final String JAR_CODE = "732999005";
    public static final String KBQ_CODE = "kBq";
    public static final String KCAL_CODE = "kcal";
    public static final String KG_CODE = "kg";
    public static final String KJ_CODE = "kJ";
    public static final String LT_CODE = "L";
    public static final String LYOPHILISATE_CODE = "733001005";
    public static final String MATRIX_CODE = "733002003";
    public static final String MBQ_CODE = "MBq";
    public static final String MEQ_CODE = "meq";
    public static final String MG_CODE = "mg";
    public static final String MILLIONINTERNATIONALUNIT_CODE = "10*6.[iU]";
    public static final String MIN_CODE = "min";
    public static final String MIOU_CODE = "396186001";
    public static final String ML_CODE = "mL";
    public static final String MM2_CODE = "mm2";
    public static final String MMOL_CODE = "mmol";
    public static final String MO_CODE = "mo";
    public static final String MOL_CODE = "mol";
    public static final String NG_CODE = "ng";
    public static final String NL_CODE = "nL";
    public static final String NMOL_CODE = "nmol";
    public static final String PACKAGE_CODE = "1681000175101";
    public static final String PAD_CODE = "733003008";
    public static final String PASTILLE_CODE = "733004002";
    public static final String PATCH_CODE = "733005001";
    public static final String PEN_CODE = "733006000";
    public static final String PERCENT_CODE = "%";
    public static final String PESSARY_CODE = "733007009";
    public static final String PIECE_CODE = "246205007";
    public static final String PILLULE_CODE = "733008004";
    public static final String PIPETTE_CODE = "733009007";
    public static final String PLASTER_CODE = "733010002";
    public static final String PLUG_CODE = "733011003";
    public static final String POUCH_CODE = "733012005";
    public static final String PPM_CODE = "[ppm]";
    public static final String SACHET_CODE = "733013000";
    public static final String SEC_CODE = "s";
    public static final String SPONGE_CODE = "733014006";
    public static final String SPOONFUL_CODE = "733015007";
    public static final String STICK_CODE = "733016008";
    public static final String STRAW_CODE = "733017004";
    public static final String STRIP_CODE = "733018009";
    public static final String SUPPOSITORY_CODE = "733019001";
    public static final String SYRINGE_CODE = "733020007";
    public static final String SYSTEM_CODE = "733021006";
    public static final String TABLESPOON_METRIC_CODE = "[tbs_m]";
    public static final String TABLET_CODE = "732936001";
    public static final String TAMPON_CODE = "733022004";
    public static final String TEASPOON_METRIC_CODE = "[tsp_m]";
    public static final String THOUSAND_PER_STAR_UNIT_CODE = "2011000175108";
    public static final String THREAD_CODE = "733023009";
    public static final String TUBE_CODE = "733024003";
    public static final String UG_CODE = "ug";
    public static final String UL_CODE = "uL";
    public static final String UMOL_CODE = "umol";
    public static final String UNIT_CODE = "767525000";
    public static final String VESSEL_CODE = "733025002";
    public static final String VIAL_CODE = "733026001";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.1.11.83";
    public static final String VALUE_SET_NAME = "UnitCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    private UnitCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }

    public @NonNull String getFhirSystem() {
        if (this.getCodeSystemId().startsWith("http")) {
            return this.getCodeSystemId();
        }
        return "urn:oid:" + this.getCodeSystemId();
    }

    public @NonNull Coding getCoding() {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.displayNames[0]);
    }

    public @NonNull CodeableConcept getCodeableConcept() {
        return new CodeableConcept().setText(this.displayNames[0]).addCoding(this.getCoding());
    }

    public @NonNull Coding getCoding(LanguageCode languageCode) {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.getDisplayName(languageCode));
    }

    public @NonNull CodeableConcept getCodeableConcept(LanguageCode languageCode) {
        return new CodeableConcept().setText(this.getDisplayName(languageCode)).addCoding(this.getCoding(languageCode));
    }

    public boolean isEqualTo(Coding coding) {
        return this.getFhirSystem().equals(coding.getSystem()) && this.getCodeValue().equals(coding.getCode());
    }

    public static @Nullable UnitCode getEnum(@Nullable String code) {
        for (UnitCode x : UnitCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(UnitCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (UnitCode x : UnitCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable UnitCode getEnum(@Nullable Coding coding) {
        for (UnitCode x : UnitCode.values()) {
            if (!x.isEqualTo(coding)) continue;
            return x;
        }
        return null;
    }

    public static boolean isInValueSet(@Nullable Coding coding) {
        for (UnitCode x : UnitCode.values()) {
            if (!x.isEqualTo(coding)) continue;
            return true;
        }
        return false;
    }
}

