/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum RouteOfAdministrationEdqm implements ValueSetEnumInterface,
FhirValueSetEnumInterface
{
    AURICULAR_USE("20001000", "0.4.0.127.0.16.1.1.2.1", "Auricular use", "Auricular use", "Anwendung am Ohr", "Voie auriculaire", "Uso auricolare"),
    BUCCAL_USE("20002500", "0.4.0.127.0.16.1.1.2.1", "Buccal use", "Buccal use", "Buccale Anwendung", "Voie buccogingivale", "Somministrazione buccale"),
    CUTANEOUS_USE("20003000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous use", "Cutaneous use", "Anwendung auf der Haut", "Voie cutan\u00e9e", "Uso cutaneo"),
    DENTAL_USE("20004000", "0.4.0.127.0.16.1.1.2.1", "Dental use", "Dental use", "dentale Anwendung", "Voie dentaire", "Uso dentale"),
    ENDOCERVICAL_USE("20006000", "0.4.0.127.0.16.1.1.2.1", "Endocervical use", "Endocervical use", "endozervikale Anwendung", "Voie endocervicale", "Uso endocervicale"),
    ENDOSINUSIAL_USE("20007000", "0.4.0.127.0.16.1.1.2.1", "Endosinusial use", "Endosinusial use", "Anwendung in den Nebenh\u00f6hlen", "Voie endosinusale", "Uso endosinusiale"),
    ENDOTRACHEOPULMONARY_USE("20008000", "0.4.0.127.0.16.1.1.2.1", "Endotracheopulmonary use", "Endotracheopulmonary use", "endotracheopulmonale Anwendung", "Voie endotrach\u00e9obronchique", "Uso endotracheobronchiale"),
    EPIDURAL_USE("20009000", "0.4.0.127.0.16.1.1.2.1", "Epidural use", "Epidural use", "epidurale Anwendung", "Voie p\u00e9ridurale", "Uso epidurale"),
    EPILESIONAL_USE("20010000", "0.4.0.127.0.16.1.1.2.1", "Epilesional use", "Epilesional use", "zum Auftragen auf die Wunde", "Voie \u00e9pil\u00e9sionnelle", "Uso epilesionale"),
    EXTRAAMNIOTIC_USE("20011000", "0.4.0.127.0.16.1.1.2.1", "Extraamniotic use", "Extraamniotic use", "extraamniotische Anwendung", "Voie extra-amniotique", "Uso extra-amniotico"),
    EXTRACORPOREAL_USE("20011500", "0.4.0.127.0.16.1.1.2.1", "Extracorporeal use", "Extracorporeal use", "extrakorporale Anwendung", "Voie extracorporelle", "Uso extracorporeo"),
    EXTRAPLEURAL_USE("20087000", "0.4.0.127.0.16.1.1.2.1", "Extrapleural use", "Extrapleural use", "extrapleurale Anwendung", "voie extrapleural", "uso extrapleurico"),
    GASTRIC_USE("20013500", "0.4.0.127.0.16.1.1.2.1", "Gastric use", "Gastric use", "zur Anwendung mittels Magensonde", "Voie gastrique", "Uso gastrico"),
    GASTROENTERAL_USE("20013000", "0.4.0.127.0.16.1.1.2.1", "Gastroenteral use", "Gastroenteral use", "gastrointestinale Anwendung", "Voie gastro-ent\u00e9rale", "Uso gastrointestinale"),
    GINGIVAL_USE("20014000", "0.4.0.127.0.16.1.1.2.1", "Gingival use", "Gingival use", "Anwendung am Zahnfleisch", "Voie gingivale", "Uso gengivale"),
    HAEMODIALYSIS("20015000", "0.4.0.127.0.16.1.1.2.1", "Haemodialysis", "Haemodialysis", "H\u00e4modialyse", "H\u00e9modialyse", "Emodialisi"),
    IMPLANTATION("20015500", "0.4.0.127.0.16.1.1.2.1", "Implantation", "Implantation", "zur Implantation", "Implantation", "Impianto"),
    INFILTRATION("20019500", "0.4.0.127.0.16.1.1.2.1", "Infiltration", "Infiltration", "Infiltration", "Infiltration", "Infiltrazione"),
    INHALATION_USE("20020000", "0.4.0.127.0.16.1.1.2.1", "Inhalation use", "Inhalation use", "zur Inhalation", "Voie inhal\u00e9e", "Uso inalatorio"),
    INTESTINAL_USE("20021000", "0.4.0.127.0.16.1.1.2.1", "Intestinal use", "Intestinal use", "intestinale Anwendung", "Voie intestinale", "Uso intestinale"),
    INTRAAMNIOTIC_USE("20022000", "0.4.0.127.0.16.1.1.2.1", "Intraamniotic use", "Intraamniotic use", "intraamniotische Anwendung", "Voie intraamniotique", "Uso intra-amniotico"),
    INTRAARTERIAL_USE("20023000", "0.4.0.127.0.16.1.1.2.1", "Intraarterial use", "Intraarterial use", "intraarterielle Anwendung", "Voie intraart\u00e9rielle", "Uso endoarterioso"),
    INTRAARTICULAR_USE("20024000", "0.4.0.127.0.16.1.1.2.1", "Intraarticular use", "Intraarticular use", "intraartikul\u00e4re Anwendung", "Voie intraarticulaire", "Uso intra-articolare"),
    INTRABURSAL_USE("20025000", "0.4.0.127.0.16.1.1.2.1", "Intrabursal use", "Intrabursal use", "intrabursale Anwendung", "Voie intrabursale", "Uso intrabursale"),
    INTRACAMERAL_USE("20025500", "0.4.0.127.0.16.1.1.2.1", "Intracameral use", "Intracameral use", "intrakamerale Anwendung", "Voie intracam\u00e9rulaire", "Uso intracamerale"),
    INTRACARDIAC_USE("20026000", "0.4.0.127.0.16.1.1.2.1", "Intracardiac use", "Intracardiac use", "intracardiale Anwendung", "Voie intracardiaque", "Uso intracardiaco"),
    INTRACARTILAGINOUS_USE("20026500", "0.4.0.127.0.16.1.1.2.1", "Intracartilaginous use", "Intracartilaginous use", "intrakartilagin\u00e4re Anwendung", "Voie intracartilagineuse", "Uso intracartilagineo"),
    INTRACAVERNOUS_USE("20027000", "0.4.0.127.0.16.1.1.2.1", "Intracavernous use", "Intracavernous use", "intrakavern\u00f6se Anwendung", "Voie intracaverneuse", "Uso intracavernoso"),
    INTRACEREBRAL_USE("20027010", "0.4.0.127.0.16.1.1.2.1", "Intracerebral use", "Intracerebral use", "Intrazerebrale Anwendung", "Voie intrac\u00e9r\u00e9brale", "Uso intracerebrale"),
    INTRACEREBROVENTRICULAR_USE("20080000", "0.4.0.127.0.16.1.1.2.1", "Intracerebroventricular use", "Intracerebroventricular use", "intracerebroventrikul\u00e4re Anwendung", "Voie intrac\u00e9r\u00e9broventriculaire", "Uso intracerebroventricolare"),
    INTRACERVICAL_USE("20028000", "0.4.0.127.0.16.1.1.2.1", "Intracervical use", "Intracervical use", "intrazervikale Anwendung", "Voie intracervicale", "Uso intracervicale"),
    INTRACHOLANGIOPANCREATIC_USE("20028300", "0.4.0.127.0.16.1.1.2.1", "Intracholangiopancreatic use", "Intracholangiopancreatic use", "zur Anwendung in der Cholangiopankreatikographie", "Voie intracholangiopancr\u00e9atique", "Uso intracolangiopancreatico"),
    INTRACISTERNAL_USE("20028500", "0.4.0.127.0.16.1.1.2.1", "Intracisternal use", "Intracisternal use", "intracisternale Anwendung", "Voie intracisternale", "Uso intracisternale"),
    INTRACORNEAL_USE("20084000", "0.4.0.127.0.16.1.1.2.1", "Intracorneal use", "Intracorneal use", "intracorneale Anwendung", "Voie intracorn\u00e9enne", "Uso intracorneale"),
    INTRACORONARY_USE("20029000", "0.4.0.127.0.16.1.1.2.1", "Intracoronary use", "Intracoronary use", "intrakoronare Anwendung", "Voie intracoronaire", "Uso intracoronarico"),
    INTRADERMAL_USE("20030000", "0.4.0.127.0.16.1.1.2.1", "Intradermal use", "Intradermal use", "intradermale Anwendung", "Voie intradermique", "Uso intradermico"),
    INTRADISCAL_USE("20031000", "0.4.0.127.0.16.1.1.2.1", "Intradiscal use", "Intradiscal use", "intradiskale Anwendung", "Voie intradiscale", "Uso intradiscale"),
    INTRAEPIDERMAL_USE("20031500", "0.4.0.127.0.16.1.1.2.1", "Intraepidermal use", "Intraepidermal use", "intraepidermale Anwendung", "Voie intra\u00e9pidermique", "Uso intraepidermico"),
    INTRAGLANDULAR_USE("20031700", "0.4.0.127.0.16.1.1.2.1", "Intraglandular use", "Intraglandular use", "intraglandul\u00e4re Anwendung", "Voie intraglandulaire", "Uso intraghiandolare"),
    INTRALESIONAL_USE("20032000", "0.4.0.127.0.16.1.1.2.1", "Intralesional use", "Intralesional use", "intral\u00e4sionale Anwendung", "Voie intral\u00e9sionnelle", "Uso intralesionale"),
    INTRALYMPHATIC_USE("20033000", "0.4.0.127.0.16.1.1.2.1", "Intralymphatic use", "Intralymphatic use", "intralymphatische Anwendung", "Voie intralymphatique", "Uso intralinfatico"),
    INTRAMUSCULAR_USE("20035000", "0.4.0.127.0.16.1.1.2.1", "Intramuscular use", "Intramuscular use", "intramuskul\u00e4re Anwendung", "Voie intramusculaire", "Uso intramuscolare"),
    INTRAOCULAR_USE("20036000", "0.4.0.127.0.16.1.1.2.1", "Intraocular use", "Intraocular use", "intraokulare Anwendung", "Voie intraoculaire", "Uso intraoculare"),
    INTRAOSSEOUS_USE("20036500", "0.4.0.127.0.16.1.1.2.1", "Intraosseous use", "Intraosseous use", "intraoss\u00e4re Anwendung", "Voie intraosseuse", "Uso intraosseo"),
    INTRAPERICARDIAL_USE("20037000", "0.4.0.127.0.16.1.1.2.1", "Intrapericardial use", "Intrapericardial use", "Intraperikardial", "Voie intrap\u00e9ricardiaque", "Uso intrapericardico"),
    INTRAPERITONEAL_USE("20038000", "0.4.0.127.0.16.1.1.2.1", "Intraperitoneal use", "Intraperitoneal use", "intraperitoneale Anwendung", "Voie intrap\u00e9riton\u00e9ale", "Uso intraperitoneale"),
    INTRAPLEURAL_USE("20039000", "0.4.0.127.0.16.1.1.2.1", "Intrapleural use", "Intrapleural use", "intrapleurale Anwendung", "Voie intrapleurale", "Uso intrapleurico"),
    INTRAPORTAL_USE("20039200", "0.4.0.127.0.16.1.1.2.1", "Intraportal use", "Intraportal use", "intraportale Anwendung", "Voie intraportale", "Uso intraportale"),
    INTRAPROSTATIC_USE("20039500", "0.4.0.127.0.16.1.1.2.1", "Intraprostatic use", "Intraprostatic use", "intraprostatische Anwendung", "Voie intraprostatique", "Uso intraprostatico"),
    INTRAPUTAMINAL_USE("20086000", "0.4.0.127.0.16.1.1.2.1", "Intraputaminal use", "Intraputaminal use", "Intraputaminale Anwendung", "null", "Intraputaminale"),
    INTRASTERNAL_USE("20041000", "0.4.0.127.0.16.1.1.2.1", "Intrasternal use", "Intrasternal use", "intrasternale Anwendung", "Voie intrasternale", "Uso intrasternale"),
    INTRATHECAL_USE("20042000", "0.4.0.127.0.16.1.1.2.1", "Intrathecal use", "Intrathecal use", "intrathekale Anwendung", "Voie intrath\u00e9cale", "Uso intratecale"),
    INTRATUMORAL_USE("20043000", "0.4.0.127.0.16.1.1.2.1", "Intratumoral use", "Intratumoral use", "intratumorale Anwendung", "Voie intratumorale", "Uso intratumorale"),
    INTRAUTERINE_USE("20044000", "0.4.0.127.0.16.1.1.2.1", "Intrauterine use", "Intrauterine use", "intrauterine Anwendung", "Voie intra-ut\u00e9rine", "Uso intrauterino"),
    INTRAVENOUS_USE("20045000", "0.4.0.127.0.16.1.1.2.1", "Intravenous use", "Intravenous use", "intraven\u00f6se Anwendung", "Voie intraveineuse", "Uso endovenoso"),
    INTRAVESICAL_USE("20046000", "0.4.0.127.0.16.1.1.2.1", "Intravesical use", "Intravesical use", "intravesikale Anwendung", "Voie intrav\u00e9sicale", "Uso endovescicale"),
    INTRAVITREAL_USE("20047000", "0.4.0.127.0.16.1.1.2.1", "Intravitreal use", "Intravitreal use", "Intravitreal", "Voie intravitr\u00e9enne", "Uso intravitreo"),
    IONTOPHORESIS("20047500", "0.4.0.127.0.16.1.1.2.1", "Iontophoresis", "Iontophoresis", "zur Iontophorese", "Iontophor\u00e8se", "Iontoforesi"),
    LARYNGOPHARYNGEAL_USE("20048000", "0.4.0.127.0.16.1.1.2.1", "Laryngopharyngeal use", "Laryngopharyngeal use", "zur Anwendung im Rachen und am Kehlkopf", "Voie laryngopharyng\u00e9e", "Uso laringofaringeo"),
    NASAL_USE("20049000", "0.4.0.127.0.16.1.1.2.1", "Nasal use", "Nasal use", "nasale Anwendung", "Voie nasale", "Uso nasale"),
    OCULAR_USE("20051000", "0.4.0.127.0.16.1.1.2.1", "Ocular use", "Ocular use", "Anwendung am Auge", "Voie ophtalmique", "Uso oftalmico"),
    ORAL_USE("20053000", "0.4.0.127.0.16.1.1.2.1", "Oral use", "Oral use", "zum Einnehmen", "Voie orale", "Uso orale"),
    OROMUCOSAL_USE("20054000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal use", "Oromucosal use", "Anwendung in der Mundh\u00f6hle", "Voie buccale", "Per mucosa orale"),
    OROPHARYNGEAL_USE("20055000", "0.4.0.127.0.16.1.1.2.1", "Oropharyngeal use", "Oropharyngeal use", "zur Anwendung im Mund- und Rachenraum", "Voie oropharyng\u00e9e", "Uso orofaringeo"),
    PERIARTICULAR_USE("20057000", "0.4.0.127.0.16.1.1.2.1", "Periarticular use", "Periarticular use", "periartikul\u00e4re Anwendung", "Voie p\u00e9riarticulaire", "Uso periarticolare"),
    PERINEURAL_USE("20058000", "0.4.0.127.0.16.1.1.2.1", "Perineural use", "Perineural use", "perineurale Anwendung", "Voie p\u00e9rineurale", "Uso perineurale"),
    PERIODONTAL_USE("20059000", "0.4.0.127.0.16.1.1.2.1", "Periodontal use", "Periodontal use", "zur periodontalen Anwendung", "Voie p\u00e9riodontale", "Uso periodontale"),
    PERIOSSEOUS_USE("20059300", "0.4.0.127.0.16.1.1.2.1", "Periosseous use", "Periosseous use", "perioss\u00e4re Anwendung", "Voie p\u00e9riosseuse", "Uso periosseo"),
    PERITUMORAL_USE("20059400", "0.4.0.127.0.16.1.1.2.1", "Peritumoral use", "Peritumoral use", "peritumorale Anwendung", "Voie p\u00e9ritumorale", "Uso peritumorale"),
    POSTERIOR_JUXTASCLERAL_USE("20059500", "0.4.0.127.0.16.1.1.2.1", "Posterior juxtascleral use", "Posterior juxtascleral use", "posteriore juxtasclerale Anwendung", "Voie juxta-scl\u00e9rale post\u00e9rieure", "Uso iuxtasclerale posteriore"),
    RECTAL_USE("20061000", "0.4.0.127.0.16.1.1.2.1", "Rectal use", "Rectal use", "rektale Anwendung", "Voie rectale", "Uso rettale"),
    RETROBULBAR_USE("20061500", "0.4.0.127.0.16.1.1.2.1", "Retrobulbar use", "Retrobulbar use", "retrobulb\u00e4re Anwendung", "Voie r\u00e9trobulbaire", "Uso retrobulbare"),
    ROUTE_OF_ADMINISTRATION_NOT_APPLICABLE("20062000", "0.4.0.127.0.16.1.1.2.1", "Route of administration not applicable", "Route of administration not applicable", "Art der Anwendung nicht spezifizierbar", "Autre(s)", "Via di somministrazione non specificabile"),
    SKIN_SCARIFICATION("20063000", "0.4.0.127.0.16.1.1.2.1", "Skin scarification", "Skin scarification", "Einritzen der Haut", "Scarification", "Scarificazione"),
    SUBCONJUNCTIVAL_USE("20065000", "0.4.0.127.0.16.1.1.2.1", "Subconjunctival use", "Subconjunctival use", "subkonjunktivale Anwendung", "Voie sous-conjonctivale", "Uso subcongiuntivale"),
    SUBCUTANEOUS_USE("20066000", "0.4.0.127.0.16.1.1.2.1", "Subcutaneous use", "Subcutaneous use", "subkutane Anwendung", "Voie sous-cutan\u00e9e", "Uso sottocutaneo"),
    SUBLINGUAL_USE("20067000", "0.4.0.127.0.16.1.1.2.1", "Sublingual use", "Sublingual use", "Sublingual", "Voie sublinguale", "Uso sublinguale"),
    SUBMUCOSAL_USE("20067500", "0.4.0.127.0.16.1.1.2.1", "Submucosal use", "Submucosal use", "submuk\u00f6se Anwendung", "Voie sous-muqueuse", "Uso sottomucosale"),
    SUBRETINAL_USE("20081000", "0.4.0.127.0.16.1.1.2.1", "Subretinal use", "Subretinal use", "subretinale Anwendung", "Voie subr\u00e9tinale", "Uso sottoretinico"),
    TRANSDERMAL_USE("20070000", "0.4.0.127.0.16.1.1.2.1", "Transdermal use", "Transdermal use", "transdermale Anwendung", "Voie transdermique", "Uso transdermico"),
    URETHRAL_USE("20071000", "0.4.0.127.0.16.1.1.2.1", "Urethral use", "Urethral use", "Anwendung in der Harnr\u00f6hre", "Voie ur\u00e9trale", "Uso uretrale"),
    VAGINAL_USE("20072000", "0.4.0.127.0.16.1.1.2.1", "Vaginal use", "Vaginal use", "vaginale Anwendung", "Voie vaginale", "Uso vaginale");

    public static final String AURICULAR_USE_CODE = "20001000";
    public static final String BUCCAL_USE_CODE = "20002500";
    public static final String CUTANEOUS_USE_CODE = "20003000";
    public static final String DENTAL_USE_CODE = "20004000";
    public static final String ENDOCERVICAL_USE_CODE = "20006000";
    public static final String ENDOSINUSIAL_USE_CODE = "20007000";
    public static final String ENDOTRACHEOPULMONARY_USE_CODE = "20008000";
    public static final String EPIDURAL_USE_CODE = "20009000";
    public static final String EPILESIONAL_USE_CODE = "20010000";
    public static final String EXTRAAMNIOTIC_USE_CODE = "20011000";
    public static final String EXTRACORPOREAL_USE_CODE = "20011500";
    public static final String EXTRAPLEURAL_USE_CODE = "20087000";
    public static final String GASTRIC_USE_CODE = "20013500";
    public static final String GASTROENTERAL_USE_CODE = "20013000";
    public static final String GINGIVAL_USE_CODE = "20014000";
    public static final String HAEMODIALYSIS_CODE = "20015000";
    public static final String IMPLANTATION_CODE = "20015500";
    public static final String INFILTRATION_CODE = "20019500";
    public static final String INHALATION_USE_CODE = "20020000";
    public static final String INTESTINAL_USE_CODE = "20021000";
    public static final String INTRAAMNIOTIC_USE_CODE = "20022000";
    public static final String INTRAARTERIAL_USE_CODE = "20023000";
    public static final String INTRAARTICULAR_USE_CODE = "20024000";
    public static final String INTRABURSAL_USE_CODE = "20025000";
    public static final String INTRACAMERAL_USE_CODE = "20025500";
    public static final String INTRACARDIAC_USE_CODE = "20026000";
    public static final String INTRACARTILAGINOUS_USE_CODE = "20026500";
    public static final String INTRACAVERNOUS_USE_CODE = "20027000";
    public static final String INTRACEREBRAL_USE_CODE = "20027010";
    public static final String INTRACEREBROVENTRICULAR_USE_CODE = "20080000";
    public static final String INTRACERVICAL_USE_CODE = "20028000";
    public static final String INTRACHOLANGIOPANCREATIC_USE_CODE = "20028300";
    public static final String INTRACISTERNAL_USE_CODE = "20028500";
    public static final String INTRACORNEAL_USE_CODE = "20084000";
    public static final String INTRACORONARY_USE_CODE = "20029000";
    public static final String INTRADERMAL_USE_CODE = "20030000";
    public static final String INTRADISCAL_USE_CODE = "20031000";
    public static final String INTRAEPIDERMAL_USE_CODE = "20031500";
    public static final String INTRAGLANDULAR_USE_CODE = "20031700";
    public static final String INTRALESIONAL_USE_CODE = "20032000";
    public static final String INTRALYMPHATIC_USE_CODE = "20033000";
    public static final String INTRAMUSCULAR_USE_CODE = "20035000";
    public static final String INTRAOCULAR_USE_CODE = "20036000";
    public static final String INTRAOSSEOUS_USE_CODE = "20036500";
    public static final String INTRAPERICARDIAL_USE_CODE = "20037000";
    public static final String INTRAPERITONEAL_USE_CODE = "20038000";
    public static final String INTRAPLEURAL_USE_CODE = "20039000";
    public static final String INTRAPORTAL_USE_CODE = "20039200";
    public static final String INTRAPROSTATIC_USE_CODE = "20039500";
    public static final String INTRAPUTAMINAL_USE_CODE = "20086000";
    public static final String INTRASTERNAL_USE_CODE = "20041000";
    public static final String INTRATHECAL_USE_CODE = "20042000";
    public static final String INTRATUMORAL_USE_CODE = "20043000";
    public static final String INTRAUTERINE_USE_CODE = "20044000";
    public static final String INTRAVENOUS_USE_CODE = "20045000";
    public static final String INTRAVESICAL_USE_CODE = "20046000";
    public static final String INTRAVITREAL_USE_CODE = "20047000";
    public static final String IONTOPHORESIS_CODE = "20047500";
    public static final String LARYNGOPHARYNGEAL_USE_CODE = "20048000";
    public static final String NASAL_USE_CODE = "20049000";
    public static final String OCULAR_USE_CODE = "20051000";
    public static final String ORAL_USE_CODE = "20053000";
    public static final String OROMUCOSAL_USE_CODE = "20054000";
    public static final String OROPHARYNGEAL_USE_CODE = "20055000";
    public static final String PERIARTICULAR_USE_CODE = "20057000";
    public static final String PERINEURAL_USE_CODE = "20058000";
    public static final String PERIODONTAL_USE_CODE = "20059000";
    public static final String PERIOSSEOUS_USE_CODE = "20059300";
    public static final String PERITUMORAL_USE_CODE = "20059400";
    public static final String POSTERIOR_JUXTASCLERAL_USE_CODE = "20059500";
    public static final String RECTAL_USE_CODE = "20061000";
    public static final String RETROBULBAR_USE_CODE = "20061500";
    public static final String ROUTE_OF_ADMINISTRATION_NOT_APPLICABLE_CODE = "20062000";
    public static final String SKIN_SCARIFICATION_CODE = "20063000";
    public static final String SUBCONJUNCTIVAL_USE_CODE = "20065000";
    public static final String SUBCUTANEOUS_USE_CODE = "20066000";
    public static final String SUBLINGUAL_USE_CODE = "20067000";
    public static final String SUBMUCOSAL_USE_CODE = "20067500";
    public static final String SUBRETINAL_USE_CODE = "20081000";
    public static final String TRANSDERMAL_USE_CODE = "20070000";
    public static final String URETHRAL_USE_CODE = "20071000";
    public static final String VAGINAL_USE_CODE = "20072000";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.1.11.2";
    public static final String VALUE_SET_NAME = "RouteOfAdministrationEDQM";
    public static final String CODE_SYSTEM_ID = "0.4.0.127.0.16.1.1.2.1";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    private RouteOfAdministrationEdqm(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }

    public @NonNull String getFhirSystem() {
        if (this.getCodeSystemId().startsWith("http")) {
            return this.getCodeSystemId();
        }
        return "urn:oid:" + this.getCodeSystemId();
    }

    public @NonNull Coding getCoding() {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.displayNames[0]);
    }

    public @NonNull CodeableConcept getCodeableConcept() {
        return new CodeableConcept().setText(this.displayNames[0]).addCoding(this.getCoding());
    }

    public @NonNull Coding getCoding(LanguageCode languageCode) {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.getDisplayName(languageCode));
    }

    public @NonNull CodeableConcept getCodeableConcept(LanguageCode languageCode) {
        return new CodeableConcept().setText(this.getDisplayName(languageCode)).addCoding(this.getCoding(languageCode));
    }

    public boolean isEqualTo(Coding coding) {
        return this.getFhirSystem().equals(coding.getSystem()) && this.getCodeValue().equals(coding.getCode());
    }

    public static @Nullable RouteOfAdministrationEdqm getEnum(@Nullable String code) {
        for (RouteOfAdministrationEdqm x : RouteOfAdministrationEdqm.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(RouteOfAdministrationEdqm.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (RouteOfAdministrationEdqm x : RouteOfAdministrationEdqm.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable RouteOfAdministrationEdqm getEnum(@Nullable Coding coding) {
        for (RouteOfAdministrationEdqm x : RouteOfAdministrationEdqm.values()) {
            if (!x.isEqualTo(coding)) continue;
            return x;
        }
        return null;
    }

    public static boolean isInValueSet(@Nullable Coding coding) {
        for (RouteOfAdministrationEdqm x : RouteOfAdministrationEdqm.values()) {
            if (!x.isEqualTo(coding)) continue;
            return true;
        }
        return false;
    }
}

