/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum PharmaceuticalDoseFormEdqm implements ValueSetEnumInterface,
FhirValueSetEnumInterface
{
    ANTICOAGULANT_AND_PRESERVATIVE_SOLUTION_FOR_BLOOD("12102000", "0.4.0.127.0.16.1.1.2.1", "Anticoagulant and preservative solution for blood", "Anticoagulant and preservative solution for blood", "Stabilisatorl\u00f6sung f\u00fcr Blutkonserven", "Solution anticoagulante et de conservation du sang humain", "Soluzione anticoagulante e conservante per il sangue"),
    BATH_ADDITIVE("10501000", "0.4.0.127.0.16.1.1.2.1", "Bath additive", "Bath additive", "Badezusatz", "Adjuvant de bain", "Additivo per bagno"),
    BLADDER_IRRIGATION("11502000", "0.4.0.127.0.16.1.1.2.1", "Bladder irrigation", "Bladder irrigation", "Blasensp\u00fcll\u00f6sung", "Solution pour irrigation v\u00e9sicale", "Irrigazione vescicale"),
    BUCCAL_FILM("10314011", "0.4.0.127.0.16.1.1.2.1", "Buccal film", "Buccal film", "Buccalfilm", "Film buccogingival", "Film orosolubile"),
    BUCCAL_TABLET("10320000", "0.4.0.127.0.16.1.1.2.1", "Buccal tablet", "Buccal tablet", "Buccaltablette", "Comprim\u00e9 buccogingival", "Compressa orosolubile"),
    CACHET("10209000", "0.4.0.127.0.16.1.1.2.1", "Cachet", "Cachet", "Oblatenkapsel", "Cachet", "Cachet"),
    CAPSULE_HARD("10210000", "0.4.0.127.0.16.1.1.2.1", "Capsule, hard", "Capsule, hard", "Hartkapsel", "G\u00e9lule", "Capsula rigida"),
    CAPSULE_SOFT("10211000", "0.4.0.127.0.16.1.1.2.1", "Capsule, soft", "Capsule, soft", "Weichkapsel", "Capsule molle", "Capsula molle"),
    CHEWABLE_CAPSULE_SOFT("10214000", "0.4.0.127.0.16.1.1.2.1", "Chewable capsule, soft", "Chewable capsule, soft", "Weichkapsel zum Zerbei\u00dfen", "Capsule molle \u00e0 m\u00e2cher", "Capsula molle masticabile"),
    CHEWABLE_DISPERSIBLE_TABLET("50001000", "0.4.0.127.0.16.1.1.2.1", "Chewable/dispersible tablet", "Chewable/dispersible tablet", "Kautablette/Tablette zur Herstellung einer Suspension zum Einnehmen", "Comprim\u00e9 dispersible / \u00e0 croquer", "Compressa masticabile/dispersibile"),
    CHEWABLE_TABLET("10228000", "0.4.0.127.0.16.1.1.2.1", "Chewable tablet", "Chewable tablet", "Kautablette", "Comprim\u00e9 \u00e0 croquer", "Compressa masticabile"),
    COATED_GRANULES("13046000", "0.4.0.127.0.16.1.1.2.1", "Coated granules", "Coated granules", "\u00dcberzogenes Granulat", "Granul\u00e9s enrob\u00e9s", "Granulato rivestito"),
    COATED_TABLET("10220000", "0.4.0.127.0.16.1.1.2.1", "Coated tablet", "Coated tablet", "\u00fcberzogene Tablette", "Comprim\u00e9 enrob\u00e9", "Compressa rivestita"),
    COLLODION("10520000", "0.4.0.127.0.16.1.1.2.1", "Collodion", "Collodion", "filmbildende Fl\u00fcssigkeit", "Collodion", "Collodio"),
    COMPRESSED_LOZENGE("10322000", "0.4.0.127.0.16.1.1.2.1", "Compressed lozenge", "Compressed lozenge", "Lutschtablette, gepresst", "Comprim\u00e9 \u00e0 sucer", "Pastiglia"),
    CONCENTRATE_FOR_CONCENTRATE_FOR_SOLUTION_FOR_INFUSION("13001000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for concentrate for solution for infusion", "Concentrate for concentrate for solution for infusion", "Konzentrat f\u00fcr ein Konzentrat zur Herstellung einer Infusionsl\u00f6sung", "Gaz m\u00e9dicinal liqu\u00e9fi\u00e9", "Concentrato per concentrato per soluzione per infusione"),
    CONCENTRATE_FOR_CUTANEOUS_SOLUTION("10514000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for cutaneous solution", "Concentrate for cutaneous solution", "Konzentrat zur Herstellung einer L\u00f6sung zur Anwendung auf der Haut", "Solution \u00e0 diluer pour solution cutan\u00e9e", "Concentrato per soluzione cutanea"),
    CONCENTRATE_FOR_CUTANEOUS_SPRAY_EMULSION("50009000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for cutaneous spray, emulsion", "Concentrate for cutaneous spray, emulsion", "Konzentrat zur Herstellung eines Sprays zur Anwendung auf der Haut, Emulsion", "Solution \u00e0 diluer pour \u00e9mulsion pour pulv\u00e9risation cutan\u00e9e", "Concentrato per spray cutaneo, emulsione"),
    CONCENTRATE_FOR_DISPERSION_FOR_INFUSION("50009300", "0.4.0.127.0.16.1.1.2.1", "Concentrate for dispersion for infusion", "Concentrate for dispersion for infusion", "Konzentrat zur Herstellung einer Infusionsdispersion", "Dispersion \u00e0 diluer pour perfusion", "Concentrato per dispersione per infusione"),
    CONCENTRATE_FOR_DISPERSION_FOR_INJECTION("13139000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for dispersion for injection", "Concentrate for dispersion for injection", "Magensaftresistentes Pulver zur Herstellung einer Suspension zum Einnehmen", "Dispersion \u00e0 diluer pour dispersion injectable", "Larva medicinale"),
    CONCENTRATE_FOR_EMULSION_FOR_INFUSION("50009500", "0.4.0.127.0.16.1.1.2.1", "Concentrate for emulsion for infusion", "Concentrate for emulsion for infusion", "Konzentrat zur Herstellung einer Emulsion zur Infusion", "Emulsion \u00e0 diluer pour perfusion", "Concentrato per emulsione per infusione"),
    CONCENTRATE_FOR_GARGLE("10302000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for gargle", "Concentrate for gargle", "Konzentrat zur Herstellung einer Gurgell\u00f6sung", "Solution \u00e0 diluer pour gargarisme", "Concentrato per soluzione per gargarismi"),
    CONCENTRATE_FOR_INTRAVESICAL_SOLUTION("50009750", "0.4.0.127.0.16.1.1.2.1", "Concentrate for intravesical solution", "Concentrate for intravesical solution", "Konzentrat zur Herstellung einer L\u00f6sung zur intravesikalen Anwendung", "Solution \u00e0 diluer pour solution intrav\u00e9sicale", "Concentrato per soluzione endovescicale"),
    CONCENTRATE_FOR_NEBULISER_SOLUTION("13002000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for nebuliser solution", "Concentrate for nebuliser solution", "Konzentrat zur Herstellung einer L\u00f6sung f\u00fcr einen Vernebler", "Solution \u00e0 diluer pour inhalation par n\u00e9buliseur", "Concentrato per soluzione per nebulizzatore"),
    CONCENTRATE_FOR_ORAL_RECTAL_SOLUTION("50011000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for oral/rectal solution", "Concentrate for oral/rectal solution", "Konzentrat zur Herstellung einer L\u00f6sung zum Einnehmen /Rektall\u00f6sung", "Solution \u00e0 diluer pour solution orale/rectale", "Concentrato per soluzione orale/rettale"),
    CONCENTRATE_FOR_ORAL_SOLUTION("50010000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for oral solution", "Concentrate for oral solution", "Konzentrat zur Herstellung einer L\u00f6sung  zum Einnehmen", "Solution \u00e0 diluer pour solution buvable", "Concentrato per soluzione orale"),
    CONCENTRATE_FOR_ORAL_SUSPENSION("10100500", "0.4.0.127.0.16.1.1.2.1", "Concentrate for oral suspension", "Concentrate for oral suspension", "Konzentrat zur Herstellung einer Suspension zum Einnehmen", "Suspension \u00e0 diluer pour suspension buvable", "Concentrato per sospensione orale"),
    CONCENTRATE_FOR_OROMUCOSAL_SOLUTION("13003000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for oromucosal solution", "Concentrate for oromucosal solution", "Konzentrat zur Herstellung einer L\u00f6sung zur Anwendung in der Mundh\u00f6hle", "Solution \u00e0 diluer buccale", "Concentrato per soluzione per mucosa orale"),
    CONCENTRATE_FOR_RECTAL_SOLUTION("11008000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for rectal solution", "Concentrate for rectal solution", "Konzentrat zur Herstellung einer Rektall\u00f6sung", "Solution rectale \u00e0 diluer", "Concentrato per soluzione rettale"),
    CONCENTRATE_FOR_SOLUTION_FOR_HAEMODIALYSIS("11405000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for solution for haemodialysis", "Concentrate for solution for haemodialysis", "Konzentrat zur Herstellung einer H\u00e4modialysel\u00f6sung", "Solution \u00e0 diluer pour h\u00e9modialyse", "Soluzione concentrata per emodialisi"),
    CONCENTRATE_FOR_SOLUTION_FOR_INFUSION("11213000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for solution for infusion", "Concentrate for solution for infusion", "Konzentrat zur Herstellung einer Infusionsl\u00f6sung", "Solution \u00e0 diluer pour perfusion", "Concentrato per soluzione per infusione"),
    CONCENTRATE_FOR_SOLUTION_FOR_INJECTION("11209000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for solution for injection", "Concentrate for solution for injection", "Konzentrat zur Herstellung einer Injektionsl\u00f6sung", "Solution \u00e0 diluer injectable", "Concentrato per soluzione iniettabile"),
    CONCENTRATE_FOR_SOLUTION_FOR_INJECTION_INFUSION("50079000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for solution for injection/infusion", "Concentrate for solution for injection/infusion", "Konzentrat zur Herstellung einer Injektions- /Infusionsl\u00f6sung", "Solution \u00e0 diluer pour solution injectable/pour perfusion", "Concentrato per soluzione iniettabile/ per infusione"),
    CONCENTRATE_FOR_SOLUTION_FOR_INTRAOCULAR_IRRIGATION("10600500", "0.4.0.127.0.16.1.1.2.1", "Concentrate for solution for intraocular irrigation", "Concentrate for solution for intraocular irrigation", "Konzentrat zur Herstellung einer L\u00f6sung zur intraokularen Anwendung", "Solution \u00e0 diluer pour solution pour irrigation intraoculaire", "Concentrato per soluzione per irrigazione intraoculare"),
    CONCENTRATE_FOR_SOLUTION_FOR_PERITONEAL_DIALYSIS("50013250", "0.4.0.127.0.16.1.1.2.1", "Concentrate for solution for peritoneal dialysis", "Concentrate for solution for peritoneal dialysis", "Konzentrat zur Herstellung einer Peritonealdialysel\u00f6sung", "Solution \u00e0 diluer pour solution pour dialyse p\u00e9riton\u00e9ale", "Concentrato per soluzione per dialisi peritoneale"),
    CONCENTRATE_FOR_SUSPENSION_FOR_INJECTION("13004000", "0.4.0.127.0.16.1.1.2.1", "Concentrate for suspension for injection", "Concentrate for suspension for injection", "Konzentrat zur Herstellung einer Injektionssuspension", "Suspension \u00e0 diluer injectable", "Concentrato per sospensione iniettabile"),
    CREAM("10502000", "0.4.0.127.0.16.1.1.2.1", "Cream", "Cream", "Creme", "Cr\u00e8me", "Crema"),
    CUTANEOUS_EMULSION("10516000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous emulsion", "Cutaneous emulsion", "Emulsion zur Anwendung auf der Haut", "Emulsion cutan\u00e9e", "Emulsione cutanea"),
    CUTANEOUS_FOAM("10507000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous foam", "Cutaneous foam", "Schaum zur  Anwendung auf der Haut", "Mousse cutan\u00e9e", "Schiuma cutanea"),
    CUTANEOUS_LIQUID("10512000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous liquid", "Cutaneous liquid", "Fl\u00fcssigkeit zur Anwendung auf der Haut", "Liquide cutan\u00e9", "Liquido cutaneo"),
    CUTANEOUS_NASAL_OINTMENT("50015200", "0.4.0.127.0.16.1.1.2.1", "Cutaneous/nasal ointment", "Cutaneous/nasal ointment", "Salbe zur Anwendung auf der Haut/Nasensalbe", "Pommade cutan\u00e9e/ nasale", "Unguento cutaneo/nasale"),
    CUTANEOUS_OROMUCOSAL_SOLUTION("13140000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous/oromucosal solution", "Cutaneous/oromucosal solution", "Magensaftresistentes Pulver zur Herstellung einer Suspension zum Einnehmen", "Dispersion \u00e0 diluer pour dispersion injectable", "Larva medicinale"),
    CUTANEOUS_PASTE("10505000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous paste", "Cutaneous paste", "Paste zur Anwendung auf der Haut", "P\u00e2te cutan\u00e9e", "Pasta cutanea"),
    CUTANEOUS_PATCH("10517500", "0.4.0.127.0.16.1.1.2.1", "Cutaneous patch", "Cutaneous patch", "Kutanes Pflaster", "Patch cutan\u00e9", "Cerotto cutaneo"),
    CUTANEOUS_POWDER("10517000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous powder", "Cutaneous powder", "Pulver zur Anwendung auf der Haut", "Poudre pour application cutan\u00e9e", "Polvere cutanea"),
    CUTANEOUS_SOLUTION("10513000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous solution", "Cutaneous solution", "L\u00f6sung zur Anwendung auf der Haut", "Solution pour application cutan\u00e9e", "Soluzione cutanea"),
    CUTANEOUS_SOLUTION_CONCENTRATE_FOR_OROMUCOSAL_SOLUTION("50015450", "0.4.0.127.0.16.1.1.2.1", "Cutaneous solution/concentrate for oromucosal solution", "Cutaneous solution/concentrate for oromucosal solution", "L\u00f6sung zur Anwendung auf der Haut/Konzentrat zur Herstellung einer L\u00f6sung zur Anwendung in der Mundh\u00f6hle", "Solution cutan\u00e9e/ solution \u00e0 diluer buccale", "Soluzione cutanea/concentrato per soluzione per mucosa orale"),
    CUTANEOUS_SPRAY_EMULSION("50015500", "0.4.0.127.0.16.1.1.2.1", "Cutaneous spray, emulsion", "Cutaneous spray, emulsion", "Spray zur Anwendung auf der Haut, Emulsion", "\u00c9mulsion pour pulv\u00e9risation cutan\u00e9e", "Spray cutaneo, emulsione"),
    CUTANEOUS_SPRAY_OINTMENT("50016000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous spray, ointment", "Cutaneous spray, ointment", "Spray zur Anwendung auf der Haut, Salbe", "Pommade pour pulv\u00e9risation cutan\u00e9e", "Spray cutaneo, unguento"),
    CUTANEOUS_SPRAY_POWDER("10511000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous spray, powder", "Cutaneous spray, powder", "Pulver-Spray zur Anwendung auf der Haut", "Poudre pour pulv\u00e9risation cutan\u00e9e", "Spray cutaneo, polvere"),
    CUTANEOUS_SPRAY_SOLUTION("10509000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous spray, solution", "Cutaneous spray, solution", "Spray zur Anwendung auf der Haut, L\u00f6sung", "Solution pour pulv\u00e9risation cutan\u00e9e", "Spray cutaneo, soluzione"),
    CUTANEOUS_SPRAY_SUSPENSION("10510000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous spray, suspension", "Cutaneous spray, suspension", "Spray zur Anwendung auf der Haut, Suspension", "Suspension pour pulv\u00e9risation cutan\u00e9e", "Spray cutaneo, sospensione"),
    CUTANEOUS_STICK("10523000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous stick", "Cutaneous stick", "Stift zur Anwendung auf der Haut", "B\u00e2ton pour application cutan\u00e9e", "Matita cutanea"),
    CUTANEOUS_SUSPENSION("10515000", "0.4.0.127.0.16.1.1.2.1", "Cutaneous suspension", "Cutaneous suspension", "Suspension zur Anwendung auf der Haut", "Suspension pour application cutan\u00e9e", "Sospensione cutanea"),
    DENTAL_CEMENT("10401500", "0.4.0.127.0.16.1.1.2.1", "Dental cement", "Dental cement", "Dentalzement", "Ciment dentaire", "Polvere periodontale"),
    DENTAL_EMULSION("10408000", "0.4.0.127.0.16.1.1.2.1", "Dental emulsion", "Dental emulsion", "Dentalemulsion", "Emulsion dentaire", "Emulsione dentale"),
    DENTAL_GEL("10402000", "0.4.0.127.0.16.1.1.2.1", "Dental gel", "Dental gel", "Dentalgel", "Gel dentaire", "Gel dentale"),
    DENTAL_PASTE("50017000", "0.4.0.127.0.16.1.1.2.1", "Dental paste", "Dental paste", "Dentalpaste", "P\u00e2te dentaire", "Spray cutaneo, unguento"),
    DENTAL_POWDER("10405000", "0.4.0.127.0.16.1.1.2.1", "Dental powder", "Dental powder", "Dentalpulver", "Poudre dentaire", "Polvere dentale"),
    DENTAL_SOLUTION("10406000", "0.4.0.127.0.16.1.1.2.1", "Dental solution", "Dental solution", "Dentall\u00f6sung", "Solution dentaire", "Soluzione dentale"),
    DENTAL_STICK("10403000", "0.4.0.127.0.16.1.1.2.1", "Dental stick", "Dental stick", "Dentalstift", "B\u00e2ton dentaire", "Bastoncino dentale"),
    DENTAL_SUSPENSION("10407000", "0.4.0.127.0.16.1.1.2.1", "Dental suspension", "Dental suspension", "Dentalsuspension", "Suspension dentaire", "Sospensione dentale"),
    DENTURE_LACQUER("12101000", "0.4.0.127.0.16.1.1.2.1", "Denture lacquer", "Denture lacquer", "Lack f\u00fcr die Gebisskontaktfl\u00e4che", "Laque dentaire", "Smalto dentale"),
    DISPERSIBLE_TABLET("10121000", "0.4.0.127.0.16.1.1.2.1", "Dispersible tablet", "Dispersible tablet", "Tablette zur Herstellung einer Suspension zum Einnehmen", "Comprim\u00e9 dispersible", "Compressa dispersibile"),
    DISPERSIBLE_TABLETS_FOR_DOSE_DISPENSER("10121500", "0.4.0.127.0.16.1.1.2.1", "Dispersible tablets for dose dispenser", "Dispersible tablets for dose dispenser", "Tablette zur Herstellung einer Suspension zum Einnehmen f\u00fcr ein Dosierger\u00e4t", "Comprim\u00e9s dispersibles pour dispensateur de dose", "Compresse dispersibili per dispensatore di dose"),
    DISPERSION_FOR_CONCENTRATE_FOR_DISPERSION_FOR_INFUSION("13005000", "0.4.0.127.0.16.1.1.2.1", "Dispersion for concentrate for dispersion for infusion", "Dispersion for concentrate for dispersion for infusion", "Dispersion f\u00fcr ein Konzentrat zur Herstellung einer Infusionsdispersion", "Dispersion pour dispersion \u00e0 diluer pour perfusion", "Dispersione per concentrato per dispersione per infusione"),
    DISPERSION_FOR_INFUSION("50017500", "0.4.0.127.0.16.1.1.2.1", "Dispersion for infusion", "Dispersion for infusion", "Infusionsdispersion", "Dispersion pour perfusion", "Dispersione per infusione"),
    DISPERSION_FOR_INJECTION("50077000", "0.4.0.127.0.16.1.1.2.1", "Dispersion for injection", "Dispersion for injection", "Injektionsdispersion", "Dispersion injectable", "Dispersione per preparazione iniettabile"),
    DISPERSION_FOR_INJECTION_INFUSION("13049000", "0.4.0.127.0.16.1.1.2.1", "Dispersion for injection/infusion", "Dispersion for injection/infusion", "Dispersion zur Injektion /Infusion", "Dispersion injectable/ pour perfusion", "Dispersione iniettabile/per infusione"),
    EAR_CREAM("10701000", "0.4.0.127.0.16.1.1.2.1", "Ear cream", "Ear cream", "Ohrencreme", "Cr\u00e8me auriculaire", "Crema auricolare"),
    EAR_DROPS_EMULSION("10706000", "0.4.0.127.0.16.1.1.2.1", "Ear drops, emulsion", "Ear drops, emulsion", "Ohrentropfen, Emulsion", "Emulsion auriculaire en gouttes", "Gocce auricolari, emulsione"),
    EAR_DROPS_POWDER_FOR_SUSPENSION("13006000", "0.4.0.127.0.16.1.1.2.1", "Ear drops, powder for suspension", "Ear drops, powder for suspension", "Pulver zur Herstellung einer Ohrentropfensuspension", "Poudre pour suspension auriculaire en gouttes", "Gocce auricolari, polvere per sospensione"),
    EAR_DROPS_SOLUTION("10704000", "0.4.0.127.0.16.1.1.2.1", "Ear drops, solution", "Ear drops, solution", "Ohrentropfen, L\u00f6sung", "Solution auriculaire en gouttes", "Gocce auricolari, soluzione"),
    EAR_DROPS_SUSPENSION("10705000", "0.4.0.127.0.16.1.1.2.1", "Ear drops, suspension", "Ear drops, suspension", "Ohrentropfen, Suspension", "Suspension auriculaire en gouttes", "Gocce auricolari, sospensione"),
    EAR_EYE_DROPS_SOLUTION("50018000", "0.4.0.127.0.16.1.1.2.1", "Ear/eye drops, solution", "Ear/eye drops, solution", "Augen-/Ohrentropfen, L\u00f6sung", "Solution auriculaire/ophtalmique en gouttes", "Gocce auricolari/collirio, soluzione"),
    EAR_EYE_DROPS_SUSPENSION("50018500", "0.4.0.127.0.16.1.1.2.1", "Ear/eye drops, suspension", "Ear/eye drops, suspension", "Augen-/Ohrentropfen, Suspension", "-", "Gocce auricolari/collirio, sospensione"),
    EAR_EYE_NASAL_DROPS_SOLUTION("50019500", "0.4.0.127.0.16.1.1.2.1", "Ear/eye/nasal drops, solution", "Ear/eye/nasal drops, solution", "Augen-/Ohren-/Nasentropfen, L\u00f6sung", "Solution auriculaire/ ophtalmique/ nasale en gouttes", "Gocce auricolari/collirio/gocce nasali, soluzione"),
    EAR_EYE_OINTMENT("50019000", "0.4.0.127.0.16.1.1.2.1", "Ear/eye ointment", "Ear/eye ointment", "Augen-/Ohrensalbe", "Pommade auriculaire/ ophtalmique", "Unguento auricolare/oftalmico"),
    EAR_GEL("10702000", "0.4.0.127.0.16.1.1.2.1", "Ear gel", "Ear gel", "Ohrengel", "Gel auriculaire", "Gel auricolare"),
    EAR_NASAL_DROPS_SUSPENSION("50020200", "0.4.0.127.0.16.1.1.2.1", "Ear/nasal drops, suspension", "Ear/nasal drops, suspension", "Augen-/Nasentropfen, Suspension", "Suspension auriculaire/nasale en gouttes", "Gocce auricolari/nasali, sospensione"),
    EAR_OINTMENT("10703000", "0.4.0.127.0.16.1.1.2.1", "Ear ointment", "Ear ointment", "Ohrensalbe", "Pommade auriculaire", "Unguento auricolare"),
    EAR_POWDER("10708000", "0.4.0.127.0.16.1.1.2.1", "Ear powder", "Ear powder", "Ohrenpulver", "Poudre auriculaire", "Polvere auricolare"),
    EAR_SPRAY_EMULSION("10711000", "0.4.0.127.0.16.1.1.2.1", "Ear spray, emulsion", "Ear spray, emulsion", "Ohrenspray, Emulsion", "Emulsion pour pulv\u00e9risation auriculaire", "Spray auricolare, emulsione"),
    EAR_SPRAY_SOLUTION("10709000", "0.4.0.127.0.16.1.1.2.1", "Ear spray, solution", "Ear spray, solution", "Ohrenspray, L\u00f6sung", "Solution pour pulv\u00e9risation auriculaire", "Spray auricolare, soluzione"),
    EAR_SPRAY_SUSPENSION("10710000", "0.4.0.127.0.16.1.1.2.1", "Ear spray, suspension", "Ear spray, suspension", "Ohrenspray, Suspension", "Suspension pour pulv\u00e9risation auriculaire", "Spray auricolare, sospensione"),
    EAR_STICK("10715000", "0.4.0.127.0.16.1.1.2.1", "Ear stick", "Ear stick", "Ohrenst\u00e4bchen", "B\u00e2ton pour usage auriculaire", "Bastoncino auricolare"),
    EAR_TAMPON("10714000", "0.4.0.127.0.16.1.1.2.1", "Ear tampon", "Ear tampon", "Ohrentampon", "Tampon auriculaire", "Tampone auricolare"),
    EAR_WASH_EMULSION("10713000", "0.4.0.127.0.16.1.1.2.1", "Ear wash, emulsion", "Ear wash, emulsion", "Ohrensp\u00fclung, Emulsion", "Emulsion pour lavage auriculaire", "Lavaggio auricolare, emulsione"),
    EAR_WASH_SOLUTION("10712000", "0.4.0.127.0.16.1.1.2.1", "Ear wash, solution", "Ear wash, solution", "Ohrensp\u00fcll\u00f6sung", "Solution pour lavage auriculaire", "Lavaggio auricolare, soluzione"),
    EFFERVESCENT_GRANULES("10205000", "0.4.0.127.0.16.1.1.2.1", "Effervescent granules", "Effervescent granules", "Brausegranulat", "Granul\u00e9s effervescents", "Granulato effervescente"),
    EFFERVESCENT_GRANULES_FOR_ORAL_SUSPENSION("13007000", "0.4.0.127.0.16.1.1.2.1", "Effervescent granules for oral suspension", "Effervescent granules for oral suspension", "Brausegranulat zur Herstellung einer Suspension zum Einnehmen", "Granul\u00e9s effervescents pour suspension buvable", "Granulato effervescente per sospensione orale"),
    EFFERVESCENT_POWDER("10203000", "0.4.0.127.0.16.1.1.2.1", "Effervescent powder", "Effervescent powder", "Brausepulver", "Poudre effervescente", "Polvere effervescente"),
    EFFERVESCENT_TABLET("10222000", "0.4.0.127.0.16.1.1.2.1", "Effervescent tablet", "Effervescent tablet", "Brausetablette", "Comprim\u00e9 effervescent", "Compressa effervescente"),
    EFFERVESCENT_VAGINAL_TABLET("10913000", "0.4.0.127.0.16.1.1.2.1", "Effervescent vaginal tablet", "Effervescent vaginal tablet", "Schaumovula", "Comprim\u00e9 vaginal effervescent", "Compressa effervescente vaginale"),
    EMULSION_FOR_EMULSION_FOR_INJECTION("13008000", "0.4.0.127.0.16.1.1.2.1", "Emulsion for emulsion for injection", "Emulsion for emulsion for injection", "Emulsion zur Herstellung einer Emulsion zur Injektion", "Emulsion pour \u00e9mulsion injectable", "Emulsione per emulsione iniettabile"),
    EMULSION_FOR_INFUSION("11211000", "0.4.0.127.0.16.1.1.2.1", "Emulsion for infusion", "Emulsion for infusion", "Emulsion zur Infusion", "Emulsion pour perfusion", "Emulsione per infusione"),
    EMULSION_FOR_INJECTION("11203000", "0.4.0.127.0.16.1.1.2.1", "Emulsion for injection", "Emulsion for injection", "Emulsion zur Injektion", "Emulsion injectable", "Emuslione iniettabile"),
    EMULSION_FOR_INJECTION_INFUSION("50021000", "0.4.0.127.0.16.1.1.2.1", "Emulsion for injection/infusion", "Emulsion for injection/infusion", "Emulsion zur Injektion/Infusion", "\u00c9mulsion injectable/pour perfusion", "Emulsione iniettabile/per infusione"),
    EMULSION_FOR_SUSPENSION_FOR_INJECTION("13091000", "0.4.0.127.0.16.1.1.2.1", "Emulsion for suspension for injection", "Emulsion for suspension for injection", "Emulsion zur Herstellung einer Injektionssuspension", "Emulsion pour suspension injectable", "Emulsione per sospensione iniettabile"),
    ENDOCERVICAL_GEL("11701000", "0.4.0.127.0.16.1.1.2.1", "Endocervical gel", "Endocervical gel", "Gel zur endozervikalen Anwendung", "Gel endocervical", "Gel endocervicale"),
    ENDOSINUSIAL_SOLUTION("13041000", "0.4.0.127.0.16.1.1.2.1", "Endosinusial solution", "Endosinusial solution", "L\u00f6sung zur Anwendung in den Nebenh\u00f6hlen", "Solution endosinusale", "Soluzione endosinusale"),
    ENDOSINUSIAL_WASH_SUSPENSION("50022000", "0.4.0.127.0.16.1.1.2.1", "Endosinusial wash, suspension", "Endosinusial wash, suspension", "Nebenh\u00f6hlensp\u00fclung, Suspension", "Suspension pour lavage endosinusal", "Lavaggio endosinusale, sospensione"),
    ENDOTRACHEOPULMONARY_INSTILLATION_POWDER_FOR_SOLUTION("11602000", "0.4.0.127.0.16.1.1.2.1", "Endotracheopulmonary instillation, powder for solution", "Endotracheopulmonary instillation, powder for solution", "Pulver zur Herstellung einer L\u00f6sung zur endotracheopulmonalen Instillation", "Poudre pour solution pour instillation endotrach\u00e9obronchique", "Polvere per soluzione per instillazione endotracheobronchiale"),
    ENDOTRACHEOPULMONARY_INSTILLATION_POWDER_FOR_SUSPENSION("13009000", "0.4.0.127.0.16.1.1.2.1", "Endotracheopulmonary instillation, powder for suspension", "Endotracheopulmonary instillation, powder for suspension", "Pulver zu Herstellung einer Suspension zur endotracheopulmonalen Instillation", "Poudre pour suspension pour instillation endotrach\u00e9obronchique", "Instillazione endotracheobronchiale, polvere per sospensione"),
    ENDOTRACHEOPULMONARY_INSTILLATION_SOLUTION("11601000", "0.4.0.127.0.16.1.1.2.1", "Endotracheopulmonary instillation, solution", "Endotracheopulmonary instillation, solution", "L\u00f6sung zur endotracheopulmonalen Instillation", "Solution pour instillation endotrach\u00e9obronchique", "Soluzione per instillazione endotracheobronchiale"),
    ENDOTRACHEOPULMONARY_INSTILLATION_SUSPENSION("11603000", "0.4.0.127.0.16.1.1.2.1", "Endotracheopulmonary instillation, suspension", "Endotracheopulmonary instillation, suspension", "Suspension zur endotracheopulmonalen Instillation", "Suspension pour instillation endotrach\u00e9obronchique", "Sospensione per instillazione endotracheobronchiale"),
    EPILESIONAL_SOLUTION("13042000", "0.4.0.127.0.16.1.1.2.1", "Epilesional solution", "Epilesional solution", "L\u00f6sung zum Auftragen auf die Haut", "Solution \u00e9pil\u00e9sionnelle", "Soluzione epilesionale"),
    EYE_CREAM("10601000", "0.4.0.127.0.16.1.1.2.1", "Eye cream", "Eye cream", "Augencreme", "Cr\u00e8me ophtalmique", "Crema oftalmica"),
    EYE_DROPS_EMULSION("10604500", "0.4.0.127.0.16.1.1.2.1", "Eye drops, emulsion", "Eye drops, emulsion", "Augentropfen, Emulsion", "Collyre en \u00e9mulsion", "Collirio, emulsione"),
    EYE_DROPS_POWDER_FOR_SOLUTION("13010000", "0.4.0.127.0.16.1.1.2.1", "Eye drops, powder for solution", "Eye drops, powder for solution", "Pulver zur Herstellung von Augentropfen, L\u00f6sung", "Poudre pour solution ophtalmique en gouttes", "Collirio, polvere per soluzione"),
    EYE_DROPS_POWDER_FOR_SUSPENSION("13011000", "0.4.0.127.0.16.1.1.2.1", "Eye drops, powder for suspension", "Eye drops, powder for suspension", "Pulver zur Herstellung einer Augentropfensuspension", "Poudre pour suspension ophtalmique en gouttes", "Collirio, polvere per sospensione"),
    EYE_DROPS_PROLONGED_RELEASE("10609000", "0.4.0.127.0.16.1.1.2.1", "Eye drops, prolonged-release", "Eye drops, prolonged-release", "Augentropfen mit verl\u00e4ngerter Wirkungsdauer", "Collyre \u00e0 lib\u00e9ration prolong\u00e9e", "Collirio a rilascio prolungato"),
    EYE_DROPS_SOLUTION("10604000", "0.4.0.127.0.16.1.1.2.1", "Eye drops, solution", "Eye drops, solution", "Augentropfen, L\u00f6sung", "Collyre en solution", "Collirio, soluzione"),
    EYE_DROPS_SOLVENT_FOR_RECONSTITUTION("10608000", "0.4.0.127.0.16.1.1.2.1", "Eye drops, solvent for reconstitution", "Eye drops, solvent for reconstitution", "L\u00f6sungsmittel zur Herstellung von Augentropfen", "Solvant pour collyre", "Solvente per collirio"),
    EYE_DROPS_SUSPENSION("10605000", "0.4.0.127.0.16.1.1.2.1", "Eye drops, suspension", "Eye drops, suspension", "Augentropfensuspension", "Collyre en suspension", "Collirio, sospensione"),
    EYE_GEL("10602000", "0.4.0.127.0.16.1.1.2.1", "Eye gel", "Eye gel", "Augengel", "Gel ophtalmique", "Gel oftalmico"),
    EYE_LOTION("10610000", "0.4.0.127.0.16.1.1.2.1", "Eye lotion", "Eye lotion", "Augenbad", "Solution pour lavage ophtalmique", "Bagno oculare"),
    EYE_LOTION_SOLVENT_FOR_RECONSTITUTION("10611000", "0.4.0.127.0.16.1.1.2.1", "Eye lotion, solvent for reconstitution", "Eye lotion, solvent for reconstitution", "L\u00f6sungsmittel zur Herstellung eines Augenbades", "Solvant pour solution pour lavage ophtalmique", "Solvente per bagno oculare"),
    EYE_OINTMENT("10603000", "0.4.0.127.0.16.1.1.2.1", "Eye ointment", "Eye ointment", "Augensalbe", "Pommade ophtalmique", "Unguento oftalmico"),
    FILM_COATED_TABLET("10221000", "0.4.0.127.0.16.1.1.2.1", "Film-coated tablet", "Film-coated tablet", "Filmtablette", "Comprim\u00e9 pellicul\u00e9", "Compressa rivestita con film"),
    GARGLE("10301000", "0.4.0.127.0.16.1.1.2.1", "Gargle", "Gargle", "Gurgell\u00f6sung", "Solution pour gargarisme", "Soluzione per gargarismi"),
    GARGLE_MOUTHWASH("50024000", "0.4.0.127.0.16.1.1.2.1", "Gargle/mouthwash", "Gargle/mouthwash", "Gurgell\u00f6sung/Mundsp\u00fclung", "Solution pour gargarisme/bain de bouche", "Soluzione per gargarismi/collutorio"),
    GARGLE_NASAL_WASH("50024500", "0.4.0.127.0.16.1.1.2.1", "Gargle/nasal wash", "Gargle/nasal wash", "Gurgell\u00f6sung/Nasensp\u00fclung", "Solution pour gargarisme/ nasale", "Soluzione per gargarismi/lavaggio nasale"),
    GARGLE_POWDER_FOR_SOLUTION("10303000", "0.4.0.127.0.16.1.1.2.1", "Gargle, powder for solution", "Gargle, powder for solution", "Pulver zur Herstellung einer Gurgell\u00f6sung", "Poudre pour solution pour gargarisme", "Polvere per soluzione per gargarismi"),
    GARGLE_TABLET_FOR_SOLUTION("10304000", "0.4.0.127.0.16.1.1.2.1", "Gargle, tablet for solution", "Gargle, tablet for solution", "Tablette zur Herstellung einer Gurgell\u00f6sung", "Comprim\u00e9 pour solution pour gargarisme", "Compressa per soluzione per gargarismi"),
    GASTROENTERAL_EMULSION("12111000", "0.4.0.127.0.16.1.1.2.1", "Gastroenteral emulsion", "Gastroenteral emulsion", "Emulsion zur gastrointestinalen Anwendung", "Emulsion gastroent\u00e9rale", "Emulsione gastroenterica"),
    GASTROENTERAL_SOLUTION("12108000", "0.4.0.127.0.16.1.1.2.1", "Gastroenteral solution", "Gastroenteral solution", "L\u00f6sung zur gastrointestinalen Anwendung", "Solution gastroent\u00e9rale", "Soluzione gastroenterica"),
    GASTROENTERAL_SUSPENSION("12110000", "0.4.0.127.0.16.1.1.2.1", "Gastroenteral suspension", "Gastroenteral suspension", "Suspension zur gastrointestinalen Anwendung", "Suspension gastroent\u00e9rale", "Sospensione gastroenterica"),
    GASTRO_RESISTANT_CAPSULE_HARD("10212000", "0.4.0.127.0.16.1.1.2.1", "Gastro-resistant capsule, hard", "Gastro-resistant capsule, hard", "magensaftresistente Hartkapsel", "G\u00e9lule gastror\u00e9sistante", "Capsula rigida gastroresistente"),
    GASTRO_RESISTANT_CAPSULE_SOFT("10213000", "0.4.0.127.0.16.1.1.2.1", "Gastro-resistant capsule, soft", "Gastro-resistant capsule, soft", "magensaftresistente Weichkapsel", "Capsule molle gastror\u00e9sistante", "Capsula molle gastroresistente"),
    GASTRO_RESISTANT_GRANULES("10206000", "0.4.0.127.0.16.1.1.2.1", "Gastro-resistant granules", "Gastro-resistant granules", "magensaftresistentes Granulat", "Granul\u00e9s gastror\u00e9sistants", "Granulato gastroresistente"),
    GASTRO_RESISTANT_GRANULES_FOR_ORAL_SUSPENSION("50026000", "0.4.0.127.0.16.1.1.2.1", "Gastro-resistant granules for oral suspension", "Gastro-resistant granules for oral suspension", "magensaftresistentes Granulat zur Herstellung einer Suspension zum Einnehmen", "Granul\u00e9s gastror\u00e9sistants pour suspension buvable", "Granulato gastroresistente per sospensione orale"),
    GASTRO_RESISTANT_ORAL_SUSPENSION("13133000", "0.4.0.127.0.16.1.1.2.1", "Gastro-resistant oral suspension", "Gastro-resistant oral suspension", "Magensaftresistente Suspension zum Einnehmen", "Solution \u00e0 lib\u00e9ration prolong\u00e9e intral\u00e9sionnelle", "Larva medicinale"),
    GASTRO_RESISTANT_POWDER_FOR_ORAL_SUSPENSION("13136000", "0.4.0.127.0.16.1.1.2.1", "Gastro-resistant powder for oral suspension", "Gastro-resistant powder for oral suspension", "Magensaftresistentes Pulver zur Herstellung einer Suspension zum Einnehmen", "Solution \u00e0 lib\u00e9ration prolong\u00e9e intral\u00e9sionnelle", "Larva medicinale"),
    GASTRO_RESISTANT_TABLET("10225000", "0.4.0.127.0.16.1.1.2.1", "Gastro-resistant tablet", "Gastro-resistant tablet", "magensaftresistente Tablette", "Comprim\u00e9 gastror\u00e9sistant", "Compressa gastroresistente"),
    GAS_FOR_DISPERSION_FOR_INFUSION("13012000", "0.4.0.127.0.16.1.1.2.1", "Gas for dispersion for infusion", "Gas for dispersion for infusion", "Gas zur Herstellung einer Infusionsdispersion", "Gaz pour dispersion pour perfusion", "Gas per dispersione per infusione"),
    GAS_FOR_DISPERSION_FOR_INJECTION("13013000", "0.4.0.127.0.16.1.1.2.1", "Gas for dispersion for injection", "Gas for dispersion for injection", "Gas zur Herstellung einer Injektionsdispersion", "Gaz pour dispersion injectable", "Gas per dispersione iniettabile"),
    GAS_FOR_DISPERSION_FOR_INJECTION_INFUSION("13050000", "0.4.0.127.0.16.1.1.2.1", "Gas for dispersion for injection/infusion", "Gas for dispersion for injection/infusion", "Gas zur Herstellung einer Injektions-/Infusionsdispersion", "Gaz pour dispersion injectable/ pour perfusion", "Gas per dispersione iniettabile/per infusione"),
    GEL("10503000", "0.4.0.127.0.16.1.1.2.1", "Gel", "Gel", "Gel", "Gel", "Gel"),
    GEL_FOR_GEL("13014000", "0.4.0.127.0.16.1.1.2.1", "Gel for gel", "Gel for gel", "Gel zur Herstellung eines Gels", "Gel pour gel", "Gel per gel"),
    GEL_FOR_INJECTION("11204000", "0.4.0.127.0.16.1.1.2.1", "Gel for injection", "Gel for injection", "Gel zur Injektion", "Gel injectable", "Gel iniettabile"),
    GINGIVAL_GEL("10315000", "0.4.0.127.0.16.1.1.2.1", "Gingival gel", "Gingival gel", "Gel zur Anwendung am Zahnfleisch", "Gel gingival", "Gel gengivale"),
    GINGIVAL_PASTE("10316000", "0.4.0.127.0.16.1.1.2.1", "Gingival paste", "Gingival paste", "Paste zur Anwendung am Zahnfleisch", "P\u00e2te gingivale", "Pasta gengivale"),
    GINGIVAL_SOLUTION("10312000", "0.4.0.127.0.16.1.1.2.1", "Gingival solution", "Gingival solution", "L\u00f6sung zur Anwendung am Zahnfleisch", "Solution gingivale", "Soluzione gengivale"),
    GRANULES("10204000", "0.4.0.127.0.16.1.1.2.1", "Granules", "Granules", "Granulat", "Granul\u00e9s", "Granulato"),
    GRANULES_FOR_ORAL_RECTAL_SUSPENSION("50029150", "0.4.0.127.0.16.1.1.2.1", "Granules for oral/rectal suspension", "Granules for oral/rectal suspension", "Granulat zur Herstellung einer Suspension zum Einnehmen/Rektalsuspension", "Granul\u00e9s pour suspension buvable/rectale", "Granulato per sospensione orale/rettale"),
    GRANULES_FOR_ORAL_SOLUTION("10112000", "0.4.0.127.0.16.1.1.2.1", "Granules for oral solution", "Granules for oral solution", "Granulat zur Herstellung einer L\u00f6sung zum Einnehmen", "Granul\u00e9s pour solution buvable", "Granulato per soluzione orale"),
    GRANULES_FOR_ORAL_SUSPENSION("10113000", "0.4.0.127.0.16.1.1.2.1", "Granules for oral suspension", "Granules for oral suspension", "Granulat zur Herstellung einer Suspension zum Einnehmen", "Granul\u00e9s pour suspension buvable", "Granulato per sospensione orale"),
    GRANULES_FOR_RECTAL_SUSPENSION("13015000", "0.4.0.127.0.16.1.1.2.1", "Granules for rectal suspension", "Granules for rectal suspension", "Granulat zur Herstellung einer Rektalsuspension", "Granul\u00e9s pour suspension rectale", "Granulato per sospensione rettale"),
    GRANULES_FOR_SUSPENSION_FOR_INJECTION("13048000", "0.4.0.127.0.16.1.1.2.1", "Granules for suspension for injection", "Granules for suspension for injection", "Granulat zur Herstellung einer Injektionssuspension", "Granul\u00e9s pour suspension injectable", "Granulato per sospensione iniettabile"),
    GRANULES_FOR_SYRUP("10119000", "0.4.0.127.0.16.1.1.2.1", "Granules for syrup", "Granules for syrup", "Granulat zur Herstellung eines Sirups", "Granul\u00e9s pour sirop", "Granulato per sciroppo"),
    GRANULES_FOR_VAGINAL_SOLUTION("50029500", "0.4.0.127.0.16.1.1.2.1", "Granules for vaginal solution", "Granules for vaginal solution", "Granulat zur Herstellung einer Vaginall\u00f6sung", "Granul\u00e9s pour solution vaginale", "Granulato per soluzione vaginale"),
    HERBAL_TEA("10122000", "0.4.0.127.0.16.1.1.2.1", "Herbal tea", "Herbal tea", "Arzneitee", "Plante(s) pour tisane", "Tisana"),
    IMPLANT("11301000", "0.4.0.127.0.16.1.1.2.1", "Implant", "Implant", "Implantat", "Implant", "Impianto"),
    IMPLANTATION_CHAIN("11303000", "0.4.0.127.0.16.1.1.2.1", "Implantation chain", "Implantation chain", "Kette zur Implantation", "Implant en cha\u00eene", "Catenella per impianto"),
    IMPLANTATION_MATRIX("11303300", "0.4.0.127.0.16.1.1.2.1", "Implantation matrix", "Implantation matrix", "Matrix zur Implantation", "Matrice pour implantation", "Catenella per impianto"),
    IMPLANTATION_PASTE("13043000", "0.4.0.127.0.16.1.1.2.1", "Implantation paste", "Implantation paste", "Paste f\u00fcr Implantate", "P\u00e2te pour implantation", "Soluzione epilesionale"),
    IMPLANTATION_SUSPENSION("11303500", "0.4.0.127.0.16.1.1.2.1", "Implantation suspension", "Implantation suspension", "Suspension zur Implantation", "Suspension pour implantation", "Catenella per impianto"),
    IMPLANTATION_TABLET("11302000", "0.4.0.127.0.16.1.1.2.1", "Implantation tablet", "Implantation tablet", "Tablette zur Implantation", "Comprim\u00e9 pour implantation", "Compressa per impianto"),
    IMPREGNATED_DRESSING("10525000", "0.4.0.127.0.16.1.1.2.1", "Impregnated dressing", "Impregnated dressing", "impr\u00e4gnierter Verband", "Compresse impr\u00e9gn\u00e9e", "Garza impregnata"),
    IMPREGNATED_PAD("12117000", "0.4.0.127.0.16.1.1.2.1", "Impregnated pad", "Impregnated pad", "Impr\u00e4gnierter Tampon", "Tampon impr\u00e9gn\u00e9", "Tampone medicato"),
    IMPREGNATED_PLUG("12117500", "0.4.0.127.0.16.1.1.2.1", "Impregnated plug", "Impregnated plug", "Impr\u00e4gnierter Einsatz", "Support poreux impr\u00e9gn\u00e9", "Supporto medicato"),
    INHALATION_POWDER("11109000", "0.4.0.127.0.16.1.1.2.1", "Inhalation powder", "Inhalation powder", "Pulver zur Inhalation", "Poudre pour inhalation", "Polvere per inalazione"),
    INHALATION_POWDER_HARD_CAPSULE("11110000", "0.4.0.127.0.16.1.1.2.1", "Inhalation powder, hard capsule", "Inhalation powder, hard capsule", "Hartkapsel mit Pulver zur Inhalation", "Poudre pour inhalation en g\u00e9lule", "Polvere per inalazione, capsula rigida"),
    INHALATION_POWDER_PRE_DISPENSED("11111000", "0.4.0.127.0.16.1.1.2.1", "Inhalation powder, pre-dispensed", "Inhalation powder, pre-dispensed", "einzeldosiertes Pulver zur Inhalation", "Poudre pour inhalation en r\u00e9cipient unidose", "Polvere per inalazione, pre-dosata"),
    INHALATION_POWDER_TABLET("50030000", "0.4.0.127.0.16.1.1.2.1", "Inhalation powder, tablet", "Inhalation powder, tablet", "Tablette mit Pulver zur Inhalation", "Comprim\u00e9 pour inhalation par poudre", "Polvere per inalazione, compressa"),
    INHALATION_SOLUTION("50081000", "0.4.0.127.0.16.1.1.2.1", "Inhalation solution", "Inhalation solution", "L\u00f6sung zur Inhalation", "Solution \u00e0 inhaler", "Soluzione per inalazione"),
    INHALATION_VAPOUR_CAPSULE("11113000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, capsule", "Inhalation vapour, capsule", "Kapsel zur Herstellung eines Dampfs zur Inhalation", "Capsule pour inhalation par vapeur", "Capsula per suffumigi"),
    INHALATION_VAPOUR_EFFERVESCENT_TABLET("50031000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, effervescent tablet", "Inhalation vapour, effervescent tablet", "Brausetablette zur Herstellung eines Dampfs zur Inhalation", "Comprim\u00e9 effervescent pour inhalation par vapeur", "Vapore  per inalazione, compressa effervescente"),
    INHALATION_VAPOUR_EMULSION("50032000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, emulsion", "Inhalation vapour, emulsion", "Emulsion zur Herstellung eines Dampfs zur Inhalation", "Emulsion pour inhalation par vapeur", "Vapore per inalazione, emulsione"),
    INHALATION_VAPOUR_IMPREGNATED_PAD("50033000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, impregnated pad", "Inhalation vapour, impregnated pad", "Dampf zur Inhalation, impr\u00e4gnierter Einsatz", "Tampon impr\u00e9gn\u00e9 pour inhalation par vapeur", "Vapore per inalazione, tampone medicato"),
    INHALATION_VAPOUR_IMPREGNATED_PLUG("50033100", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, impregnated plug", "Inhalation vapour, impregnated plug", "Dampf zur Inhalation, impr\u00e4gnierter Einsatz", "Support poreux impr\u00e9gn\u00e9 pour inhalation par vapeur", "Vapore per inalazione, supporto medicato"),
    INHALATION_VAPOUR_LIQUID("11117000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, liquid", "Inhalation vapour, liquid", "Fl\u00fcssigkeit zur Herstellung eines Dampfs zur Inhalation", "Liquide pour inhalation par vapeur", "Liquido per  suffumigi"),
    INHALATION_VAPOUR_OINTMENT("11116000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, ointment", "Inhalation vapour, ointment", "Salbe zur Herstellung eines Dampfs zur Inhalation", "Pommade pour inhalation par vapeur", "Unguento per suffumigi"),
    INHALATION_VAPOUR_POWDER("11112000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, powder", "Inhalation vapour, powder", "Pulver zur Herstellung eines Dampfs zur Inhalation", "Poudre pour inhalation par vapeur", "Polvere per suffumigi"),
    INHALATION_VAPOUR_SOLUTION("11114000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, solution", "Inhalation vapour, solution", "L\u00f6sung zur Herstellung eines Dampfs zur Inhalation", "Solution pour inhalation par vapeur", "Soluzione per  suffumigi"),
    INHALATION_VAPOUR_TABLET("11115000", "0.4.0.127.0.16.1.1.2.1", "Inhalation vapour, tablet", "Inhalation vapour, tablet", "Tablette zur Herstellung eines Dampfs zur Inhalation", "Comprim\u00e9 pour inhalation par vapeur", "Compressa per  suffumigi"),
    INSTANT_HERBAL_TEA("10202000", "0.4.0.127.0.16.1.1.2.1", "Instant herbal tea", "Instant herbal tea", "Teeaufgusspulver", "Pr\u00e9paration instantan\u00e9e pour tisane", "Tisana, polvere solubile"),
    INTESTINAL_GEL("12120000", "0.4.0.127.0.16.1.1.2.1", "Intestinal gel", "Intestinal gel", "Gel zur intestinalen Anwendung", "Gel intestinal", "Gel intestinale"),
    INTRAOCULAR_INSTILLATION_SOLUTION("13044000", "0.4.0.127.0.16.1.1.2.1", "Intraocular instillation solution", "Intraocular instillation solution", "L\u00f6sung zur intraokularen Instillation", "Solution pour instillation intraoculaire", "Soluzione per instillazione intraoculare"),
    INTRAPERITONEAL_SOLUTION("12111500", "0.4.0.127.0.16.1.1.2.1", "Intraperitoneal solution", "Intraperitoneal solution", "L\u00f6sung zur intraperitonealen Awendung", "Solution intrap\u00e9riton\u00e9ale", "Soluzione intraperitoneale"),
    INTRAUTERINE_DELIVERY_SYSTEM("11901000", "0.4.0.127.0.16.1.1.2.1", "Intrauterine delivery system", "Intrauterine delivery system", "Intrauterines Wirkstofffreisetzungssystem", "Syst\u00e8me de diffusion intra-ut\u00e9rin", "Sistema a rilascio intrauterino"),
    INTRAUTERINE_GEL("13113000", "0.4.0.127.0.16.1.1.2.1", "Intrauterine gel", "Intrauterine gel", "Gel zur intrauterinen Anwendung", "Gel intra-ut\u00e9rin", "Gel intrauterino"),
    INTRAVESICAL_SOLUTION("11502500", "0.4.0.127.0.16.1.1.2.1", "Intravesical solution", "Intravesical solution", "L\u00f6sung zur intravesikalen Anwendung", "Solution intrav\u00e9sicale", "Soluzione endovescicale"),
    INTRAVESICAL_SOLUTION_SOLUTION_FOR_INJECTION("50033400", "0.4.0.127.0.16.1.1.2.1", "Intravesical solution/solution for injection", "Intravesical solution/solution for injection", "L\u00f6sung zur intravesikalen Anwendung/Injektionsl\u00f6sung", "Solution intrav\u00e9sicale/solution injectable", "Soluzione endovescicale/soluzione iniettabile"),
    INTRAVESICAL_SUSPENSION("13045000", "0.4.0.127.0.16.1.1.2.1", "Intravesical suspension", "Intravesical suspension", "Suspension zur intravesikalen Anwendung", "Suspension intrav\u00e9sicale", "Sospensione endovescicale"),
    IRRIGATION_SOLUTION("12113000", "0.4.0.127.0.16.1.1.2.1", "Irrigation solution", "Irrigation solution", "Sp\u00fcll\u00f6sung", "Solution pour irrigation", "Soluzione per irrigazione"),
    KIT_FOR_RADIOPHARMACEUTICAL_PREPARATION("12107000", "0.4.0.127.0.16.1.1.2.1", "Kit for radiopharmaceutical preparation", "Kit for radiopharmaceutical preparation", "Kit f\u00fcr ein radioaktives Arzneimittel", "Trousse pour pr\u00e9paration radiopharmaceutique", "Kit per preparazione radiofarmaceutica"),
    LARYNGOPHARYNGEAL_SOLUTION("13016000", "0.4.0.127.0.16.1.1.2.1", "Laryngopharyngeal solution", "Laryngopharyngeal solution", "L\u00f6sung zur Anwendung im Rachenraum und am Kehlkopf", "Solution laryngopharyng\u00e9e", "Soluzione laringofaringea"),
    LARYNGOPHARYNGEAL_SPRAY_SOLUTION("13017000", "0.4.0.127.0.16.1.1.2.1", "Laryngopharyngeal spray, solution", "Laryngopharyngeal spray, solution", "Spray zur Anwendung im Rachenraum und am Kehlkopf, L\u00f6sung", "Solution pour pulv\u00e9risation laryngopharyng\u00e9e", "Spray laringofaringeo, soluzione"),
    LIVING_TISSUE_EQUIVALENT("12118000", "0.4.0.127.0.16.1.1.2.1", "Living tissue equivalent", "Living tissue equivalent", "lebendes Gewebe\u00e4quivalent", "Substitut de tissu vivant", "Tessuto vivente da coltura di cellule"),
    LOZENGE("10321000", "0.4.0.127.0.16.1.1.2.1", "Lozenge", "Lozenge", "Lutschtablette", "Pastille", "Pastiglia"),
    MATRIX_FOR_IMPLANTATION_MATRIX("13018000", "0.4.0.127.0.16.1.1.2.1", "Matrix for implantation matrix", "Matrix for implantation matrix", "Matrix f\u00fcr Matrix zur Implantation", "Matrice pour matrice pour implantation", "Spray laringofaringeo, soluzione"),
    MEDICATED_CHEWING_GUM("10229000", "0.4.0.127.0.16.1.1.2.1", "Medicated chewing-gum", "Medicated chewing-gum", "wirkstoffhaltiges Kaugummi", "Gomme \u00e0 m\u00e2cher m\u00e9dicamenteuse", "Gomma da masticare medicata"),
    MEDICATED_NAIL_LACQUER("10521000", "0.4.0.127.0.16.1.1.2.1", "Medicated nail lacquer", "Medicated nail lacquer", "wirkstoffhaltiger Nagellack", "Vernis \u00e0 ongles m\u00e9dicamenteux", "Smalto medicato per unghie"),
    MEDICATED_PLASTER("10506000", "0.4.0.127.0.16.1.1.2.1", "Medicated plaster", "Medicated plaster", "wirkstoffhaltiges Pflaster", "Empl\u00e2tre m\u00e9dicamenteux", "Cerotto medicato"),
    MEDICATED_SPONGE("12119000", "0.4.0.127.0.16.1.1.2.1", "Medicated sponge", "Medicated sponge", "wirkstoffhaltiges Schw\u00e4mmchen", "Eponge m\u00e9dicamenteuse", "Spugna medicata"),
    MEDICATED_THREAD("12130000", "0.4.0.127.0.16.1.1.2.1", "Medicated thread", "Medicated thread", "wirkstoffhaltiger Faden", "Fils m\u00e9dicamenteux", "Filo medicato"),
    MEDICATED_VAGINAL_TAMPON("10914000", "0.4.0.127.0.16.1.1.2.1", "Medicated vaginal tampon", "Medicated vaginal tampon", "Wirkstoffhaltiger Vaginaltampon", "Tampon vaginal m\u00e9dicamenteux", "Tampone vaginale medicato"),
    MEDICINAL_GAS_COMPRESSED("12301000", "0.4.0.127.0.16.1.1.2.1", "Medicinal gas, compressed", "Medicinal gas, compressed", "Gas zur medizinischen Anwendung, druckverdichtet", "Gaz m\u00e9dicinal comprim\u00e9", "Gas medicinale compresso"),
    MEDICINAL_GAS_CRYOGENIC("12302000", "0.4.0.127.0.16.1.1.2.1", "Medicinal gas, cryogenic", "Medicinal gas, cryogenic", "Gas zur medizinischen Anwendung, k\u00e4lteverfl\u00fcssigt", "Gaz m\u00e9dicinal cryog\u00e9nique", "Gas medicinale criogenico"),
    MEDICINAL_GAS_LIQUEFIED("12303000", "0.4.0.127.0.16.1.1.2.1", "Medicinal gas, liquefied", "Medicinal gas, liquefied", "Gas zur medizinischen Anwendung, verfl\u00fcssigt", "Gaz m\u00e9dicinal liqu\u00e9fi\u00e9", "Gas medicinale liquefatto"),
    MEDICINAL_LARVAE("13124000", "0.4.0.127.0.16.1.1.2.1", "Medicinal larvae", "Medicinal larvae", "Larven zur medizinischen Anwendung", "Larves m\u00e9dicinales", "Larva medicinale"),
    MEDICINAL_LEECH("13115000", "0.4.0.127.0.16.1.1.2.1", "Medicinal leech", "Medicinal leech", "Blutegel zur medizinischen Anwendung", "Sangsue m\u00e9dicinale", "Sanguisuga medicinale"),
    MODIFIED_RELEASE_CAPSULE_HARD("10217000", "0.4.0.127.0.16.1.1.2.1", "Modified-release capsule, hard", "Modified-release capsule, hard", "Hartkapsel mit ver\u00e4nderter Wirkstofffreisetzung", "G\u00e9lule \u00e0 lib\u00e9ration modifi\u00e9e", "Capsula rigida a rilascio modificato"),
    MODIFIED_RELEASE_CAPSULE_SOFT("10218000", "0.4.0.127.0.16.1.1.2.1", "Modified-release capsule, soft", "Modified-release capsule, soft", "Weichkapsel mit ver\u00e4nderter Wirkstofffreisetzung", "Capsule molle \u00e0 lib\u00e9ration modifi\u00e9e", "Capsula molle a rilascio modificato"),
    MODIFIED_RELEASE_GRANULES("10208000", "0.4.0.127.0.16.1.1.2.1", "Modified-release granules", "Modified-release granules", "Granulat mit ver\u00e4nderter Wirkstofffreisetzung", "Granul\u00e9s \u00e0 lib\u00e9ration modifi\u00e9e", "Granulato a rilascio modificato"),
    MODIFIED_RELEASE_GRANULES_FOR_ORAL_SUSPENSION("50036000", "0.4.0.127.0.16.1.1.2.1", "Modified-release granules for oral suspension", "Modified-release granules for oral suspension", "Granulat mit ver\u00e4nderter Wirkstofffreisetzung zur Herstellung einer Suspension zum Einnehmen", "Granul\u00e9s \u00e0 lib\u00e9ration modifi\u00e9e pour suspension buvable", "Granulato a rilascio modificato per sospensione orale"),
    MODIFIED_RELEASE_ORAL_SUSPENSION("13135000", "0.4.0.127.0.16.1.1.2.1", "Modified-release oral suspension", "Modified-release oral suspension", "Suspension zum Einnehmen mit ver\u00e4nderter Wirkstofffreisetzung", "Solution \u00e0 lib\u00e9ration prolong\u00e9e intral\u00e9sionnelle", "Larva medicinale"),
    MODIFIED_RELEASE_TABLET("10227000", "0.4.0.127.0.16.1.1.2.1", "Modified-release tablet", "Modified-release tablet", "Tablette mit ver\u00e4nderter Wirkstofffreisetzung", "Comprim\u00e9 \u00e0 lib\u00e9ration modifi\u00e9e", "Compressa a rilascio modificato"),
    MOUTHWASH("10310000", "0.4.0.127.0.16.1.1.2.1", "Mouthwash", "Mouthwash", "Mundsp\u00fclung", "Solution pour bain de bouche", "Collutorio"),
    MOUTHWASH_POWDER_FOR_SOLUTION("50036050", "0.4.0.127.0.16.1.1.2.1", "Mouthwash, powder for solution", "Mouthwash, powder for solution", "Pulver zur Herstellung einer Mundsp\u00fclung, L\u00f6sung", "Poudre pour solution pour bain de bouche", "Collutorio, polvere per soluzione"),
    MOUTHWASH_TABLET_FOR_SOLUTION("10311000", "0.4.0.127.0.16.1.1.2.1", "Mouthwash, tablet for solution", "Mouthwash, tablet for solution", "Tablette zur Herstellung einer Mundsp\u00fclung", "Comprim\u00e9 pour solution pour bain de bouche", "Compressa per soluzione per collutorio"),
    MUCO_ADHESIVE_BUCCAL_TABLET("10319000", "0.4.0.127.0.16.1.1.2.1", "Muco-adhesive buccal tablet", "Muco-adhesive buccal tablet", "mucoadh\u00e4sive Buccaltablette", "Comprim\u00e9 buccogingival muco-adh\u00e9sif", "Compressa buccale mucoadesiva"),
    NASAL_CREAM("10801000", "0.4.0.127.0.16.1.1.2.1", "Nasal cream", "Nasal cream", "Nasencreme", "Cr\u00e8me nasale", "Crema nasale"),
    NASAL_DROPS_EMULSION("10806000", "0.4.0.127.0.16.1.1.2.1", "Nasal drops, emulsion", "Nasal drops, emulsion", "Nasentropfen, Emulsion", "Emulsion nasale en gouttes", "Gocce nasali, emulsione"),
    NASAL_DROPS_POWDER_FOR_SOLUTION("13020000", "0.4.0.127.0.16.1.1.2.1", "Nasal drops, powder for solution", "Nasal drops, powder for solution", "Pulver zur Herstellung von Nasentropfen, L\u00f6sung", "Poudre pour solution nasale en gouttes", "Gocce nasali, polvere per soluzione"),
    NASAL_DROPS_SOLUTION("10804000", "0.4.0.127.0.16.1.1.2.1", "Nasal drops, solution", "Nasal drops, solution", "Nasentropfen, L\u00f6sung", "Solution nasale en gouttes", "Gocce nasali, soluzione"),
    NASAL_DROPS_SUSPENSION("10805000", "0.4.0.127.0.16.1.1.2.1", "Nasal drops, suspension", "Nasal drops, suspension", "Nasentropfen, Suspension", "Suspension nasale en gouttes", "Gocce nasali, sospensione"),
    NASAL_GEL("10802000", "0.4.0.127.0.16.1.1.2.1", "Nasal gel", "Nasal gel", "Nasengel", "Gel nasal", "Gel nasale"),
    NASAL_OINTMENT("10803000", "0.4.0.127.0.16.1.1.2.1", "Nasal ointment", "Nasal ointment", "Nasensalbe", "Pommade nasale", "Unguento nasale"),
    NASAL_OROMUCOSAL_SOLUTION("50036500", "0.4.0.127.0.16.1.1.2.1", "Nasal/oromucosal solution", "Nasal/oromucosal solution", "L\u00f6sung zur nasalen Anwendung/L\u00f6sung zur Anwendung in der Mundh\u00f6hle", "Solution nasale/buccale", "Soluzione nasale/per mucosa orale"),
    NASAL_OROMUCOSAL_SPRAY_SOLUTION("50036700", "0.4.0.127.0.16.1.1.2.1", "Nasal/oromucosal spray, solution", "Nasal/oromucosal spray, solution", "Nasenspray und Spray zur Anwendung in der Mundh\u00f6hle, L\u00f6sung", "Solution pour pulv\u00e9risation nasale/ buccale", "Spray nasale/per mucosa orale, soluzione"),
    NASAL_POWDER("10807000", "0.4.0.127.0.16.1.1.2.1", "Nasal powder", "Nasal powder", "Nasenpulver", "Poudre nasale", "Polvere nasale"),
    NASAL_SPRAY_EMULSION("10810000", "0.4.0.127.0.16.1.1.2.1", "Nasal spray, emulsion", "Nasal spray, emulsion", "Nasenspray, Emulsion", "Emulsion pour pulv\u00e9risation nasale", "Spray nasale, emulsione"),
    NASAL_SPRAY_POWDER_FOR_SOLUTION("50037100", "0.4.0.127.0.16.1.1.2.1", "Nasal spray, powder for solution", "Nasal spray, powder for solution", "Nasenspray, Pulver zur Herstellung einer L\u00f6sung", "Poudre pour solution pour pulv\u00e9risation nasale", "Spray nasale, polvere per soluzione"),
    NASAL_SPRAY_SOLUTION("10808000", "0.4.0.127.0.16.1.1.2.1", "Nasal spray, solution", "Nasal spray, solution", "Nasenspray, L\u00f6sung", "Solution pour pulv\u00e9risation nasale", "Spray nasale, soluzione"),
    NASAL_SPRAY_SOLUTION_OROMUCOSAL_SOLUTION("50037400", "0.4.0.127.0.16.1.1.2.1", "Nasal spray, solution/oromucosal solution", "Nasal spray, solution/oromucosal solution", "Nasenspray, L\u00f6sung/L\u00f6sung zur Anwendung in der Mundh\u00f6hle", "Solution pour pulv\u00e9risation nasale/ solution buccale", "Spray nasale, soluzione/soluzione per mucosa orale"),
    NASAL_SPRAY_SUSPENSION("10809000", "0.4.0.127.0.16.1.1.2.1", "Nasal spray, suspension", "Nasal spray, suspension", "Nasenspray, Suspension", "Suspension pour pulv\u00e9risation nasale", "Spray nasale, sospensione"),
    NASAL_STICK("10812000", "0.4.0.127.0.16.1.1.2.1", "Nasal stick", "Nasal stick", "Nasenstift", "B\u00e2ton pour usage nasal", "Bastoncino nasale"),
    NASAL_WASH("10811000", "0.4.0.127.0.16.1.1.2.1", "Nasal wash", "Nasal wash", "Nasensp\u00fclung", "Solution pour lavage nasal", "Lavaggio nasale"),
    NEBULISER_DISPERSION("13129000", "0.4.0.127.0.16.1.1.2.1", "Nebuliser dispersion", "Nebuliser dispersion", "Lyophilisat zur sublingualen Anwendung", "Solution \u00e0 lib\u00e9ration prolong\u00e9e intral\u00e9sionnelle", "Larva medicinale"),
    NEBULISER_EMULSION("11105000", "0.4.0.127.0.16.1.1.2.1", "Nebuliser emulsion", "Nebuliser emulsion", "Emulsion f\u00fcr einen Vernebler", "Emulsion pour inhalation par n\u00e9buliseur", "Emulsione per nebulizzatore"),
    NEBULISER_SOLUTION("11101000", "0.4.0.127.0.16.1.1.2.1", "Nebuliser solution", "Nebuliser solution", "L\u00f6sung f\u00fcr einen Vernebler", "Solution pour inhalation par n\u00e9buliseur", "Soluzione per nebulizzatore"),
    NEBULISER_SUSPENSION("11102000", "0.4.0.127.0.16.1.1.2.1", "Nebuliser suspension", "Nebuliser suspension", "Suspension f\u00fcr einen Vernebler", "Suspension pour inhalation par n\u00e9buliseur", "Sospensione per nebulizzatore"),
    OINTMENT("10504000", "0.4.0.127.0.16.1.1.2.1", "Ointment", "Ointment", "Salbe", "Pommade", "Unguento"),
    OPHTHALMIC_INSERT("10612000", "0.4.0.127.0.16.1.1.2.1", "Ophthalmic insert", "Ophthalmic insert", "Augeninsert", "Insert ophtalmique", "Inserto oftalmico"),
    OPHTHALMIC_STRIP("10613000", "0.4.0.127.0.16.1.1.2.1", "Ophthalmic strip", "Ophthalmic strip", "Teststreifen zur Anwendung am Auge", "Bandelette ophtalmique", "Striscia oftalmica"),
    ORAL_DROPS_EMULSION("10103000", "0.4.0.127.0.16.1.1.2.1", "Oral drops, emulsion", "Oral drops, emulsion", "Tropfen zum Einnehmen, Emulsion", "Emulsion buvable en gouttes", "Gocce orali, emulsione"),
    ORAL_DROPS_GRANULES_FOR_SOLUTION("50037500", "0.4.0.127.0.16.1.1.2.1", "Oral drops, granules for solution", "Oral drops, granules for solution", "Granulat zur Herstellung von Tropfen zum Einnehmen, L\u00f6sung", "Granul\u00e9s pour solution buvale en gouttes", "Gocce orali, granulato per soluzione"),
    ORAL_DROPS_LIQUID("50037750", "0.4.0.127.0.16.1.1.2.1", "Oral drops, liquid", "Oral drops, liquid", "Tropfen zum Einnehmen, Fl\u00fcssigkeit", "Liquide oral en gouttes", "Gocce orali, liquido"),
    ORAL_DROPS_POWDER_FOR_SUSPENSION("50082000", "0.4.0.127.0.16.1.1.2.1", "Oral drops, powder for suspension", "Oral drops, powder for suspension", "Pulver zur Herstellung von Tropfen zum Einnehmen, Suspension", "Poudre pour suspension oral en gouttes", "Gocce orali, polvere per sospensione"),
    ORAL_DROPS_SOLUTION("10101000", "0.4.0.127.0.16.1.1.2.1", "Oral drops, solution", "Oral drops, solution", "Tropfen zum Einnehmen, L\u00f6sung", "Solution buvable en gouttes", "Gocce orali, soluzione"),
    ORAL_DROPS_SUSPENSION("10102000", "0.4.0.127.0.16.1.1.2.1", "Oral drops, suspension", "Oral drops, suspension", "Tropfen zum Einnehmen, Suspension", "Suspension buvable en gouttes", "Gocce orali, sospensione"),
    ORAL_EMULSION("10107000", "0.4.0.127.0.16.1.1.2.1", "Oral emulsion", "Oral emulsion", "Emulsion zum Einnehmen", "Emulsion buvable", "Emulsione orale"),
    ORAL_GEL("10108000", "0.4.0.127.0.16.1.1.2.1", "Oral gel", "Oral gel", "Gel zum Einnehmen", "Gel oral", "Gel orale"),
    ORAL_GUM("10230000", "0.4.0.127.0.16.1.1.2.1", "Oral gum", "Oral gum", "Lutschpastille", "Gomme orale", "Pastiglia gommosa"),
    ORAL_HERBAL_MATERIAL("13106000", "0.4.0.127.0.16.1.1.2.1", "Oral herbal material", "Oral herbal material", "Pflanzenteile zum Einnehmen", "-", "Sostanza di origine vegetale  per uso orale"),
    ORAL_LIQUID("10104000", "0.4.0.127.0.16.1.1.2.1", "Oral liquid", "Oral liquid", "Fl\u00fcssigkeit zum Einnehmen", "Liquide oral", "Liquido orale"),
    ORAL_LYOPHILISATE("10224000", "0.4.0.127.0.16.1.1.2.1", "Oral lyophilisate", "Oral lyophilisate", "Lyophilisat zum Einnehmen", "Lyophilisat oral", "Liofilizzato orale"),
    ORAL_PASTE("10109000", "0.4.0.127.0.16.1.1.2.1", "Oral paste", "Oral paste", "Paste zum Einnehmen", "P\u00e2te orale", "Pasta per uso orale"),
    ORAL_POWDER("10201000", "0.4.0.127.0.16.1.1.2.1", "Oral powder", "Oral powder", "Pulver zum Einnehmen", "Poudre orale", "Polvere orale"),
    ORAL_RECTAL_SOLUTION("50037900", "0.4.0.127.0.16.1.1.2.1", "Oral/rectal solution", "Oral/rectal solution", "L\u00f6sung zum Einnehmen/Rektall\u00f6sung", "Solution buvable/rectale", "Soluzione orale/rettale"),
    ORAL_RECTAL_SUSPENSION("50038000", "0.4.0.127.0.16.1.1.2.1", "Oral/rectal suspension", "Oral/rectal suspension", "Suspension zum Einnehmen/Rektalsuspension", "Suspension buvable/rectale", "Sospensione orale/rettale"),
    ORAL_SOLUTION("10105000", "0.4.0.127.0.16.1.1.2.1", "Oral solution", "Oral solution", "L\u00f6sung zum Einnehmen", "Solution  buvable", "Soluzione orale"),
    ORAL_SOLUTION_CONCENTRATE_FOR_NEBULISER_SOLUTION("50038500", "0.4.0.127.0.16.1.1.2.1", "Oral solution/concentrate for nebuliser solution", "Oral solution/concentrate for nebuliser solution", "L\u00f6sung zum Einnehmen/ Konzentrat zur Herstellung einer L\u00f6sung f\u00fcr einen Vernebler", "Solution orale/solution \u00e0 diluer pour inhalation par n\u00e9buliseur", "Soluzione orale/concentrato per soluzione per nebulizzatore"),
    ORAL_SUSPENSION("10106000", "0.4.0.127.0.16.1.1.2.1", "Oral suspension", "Oral suspension", "Suspension zum Einnehmen", "Suspension buvable", "Sospensione orale"),
    ORODISPERSIBLE_FILM("10236100", "0.4.0.127.0.16.1.1.2.1", "Orodispersible film", "Orodispersible film", "Schmelzfilm", "Film orodispersible", "Film orodispersibile"),
    ORODISPERSIBLE_TABLET("10223000", "0.4.0.127.0.16.1.1.2.1", "Orodispersible tablet", "Orodispersible tablet", "Schmelztablette", "Comprim\u00e9 orodispersible", "Compressa orodispersibile"),
    OROMUCOSAL_CAPSULE("10317000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal capsule", "Oromucosal capsule", "Kapsel zur Anwendung in der Mundh\u00f6hle", "Capsule buccale", "Capsula per mucosa orale"),
    OROMUCOSAL_CREAM("10314010", "0.4.0.127.0.16.1.1.2.1", "Oromucosal cream", "Oromucosal cream", "Creme zur Anwendung in der Mundh\u00f6hle", "cr\u00e8me buccale", "Crema per mucosa orale"),
    OROMUCOSAL_DROPS("10307000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal drops", "Oromucosal drops", "Tropfen zur Anwendung in der Mundh\u00f6hle", "Solution buccale en gouttes", "Gocce per mucosa orale"),
    OROMUCOSAL_GEL("10313000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal gel", "Oromucosal gel", "Gel zur Anwendung in der Mundh\u00f6hle", "Gel buccal", "Gel per mucosa orale"),
    OROMUCOSAL_LARYNGOPHARYNGEAL_SOLUTION("50039500", "0.4.0.127.0.16.1.1.2.1", "Oromucosal/laryngopharyngeal solution", "Oromucosal/laryngopharyngeal solution", "L\u00f6sung zur Anwendung in der Mundh\u00f6hle/im Rachenraum und am Kehlkopf", "Solution buccale/laryngopharyng\u00e9e", "Soluzione per mucosa orale/laringofaringea"),
    OROMUCOSAL_LARYNGOPHARYNGEAL_SOLUTION_SPRAY_SOLUTION("50040500", "0.4.0.127.0.16.1.1.2.1", "Oromucosal/laryngopharyngeal solution/spray, solution", "Oromucosal/laryngopharyngeal solution/spray, solution", "L\u00f6sung/Spray zur Anwendung in der Mundh\u00f6hle/im Rachenraum oder am Kehlkopf, L\u00f6sung", "Solution/ solution pour pulv\u00e9risation buccale/ laryngopharyng\u00e9e", "Soluzione per mucosa orale/laringofaringea  o spray per mucosa orale/laringofaringeo, soluzione"),
    OROMUCOSAL_OINTMENT("10314005", "0.4.0.127.0.16.1.1.2.1", "Oromucosal ointment", "Oromucosal ointment", "Salbe zur Anwendung in der Mundh\u00f6hle", "Pommade buccale", "Unguento per mucosa orale"),
    OROMUCOSAL_PASTE("10314000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal paste", "Oromucosal paste", "Paste zur Anwendung in der Mundh\u00f6hle", "P\u00e2te buccale", "Pasta per mucosa orale"),
    OROMUCOSAL_PATCH("50039000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal patch", "Oromucosal patch", "Pflaster zur Anwendung in der Mundh\u00f6hle", "Patch buccal", "Cerotto per mucosa orale"),
    OROMUCOSAL_POUCH("13141000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal pouch", "Oromucosal pouch", "Magensaftresistentes Pulver zur Herstellung einer Suspension zum Einnehmen", "Dispersion \u00e0 diluer pour dispersion injectable", "Larva medicinale"),
    OROMUCOSAL_SOLUTION("10305000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal solution", "Oromucosal solution", "L\u00f6sung zur Anwendung in der Mundh\u00f6hle", "Solution buccale", "Soluzione per mucosa orale"),
    OROMUCOSAL_SPRAY_EMULSION("10308100", "0.4.0.127.0.16.1.1.2.1", "Oromucosal spray, emulsion", "Oromucosal spray, emulsion", "Spray zur Anwendung in der Mundh\u00f6hle, Emulsion", "Emulsion pour pulv\u00e9risation buccale", "Spray per mucosa orale, emulsione"),
    OROMUCOSAL_SPRAY_SOLUTION("10308200", "0.4.0.127.0.16.1.1.2.1", "Oromucosal spray, solution", "Oromucosal spray, solution", "Spray zur Anwendung in der Mundh\u00f6hle, L\u00f6sung", "Solution pour pulv\u00e9risation buccale", "Spray per mucosa orale, soluzione"),
    OROMUCOSAL_SPRAY_SUSPENSION("10308300", "0.4.0.127.0.16.1.1.2.1", "Oromucosal spray, suspension", "Oromucosal spray, suspension", "Spray zur Anwendung in der Mundh\u00f6hle, Suspension", "Suspension pour pulv\u00e9risation buccale", "Spray per mucosa orale, sospensione"),
    OROMUCOSAL_SUSPENSION("10306000", "0.4.0.127.0.16.1.1.2.1", "Oromucosal suspension", "Oromucosal suspension", "Suspension zur Anwendung in der Mundh\u00f6hle", "Suspension buccale", "Sospensione per mucosa orale"),
    PASTILLE("10323000", "0.4.0.127.0.16.1.1.2.1", "Pastille", "Pastille", "Pastille", "P\u00e2te \u00e0 sucer", "Pastiglia molle"),
    PERIODONTAL_GEL("10410000", "0.4.0.127.0.16.1.1.2.1", "Periodontal gel", "Periodontal gel", "Gel zur periodontalen Anwendung", "Gel p\u00e9riodontal", "Gel periodontale"),
    PERIODONTAL_INSERT("10411000", "0.4.0.127.0.16.1.1.2.1", "Periodontal insert", "Periodontal insert", "Insert zur periodontalen Anwendung", "Insert p\u00e9riodontal", "Inserto periodontale"),
    PERIODONTAL_POWDER("10401000", "0.4.0.127.0.16.1.1.2.1", "Periodontal powder", "Periodontal powder", "Pulver zur periodontalen Anwendung", "Poudre p\u00e9ridontale", "Polvere periodontale"),
    PESSARY("10909000", "0.4.0.127.0.16.1.1.2.1", "Pessary", "Pessary", "Vaginalz\u00e4pfchen", "Ovule", "Ovulo"),
    PILLULES("10231000", "0.4.0.127.0.16.1.1.2.1", "Pillules", "Pillules", "Streuk\u00fcgelchen", "Granules", "Granuli"),
    PLASTER_FOR_PROVOCATION_TEST("10550000", "0.4.0.127.0.16.1.1.2.1", "Plaster for provocation test", "Plaster for provocation test", "Pflaster f\u00fcr Provokationstest", "patch pour test \u00e9picutan\u00e9", "Cerotto per test di provocazione"),
    POULTICE("10522000", "0.4.0.127.0.16.1.1.2.1", "Poultice", "Poultice", "Umschlagpaste", "Cataplasme", "Cataplasma"),
    POWDER_FOR_BLADDER_IRRIGATION("11503000", "0.4.0.127.0.16.1.1.2.1", "Powder for bladder irrigation", "Powder for bladder irrigation", "Pulver zur Herstellung einer Blasensp\u00fcll\u00f6sung", "Poudre pour solution pour irrigation v\u00e9sicale", "Polvere per irrigazione vescicale"),
    POWDER_FOR_CONCENTRATE_FOR_DISPERSION_FOR_INFUSION("50048750", "0.4.0.127.0.16.1.1.2.1", "Powder for concentrate for dispersion for infusion", "Powder for concentrate for dispersion for infusion", "Pulver f\u00fcr ein Konzentrat zur Herstellung einer Infusionsdispersion", "Poudre pour dispersion \u00e0 diluer pour dispersion pour perfusion", "Polvere per concentrato per dispersione per infusione"),
    POWDER_FOR_CONCENTRATE_FOR_INTRAVESICAL_SUSPENSION("50049100", "0.4.0.127.0.16.1.1.2.1", "Powder for concentrate for intravesical suspension", "Powder for concentrate for intravesical suspension", "Pulver f\u00fcr ein Konzentrat zur Herstellung einer Suspension zur intravesikalen Anwendung", "Poudre pour suspension \u00e0 diluer pour suspension intrav\u00e9sicale", "Polvere per concentrato per sospensione endovescicale"),
    POWDER_FOR_CONCENTRATE_FOR_SOLUTION_FOR_HAEMODIALYSIS("50049200", "0.4.0.127.0.16.1.1.2.1", "Powder for concentrate for solution for haemodialysis", "Powder for concentrate for solution for haemodialysis", "Pulver f\u00fcr ein Konzentrat zur Herstellung einer H\u00e4modialysel\u00f6sung", "Poudre pour solution \u00e0 diluer pour solution pour h\u00e9modialyse", "Polvere per concentrato per soluzione per emodialisi"),
    POWDER_FOR_CONCENTRATE_FOR_SOLUTION_FOR_INFUSION("50043000", "0.4.0.127.0.16.1.1.2.1", "Powder for concentrate for solution for infusion", "Powder for concentrate for solution for infusion", "Pulver f\u00fcr ein Konzentrat zur Herstellung einer Infusionsl\u00f6sung", "Poudre pour solution \u00e0 diluer pour perfusion", "Polvere per concentrato per soluzione per infusione"),
    POWDER_FOR_CONCENTRATE_FOR_SOLUTION_FOR_INJECTION_INFUSION("50049250", "0.4.0.127.0.16.1.1.2.1", "Powder for concentrate for solution for injection/infusion", "Powder for concentrate for solution for injection/infusion", "Pulver f\u00fcr ein Konzentrat zur Herstellung einer Injektions-/Infusionsl\u00f6sung", "Poudre pour solution \u00e0 diluer pour solution injectable/pour perfusion", "Polvere per concentrato per soluzione iniettabile/per infusione"),
    POWDER_FOR_CUTANEOUS_SOLUTION("10514500", "0.4.0.127.0.16.1.1.2.1", "Powder for cutaneous solution", "Powder for cutaneous solution", "Pulver zur Herstellung einer L\u00f6sung zur Anwendung auf der Haut", "Poudre pour solution cutan\u00e9e", "Polvere per soluzione cutanea"),
    POWDER_FOR_DENTAL_CEMENT("10413000", "0.4.0.127.0.16.1.1.2.1", "Powder for dental cement", "Powder for dental cement", "Pulver zur Herstellung eines Dentalzements", "Poudre pour ciment dentaire", "Inserto periodontale"),
    POWDER_FOR_DENTAL_GEL("13022000", "0.4.0.127.0.16.1.1.2.1", "Powder for dental gel", "Powder for dental gel", "Pulver zur Herstellung eines Dentalgels", "Poudre pour gel dentaire", "Polvere per gel"),
    POWDER_FOR_DENTAL_SOLUTION("50049270", "0.4.0.127.0.16.1.1.2.1", "Powder for dental solution", "Powder for dental solution", "Pulver zur Herstellung einer Dentall\u00f6sung", "Poudre pour solution dentaire", "Polvere per concentrato per soluzione iniettabile/per infusione"),
    POWDER_FOR_DISPERSION_FOR_INFUSION("11211500", "0.4.0.127.0.16.1.1.2.1", "Powder for dispersion for infusion", "Powder for dispersion for infusion", "Pulver zur Herstellung einer Infusionsdispersion", "Poudre pour dispersion pour perfusion", "Polvere per dispersione per infusione"),
    POWDER_FOR_DISPERSION_FOR_INJECTION("13023000", "0.4.0.127.0.16.1.1.2.1", "Powder for dispersion for injection", "Powder for dispersion for injection", "Pulver zur Herstellung einer Injektionsdispersion", "Poudre pour dispersion injectable", "Polvere per dispersione iniettabile"),
    POWDER_FOR_EMULSION_FOR_INJECTION("13040000", "0.4.0.127.0.16.1.1.2.1", "Powder for emulsion for injection", "Powder for emulsion for injection", "Pulver zur Herstellung einer Emulsion zur Injektion", "Poudre pour \u00e9mulsion injectable", "Polvere per emulsione iniettabile"),
    POWDER_FOR_ENDOCERVICAL_GEL("13024000", "0.4.0.127.0.16.1.1.2.1", "Powder for endocervical gel", "Powder for endocervical gel", "Pulver zur Herstellung eines Gels zur endozervikalen Anwendung", "Poudre pour gel endocervical", "Polvere per gel endocervicale"),
    POWDER_FOR_ENDOSINUSIAL_SOLUTION("13025000", "0.4.0.127.0.16.1.1.2.1", "Powder for endosinusial solution", "Powder for endosinusial solution", "Pulver zur Herstellung einer L\u00f6sung zur Anwendung in den Nasennebenh\u00f6hlen", "Poudre pour solution endosinusale", "Polvere per soluzione endosinusale"),
    POWDER_FOR_EPILESIONAL_SOLUTION("50049300", "0.4.0.127.0.16.1.1.2.1", "Powder for epilesional solution", "Powder for epilesional solution", "Pulver zur Herstellung einer L\u00f6sung zum Auftragen auf die Wunde", "Poudre pour solution \u00e9pil\u00e9sionnelle", "Polvere per soluzione epilesionale"),
    POWDER_FOR_GEL("13021000", "0.4.0.127.0.16.1.1.2.1", "Powder for gel", "Powder for gel", "Pulver zur Herstellung eines Gels", "Poudre pour gel", "Polvere per gel"),
    POWDER_FOR_GINGIVAL_GEL("13026000", "0.4.0.127.0.16.1.1.2.1", "Powder for gingival gel", "Powder for gingival gel", "Pulver zur Herstellung eines Gels zur Anwendung am Zahnfleisch", "Poudre pour gel gingival", "Polvere per gel gengivale"),
    POWDER_FOR_IMPLANTATION_MATRIX("13027000", "0.4.0.127.0.16.1.1.2.1", "Powder for implantation matrix", "Powder for implantation matrix", "Pulver f\u00fcr Matrix zur Implantation", "Poudre pour matrice pour implantation", "Polvere per gel gengivale"),
    POWDER_FOR_IMPLANTATION_PASTE("13028000", "0.4.0.127.0.16.1.1.2.1", "Powder for implantation paste", "Powder for implantation paste", "Pulver zur Herstellung einer Paste f\u00fcr ein Implantat", "Poudre pour p\u00e2te pour implantation", "Polvere per gel gengivale"),
    POWDER_FOR_IMPLANTATION_SUSPENSION("50049500", "0.4.0.127.0.16.1.1.2.1", "Powder for implantation suspension", "Powder for implantation suspension", "Pulver zur Herstellung einer Suspension zur Implantation", "Poudre pour suspension pour implantation", "Polvere per soluzione epilesionale"),
    POWDER_FOR_INTRAOCULAR_INSTILLATION_SOLUTION("13029000", "0.4.0.127.0.16.1.1.2.1", "Powder for intraocular instillation solution", "Powder for intraocular instillation solution", "Pulver zur Herstellung einer Instillationsl\u00f6sung zur intraokularen Anwendung", "Poudre pour solution pour instillation intraoculaire", "Polvere per soluzione per instillazione intraoculare"),
    POWDER_FOR_INTRAVESICAL_SOLUTION("50050000", "0.4.0.127.0.16.1.1.2.1", "Powder for intravesical solution", "Powder for intravesical solution", "Pulver zur Herstellung einer L\u00f6sung zur intravesikalen Anwendung", "Poudre pour solution intrav\u00e9sicale", "Polvere per soluzione endovescicale"),
    POWDER_FOR_INTRAVESICAL_SOLUTION_SOLUTION_FOR_INJECTION("50050500", "0.4.0.127.0.16.1.1.2.1", "Powder for intravesical solution/solution for injection", "Powder for intravesical solution/solution for injection", "Pulver zur Herstellung einer L\u00f6sung zur intravesikalen Anwendung / Injektionsl\u00f6sung", "Poudre pour solution intrav\u00e9sicale/injectable", "Polvere per soluzione endovescicale/soluzione iniettabile"),
    POWDER_FOR_INTRAVESICAL_SUSPENSION("50051000", "0.4.0.127.0.16.1.1.2.1", "Powder for intravesical suspension", "Powder for intravesical suspension", "Pulver zur Herstellung einer Suspensionen zur intravesikalen Anwendung", "Poudre pour suspension intrav\u00e9sicale", "Polvere per sospensione endovescicale"),
    POWDER_FOR_NEBULISER_SOLUTION("11104000", "0.4.0.127.0.16.1.1.2.1", "Powder for nebuliser solution", "Powder for nebuliser solution", "Pulver zur Herstellung einer L\u00f6sung f\u00fcr einen Vernebler", "Poudre pour solution pour inhalation par n\u00e9buliseur", "Polvere per soluzione per nebulizzatore"),
    POWDER_FOR_NEBULISER_SUSPENSION("11103000", "0.4.0.127.0.16.1.1.2.1", "Powder for nebuliser suspension", "Powder for nebuliser suspension", "Pulver zur Herstellung einer Suspension f\u00fcr einen Vernebler", "Poudre pour suspension pour inhalation par n\u00e9buliseur", "Polvere per sospensione per nebulizzatore"),
    POWDER_FOR_ORAL_RECTAL_SUSPENSION("50052000", "0.4.0.127.0.16.1.1.2.1", "Powder for oral/rectal suspension", "Powder for oral/rectal suspension", "Pulver zur Herstellung einer Suspension zum Einnehmen/Rektalsuspension", "Poudre pour suspension oral/rectal", "Polvere per sospensione orale/rettale"),
    POWDER_FOR_ORAL_SOLUTION("10110000", "0.4.0.127.0.16.1.1.2.1", "Powder for oral solution", "Powder for oral solution", "Pulver zur Herstellung einer L\u00f6sung zum Einnehmen", "Poudre pour solution buvable", "Polvere per soluzione orale"),
    POWDER_FOR_ORAL_SUSPENSION("10111000", "0.4.0.127.0.16.1.1.2.1", "Powder for oral suspension", "Powder for oral suspension", "Pulver zur Herstellung einer Suspension zum Einnehmen", "Poudre pour suspension buvable", "Polvere per sospensione orale"),
    POWDER_FOR_PROLONGED_RELEASE_SUSPENSION_FOR_INJECTION("11208400", "0.4.0.127.0.16.1.1.2.1", "Powder for prolonged-release suspension for injection", "Powder for prolonged-release suspension for injection", "Pulver zur Herstellung einer Depot-Injektionssuspension", "Poudre pour suspension injectable \u00e0 lib\u00e9ration prolong\u00e9e", "Polvere per sospensione iniettabile a rilascio prolungato"),
    POWDER_FOR_RECTAL_SOLUTION("11009000", "0.4.0.127.0.16.1.1.2.1", "Powder for rectal solution", "Powder for rectal solution", "Pulver zur Herstellung einer Rektall\u00f6sung", "Poudre pour solution rectale", "Polvere per soluzione rettale"),
    POWDER_FOR_RECTAL_SUSPENSION("11010000", "0.4.0.127.0.16.1.1.2.1", "Powder for rectal suspension", "Powder for rectal suspension", "Pulver zur Herstellung einer Rektalsuspension", "Poudre pour suspension rectale", "Polvere per sospensione rettale"),
    POWDER_FOR_SEALANT("13031000", "0.4.0.127.0.16.1.1.2.1", "Powder for sealant", "Powder for sealant", "Pulver f\u00fcr einen Gewebekleber", "Poudre pour colle", "Polvere per adesivo tissutale"),
    POWDER_FOR_SOLUTION_FOR_INFUSION("11212000", "0.4.0.127.0.16.1.1.2.1", "Powder for solution for infusion", "Powder for solution for infusion", "Pulver zur Herstellung einer Infusionsl\u00f6sung", "Poudre pour solution pour perfusion", "Polvere per soluzione per infusione"),
    POWDER_FOR_SOLUTION_FOR_INJECTION("11205000", "0.4.0.127.0.16.1.1.2.1", "Powder for solution for injection", "Powder for solution for injection", "Pulver zur Herstellung einer Injektionsl\u00f6sung", "Poudre pour solution injectable", "Polvere per soluzione iniettabile"),
    POWDER_FOR_SOLUTION_FOR_INJECTION_INFUSION("50053500", "0.4.0.127.0.16.1.1.2.1", "Powder for solution for injection/infusion", "Powder for solution for injection/infusion", "Pulver zur Herstellung einer Injektions-/Infusionsl\u00f6sung", "Poudre pour solution injectable/pour perfusion", "Polvere per soluzione iniettabile/per infusione"),
    POWDER_FOR_SOLUTION_FOR_INJECTION_SKIN_PRICK_TEST("13052000", "0.4.0.127.0.16.1.1.2.1", "Powder for solution for injection/skin-prick test", "Powder for solution for injection/skin-prick test", "Pulver zur Herstellung einer Injektionsl\u00f6sung/Pricktestl\u00f6sung", "Poudre pour solution injectable/ pour prick-test", "Polvere per soluzione iniettabile/per skin-prick test"),
    POWDER_FOR_SOLUTION_FOR_INTRAOCULAR_IRRIGATION("50073000", "0.4.0.127.0.16.1.1.2.1", "Powder for solution for intraocular irrigation", "Powder for solution for intraocular irrigation", "Pulver zur Herstellung einer L\u00f6sung zur intraokularen Anwendung", "Poudre pour solution pour irrigation intraoculaire", "Polvere per soluzione per irrigazione intraoculare"),
    POWDER_FOR_SOLUTION_FOR_IONTOPHORESIS("10518500", "0.4.0.127.0.16.1.1.2.1", "Powder for solution for iontophoresis", "Powder for solution for iontophoresis", "Pulver zur Herstellung einer L\u00f6sung zur Iontophorese", "Poudre pour solution pour iontoph\u00e9r\u00e8se", "Polvere per soluzione per ionoforesi"),
    POWDER_FOR_SOLUTION_FOR_SKIN_PRICK_TEST("13032000", "0.4.0.127.0.16.1.1.2.1", "Powder for solution for skin-prick test", "Powder for solution for skin-prick test", "Pulver zur Herstellung einer Pricktestl\u00f6sung", "Poudre pour solution pour prick-test", "Polvere per soluzione per skin-prick test"),
    POWDER_FOR_SUSPENSION_FOR_INJECTION("11206000", "0.4.0.127.0.16.1.1.2.1", "Powder for suspension for injection", "Powder for suspension for injection", "Pulver zur Herstellung einer Injektionssuspension", "Poudre pour suspension injectable", "Polvere per sospensione iniettabile"),
    POWDER_FOR_SYRUP("10118000", "0.4.0.127.0.16.1.1.2.1", "Powder for syrup", "Powder for syrup", "Pulver zur Herstellung eines Sirups", "Poudre pour sirop", "Polvere per sciroppo"),
    POWDER_FOR_VAGINAL_SOLUTION("13111000", "0.4.0.127.0.16.1.1.2.1", "Powder for vaginal solution", "Powder for vaginal solution", "Pulver zur Herstellung einer Vaginall\u00f6sung", "Poudre pour solution vaginale", "Polvere per soluzione vaginale"),
    PRESSURISED_INHALATION_EMULSION("11108000", "0.4.0.127.0.16.1.1.2.1", "Pressurised inhalation, emulsion", "Pressurised inhalation, emulsion", "Druckgasinhalation, Emulsion", "Emulsion pour inhalation en flacon pressuris\u00e9", "Emulsione pressurizzata per inalazione"),
    PRESSURISED_INHALATION_SOLUTION("11106000", "0.4.0.127.0.16.1.1.2.1", "Pressurised inhalation, solution", "Pressurised inhalation, solution", "Druckgasinhalation, L\u00f6sung", "Solution pour inhalation en flacon pressuris\u00e9", "Soluzione pressurizzata per inalazione"),
    PRESSURISED_INHALATION_SUSPENSION("11107000", "0.4.0.127.0.16.1.1.2.1", "Pressurised inhalation, suspension", "Pressurised inhalation, suspension", "Druckgasinhalation, Suspension", "Suspension pour inhalation en flacon pressuris\u00e9", "Sospensione pressurizzata per inalazione"),
    PROLONGED_RELEASE_CAPSULE_HARD("10215000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release capsule, hard", "Prolonged-release capsule, hard", "Hartkapsel, retardiert", "G\u00e9lule \u00e0 lib\u00e9ration prolong\u00e9e", "Capsula rigida a rilascio prolungato"),
    PROLONGED_RELEASE_CAPSULE_SOFT("10216000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release capsule, soft", "Prolonged-release capsule, soft", "Weichkapsel, retardiert", "Capsule molle \u00e0 lib\u00e9ration prolong\u00e9e", "Capsula molle a rilascio prolungato"),
    PROLONGED_RELEASE_DISPERSION_FOR_INJECTION("13126000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release dispersion for injection", "Prolonged-release dispersion for injection", "Depot-Injektionsdispersion", "Larves m\u00e9dicinales", "Larva medicinale"),
    PROLONGED_RELEASE_GRANULES("10207000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release granules", "Prolonged-release granules", "Retardgranulat", "Granul\u00e9s \u00e0 lib\u00e9ration prolong\u00e9e", "Granulato a rilascio prolungato"),
    PROLONGED_RELEASE_GRANULES_FOR_ORAL_SUSPENSION("50056000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release granules for oral suspension", "Prolonged-release granules for oral suspension", "Retardgranulat zur Herstellung einer Suspension zum Einnehmen", "Granul\u00e9s \u00e0 lib\u00e9ration prolong\u00e9e pour suspension buvable", "Granulato a rilascio prolungato per sospensione orale"),
    PROLONGED_RELEASE_ORAL_SUSPENSION("13134000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release oral suspension", "Prolonged-release oral suspension", "Retardsuspension zum Einnehmen", "Solution \u00e0 lib\u00e9ration prolong\u00e9e intral\u00e9sionnelle", "Larva medicinale"),
    PROLONGED_RELEASE_SOLUTION_FOR_INJECTION("13076000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release solution for injection", "Prolonged-release solution for injection", "Depot-Injektionsl\u00f6sung", "Solution injectable \u00e0 lib\u00e9ration prolong\u00e9e", "Soluzione iniettabile a rilascio prolungato"),
    PROLONGED_RELEASE_SUSPENSION_FOR_INJECTION("11208500", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release suspension for injection", "Prolonged-release suspension for injection", "Depot-Injektionssuspension", "Suspension injectable \u00e0 lib\u00e9ration prolong\u00e9e", "Sospensione iniettabile a rilascio prolungato"),
    PROLONGED_RELEASE_TABLET("10226000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release tablet", "Prolonged-release tablet", "Retardtablette", "Comprim\u00e9 \u00e0 lib\u00e9ration prolong\u00e9e", "Compressa a rilascio prolungato"),
    PROLONGED_RELEASE_WOUND_SOLUTION("13128000", "0.4.0.127.0.16.1.1.2.1", "Prolonged-release wound solution", "Prolonged-release wound solution", "Lyophilisat zur sublingualen Anwendung", "Solution \u00e0 lib\u00e9ration prolong\u00e9e intral\u00e9sionnelle", "Larva medicinale"),
    RADIONUCLIDE_GENERATOR("12106000", "0.4.0.127.0.16.1.1.2.1", "Radionuclide generator", "Radionuclide generator", "Radionuklidgenerator", "G\u00e9n\u00e9rateur radiopharmaceutique", "Generatore di radionuclidi"),
    RADIOPHARMACEUTICAL_PRECURSOR("12105000", "0.4.0.127.0.16.1.1.2.1", "Radiopharmaceutical precursor", "Radiopharmaceutical precursor", "Markerzubereitung", "Pr\u00e9curseur radiopharmaceutique", "Precursore radiofarmaceutico"),
    RADIOPHARMACEUTICAL_PRECURSOR_SOLUTION("50056500", "0.4.0.127.0.16.1.1.2.1", "Radiopharmaceutical precursor, solution", "Radiopharmaceutical precursor, solution", "Markerzubereitung, L\u00f6sung", "Solution de pr\u00e9curseur radiopharmaceutique", "Precursore di radionuclidi, soluzione"),
    RECTAL_CAPSULE("11014000", "0.4.0.127.0.16.1.1.2.1", "Rectal capsule", "Rectal capsule", "Rektalkapsel", "Capsule  rectale", "Capsula rettale"),
    RECTAL_CREAM("11001000", "0.4.0.127.0.16.1.1.2.1", "Rectal cream", "Rectal cream", "Rektalcreme", "Cr\u00e8me rectale", "Crema rettale"),
    RECTAL_EMULSION("11007000", "0.4.0.127.0.16.1.1.2.1", "Rectal emulsion", "Rectal emulsion", "Rektalemulsion", "Emulsion rectale", "Emulsione rettale"),
    RECTAL_FOAM("11004000", "0.4.0.127.0.16.1.1.2.1", "Rectal foam", "Rectal foam", "Rektalschaum", "Mousse rectale", "Schiuma rettale"),
    RECTAL_GEL("11002000", "0.4.0.127.0.16.1.1.2.1", "Rectal gel", "Rectal gel", "Rektalgel", "Gel rectal", "Gel rettale"),
    RECTAL_OINTMENT("11003000", "0.4.0.127.0.16.1.1.2.1", "Rectal ointment", "Rectal ointment", "Rektalsalbe", "Pommade rectale", "Unguento rettale"),
    RECTAL_SOLUTION("11005000", "0.4.0.127.0.16.1.1.2.1", "Rectal solution", "Rectal solution", "Rektall\u00f6sung", "Solution rectale", "Soluzione rettale"),
    RECTAL_SUSPENSION("11006000", "0.4.0.127.0.16.1.1.2.1", "Rectal suspension", "Rectal suspension", "Rektalsuspension", "Suspension rectale", "Sospensione rettale"),
    RECTAL_TAMPON("11015000", "0.4.0.127.0.16.1.1.2.1", "Rectal tampon", "Rectal tampon", "Rektaltampon", "Tampon rectal", "Tampone rettale"),
    SEALANT("12115000", "0.4.0.127.0.16.1.1.2.1", "Sealant", "Sealant", "Gewebekleber", "Colle", "Adesivo tissutale"),
    SEALANT_MATRIX("12115100", "0.4.0.127.0.16.1.1.2.1", "Sealant matrix", "Sealant matrix", "Versiegelungsmatrix", "Matrice pour colle", "Matrice per adesivo tissutale"),
    SEALANT_POWDER("12115200", "0.4.0.127.0.16.1.1.2.1", "Sealant powder", "Sealant powder", "Gewebekleber", "Poudre pour colle", "Adesivo tissutale, polvere"),
    SHAMPOO("10508000", "0.4.0.127.0.16.1.1.2.1", "Shampoo", "Shampoo", "Shampoo", "Shampoing", "Shampoo"),
    SOLUBLE_TABLET("10120000", "0.4.0.127.0.16.1.1.2.1", "Soluble tablet", "Soluble tablet", "Tablette zur Herstellung einer L\u00f6sung zum Einnehmen", "Comprim\u00e9 pour solution buvable", "Compressa solubile"),
    SOLUTION_FOR_BLOOD_FRACTION_MODIFICATION("12103000", "0.4.0.127.0.16.1.1.2.1", "Solution for blood fraction modification", "Solution for blood fraction modification", "L\u00f6sung zur Modifikation einer Blutfraktion", "Solution pour la pr\u00e9paration ex vivo de fractions sanguines", "Soluzione per la modifica di frazione ematica"),
    SOLUTION_FOR_CARDIOPLEGIA("11209500", "0.4.0.127.0.16.1.1.2.1", "Solution for cardioplegia", "Solution for cardioplegia", "Kardioplege L\u00f6sung", "Solution de cardiopl\u00e9gie", "Soluzione per cardioplegia"),
    SOLUTION_FOR_CARDIOPLEGIA_ORGAN_PRESERVATION("13107000", "0.4.0.127.0.16.1.1.2.1", "Solution for cardioplegia/organ preservation", "Solution for cardioplegia/organ preservation", "Kardioplege L\u00f6sung/Organkonservierungsl\u00f6sung", "Solution pour cardiopl\u00e9gie/pr\u00e9servation d'organe", "Soluzione per cardioplegia/conservazione di organi"),
    SOLUTION_FOR_DENTAL_CEMENT("10414000", "0.4.0.127.0.16.1.1.2.1", "Solution for dental cement", "Solution for dental cement", "L\u00f6sung zur Herstellung eines Dentalzements", "Solution pour ciment dentaire", "Inserto periodontale"),
    SOLUTION_FOR_HAEMODIAFILTRATION("11403000", "0.4.0.127.0.16.1.1.2.1", "Solution for haemodiafiltration", "Solution for haemodiafiltration", "H\u00e4modiafiltrationsl\u00f6sung", "Solution pour h\u00e9modiafiltration", "Soluzione per emofiltrazione"),
    SOLUTION_FOR_HAEMODIALYSIS("11404000", "0.4.0.127.0.16.1.1.2.1", "Solution for haemodialysis", "Solution for haemodialysis", "H\u00e4modialysel\u00f6sung", "Solution pour h\u00e9modialyse", "Soluzione per emodialisi"),
    SOLUTION_FOR_HAEMODIALYSIS_HAEMOFILTRATION("50057000", "0.4.0.127.0.16.1.1.2.1", "Solution for haemodialysis/haemofiltration", "Solution for haemodialysis/haemofiltration", "H\u00e4modialysel\u00f6sung/H\u00e4mofiltrationsl\u00f6sung", "Solution pour h\u00e9modialyse/h\u00e9mofiltration", "Soluzione per emodialisi/emofiltrazione"),
    SOLUTION_FOR_HAEMOFILTRATION("11402000", "0.4.0.127.0.16.1.1.2.1", "Solution for haemofiltration", "Solution for haemofiltration", "H\u00e4mofiltrationsl\u00f6sung", "Solution pour h\u00e9mofiltration", "Soluzione per emofiltrazione"),
    SOLUTION_FOR_INFUSION("11210000", "0.4.0.127.0.16.1.1.2.1", "Solution for infusion", "Solution for infusion", "Infusionsl\u00f6sung", "Solution pour perfusion", "Soluzione per infusione"),
    SOLUTION_FOR_INJECTION("11201000", "0.4.0.127.0.16.1.1.2.1", "Solution for injection", "Solution for injection", "Injektionsl\u00f6sung", "Solution injectable", "Soluzione iniettabile"),
    SOLUTION_FOR_INJECTION_INFUSION("50060000", "0.4.0.127.0.16.1.1.2.1", "Solution for injection/infusion", "Solution for injection/infusion", "Injektions-/Infusionsl\u00f6sung", "Solution injectable/pour perfusion", "Soluzione iniettabile o per infusione"),
    SOLUTION_FOR_INJECTION_SKIN_PRICK_TEST("13051000", "0.4.0.127.0.16.1.1.2.1", "Solution for injection/skin-prick test", "Solution for injection/skin-prick test", "Injektionsl\u00f6sung/ Pricktestl\u00f6sung", "Solution injectable/ pour prick-test", "Soluzione iniettabile/per skin-prick test"),
    SOLUTION_FOR_INTRAOCULAR_IRRIGATION("50073500", "0.4.0.127.0.16.1.1.2.1", "Solution for intraocular irrigation", "Solution for intraocular irrigation", "L\u00f6sung zur intraokularen Anwendung", "Solution pour irrigation intraoculaire", "Soluzione per irrigazione intraoculare"),
    SOLUTION_FOR_IONTOPHORESIS("10518000", "0.4.0.127.0.16.1.1.2.1", "Solution for iontophoresis", "Solution for iontophoresis", "L\u00f6sung zur Iontophorese", "Solution pour iontophor\u00e8se", "Soluzione per iontoforesi"),
    SOLUTION_FOR_ORGAN_PRESERVATION("12112000", "0.4.0.127.0.16.1.1.2.1", "Solution for organ preservation", "Solution for organ preservation", "Organkonservierungsl\u00f6sung", "Solution pour conservation d'organe", "Soluzione per conservazione di organi"),
    SOLUTION_FOR_PERITONEAL_DIALYSIS("11401000", "0.4.0.127.0.16.1.1.2.1", "Solution for peritoneal dialysis", "Solution for peritoneal dialysis", "Peritonealdialysel\u00f6sung", "Solution pour dialyse p\u00e9riton\u00e9ale", "Soluzione per dialisi peritoneale"),
    SOLUTION_FOR_PROVOCATION_TEST("12131000", "0.4.0.127.0.16.1.1.2.1", "Solution for provocation test", "Solution for provocation test", "Provokationstestl\u00f6sung", "solution pour test de provocation", "Soluzione per saggio di provocazione"),
    SOLUTION_FOR_SEALANT("50061500", "0.4.0.127.0.16.1.1.2.1", "Solution for sealant", "Solution for sealant", "L\u00f6sung f\u00fcr Gewebekleber", "Solution pour colle", "Soluzione per adesivo tissutale"),
    SOLUTION_FOR_SKIN_PRICK_TEST("10548000", "0.4.0.127.0.16.1.1.2.1", "Solution for skin-prick test", "Solution for skin-prick test", "Pricktestl\u00f6sung", "solution pour prick-test", "Soluzione per skin-prick test"),
    SOLUTION_FOR_SKIN_SCRATCH_TEST("10549000", "0.4.0.127.0.16.1.1.2.1", "Solution for skin-scratch test", "Solution for skin-scratch test", "Scratchtestl\u00f6sung", "solution pour test intradermique", "Soluzione per scarificazione"),
    SOLUTION_FOR_SOLUTION_FOR_INFUSION("13061000", "0.4.0.127.0.16.1.1.2.1", "Solution for solution for infusion", "Solution for solution for infusion", "L\u00f6sung zur Herstellung einer Infusionsl\u00f6sung", "Solution pour solution pour perfusion", "Soluzione per soluzione per infusione"),
    SOLUTION_FOR_SOLUTION_FOR_INJECTION("13033000", "0.4.0.127.0.16.1.1.2.1", "Solution for solution for injection", "Solution for solution for injection", "L\u00f6sung zur Herstellung einer Injektionsl\u00f6sung", "Solution pour solution injectable", "Soluzione per soluzione iniettabile"),
    SOLUTION_FOR_SUSPENSION_FOR_INJECTION("13047000", "0.4.0.127.0.16.1.1.2.1", "Solution for suspension for injection", "Solution for suspension for injection", "L\u00f6sung zur Herstellung einer Injektionssuspension", "Solution pour suspension injectable", "Soluzione per sospensione iniettabile"),
    SOLVENT_FOR("13035000", "0.4.0.127.0.16.1.1.2.1", "Solvent for...", "Solvent for...", "L\u00f6sungsmittel zur Herstellung...", "Solvant pour...", "Solvente per\u2026"),
    SOLVENT_FOR_PARENTERAL_USE("11216000", "0.4.0.127.0.16.1.1.2.1", "Solvent for parenteral use", "Solvent for parenteral use", "L\u00f6sungsmittel zur Herstellung von Parenteralia", "Solvant pour pr\u00e9paration parent\u00e9rale", "Solvente per uso parenterale"),
    SOLVENT_FOR_SOLUTION_FOR_INFUSION("50076000", "0.4.0.127.0.16.1.1.2.1", "Solvent for solution for infusion", "Solvent for solution for infusion", "L\u00f6sungsmittel zur Herstellung einer Infusionsl\u00f6sung", "Solvant pour solution pour perfusion", "Solvente per soluzione per infusione"),
    SOLVENT_FOR_SOLUTION_FOR_INTRAOCULAR_IRRIGATION("50074000", "0.4.0.127.0.16.1.1.2.1", "Solvent for solution for intraocular irrigation", "Solvent for solution for intraocular irrigation", "L\u00f6sungsmittel zur Herstellung einer L\u00f6sung zur intraokularen Anwendung", "Solvant pour solution pour irrigation intraoculaire", "Solvente per soluzione per irrigazione intraoculare"),
    STOMACH_IRRIGATION("12114000", "0.4.0.127.0.16.1.1.2.1", "Stomach irrigation", "Stomach irrigation", "Magensp\u00fclfl\u00fcssigkeit", "Solution pour irrigation stomacale", "Liquido per lavanda gastrica"),
    SUBLINGUAL_FILM("10317500", "0.4.0.127.0.16.1.1.2.1", "Sublingual film", "Sublingual film", "Schmelzfilm zur sublingualen Anwendung", "Film sublinguale", "Film sublinguale"),
    SUBLINGUAL_LYOPHILISATE("13127000", "0.4.0.127.0.16.1.1.2.1", "Sublingual lyophilisate", "Sublingual lyophilisate", "Lyophilisat zur sublingualen Anwendung", "Larves m\u00e9dicinales", "Larva medicinale"),
    SUBLINGUAL_POWDER("13105000", "0.4.0.127.0.16.1.1.2.1", "Sublingual powder", "Sublingual powder", "Pulver zur sublingualen Anwendung", "Poudre sublinguale", "Polvere sublinguale"),
    SUBLINGUAL_SPRAY_EMULSION("10309100", "0.4.0.127.0.16.1.1.2.1", "Sublingual spray, emulsion", "Sublingual spray, emulsion", "Sublingualspray, Emulsion", "Emulsion pour pulv\u00e9risation sublinguale", "Spray sublinguale, emulsione"),
    SUBLINGUAL_SPRAY_SOLUTION("10309200", "0.4.0.127.0.16.1.1.2.1", "Sublingual spray, solution", "Sublingual spray, solution", "Sublingualspray, L\u00f6sung", "Solution pour pulv\u00e9risation sublinguale", "Spray sublinguale, soluzione"),
    SUBLINGUAL_SPRAY_SUSPENSION("10309300", "0.4.0.127.0.16.1.1.2.1", "Sublingual spray, suspension", "Sublingual spray, suspension", "Sublingualspray, Suspension", "Suspension pour pulv\u00e9risation sublinguale", "Spray sublinguale, sospensione"),
    SUBLINGUAL_TABLET("10318000", "0.4.0.127.0.16.1.1.2.1", "Sublingual tablet", "Sublingual tablet", "Sublingualtablette", "Comprim\u00e9 sublingual", "Compressa sublinguale"),
    SUPPOSITORY("11013000", "0.4.0.127.0.16.1.1.2.1", "Suppository", "Suppository", "Z\u00e4pfchen", "Suppositoire", "Supposta"),
    SUSPENSION_FOR_EMULSION_FOR_INJECTION("13036000", "0.4.0.127.0.16.1.1.2.1", "Suspension for emulsion for injection", "Suspension for emulsion for injection", "Suspension zur Herstellung einer Emulsion zur Injektion", "Suspension pour \u00e9mulsion injectable", "Sospensione per emulsione iniettabile"),
    SUSPENSION_FOR_INJECTION("11202000", "0.4.0.127.0.16.1.1.2.1", "Suspension for injection", "Suspension for injection", "Injektionssuspension", "Suspension injectable", "Sospensione iniettabile"),
    SUSPENSION_FOR_ORAL_SUSPENSION("13037000", "0.4.0.127.0.16.1.1.2.1", "Suspension for oral suspension", "Suspension for oral suspension", "Suspension zur Herstellung einer Suspension zum Einnehmen", "Suspension pour suspension buvable", "Sospensione per sospensione orale"),
    SUSPENSION_FOR_SUSPENSION_FOR_INJECTION("13039000", "0.4.0.127.0.16.1.1.2.1", "Suspension for suspension for injection", "Suspension for suspension for injection", "Suspension zur Herstellung einer Injektionssuspension", "Suspension pour suspension injectable", "Sospensione per sospensione iniettabile"),
    SYRUP("10117000", "0.4.0.127.0.16.1.1.2.1", "Syrup", "Syrup", "Sirup", "Sirop", "Sciroppo"),
    TABLET("10219000", "0.4.0.127.0.16.1.1.2.1", "Tablet", "Tablet", "Tablette", "Comprim\u00e9", "Compressa"),
    TABLET_FOR_CUTANEOUS_SOLUTION("13066000", "0.4.0.127.0.16.1.1.2.1", "Tablet for cutaneous solution", "Tablet for cutaneous solution", "Tablette zur Herstellung einer L\u00f6sung zur Anwendung auf der Haut", "Comprim\u00e9 pour solution cutan\u00e9e", "Compressa per soluzione cutanea"),
    TABLET_FOR_RECTAL_SOLUTION("11011000", "0.4.0.127.0.16.1.1.2.1", "Tablet for rectal solution", "Tablet for rectal solution", "Tablette zur Herstellung einer Rektall\u00f6sung", "Comprim\u00e9 pour solution rectale", "Compressa per soluzione rettale"),
    TABLET_FOR_RECTAL_SUSPENSION("11012000", "0.4.0.127.0.16.1.1.2.1", "Tablet for rectal suspension", "Tablet for rectal suspension", "Tablette zur Herstellung einer Rektalsuspension", "Comprim\u00e9 pour suspension rectale", "Compressa per sospensione rettale"),
    TABLET_FOR_VAGINAL_SOLUTION("10908000", "0.4.0.127.0.16.1.1.2.1", "Tablet for vaginal solution", "Tablet for vaginal solution", "Tablette zur Herstellung einer Vaginall\u00f6sung", "Comprim\u00e9 pour solution vaginale", "Compressa per soluzione vaginale"),
    TABLET_WITH_SENSOR("13118000", "0.4.0.127.0.16.1.1.2.1", "Tablet with sensor", "Tablet with sensor", "Tablette mit Sensor", "Comprim\u00e9 avec capteur", "Compressa con sensore"),
    TOOTHPASTE("10409000", "0.4.0.127.0.16.1.1.2.1", "Toothpaste", "Toothpaste", "Zahnpaste", "P\u00e2te dentifrice", "Pasta dentifricia"),
    TRANSDERMAL_GEL("10546250", "0.4.0.127.0.16.1.1.2.1", "Transdermal gel", "Transdermal gel", "Transdermales Gel", "Gel transdermique", "Gel transdermico"),
    TRANSDERMAL_OINTMENT("13102000", "0.4.0.127.0.16.1.1.2.1", "Transdermal ointment", "Transdermal ointment", "Transdermale Salbe", "Pommade transdermique", "Unguento transdermico"),
    TRANSDERMAL_PATCH("10519000", "0.4.0.127.0.16.1.1.2.1", "Transdermal patch", "Transdermal patch", "transdermales Pflaster", "Patch transdermique", "Cerotto transdermico"),
    TRANSDERMAL_SOLUTION("10546400", "0.4.0.127.0.16.1.1.2.1", "Transdermal solution", "Transdermal solution", "transdermale L\u00f6sung", "Solution transdermique", "Soluzione transdermica"),
    TRANSDERMAL_SPRAY_SOLUTION("10546500", "0.4.0.127.0.16.1.1.2.1", "Transdermal spray, solution", "Transdermal spray, solution", "transdermales Spray, L\u00f6sung", "Solution pour pulv\u00e9risation transdermique", "Spray transdermico, soluzione"),
    TRANSDERMAL_SYSTEM("10547000", "0.4.0.127.0.16.1.1.2.1", "Transdermal system", "Transdermal system", "transdermales System", "syst\u00e8me transdermique", "Sistema transdermico"),
    URETHRAL_EMULSION("13077000", "0.4.0.127.0.16.1.1.2.1", "Urethral emulsion", "Urethral emulsion", "Emulsion zur Anwendung in der Harnr\u00f6hre", "Emulsion ur\u00e9trale", "Emulsione uretrale"),
    URETHRAL_GEL("11504000", "0.4.0.127.0.16.1.1.2.1", "Urethral gel", "Urethral gel", "Gel zur Anwendung in der Harnr\u00f6hre", "Gel ur\u00e9tral", "Gel uretrale"),
    URETHRAL_OINTMENT("13123000", "0.4.0.127.0.16.1.1.2.1", "Urethral ointment", "Urethral ointment", "Salbe zur Anwendung in der Harnr\u00f6hre", "Pommade ur\u00e9trale", "Unguento uretrale"),
    URETHRAL_STICK("11505000", "0.4.0.127.0.16.1.1.2.1", "Urethral stick", "Urethral stick", "St\u00e4bchen zur Anwendung in der Harnr\u00f6hre", "B\u00e2ton pour usage ur\u00e9tral", "Bastoncino uretrale"),
    VAGINAL_CAPSULE_HARD("10910000", "0.4.0.127.0.16.1.1.2.1", "Vaginal capsule, hard", "Vaginal capsule, hard", "Hartkapsel zur vaginalen Anwendung", "G\u00e9lule vaginale", "Capsula rigida vaginale"),
    VAGINAL_CAPSULE_SOFT("10911000", "0.4.0.127.0.16.1.1.2.1", "Vaginal capsule, soft", "Vaginal capsule, soft", "Weichkapsel zur vaginalen Anwendung", "Capsule molle vaginale", "Capsula molle vaginale"),
    VAGINAL_CREAM("10901000", "0.4.0.127.0.16.1.1.2.1", "Vaginal cream", "Vaginal cream", "Vaginalcreme", "Cr\u00e8me vaginale", "Crema vaginale"),
    VAGINAL_DELIVERY_SYSTEM("10915000", "0.4.0.127.0.16.1.1.2.1", "Vaginal delivery system", "Vaginal delivery system", "vaginales Wirkstofffreisetzungssystem", "Syst\u00e8me de diffusion vaginal", "Dispositivo vaginale"),
    VAGINAL_EMULSION("10907000", "0.4.0.127.0.16.1.1.2.1", "Vaginal emulsion", "Vaginal emulsion", "Vaginalemulsion", "Emulsion vaginale", "Emulsione vaginale"),
    VAGINAL_FOAM("10904000", "0.4.0.127.0.16.1.1.2.1", "Vaginal foam", "Vaginal foam", "Vaginalschaum", "Mousse vaginale", "Schiuma vaginale"),
    VAGINAL_GEL("10902000", "0.4.0.127.0.16.1.1.2.1", "Vaginal gel", "Vaginal gel", "Vaginalgel", "Gel vaginal", "Gel vaginale"),
    VAGINAL_OINTMENT("10903000", "0.4.0.127.0.16.1.1.2.1", "Vaginal ointment", "Vaginal ointment", "Vaginalsalbe", "Pommade vaginale", "Unguento vaginale"),
    VAGINAL_SOLUTION("10905000", "0.4.0.127.0.16.1.1.2.1", "Vaginal solution", "Vaginal solution", "Vaginall\u00f6sung", "Solution vaginale", "Soluzione vaginale"),
    VAGINAL_SUSPENSION("10906000", "0.4.0.127.0.16.1.1.2.1", "Vaginal suspension", "Vaginal suspension", "Vaginalsuspension", "Suspension vaginale", "Sospensione vaginale"),
    VAGINAL_TABLET("10912000", "0.4.0.127.0.16.1.1.2.1", "Vaginal tablet", "Vaginal tablet", "Vaginaltablette", "Comprim\u00e9 vaginal", "Compressa vaginale"),
    WOUND_STICK("12104000", "0.4.0.127.0.16.1.1.2.1", "Wound stick", "Wound stick", "Wundst\u00e4bchen", "B\u00e2ton intral\u00e9sionnel", "Matita emostatica");

    public static final String ANTICOAGULANT_AND_PRESERVATIVE_SOLUTION_FOR_BLOOD_CODE = "12102000";
    public static final String BATH_ADDITIVE_CODE = "10501000";
    public static final String BLADDER_IRRIGATION_CODE = "11502000";
    public static final String BUCCAL_FILM_CODE = "10314011";
    public static final String BUCCAL_TABLET_CODE = "10320000";
    public static final String CACHET_CODE = "10209000";
    public static final String CAPSULE_HARD_CODE = "10210000";
    public static final String CAPSULE_SOFT_CODE = "10211000";
    public static final String CHEWABLE_CAPSULE_SOFT_CODE = "10214000";
    public static final String CHEWABLE_DISPERSIBLE_TABLET_CODE = "50001000";
    public static final String CHEWABLE_TABLET_CODE = "10228000";
    public static final String COATED_GRANULES_CODE = "13046000";
    public static final String COATED_TABLET_CODE = "10220000";
    public static final String COLLODION_CODE = "10520000";
    public static final String COMPRESSED_LOZENGE_CODE = "10322000";
    public static final String CONCENTRATE_FOR_CONCENTRATE_FOR_SOLUTION_FOR_INFUSION_CODE = "13001000";
    public static final String CONCENTRATE_FOR_CUTANEOUS_SOLUTION_CODE = "10514000";
    public static final String CONCENTRATE_FOR_CUTANEOUS_SPRAY_EMULSION_CODE = "50009000";
    public static final String CONCENTRATE_FOR_DISPERSION_FOR_INFUSION_CODE = "50009300";
    public static final String CONCENTRATE_FOR_DISPERSION_FOR_INJECTION_CODE = "13139000";
    public static final String CONCENTRATE_FOR_EMULSION_FOR_INFUSION_CODE = "50009500";
    public static final String CONCENTRATE_FOR_GARGLE_CODE = "10302000";
    public static final String CONCENTRATE_FOR_INTRAVESICAL_SOLUTION_CODE = "50009750";
    public static final String CONCENTRATE_FOR_NEBULISER_SOLUTION_CODE = "13002000";
    public static final String CONCENTRATE_FOR_ORAL_RECTAL_SOLUTION_CODE = "50011000";
    public static final String CONCENTRATE_FOR_ORAL_SOLUTION_CODE = "50010000";
    public static final String CONCENTRATE_FOR_ORAL_SUSPENSION_CODE = "10100500";
    public static final String CONCENTRATE_FOR_OROMUCOSAL_SOLUTION_CODE = "13003000";
    public static final String CONCENTRATE_FOR_RECTAL_SOLUTION_CODE = "11008000";
    public static final String CONCENTRATE_FOR_SOLUTION_FOR_HAEMODIALYSIS_CODE = "11405000";
    public static final String CONCENTRATE_FOR_SOLUTION_FOR_INFUSION_CODE = "11213000";
    public static final String CONCENTRATE_FOR_SOLUTION_FOR_INJECTION_CODE = "11209000";
    public static final String CONCENTRATE_FOR_SOLUTION_FOR_INJECTION_INFUSION_CODE = "50079000";
    public static final String CONCENTRATE_FOR_SOLUTION_FOR_INTRAOCULAR_IRRIGATION_CODE = "10600500";
    public static final String CONCENTRATE_FOR_SOLUTION_FOR_PERITONEAL_DIALYSIS_CODE = "50013250";
    public static final String CONCENTRATE_FOR_SUSPENSION_FOR_INJECTION_CODE = "13004000";
    public static final String CREAM_CODE = "10502000";
    public static final String CUTANEOUS_EMULSION_CODE = "10516000";
    public static final String CUTANEOUS_FOAM_CODE = "10507000";
    public static final String CUTANEOUS_LIQUID_CODE = "10512000";
    public static final String CUTANEOUS_NASAL_OINTMENT_CODE = "50015200";
    public static final String CUTANEOUS_OROMUCOSAL_SOLUTION_CODE = "13140000";
    public static final String CUTANEOUS_PASTE_CODE = "10505000";
    public static final String CUTANEOUS_PATCH_CODE = "10517500";
    public static final String CUTANEOUS_POWDER_CODE = "10517000";
    public static final String CUTANEOUS_SOLUTION_CODE = "10513000";
    public static final String CUTANEOUS_SOLUTION_CONCENTRATE_FOR_OROMUCOSAL_SOLUTION_CODE = "50015450";
    public static final String CUTANEOUS_SPRAY_EMULSION_CODE = "50015500";
    public static final String CUTANEOUS_SPRAY_OINTMENT_CODE = "50016000";
    public static final String CUTANEOUS_SPRAY_POWDER_CODE = "10511000";
    public static final String CUTANEOUS_SPRAY_SOLUTION_CODE = "10509000";
    public static final String CUTANEOUS_SPRAY_SUSPENSION_CODE = "10510000";
    public static final String CUTANEOUS_STICK_CODE = "10523000";
    public static final String CUTANEOUS_SUSPENSION_CODE = "10515000";
    public static final String DENTAL_CEMENT_CODE = "10401500";
    public static final String DENTAL_EMULSION_CODE = "10408000";
    public static final String DENTAL_GEL_CODE = "10402000";
    public static final String DENTAL_PASTE_CODE = "50017000";
    public static final String DENTAL_POWDER_CODE = "10405000";
    public static final String DENTAL_SOLUTION_CODE = "10406000";
    public static final String DENTAL_STICK_CODE = "10403000";
    public static final String DENTAL_SUSPENSION_CODE = "10407000";
    public static final String DENTURE_LACQUER_CODE = "12101000";
    public static final String DISPERSIBLE_TABLET_CODE = "10121000";
    public static final String DISPERSIBLE_TABLETS_FOR_DOSE_DISPENSER_CODE = "10121500";
    public static final String DISPERSION_FOR_CONCENTRATE_FOR_DISPERSION_FOR_INFUSION_CODE = "13005000";
    public static final String DISPERSION_FOR_INFUSION_CODE = "50017500";
    public static final String DISPERSION_FOR_INJECTION_CODE = "50077000";
    public static final String DISPERSION_FOR_INJECTION_INFUSION_CODE = "13049000";
    public static final String EAR_CREAM_CODE = "10701000";
    public static final String EAR_DROPS_EMULSION_CODE = "10706000";
    public static final String EAR_DROPS_POWDER_FOR_SUSPENSION_CODE = "13006000";
    public static final String EAR_DROPS_SOLUTION_CODE = "10704000";
    public static final String EAR_DROPS_SUSPENSION_CODE = "10705000";
    public static final String EAR_EYE_DROPS_SOLUTION_CODE = "50018000";
    public static final String EAR_EYE_DROPS_SUSPENSION_CODE = "50018500";
    public static final String EAR_EYE_NASAL_DROPS_SOLUTION_CODE = "50019500";
    public static final String EAR_EYE_OINTMENT_CODE = "50019000";
    public static final String EAR_GEL_CODE = "10702000";
    public static final String EAR_NASAL_DROPS_SUSPENSION_CODE = "50020200";
    public static final String EAR_OINTMENT_CODE = "10703000";
    public static final String EAR_POWDER_CODE = "10708000";
    public static final String EAR_SPRAY_EMULSION_CODE = "10711000";
    public static final String EAR_SPRAY_SOLUTION_CODE = "10709000";
    public static final String EAR_SPRAY_SUSPENSION_CODE = "10710000";
    public static final String EAR_STICK_CODE = "10715000";
    public static final String EAR_TAMPON_CODE = "10714000";
    public static final String EAR_WASH_EMULSION_CODE = "10713000";
    public static final String EAR_WASH_SOLUTION_CODE = "10712000";
    public static final String EFFERVESCENT_GRANULES_CODE = "10205000";
    public static final String EFFERVESCENT_GRANULES_FOR_ORAL_SUSPENSION_CODE = "13007000";
    public static final String EFFERVESCENT_POWDER_CODE = "10203000";
    public static final String EFFERVESCENT_TABLET_CODE = "10222000";
    public static final String EFFERVESCENT_VAGINAL_TABLET_CODE = "10913000";
    public static final String EMULSION_FOR_EMULSION_FOR_INJECTION_CODE = "13008000";
    public static final String EMULSION_FOR_INFUSION_CODE = "11211000";
    public static final String EMULSION_FOR_INJECTION_CODE = "11203000";
    public static final String EMULSION_FOR_INJECTION_INFUSION_CODE = "50021000";
    public static final String EMULSION_FOR_SUSPENSION_FOR_INJECTION_CODE = "13091000";
    public static final String ENDOCERVICAL_GEL_CODE = "11701000";
    public static final String ENDOSINUSIAL_SOLUTION_CODE = "13041000";
    public static final String ENDOSINUSIAL_WASH_SUSPENSION_CODE = "50022000";
    public static final String ENDOTRACHEOPULMONARY_INSTILLATION_POWDER_FOR_SOLUTION_CODE = "11602000";
    public static final String ENDOTRACHEOPULMONARY_INSTILLATION_POWDER_FOR_SUSPENSION_CODE = "13009000";
    public static final String ENDOTRACHEOPULMONARY_INSTILLATION_SOLUTION_CODE = "11601000";
    public static final String ENDOTRACHEOPULMONARY_INSTILLATION_SUSPENSION_CODE = "11603000";
    public static final String EPILESIONAL_SOLUTION_CODE = "13042000";
    public static final String EYE_CREAM_CODE = "10601000";
    public static final String EYE_DROPS_EMULSION_CODE = "10604500";
    public static final String EYE_DROPS_POWDER_FOR_SOLUTION_CODE = "13010000";
    public static final String EYE_DROPS_POWDER_FOR_SUSPENSION_CODE = "13011000";
    public static final String EYE_DROPS_PROLONGED_RELEASE_CODE = "10609000";
    public static final String EYE_DROPS_SOLUTION_CODE = "10604000";
    public static final String EYE_DROPS_SOLVENT_FOR_RECONSTITUTION_CODE = "10608000";
    public static final String EYE_DROPS_SUSPENSION_CODE = "10605000";
    public static final String EYE_GEL_CODE = "10602000";
    public static final String EYE_LOTION_CODE = "10610000";
    public static final String EYE_LOTION_SOLVENT_FOR_RECONSTITUTION_CODE = "10611000";
    public static final String EYE_OINTMENT_CODE = "10603000";
    public static final String FILM_COATED_TABLET_CODE = "10221000";
    public static final String GARGLE_CODE = "10301000";
    public static final String GARGLE_MOUTHWASH_CODE = "50024000";
    public static final String GARGLE_NASAL_WASH_CODE = "50024500";
    public static final String GARGLE_POWDER_FOR_SOLUTION_CODE = "10303000";
    public static final String GARGLE_TABLET_FOR_SOLUTION_CODE = "10304000";
    public static final String GASTROENTERAL_EMULSION_CODE = "12111000";
    public static final String GASTROENTERAL_SOLUTION_CODE = "12108000";
    public static final String GASTROENTERAL_SUSPENSION_CODE = "12110000";
    public static final String GASTRO_RESISTANT_CAPSULE_HARD_CODE = "10212000";
    public static final String GASTRO_RESISTANT_CAPSULE_SOFT_CODE = "10213000";
    public static final String GASTRO_RESISTANT_GRANULES_CODE = "10206000";
    public static final String GASTRO_RESISTANT_GRANULES_FOR_ORAL_SUSPENSION_CODE = "50026000";
    public static final String GASTRO_RESISTANT_ORAL_SUSPENSION_CODE = "13133000";
    public static final String GASTRO_RESISTANT_POWDER_FOR_ORAL_SUSPENSION_CODE = "13136000";
    public static final String GASTRO_RESISTANT_TABLET_CODE = "10225000";
    public static final String GAS_FOR_DISPERSION_FOR_INFUSION_CODE = "13012000";
    public static final String GAS_FOR_DISPERSION_FOR_INJECTION_CODE = "13013000";
    public static final String GAS_FOR_DISPERSION_FOR_INJECTION_INFUSION_CODE = "13050000";
    public static final String GEL_CODE = "10503000";
    public static final String GEL_FOR_GEL_CODE = "13014000";
    public static final String GEL_FOR_INJECTION_CODE = "11204000";
    public static final String GINGIVAL_GEL_CODE = "10315000";
    public static final String GINGIVAL_PASTE_CODE = "10316000";
    public static final String GINGIVAL_SOLUTION_CODE = "10312000";
    public static final String GRANULES_CODE = "10204000";
    public static final String GRANULES_FOR_ORAL_RECTAL_SUSPENSION_CODE = "50029150";
    public static final String GRANULES_FOR_ORAL_SOLUTION_CODE = "10112000";
    public static final String GRANULES_FOR_ORAL_SUSPENSION_CODE = "10113000";
    public static final String GRANULES_FOR_RECTAL_SUSPENSION_CODE = "13015000";
    public static final String GRANULES_FOR_SUSPENSION_FOR_INJECTION_CODE = "13048000";
    public static final String GRANULES_FOR_SYRUP_CODE = "10119000";
    public static final String GRANULES_FOR_VAGINAL_SOLUTION_CODE = "50029500";
    public static final String HERBAL_TEA_CODE = "10122000";
    public static final String IMPLANT_CODE = "11301000";
    public static final String IMPLANTATION_CHAIN_CODE = "11303000";
    public static final String IMPLANTATION_MATRIX_CODE = "11303300";
    public static final String IMPLANTATION_PASTE_CODE = "13043000";
    public static final String IMPLANTATION_SUSPENSION_CODE = "11303500";
    public static final String IMPLANTATION_TABLET_CODE = "11302000";
    public static final String IMPREGNATED_DRESSING_CODE = "10525000";
    public static final String IMPREGNATED_PAD_CODE = "12117000";
    public static final String IMPREGNATED_PLUG_CODE = "12117500";
    public static final String INHALATION_POWDER_CODE = "11109000";
    public static final String INHALATION_POWDER_HARD_CAPSULE_CODE = "11110000";
    public static final String INHALATION_POWDER_PRE_DISPENSED_CODE = "11111000";
    public static final String INHALATION_POWDER_TABLET_CODE = "50030000";
    public static final String INHALATION_SOLUTION_CODE = "50081000";
    public static final String INHALATION_VAPOUR_CAPSULE_CODE = "11113000";
    public static final String INHALATION_VAPOUR_EFFERVESCENT_TABLET_CODE = "50031000";
    public static final String INHALATION_VAPOUR_EMULSION_CODE = "50032000";
    public static final String INHALATION_VAPOUR_IMPREGNATED_PAD_CODE = "50033000";
    public static final String INHALATION_VAPOUR_IMPREGNATED_PLUG_CODE = "50033100";
    public static final String INHALATION_VAPOUR_LIQUID_CODE = "11117000";
    public static final String INHALATION_VAPOUR_OINTMENT_CODE = "11116000";
    public static final String INHALATION_VAPOUR_POWDER_CODE = "11112000";
    public static final String INHALATION_VAPOUR_SOLUTION_CODE = "11114000";
    public static final String INHALATION_VAPOUR_TABLET_CODE = "11115000";
    public static final String INSTANT_HERBAL_TEA_CODE = "10202000";
    public static final String INTESTINAL_GEL_CODE = "12120000";
    public static final String INTRAOCULAR_INSTILLATION_SOLUTION_CODE = "13044000";
    public static final String INTRAPERITONEAL_SOLUTION_CODE = "12111500";
    public static final String INTRAUTERINE_DELIVERY_SYSTEM_CODE = "11901000";
    public static final String INTRAUTERINE_GEL_CODE = "13113000";
    public static final String INTRAVESICAL_SOLUTION_CODE = "11502500";
    public static final String INTRAVESICAL_SOLUTION_SOLUTION_FOR_INJECTION_CODE = "50033400";
    public static final String INTRAVESICAL_SUSPENSION_CODE = "13045000";
    public static final String IRRIGATION_SOLUTION_CODE = "12113000";
    public static final String KIT_FOR_RADIOPHARMACEUTICAL_PREPARATION_CODE = "12107000";
    public static final String LARYNGOPHARYNGEAL_SOLUTION_CODE = "13016000";
    public static final String LARYNGOPHARYNGEAL_SPRAY_SOLUTION_CODE = "13017000";
    public static final String LIVING_TISSUE_EQUIVALENT_CODE = "12118000";
    public static final String LOZENGE_CODE = "10321000";
    public static final String MATRIX_FOR_IMPLANTATION_MATRIX_CODE = "13018000";
    public static final String MEDICATED_CHEWING_GUM_CODE = "10229000";
    public static final String MEDICATED_NAIL_LACQUER_CODE = "10521000";
    public static final String MEDICATED_PLASTER_CODE = "10506000";
    public static final String MEDICATED_SPONGE_CODE = "12119000";
    public static final String MEDICATED_THREAD_CODE = "12130000";
    public static final String MEDICATED_VAGINAL_TAMPON_CODE = "10914000";
    public static final String MEDICINAL_GAS_COMPRESSED_CODE = "12301000";
    public static final String MEDICINAL_GAS_CRYOGENIC_CODE = "12302000";
    public static final String MEDICINAL_GAS_LIQUEFIED_CODE = "12303000";
    public static final String MEDICINAL_LARVAE_CODE = "13124000";
    public static final String MEDICINAL_LEECH_CODE = "13115000";
    public static final String MODIFIED_RELEASE_CAPSULE_HARD_CODE = "10217000";
    public static final String MODIFIED_RELEASE_CAPSULE_SOFT_CODE = "10218000";
    public static final String MODIFIED_RELEASE_GRANULES_CODE = "10208000";
    public static final String MODIFIED_RELEASE_GRANULES_FOR_ORAL_SUSPENSION_CODE = "50036000";
    public static final String MODIFIED_RELEASE_ORAL_SUSPENSION_CODE = "13135000";
    public static final String MODIFIED_RELEASE_TABLET_CODE = "10227000";
    public static final String MOUTHWASH_CODE = "10310000";
    public static final String MOUTHWASH_POWDER_FOR_SOLUTION_CODE = "50036050";
    public static final String MOUTHWASH_TABLET_FOR_SOLUTION_CODE = "10311000";
    public static final String MUCO_ADHESIVE_BUCCAL_TABLET_CODE = "10319000";
    public static final String NASAL_CREAM_CODE = "10801000";
    public static final String NASAL_DROPS_EMULSION_CODE = "10806000";
    public static final String NASAL_DROPS_POWDER_FOR_SOLUTION_CODE = "13020000";
    public static final String NASAL_DROPS_SOLUTION_CODE = "10804000";
    public static final String NASAL_DROPS_SUSPENSION_CODE = "10805000";
    public static final String NASAL_GEL_CODE = "10802000";
    public static final String NASAL_OINTMENT_CODE = "10803000";
    public static final String NASAL_OROMUCOSAL_SOLUTION_CODE = "50036500";
    public static final String NASAL_OROMUCOSAL_SPRAY_SOLUTION_CODE = "50036700";
    public static final String NASAL_POWDER_CODE = "10807000";
    public static final String NASAL_SPRAY_EMULSION_CODE = "10810000";
    public static final String NASAL_SPRAY_POWDER_FOR_SOLUTION_CODE = "50037100";
    public static final String NASAL_SPRAY_SOLUTION_CODE = "10808000";
    public static final String NASAL_SPRAY_SOLUTION_OROMUCOSAL_SOLUTION_CODE = "50037400";
    public static final String NASAL_SPRAY_SUSPENSION_CODE = "10809000";
    public static final String NASAL_STICK_CODE = "10812000";
    public static final String NASAL_WASH_CODE = "10811000";
    public static final String NEBULISER_DISPERSION_CODE = "13129000";
    public static final String NEBULISER_EMULSION_CODE = "11105000";
    public static final String NEBULISER_SOLUTION_CODE = "11101000";
    public static final String NEBULISER_SUSPENSION_CODE = "11102000";
    public static final String OINTMENT_CODE = "10504000";
    public static final String OPHTHALMIC_INSERT_CODE = "10612000";
    public static final String OPHTHALMIC_STRIP_CODE = "10613000";
    public static final String ORAL_DROPS_EMULSION_CODE = "10103000";
    public static final String ORAL_DROPS_GRANULES_FOR_SOLUTION_CODE = "50037500";
    public static final String ORAL_DROPS_LIQUID_CODE = "50037750";
    public static final String ORAL_DROPS_POWDER_FOR_SUSPENSION_CODE = "50082000";
    public static final String ORAL_DROPS_SOLUTION_CODE = "10101000";
    public static final String ORAL_DROPS_SUSPENSION_CODE = "10102000";
    public static final String ORAL_EMULSION_CODE = "10107000";
    public static final String ORAL_GEL_CODE = "10108000";
    public static final String ORAL_GUM_CODE = "10230000";
    public static final String ORAL_HERBAL_MATERIAL_CODE = "13106000";
    public static final String ORAL_LIQUID_CODE = "10104000";
    public static final String ORAL_LYOPHILISATE_CODE = "10224000";
    public static final String ORAL_PASTE_CODE = "10109000";
    public static final String ORAL_POWDER_CODE = "10201000";
    public static final String ORAL_RECTAL_SOLUTION_CODE = "50037900";
    public static final String ORAL_RECTAL_SUSPENSION_CODE = "50038000";
    public static final String ORAL_SOLUTION_CODE = "10105000";
    public static final String ORAL_SOLUTION_CONCENTRATE_FOR_NEBULISER_SOLUTION_CODE = "50038500";
    public static final String ORAL_SUSPENSION_CODE = "10106000";
    public static final String ORODISPERSIBLE_FILM_CODE = "10236100";
    public static final String ORODISPERSIBLE_TABLET_CODE = "10223000";
    public static final String OROMUCOSAL_CAPSULE_CODE = "10317000";
    public static final String OROMUCOSAL_CREAM_CODE = "10314010";
    public static final String OROMUCOSAL_DROPS_CODE = "10307000";
    public static final String OROMUCOSAL_GEL_CODE = "10313000";
    public static final String OROMUCOSAL_LARYNGOPHARYNGEAL_SOLUTION_CODE = "50039500";
    public static final String OROMUCOSAL_LARYNGOPHARYNGEAL_SOLUTION_SPRAY_SOLUTION_CODE = "50040500";
    public static final String OROMUCOSAL_OINTMENT_CODE = "10314005";
    public static final String OROMUCOSAL_PASTE_CODE = "10314000";
    public static final String OROMUCOSAL_PATCH_CODE = "50039000";
    public static final String OROMUCOSAL_POUCH_CODE = "13141000";
    public static final String OROMUCOSAL_SOLUTION_CODE = "10305000";
    public static final String OROMUCOSAL_SPRAY_EMULSION_CODE = "10308100";
    public static final String OROMUCOSAL_SPRAY_SOLUTION_CODE = "10308200";
    public static final String OROMUCOSAL_SPRAY_SUSPENSION_CODE = "10308300";
    public static final String OROMUCOSAL_SUSPENSION_CODE = "10306000";
    public static final String PASTILLE_CODE = "10323000";
    public static final String PERIODONTAL_GEL_CODE = "10410000";
    public static final String PERIODONTAL_INSERT_CODE = "10411000";
    public static final String PERIODONTAL_POWDER_CODE = "10401000";
    public static final String PESSARY_CODE = "10909000";
    public static final String PILLULES_CODE = "10231000";
    public static final String PLASTER_FOR_PROVOCATION_TEST_CODE = "10550000";
    public static final String POULTICE_CODE = "10522000";
    public static final String POWDER_FOR_BLADDER_IRRIGATION_CODE = "11503000";
    public static final String POWDER_FOR_CONCENTRATE_FOR_DISPERSION_FOR_INFUSION_CODE = "50048750";
    public static final String POWDER_FOR_CONCENTRATE_FOR_INTRAVESICAL_SUSPENSION_CODE = "50049100";
    public static final String POWDER_FOR_CONCENTRATE_FOR_SOLUTION_FOR_HAEMODIALYSIS_CODE = "50049200";
    public static final String POWDER_FOR_CONCENTRATE_FOR_SOLUTION_FOR_INFUSION_CODE = "50043000";
    public static final String POWDER_FOR_CONCENTRATE_FOR_SOLUTION_FOR_INJECTION_INFUSION_CODE = "50049250";
    public static final String POWDER_FOR_CUTANEOUS_SOLUTION_CODE = "10514500";
    public static final String POWDER_FOR_DENTAL_CEMENT_CODE = "10413000";
    public static final String POWDER_FOR_DENTAL_GEL_CODE = "13022000";
    public static final String POWDER_FOR_DENTAL_SOLUTION_CODE = "50049270";
    public static final String POWDER_FOR_DISPERSION_FOR_INFUSION_CODE = "11211500";
    public static final String POWDER_FOR_DISPERSION_FOR_INJECTION_CODE = "13023000";
    public static final String POWDER_FOR_EMULSION_FOR_INJECTION_CODE = "13040000";
    public static final String POWDER_FOR_ENDOCERVICAL_GEL_CODE = "13024000";
    public static final String POWDER_FOR_ENDOSINUSIAL_SOLUTION_CODE = "13025000";
    public static final String POWDER_FOR_EPILESIONAL_SOLUTION_CODE = "50049300";
    public static final String POWDER_FOR_GEL_CODE = "13021000";
    public static final String POWDER_FOR_GINGIVAL_GEL_CODE = "13026000";
    public static final String POWDER_FOR_IMPLANTATION_MATRIX_CODE = "13027000";
    public static final String POWDER_FOR_IMPLANTATION_PASTE_CODE = "13028000";
    public static final String POWDER_FOR_IMPLANTATION_SUSPENSION_CODE = "50049500";
    public static final String POWDER_FOR_INTRAOCULAR_INSTILLATION_SOLUTION_CODE = "13029000";
    public static final String POWDER_FOR_INTRAVESICAL_SOLUTION_CODE = "50050000";
    public static final String POWDER_FOR_INTRAVESICAL_SOLUTION_SOLUTION_FOR_INJECTION_CODE = "50050500";
    public static final String POWDER_FOR_INTRAVESICAL_SUSPENSION_CODE = "50051000";
    public static final String POWDER_FOR_NEBULISER_SOLUTION_CODE = "11104000";
    public static final String POWDER_FOR_NEBULISER_SUSPENSION_CODE = "11103000";
    public static final String POWDER_FOR_ORAL_RECTAL_SUSPENSION_CODE = "50052000";
    public static final String POWDER_FOR_ORAL_SOLUTION_CODE = "10110000";
    public static final String POWDER_FOR_ORAL_SUSPENSION_CODE = "10111000";
    public static final String POWDER_FOR_PROLONGED_RELEASE_SUSPENSION_FOR_INJECTION_CODE = "11208400";
    public static final String POWDER_FOR_RECTAL_SOLUTION_CODE = "11009000";
    public static final String POWDER_FOR_RECTAL_SUSPENSION_CODE = "11010000";
    public static final String POWDER_FOR_SEALANT_CODE = "13031000";
    public static final String POWDER_FOR_SOLUTION_FOR_INFUSION_CODE = "11212000";
    public static final String POWDER_FOR_SOLUTION_FOR_INJECTION_CODE = "11205000";
    public static final String POWDER_FOR_SOLUTION_FOR_INJECTION_INFUSION_CODE = "50053500";
    public static final String POWDER_FOR_SOLUTION_FOR_INJECTION_SKIN_PRICK_TEST_CODE = "13052000";
    public static final String POWDER_FOR_SOLUTION_FOR_INTRAOCULAR_IRRIGATION_CODE = "50073000";
    public static final String POWDER_FOR_SOLUTION_FOR_IONTOPHORESIS_CODE = "10518500";
    public static final String POWDER_FOR_SOLUTION_FOR_SKIN_PRICK_TEST_CODE = "13032000";
    public static final String POWDER_FOR_SUSPENSION_FOR_INJECTION_CODE = "11206000";
    public static final String POWDER_FOR_SYRUP_CODE = "10118000";
    public static final String POWDER_FOR_VAGINAL_SOLUTION_CODE = "13111000";
    public static final String PRESSURISED_INHALATION_EMULSION_CODE = "11108000";
    public static final String PRESSURISED_INHALATION_SOLUTION_CODE = "11106000";
    public static final String PRESSURISED_INHALATION_SUSPENSION_CODE = "11107000";
    public static final String PROLONGED_RELEASE_CAPSULE_HARD_CODE = "10215000";
    public static final String PROLONGED_RELEASE_CAPSULE_SOFT_CODE = "10216000";
    public static final String PROLONGED_RELEASE_DISPERSION_FOR_INJECTION_CODE = "13126000";
    public static final String PROLONGED_RELEASE_GRANULES_CODE = "10207000";
    public static final String PROLONGED_RELEASE_GRANULES_FOR_ORAL_SUSPENSION_CODE = "50056000";
    public static final String PROLONGED_RELEASE_ORAL_SUSPENSION_CODE = "13134000";
    public static final String PROLONGED_RELEASE_SOLUTION_FOR_INJECTION_CODE = "13076000";
    public static final String PROLONGED_RELEASE_SUSPENSION_FOR_INJECTION_CODE = "11208500";
    public static final String PROLONGED_RELEASE_TABLET_CODE = "10226000";
    public static final String PROLONGED_RELEASE_WOUND_SOLUTION_CODE = "13128000";
    public static final String RADIONUCLIDE_GENERATOR_CODE = "12106000";
    public static final String RADIOPHARMACEUTICAL_PRECURSOR_CODE = "12105000";
    public static final String RADIOPHARMACEUTICAL_PRECURSOR_SOLUTION_CODE = "50056500";
    public static final String RECTAL_CAPSULE_CODE = "11014000";
    public static final String RECTAL_CREAM_CODE = "11001000";
    public static final String RECTAL_EMULSION_CODE = "11007000";
    public static final String RECTAL_FOAM_CODE = "11004000";
    public static final String RECTAL_GEL_CODE = "11002000";
    public static final String RECTAL_OINTMENT_CODE = "11003000";
    public static final String RECTAL_SOLUTION_CODE = "11005000";
    public static final String RECTAL_SUSPENSION_CODE = "11006000";
    public static final String RECTAL_TAMPON_CODE = "11015000";
    public static final String SEALANT_CODE = "12115000";
    public static final String SEALANT_MATRIX_CODE = "12115100";
    public static final String SEALANT_POWDER_CODE = "12115200";
    public static final String SHAMPOO_CODE = "10508000";
    public static final String SOLUBLE_TABLET_CODE = "10120000";
    public static final String SOLUTION_FOR_BLOOD_FRACTION_MODIFICATION_CODE = "12103000";
    public static final String SOLUTION_FOR_CARDIOPLEGIA_CODE = "11209500";
    public static final String SOLUTION_FOR_CARDIOPLEGIA_ORGAN_PRESERVATION_CODE = "13107000";
    public static final String SOLUTION_FOR_DENTAL_CEMENT_CODE = "10414000";
    public static final String SOLUTION_FOR_HAEMODIAFILTRATION_CODE = "11403000";
    public static final String SOLUTION_FOR_HAEMODIALYSIS_CODE = "11404000";
    public static final String SOLUTION_FOR_HAEMODIALYSIS_HAEMOFILTRATION_CODE = "50057000";
    public static final String SOLUTION_FOR_HAEMOFILTRATION_CODE = "11402000";
    public static final String SOLUTION_FOR_INFUSION_CODE = "11210000";
    public static final String SOLUTION_FOR_INJECTION_CODE = "11201000";
    public static final String SOLUTION_FOR_INJECTION_INFUSION_CODE = "50060000";
    public static final String SOLUTION_FOR_INJECTION_SKIN_PRICK_TEST_CODE = "13051000";
    public static final String SOLUTION_FOR_INTRAOCULAR_IRRIGATION_CODE = "50073500";
    public static final String SOLUTION_FOR_IONTOPHORESIS_CODE = "10518000";
    public static final String SOLUTION_FOR_ORGAN_PRESERVATION_CODE = "12112000";
    public static final String SOLUTION_FOR_PERITONEAL_DIALYSIS_CODE = "11401000";
    public static final String SOLUTION_FOR_PROVOCATION_TEST_CODE = "12131000";
    public static final String SOLUTION_FOR_SEALANT_CODE = "50061500";
    public static final String SOLUTION_FOR_SKIN_PRICK_TEST_CODE = "10548000";
    public static final String SOLUTION_FOR_SKIN_SCRATCH_TEST_CODE = "10549000";
    public static final String SOLUTION_FOR_SOLUTION_FOR_INFUSION_CODE = "13061000";
    public static final String SOLUTION_FOR_SOLUTION_FOR_INJECTION_CODE = "13033000";
    public static final String SOLUTION_FOR_SUSPENSION_FOR_INJECTION_CODE = "13047000";
    public static final String SOLVENT_FOR_CODE = "13035000";
    public static final String SOLVENT_FOR_PARENTERAL_USE_CODE = "11216000";
    public static final String SOLVENT_FOR_SOLUTION_FOR_INFUSION_CODE = "50076000";
    public static final String SOLVENT_FOR_SOLUTION_FOR_INTRAOCULAR_IRRIGATION_CODE = "50074000";
    public static final String STOMACH_IRRIGATION_CODE = "12114000";
    public static final String SUBLINGUAL_FILM_CODE = "10317500";
    public static final String SUBLINGUAL_LYOPHILISATE_CODE = "13127000";
    public static final String SUBLINGUAL_POWDER_CODE = "13105000";
    public static final String SUBLINGUAL_SPRAY_EMULSION_CODE = "10309100";
    public static final String SUBLINGUAL_SPRAY_SOLUTION_CODE = "10309200";
    public static final String SUBLINGUAL_SPRAY_SUSPENSION_CODE = "10309300";
    public static final String SUBLINGUAL_TABLET_CODE = "10318000";
    public static final String SUPPOSITORY_CODE = "11013000";
    public static final String SUSPENSION_FOR_EMULSION_FOR_INJECTION_CODE = "13036000";
    public static final String SUSPENSION_FOR_INJECTION_CODE = "11202000";
    public static final String SUSPENSION_FOR_ORAL_SUSPENSION_CODE = "13037000";
    public static final String SUSPENSION_FOR_SUSPENSION_FOR_INJECTION_CODE = "13039000";
    public static final String SYRUP_CODE = "10117000";
    public static final String TABLET_CODE = "10219000";
    public static final String TABLET_FOR_CUTANEOUS_SOLUTION_CODE = "13066000";
    public static final String TABLET_FOR_RECTAL_SOLUTION_CODE = "11011000";
    public static final String TABLET_FOR_RECTAL_SUSPENSION_CODE = "11012000";
    public static final String TABLET_FOR_VAGINAL_SOLUTION_CODE = "10908000";
    public static final String TABLET_WITH_SENSOR_CODE = "13118000";
    public static final String TOOTHPASTE_CODE = "10409000";
    public static final String TRANSDERMAL_GEL_CODE = "10546250";
    public static final String TRANSDERMAL_OINTMENT_CODE = "13102000";
    public static final String TRANSDERMAL_PATCH_CODE = "10519000";
    public static final String TRANSDERMAL_SOLUTION_CODE = "10546400";
    public static final String TRANSDERMAL_SPRAY_SOLUTION_CODE = "10546500";
    public static final String TRANSDERMAL_SYSTEM_CODE = "10547000";
    public static final String URETHRAL_EMULSION_CODE = "13077000";
    public static final String URETHRAL_GEL_CODE = "11504000";
    public static final String URETHRAL_OINTMENT_CODE = "13123000";
    public static final String URETHRAL_STICK_CODE = "11505000";
    public static final String VAGINAL_CAPSULE_HARD_CODE = "10910000";
    public static final String VAGINAL_CAPSULE_SOFT_CODE = "10911000";
    public static final String VAGINAL_CREAM_CODE = "10901000";
    public static final String VAGINAL_DELIVERY_SYSTEM_CODE = "10915000";
    public static final String VAGINAL_EMULSION_CODE = "10907000";
    public static final String VAGINAL_FOAM_CODE = "10904000";
    public static final String VAGINAL_GEL_CODE = "10902000";
    public static final String VAGINAL_OINTMENT_CODE = "10903000";
    public static final String VAGINAL_SOLUTION_CODE = "10905000";
    public static final String VAGINAL_SUSPENSION_CODE = "10906000";
    public static final String VAGINAL_TABLET_CODE = "10912000";
    public static final String WOUND_STICK_CODE = "12104000";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.1.11.3";
    public static final String VALUE_SET_NAME = "PharmaceuticalDoseFormEDQM";
    public static final String CODE_SYSTEM_ID = "0.4.0.127.0.16.1.1.2.1";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    private PharmaceuticalDoseFormEdqm(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }

    public @NonNull String getFhirSystem() {
        if (this.getCodeSystemId().startsWith("http")) {
            return this.getCodeSystemId();
        }
        return "urn:oid:" + this.getCodeSystemId();
    }

    public @NonNull Coding getCoding() {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.displayNames[0]);
    }

    public @NonNull CodeableConcept getCodeableConcept() {
        return new CodeableConcept().setText(this.displayNames[0]).addCoding(this.getCoding());
    }

    public @NonNull Coding getCoding(LanguageCode languageCode) {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.getDisplayName(languageCode));
    }

    public @NonNull CodeableConcept getCodeableConcept(LanguageCode languageCode) {
        return new CodeableConcept().setText(this.getDisplayName(languageCode)).addCoding(this.getCoding(languageCode));
    }

    public boolean isEqualTo(Coding coding) {
        return this.getFhirSystem().equals(coding.getSystem()) && this.getCodeValue().equals(coding.getCode());
    }

    public static @Nullable PharmaceuticalDoseFormEdqm getEnum(@Nullable String code) {
        for (PharmaceuticalDoseFormEdqm x : PharmaceuticalDoseFormEdqm.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(PharmaceuticalDoseFormEdqm.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (PharmaceuticalDoseFormEdqm x : PharmaceuticalDoseFormEdqm.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable PharmaceuticalDoseFormEdqm getEnum(@Nullable Coding coding) {
        for (PharmaceuticalDoseFormEdqm x : PharmaceuticalDoseFormEdqm.values()) {
            if (!x.isEqualTo(coding)) continue;
            return x;
        }
        return null;
    }

    public static boolean isInValueSet(@Nullable Coding coding) {
        for (PharmaceuticalDoseFormEdqm x : PharmaceuticalDoseFormEdqm.values()) {
            if (!x.isEqualTo(coding)) continue;
            return true;
        }
        return false;
    }
}

