/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum EmedPadvEntryType implements FhirValueSetEnumInterface
{
    OK("OK", "urn:oid:1.3.6.1.4.1.19376.1.9.2.1", "OK", "OK", "OK", "OK", "OK"),
    COMMENT("COMMENT", "urn:oid:1.3.6.1.4.1.19376.1.9.2.1", "COMMENT", "COMMENT", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CANCEL("CANCEL", "urn:oid:1.3.6.1.4.1.19376.1.9.2.1", "CANCEL", "CANCEL", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SUSPEND("SUSPEND", "urn:oid:1.3.6.1.4.1.19376.1.9.2.1", "SUSPEND", "SUSPEND", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    REFUSE("REFUSE", "urn:oid:1.3.6.1.4.1.19376.1.9.2.1", "REFUSE", "REFUSE", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHANGE("CHANGE", "urn:oid:1.3.6.1.4.1.19376.1.9.2.1", "CHANGE", "CHANGE", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    private final @NonNull String code;
    private final @NonNull String system;
    private final @NonNull String[] displayNames;

    private EmedPadvEntryType(@NonNull String code, @NonNull String system, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.system = Objects.requireNonNull(system);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getFhirSystem() {
        return this.system;
    }

    public Coding getCoding() {
        return new Coding().setSystem(this.system).setCode(this.code).setDisplay(this.displayNames[0]);
    }

    public CodeableConcept getCodeableConcept() {
        return new CodeableConcept().addCoding(this.getCoding()).setText(this.displayNames[0]);
    }

    public @NonNull Coding getCoding(LanguageCode languageCode) {
        return new Coding(this.getFhirSystem(), this.code, this.getDisplayName(languageCode));
    }

    public @NonNull CodeableConcept getCodeableConcept(LanguageCode languageCode) {
        return new CodeableConcept().setText(this.getDisplayName(languageCode)).addCoding(this.getCoding(languageCode));
    }

    public boolean isEqualTo(Coding coding) {
        Coding thisCoding = this.getCoding();
        return thisCoding.getCode().equals(coding.getCode()) && thisCoding.getSystem().equals(coding.getSystem());
    }

    public static @Nullable EmedPadvEntryType getEnum(@Nullable Coding coding) {
        if (coding != null) {
            for (EmedPadvEntryType e : EmedPadvEntryType.values()) {
                if (!e.isEqualTo(coding)) continue;
                return e;
            }
        }
        return null;
    }
}

