/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.projecthusky.communication.ch.enums.beta.ClassCode;
import org.projecthusky.communication.ch.enums.beta.FormatCode;
import org.projecthusky.communication.ch.enums.beta.TypeCode;

public enum EmedDocumentType {
    MTP("MTP", TypeCode.MEDICATION_TREATMENT_PLAN, ClassCode.PRESCRIPTION_RECORD, FormatCode.CH_EMED_MEDICATION_TREATMENT_PLAN, "http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-document-medicationtreatmentplan"),
    PRE("PRE", TypeCode.MEDICAL_PRESCRIPTION_RECORD, ClassCode.PRESCRIPTION_RECORD, FormatCode.CH_EMED_MEDICATION_PRESCRIPTION, "http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-document-medicationprescription"),
    DIS("DIS", TypeCode.MEDICATION_DISPENSE_DOCUMENT, ClassCode.PRESCRIPTION_RECORD, FormatCode.CH_EMED_MEDICATION_DISPENSE, "http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-document-medicationdispense"),
    PADV("PADV", TypeCode.RECORD_ARTIFACT, ClassCode.PRESCRIPTION_RECORD, FormatCode.CH_EMED_PHARMACEUTICAL_ADVICE, "http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-document-pharmaceuticaladvice"),
    PML("PML", TypeCode.MEDICATION_SUMMARY_DOCUMENT, ClassCode.SUMMARY_CLINICAL_DOCUMENT, FormatCode.CH_EMED_MEDICATION_LIST, "http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-document-medicationlist"),
    PMLC("PMLC", TypeCode.MEDICATION_CARD_DOCUMENT, ClassCode.SUMMARY_CLINICAL_DOCUMENT, FormatCode.CH_EMED_MEDICATION_CARD_DOCUMENT, "http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-document-medicationcard");

    private final String name;
    private final TypeCode typeCode;
    private final ClassCode classCode;
    private final FormatCode formatCode;
    private final String profile;

    private EmedDocumentType(String name, TypeCode typeCode, ClassCode classCode, FormatCode formatCode, String profile) {
        this.name = Objects.requireNonNull(name);
        this.typeCode = Objects.requireNonNull(typeCode);
        this.classCode = Objects.requireNonNull(classCode);
        this.formatCode = Objects.requireNonNull(formatCode);
        this.profile = Objects.requireNonNull(profile);
    }

    public String getName() {
        return this.name;
    }

    public TypeCode getTypeCode() {
        return this.typeCode;
    }

    public ClassCode getClassCode() {
        return this.classCode;
    }

    public FormatCode getFormatCode() {
        return this.formatCode;
    }

    public String getProfile() {
        return this.profile;
    }
}

