/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum DispenseSupplyType implements ValueSetEnumInterface,
FhirValueSetEnumInterface
{
    FIRST_FILL_COMPLETE("FFC", "2.16.840.1.113883.5.4", "First Fill - Complete", "First Fill - Complete", "Erstbef\u00fcllung - Voll", "Premier remplissage - complet", "Prima consegna - completa"),
    FIRST_FILL_PART_FILL("FFP", "2.16.840.1.113883.5.4", "First Fill - Part Fill", "First Fill - Part Fill", "Erstbef\u00fcllung - Teilbef\u00fcllung", "Premier remplissage - partiel", "Prima consegna - parziale"),
    REFILL_COMPLETE("RFC", "2.16.840.1.113883.5.4", "Refill - Complete", "Refill - Complete", "Nachf\u00fcllung - Voll", "Prochain remplissage - complet", "Consegna successiva - completa"),
    REFILL_PART_FILL("RFP", "2.16.840.1.113883.5.4", "Refill - Part Fill", "Refill - Part Fill", "Nachf\u00fcllung - Teilbef\u00fcllung", "Prochain remplissage - partiel", "Consegna successiva - parziale");

    public static final String FIRST_FILL_COMPLETE_CODE = "FFC";
    public static final String FIRST_FILL_PART_FILL_CODE = "FFP";
    public static final String REFILL_COMPLETE_CODE = "RFC";
    public static final String REFILL_PART_FILL_CODE = "RFP";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.77.4.11.7";
    public static final String VALUE_SET_NAME = "DispenseSupplyType";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.4";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    private DispenseSupplyType(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }

    public @NonNull String getFhirSystem() {
        if (this.getCodeSystemId().startsWith("http")) {
            return this.getCodeSystemId();
        }
        return "urn:oid:" + this.getCodeSystemId();
    }

    public @NonNull Coding getCoding() {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.displayNames[0]);
    }

    public @NonNull CodeableConcept getCodeableConcept() {
        return new CodeableConcept().setText(this.displayNames[0]).addCoding(this.getCoding());
    }

    public @NonNull Coding getCoding(LanguageCode languageCode) {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.getDisplayName(languageCode));
    }

    public @NonNull CodeableConcept getCodeableConcept(LanguageCode languageCode) {
        return new CodeableConcept().setText(this.getDisplayName(languageCode)).addCoding(this.getCoding(languageCode));
    }

    public boolean isEqualTo(Coding coding) {
        return this.getFhirSystem().equals(coding.getSystem()) && this.getCodeValue().equals(coding.getCode());
    }

    public static @Nullable DispenseSupplyType getEnum(@Nullable String code) {
        for (DispenseSupplyType x : DispenseSupplyType.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(DispenseSupplyType.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (DispenseSupplyType x : DispenseSupplyType.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable DispenseSupplyType getEnum(@Nullable Coding coding) {
        for (DispenseSupplyType x : DispenseSupplyType.values()) {
            if (!x.isEqualTo(coding)) continue;
            return x;
        }
        return null;
    }

    public static boolean isInValueSet(@Nullable Coding coding) {
        for (DispenseSupplyType x : DispenseSupplyType.values()) {
            if (!x.isEqualTo(coding)) continue;
            return true;
        }
        return false;
    }
}

