/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum ChEmedTimingEvent implements ValueSetEnumInterface,
FhirValueSetEnumInterface
{
    AFTERNOON("AFT", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Afternoon", "Afternoon", "Nachmittag", "Apr\u00e8s-midi", "Pomeriggio"),
    AFTER_BREAKFAST("PCM", "2.16.840.1.113883.5.139", "After breakfast", "After breakfast", "Nach dem Fr\u00fchst\u00fcck", "Apr\u00e8s le petit-d\u00e9jeuner", "Dopo la prima colazione"),
    AFTER_DINNER("PCV", "2.16.840.1.113883.5.139", "After dinner", "After dinner", "Nach dem Abendessen", "Apr\u00e8s le repas du soir", "Dopo cena"),
    AFTER_LUNCH("PCD", "2.16.840.1.113883.5.139", "After lunch", "After lunch", "Nach dem Mittagessen", "Apr\u00e8s le repas de midi", "Dopo pranzo"),
    AFTER_SLEEP("PHS", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "After Sleep", "After Sleep", "Nach dem Einschlafen", "Apr\u00e8s le coucher", "Dopo il sonno"),
    AFTER_THE_MEAL("PC", "2.16.840.1.113883.5.139", "After the meal", "After the meal", "Nach dem Essen", "Apr\u00e8s le repas", "Dopo il pasto"),
    BEFORE_BREAKFAST("ACM", "2.16.840.1.113883.5.139", "Before breakfast", "Before breakfast", "Vor dem Fr\u00fchst\u00fcck", "Avant le petit-d\u00e9jeuner", "Prima di colazione"),
    BEFORE_DINNER("ACV", "2.16.840.1.113883.5.139", "Before dinner", "Before dinner", "Vor dem Abendessen", "Avant le repas du soir", "Prima di cena"),
    BEFORE_LUNCH("ACD", "2.16.840.1.113883.5.139", "Before lunch", "Before lunch", "Vor dem Mittagessen", "Avant le repas de midi", "Prima di pranzo"),
    BEFORE_SLEEP("HS", "2.16.840.1.113883.5.139", "Before sleep", "Before sleep", "Vor dem Schlafengehen", "Avant le coucher", "Prima di andare a dormire"),
    BEFORE_THE_MEAL("AC", "2.16.840.1.113883.5.139", "Before the meal", "Before the meal", "Vor der Mahlzeit", "Avant le repas", "Prima del pasto"),
    DURING_BREAKFAST("CM", "2.16.840.1.113883.5.139", "During breakfast", "During breakfast", "W\u00e4hrend des Fr\u00fchst\u00fccks", "Pendant le petit-d\u00e9jeuner", "Durante la prima colazione"),
    DURING_DINNER("CV", "2.16.840.1.113883.5.139", "During dinner", "During dinner", "W\u00e4hrend des Abendessens", "Pendant le repas du soir", "Durante la cena"),
    DURING_LUNCH("CD", "2.16.840.1.113883.5.139", "During lunch", "During lunch", "W\u00e4hrend des Mittagessens", "Pendant le repas de midi", "Durante il pranzo"),
    DURING_MEALS("C", "2.16.840.1.113883.5.139", "During meals", "During meals", "W\u00e4hrend der Mahlzeit", "Pendant le repas", "Durante il pasto"),
    EARLY_AFTERNOON("AFT.early", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Early Afternoon", "Early Afternoon", "Fr\u00fcher Nachmittag", "D\u00e9but d\u2019apr\u00e8s-midi", "Primo pomeriggio"),
    EARLY_EVENING("EVE.early", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Early Evening", "Early Evening", "Fr\u00fcher Abend", "D\u00e9but de soir\u00e9e", "Prima serata"),
    EARLY_MORNING("MORN.early", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Early Morning", "Early Morning", "Fr\u00fcher Morgen", "D\u00e9but de matin\u00e9e", "Prima mattina"),
    EVENING("EVE", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Evening", "Evening", "Abend", "Soir\u00e9e", "Sera"),
    LATE_AFTERNOON("AFT.late", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Late Afternoon", "Late Afternoon", "Sp\u00e4ter Nachmittag", "Fin d\u2019apr\u00e8s-midi", "Tardo pomeriggio"),
    LATE_EVENING("EVE.late", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Late Evening", "Late Evening", "Sp\u00e4ter Abend", "Fin de soir\u00e9e", "Tarda serata"),
    LATE_MORNING("MORN.late", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Late Morning", "Late Morning", "Sp\u00e4ter Morgen", "Fin de matin\u00e9e", "Tarda mattinata"),
    MORNING("MORN", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Morning", "Morning", "Morgen", "Matin\u00e9e", "Mattina"),
    NIGHT("NIGHT", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Night", "Night", "Nacht", "Nuit", "Notte"),
    NOON("NOON", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Noon", "Noon", "Mittag", "Midi", "Mezzogiorno"),
    UPON_WAKING_UP("WAKE", "2.16.840.1.113883.5.139", "Upon waking up", "Upon waking up", "Beim Aufwachen", "Au r\u00e9veil", "Al risveglio");

    public static final String AFTERNOON_CODE = "AFT";
    public static final String AFTER_BREAKFAST_CODE = "PCM";
    public static final String AFTER_DINNER_CODE = "PCV";
    public static final String AFTER_LUNCH_CODE = "PCD";
    public static final String AFTER_SLEEP_CODE = "PHS";
    public static final String AFTER_THE_MEAL_CODE = "PC";
    public static final String BEFORE_BREAKFAST_CODE = "ACM";
    public static final String BEFORE_DINNER_CODE = "ACV";
    public static final String BEFORE_LUNCH_CODE = "ACD";
    public static final String BEFORE_SLEEP_CODE = "HS";
    public static final String BEFORE_THE_MEAL_CODE = "AC";
    public static final String DURING_BREAKFAST_CODE = "CM";
    public static final String DURING_DINNER_CODE = "CV";
    public static final String DURING_LUNCH_CODE = "CD";
    public static final String DURING_MEALS_CODE = "C";
    public static final String EARLY_AFTERNOON_CODE = "AFT.early";
    public static final String EARLY_EVENING_CODE = "EVE.early";
    public static final String EARLY_MORNING_CODE = "MORN.early";
    public static final String EVENING_CODE = "EVE";
    public static final String LATE_AFTERNOON_CODE = "AFT.late";
    public static final String LATE_EVENING_CODE = "EVE.late";
    public static final String LATE_MORNING_CODE = "MORN.late";
    public static final String MORNING_CODE = "MORN";
    public static final String NIGHT_CODE = "NIGHT";
    public static final String NOON_CODE = "NOON";
    public static final String UPON_WAKING_UP_CODE = "WAKE";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.77.4.11.2";
    public static final String VALUE_SET_NAME = "CH-EMED-TimingEvent";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    private ChEmedTimingEvent(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }

    public @NonNull String getFhirSystem() {
        if (this.getCodeSystemId().startsWith("http")) {
            return this.getCodeSystemId();
        }
        return "urn:oid:" + this.getCodeSystemId();
    }

    public @NonNull Coding getCoding() {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.displayNames[0]);
    }

    public @NonNull CodeableConcept getCodeableConcept() {
        return new CodeableConcept().setText(this.displayNames[0]).addCoding(this.getCoding());
    }

    public @NonNull Coding getCoding(LanguageCode languageCode) {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.getDisplayName(languageCode));
    }

    public @NonNull CodeableConcept getCodeableConcept(LanguageCode languageCode) {
        return new CodeableConcept().setText(this.getDisplayName(languageCode)).addCoding(this.getCoding(languageCode));
    }

    public boolean isEqualTo(Coding coding) {
        return this.getFhirSystem().equals(coding.getSystem()) && this.getCodeValue().equals(coding.getCode());
    }

    public static @Nullable ChEmedTimingEvent getEnum(@Nullable String code) {
        for (ChEmedTimingEvent x : ChEmedTimingEvent.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ChEmedTimingEvent.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ChEmedTimingEvent x : ChEmedTimingEvent.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable ChEmedTimingEvent getEnum(@Nullable Coding coding) {
        for (ChEmedTimingEvent x : ChEmedTimingEvent.values()) {
            if (!x.isEqualTo(coding)) continue;
            return x;
        }
        return null;
    }

    public static boolean isInValueSet(@Nullable Coding coding) {
        for (ChEmedTimingEvent x : ChEmedTimingEvent.values()) {
            if (!x.isEqualTo(coding)) continue;
            return true;
        }
        return false;
    }
}

