/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum ActSubstanceAdminSubstitutionCode implements ValueSetEnumInterface,
FhirValueSetEnumInterface
{
    BRAND_COMPOSITION_L3("BC", "2.16.840.1.113883.5.1070", "brand composition", "brand composition", "\u00c4quivalent, andere Marke", "\u00e9quivalent autre fabriquant", "equivalente altra marca"),
    EQUIVALENT_COMPOSITION_L2("EC", "2.16.840.1.113883.5.1070", "equivalent composition", "equivalent composition", "\u00e4quivalente Zusammensetzung", "composition \u00e9quivalente", "composizione simile"),
    EQUIVALENT_L1("E", "2.16.840.1.113883.5.1070", "equivalent", "equivalent", "\u00c4quivalent", "\u00e9quivalent", "equivalente"),
    GENERIC_COMPOSITION_L3("G", "2.16.840.1.113883.5.1070", "generic composition", "generic composition", "\u00c4quivalent, Generikum", "\u00e9quivalent g\u00e9n\u00e9rique", "equivalente generico"),
    NONE_L1("N", "2.16.840.1.113883.5.1070", "none", "none", "nicht autorisiert", "non autoris\u00e9", "non autorizzato"),
    THERAPEUTIC_ALTERNATIVE_L2("TE", "2.16.840.1.113883.5.1070", "therapeutic alternative", "therapeutic alternative", "therapeutische Alternative", "alternative th\u00e9rapeutique", "alternativa terapeutica"),
    THERAPEUTIC_BRAND_L3("TB", "2.16.840.1.113883.5.1070", "therapeutic brand", "therapeutic brand", "therapeutische Alternative, andere Marke", "lternative th\u00e9rapeutique autre marque", "alternativa terapeutica altra marca"),
    THERAPEUTIC_GENERIC_L3("TG", "2.16.840.1.113883.5.1070", "therapeutic generic", "therapeutic generic", "therapeutische Alternative, Generikum", "alternative th\u00e9rapeutique g\u00e9n\u00e9rique", "alternativa terapeutica generico");

    public static final String BRAND_COMPOSITION_L3_CODE = "BC";
    public static final String EQUIVALENT_COMPOSITION_L2_CODE = "EC";
    public static final String EQUIVALENT_L1_CODE = "E";
    public static final String GENERIC_COMPOSITION_L3_CODE = "G";
    public static final String NONE_L1_CODE = "N";
    public static final String THERAPEUTIC_ALTERNATIVE_L2_CODE = "TE";
    public static final String THERAPEUTIC_BRAND_L3_CODE = "TB";
    public static final String THERAPEUTIC_GENERIC_L3_CODE = "TG";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.1.11.81";
    public static final String VALUE_SET_NAME = "ActSubstanceAdminSubstitutionCode";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.1070";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    private ActSubstanceAdminSubstitutionCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }

    public @NonNull String getFhirSystem() {
        if (this.getCodeSystemId().startsWith("http")) {
            return this.getCodeSystemId();
        }
        return "urn:oid:" + this.getCodeSystemId();
    }

    public @NonNull Coding getCoding() {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.displayNames[0]);
    }

    public @NonNull CodeableConcept getCodeableConcept() {
        return new CodeableConcept().setText(this.displayNames[0]).addCoding(this.getCoding());
    }

    public @NonNull Coding getCoding(LanguageCode languageCode) {
        return new Coding(this.getFhirSystem(), this.getCodeValue(), this.getDisplayName(languageCode));
    }

    public @NonNull CodeableConcept getCodeableConcept(LanguageCode languageCode) {
        return new CodeableConcept().setText(this.getDisplayName(languageCode)).addCoding(this.getCoding(languageCode));
    }

    public boolean isEqualTo(Coding coding) {
        return this.getFhirSystem().equals(coding.getSystem()) && this.getCodeValue().equals(coding.getCode());
    }

    public static @Nullable ActSubstanceAdminSubstitutionCode getEnum(@Nullable String code) {
        for (ActSubstanceAdminSubstitutionCode x : ActSubstanceAdminSubstitutionCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ActSubstanceAdminSubstitutionCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ActSubstanceAdminSubstitutionCode x : ActSubstanceAdminSubstitutionCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable ActSubstanceAdminSubstitutionCode getEnum(@Nullable Coding coding) {
        for (ActSubstanceAdminSubstitutionCode x : ActSubstanceAdminSubstitutionCode.values()) {
            if (!x.isEqualTo(coding)) continue;
            return x;
        }
        return null;
    }

    public static boolean isInValueSet(@Nullable Coding coding) {
        for (ActSubstanceAdminSubstitutionCode x : ActSubstanceAdminSubstitutionCode.values()) {
            if (!x.isEqualTo(coding)) continue;
            return true;
        }
        return false;
    }
}

