/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.common.datatype;

import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class ChCoreAddressAdapter {
    public static final String BFS_EXTENSION = "http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-ech-7-municipalityid";
    public static final String COUNTRY_CODE_EXTENSION = "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding";
    private final Address address;

    public ChCoreAddressAdapter() {
        this.address = new Address();
    }

    public ChCoreAddressAdapter(Address address) {
        this.address = Objects.requireNonNull(address);
    }

    public Address getAddress() {
        return this.address;
    }

    public @Nullable String getCityBfs() {
        return this.address.getCityElement().getExtensionString(BFS_EXTENSION);
    }

    public ChCoreAddressAdapter setCityBfs(@Nullable String bfs) {
        this.address.getCityElement().addExtension(BFS_EXTENSION, (Type)new StringType(bfs));
        return this;
    }

    public @Nullable String getCountryCode() {
        return this.address.getCountryElement().getExtensionString(COUNTRY_CODE_EXTENSION);
    }

    public ChCoreAddressAdapter setCountryCode(@Nullable String countryCode) {
        this.address.getCountryElement().addExtension(COUNTRY_CODE_EXTENSION, (Type)new StringType(countryCode));
        return this;
    }

    public List<AddressLineAdapter> getLines() {
        return this.address.getLine().stream().map(AddressLineAdapter::new).toList();
    }

    public ChCoreAddressAdapter addLine(AddressLineAdapter addressLineAdapter) {
        this.address.getLine().add(addressLineAdapter.getLine());
        return this;
    }

    public static final class AddressLineAdapter {
        public static final String LINE_TYPE = "http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-ech-10-linetype";
        private final StringType line;

        public AddressLineAdapter() {
            this.line = new StringType();
        }

        public AddressLineAdapter(StringType line) {
            this.line = Objects.requireNonNull(line);
        }

        public StringType getLine() {
            return this.line;
        }
    }
}

