/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.saml2.validation.impl;

import java.security.KeyStore;
import java.util.HashMap;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.projecthusky.xua.exceptions.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String password;
    private KeyStore trustStore;

    public Logger getLog() {
        return this.log;
    }

    public String getPassword() {
        return this.password;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public void validate(Signature aSignature, String aAlias) throws ValidationException {
        try {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(aSignature);
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
        }
        try {
            HashMap passwordMap = new HashMap();
            KeyStoreCredentialResolver resolver = new KeyStoreCredentialResolver(this.trustStore, passwordMap);
            EntityIdCriterion criterion = new EntityIdCriterion(aAlias);
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{criterion});
            Credential credential = resolver.resolveSingle(criteriaSet);
            SignatureValidator.validate((Signature)aSignature, (Credential)credential);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
    }
}

