/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.saml2.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.XACMLPolicySetIdReferenceStatementType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AssertionType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AttributeStatementType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AttributeType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AuthnStatementType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.ConditionsType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.NameIDType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.StatementAbstractType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.SubjectType;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml.saml2.core.impl.AttributeStatementBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.xacml.profile.saml.XACMLPolicyStatementType;
import org.projecthusky.xua.core.SecurityObject;
import org.projecthusky.xua.saml2.Assertion;
import org.projecthusky.xua.saml2.XACMLPolicySetIdReferenceStatement;
import org.projecthusky.xua.saml2.impl.AttributeBuilderImpl;
import org.projecthusky.xua.saml2.impl.AudienceRestrictionBuilderImpl;
import org.projecthusky.xua.saml2.impl.AuthnStatementBuilderImpl;
import org.projecthusky.xua.saml2.impl.ConditionsBuilderImpl;
import org.projecthusky.xua.saml2.impl.StatementBuilderImpl;
import org.projecthusky.xua.saml2.impl.SubjectBuilderImpl;
import org.projecthusky.xua.saml2.impl.XacmlPolicySetIdReferenceStatementBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionImpl
extends Assertion
implements SecurityObject<org.opensaml.saml.saml2.core.Assertion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssertionImpl.class);
    private org.opensaml.saml.saml2.core.Assertion assertion;

    protected AssertionImpl(org.opensaml.saml.saml2.core.Assertion aAssertion) {
        this.assertion = aAssertion;
        this.setAttributes();
        this.setAuthnStatements();
        this.setConditions();
        this.setConditionsAudienceRestrictions();
        this.setId();
        this.setConditionsNotBefore();
        this.setConditionsNotOnOrAfter();
        this.setIssueInstant();
        this.setIssuer();
        this.setSubject();
        this.setVersion();
        this.setStatements();
    }

    protected AssertionImpl(AssertionType aAssertion) {
        this.assertion = new AssertionBuilder().buildObject();
        this.addStatements(aAssertion.getStatementOrAuthnStatementOrAuthzDecisionStatement());
        this.setIssuer(aAssertion.getIssuer());
        this.setConditions(aAssertion.getConditions());
        this.setId(aAssertion.getID());
        this.setIssueInstant(aAssertion.getIssueInstant());
        this.setSubject(aAssertion.getSubject());
        this.setVersion(aAssertion.getVersion());
    }

    public void setAttributes() {
        if (this.statementOrAuthnStatementOrAuthzDecisionStatement == null) {
            this.statementOrAuthnStatementOrAuthzDecisionStatement = new ArrayList();
        }
        List internalAttributes = this.assertion.getAttributeStatements();
        internalAttributes.forEach(c -> {
            LinkedList attributes = new LinkedList();
            List listOfAttributes = c.getAttributes();
            listOfAttributes.forEach(d -> attributes.add(new AttributeBuilderImpl().create((Attribute)d)));
            AttributeStatementType statement = new AttributeStatementType();
            statement.getAttributeOrEncryptedAttribute().addAll(attributes);
            this.statementOrAuthnStatementOrAuthzDecisionStatement.add(statement);
        });
    }

    public void addStatements(List<StatementAbstractType> statements) {
        if (this.assertion == null) {
            this.assertion = new AssertionBuilder().buildObject();
        }
        for (StatementAbstractType statement : statements) {
            if (statement instanceof org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.assertion.XACMLPolicyStatementType) {
                org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.assertion.XACMLPolicyStatementType policyStat = (org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.assertion.XACMLPolicyStatementType)statement;
                this.assertion.getStatements().add(new StatementBuilderImpl().create(policyStat));
                continue;
            }
            if (statement instanceof AttributeStatementType) {
                AttributeStatementType attrStat = (AttributeStatementType)statement;
                AttributeStatement retVal = new AttributeStatementBuilder().buildObject();
                for (Object obj : attrStat.getAttributeOrEncryptedAttribute()) {
                    if (!(obj instanceof AttributeType)) continue;
                    AttributeType attributeType = (AttributeType)obj;
                    retVal.getAttributes().add(new AttributeBuilderImpl().create(attributeType));
                }
                this.assertion.getStatements().add(retVal);
                continue;
            }
            if (statement instanceof AuthnStatementType) {
                AuthnStatementType attrStat = (AuthnStatementType)statement;
                this.assertion.getAuthnStatements().add(new AuthnStatementBuilderImpl().create(attrStat));
                continue;
            }
            if (!(statement instanceof XACMLPolicySetIdReferenceStatementType)) continue;
            XACMLPolicySetIdReferenceStatementType policyStat = (XACMLPolicySetIdReferenceStatementType)statement;
            this.assertion.getStatements().add(new XacmlPolicySetIdReferenceStatementBuilderImpl().create(policyStat));
        }
    }

    public void setAuthnStatements() {
        if (this.statementOrAuthnStatementOrAuthzDecisionStatement == null) {
            this.statementOrAuthnStatementOrAuthzDecisionStatement = new ArrayList();
        }
        List innerList = this.assertion.getAuthnStatements();
        innerList.forEach(c -> this.statementOrAuthnStatementOrAuthzDecisionStatement.add(new AuthnStatementBuilderImpl().create((AuthnStatement)c)));
    }

    public void setStatements() {
        if (this.statementOrAuthnStatementOrAuthzDecisionStatement == null) {
            this.statementOrAuthnStatementOrAuthzDecisionStatement = new ArrayList();
        }
        List innerList = this.assertion.getStatements();
        innerList.forEach(c -> {
            if (c instanceof XACMLPolicyStatementType) {
                XACMLPolicyStatementType xacmlPolicyStatementType = (XACMLPolicyStatementType)c;
                this.statementOrAuthnStatementOrAuthzDecisionStatement.add(new StatementBuilderImpl().create(xacmlPolicyStatementType));
            } else if (c instanceof XACMLPolicySetIdReferenceStatement) {
                XACMLPolicySetIdReferenceStatement xacmlPolicySetIdReferenceStatement = (XACMLPolicySetIdReferenceStatement)c;
                this.statementOrAuthnStatementOrAuthzDecisionStatement.add(new XacmlPolicySetIdReferenceStatementBuilderImpl().create(xacmlPolicySetIdReferenceStatement));
            }
        });
    }

    public void setConditions() {
        if (this.assertion.getConditions() != null) {
            this.conditions = new ConditionsBuilderImpl().create(this.assertion.getConditions());
        }
    }

    public void setConditions(ConditionsType conditions) {
        if (conditions != null) {
            this.assertion.setConditions(new ConditionsBuilderImpl().create(conditions));
        }
    }

    public void setConditionsAudienceRestrictions() {
        if (this.assertion.getConditions() != null && this.assertion.getConditions().getAudienceRestrictions() != null) {
            this.assertion.getConditions().getAudienceRestrictions().forEach(audres -> this.getConditions().getConditionOrAudienceRestrictionOrOneTimeUse().add(new AudienceRestrictionBuilderImpl().create((AudienceRestriction)audres)));
        }
    }

    public void setConditionsNotBefore() {
        if (this.assertion.getConditions() != null) {
            GregorianCalendar retVal = new GregorianCalendar();
            retVal.setTimeInMillis(this.assertion.getConditions().getNotBefore().toEpochMilli());
            XMLGregorianCalendar xmlGregCal = null;
            try {
                xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar();
                this.getConditions().setNotBefore(xmlGregCal);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setConditionsNotOnOrAfter() {
        if (this.assertion.getConditions() != null) {
            Calendar retVal = Calendar.getInstance();
            retVal.setTimeInMillis(this.assertion.getConditions().getNotOnOrAfter().toEpochMilli());
            XMLGregorianCalendar xmlGregCal = null;
            try {
                xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar();
                this.getConditions().setNotOnOrAfter(xmlGregCal);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setId() {
        this.setID(this.assertion.getID());
    }

    public void setId(String id) {
        this.assertion.setID(id);
    }

    public void setIssueInstant() {
        if (this.assertion.getIssueInstant() != null) {
            GregorianCalendar retVal = new GregorianCalendar();
            retVal.setTimeInMillis(this.assertion.getIssueInstant().toEpochMilli());
            XMLGregorianCalendar xmlGregCal = null;
            try {
                xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(retVal);
                this.setIssueInstant(xmlGregCal);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setIssueInstant(XMLGregorianCalendar cal) {
        if (cal != null) {
            this.assertion.setIssueInstant(cal.toGregorianCalendar().toInstant());
        }
    }

    public void setIssuer() {
        if (this.assertion.getIssuer() != null) {
            NameIDType nameIdType = new NameIDType();
            nameIdType.setValue(this.assertion.getIssuer().getValue());
            nameIdType.setNameQualifier(this.assertion.getIssuer().getNameQualifier());
            nameIdType.setSPNameQualifier(this.assertion.getIssuer().getSPNameQualifier());
            nameIdType.setSPProvidedID(this.assertion.getIssuer().getSPProvidedID());
            this.setIssuer(nameIdType);
            super.setIssuer(nameIdType);
        }
    }

    public void setIssuer(NameIDType issuer) {
        if (issuer != null) {
            Issuer retVal = new IssuerBuilder().buildObject();
            retVal.setValue(issuer.getValue());
            retVal.setNameQualifier(issuer.getNameQualifier());
            retVal.setSPNameQualifier(issuer.getSPNameQualifier());
            retVal.setSPProvidedID(issuer.getSPProvidedID());
            this.assertion.setIssuer(retVal);
        }
    }

    public void setSubject() {
        if (this.assertion.getSubject() != null) {
            SubjectType retVal = new SubjectBuilderImpl().create(this.assertion.getSubject());
            this.setSubject(retVal);
        }
    }

    public void getSubject(SubjectType subject) {
        if (subject != null) {
            this.assertion.setSubject(new SubjectBuilderImpl().create(subject));
        }
    }

    public void setVersion() {
        if (this.assertion.getVersion() != null) {
            String retVal = this.assertion.getVersion().toString();
            this.setVersion(retVal);
        }
    }

    public void setVersion(String version) {
        if (version != null) {
            this.assertion.setVersion(SAMLVersion.valueOf((String)version));
        }
    }

    public org.opensaml.saml.saml2.core.Assertion getWrappedObject() {
        return this.assertion;
    }

    public boolean hasSignature() {
        return this.assertion.getSignature() != null;
    }

    public List<AttributeStatement> getAttributeStatements() {
        return this.assertion.getAttributeStatements();
    }
}

