/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.soap.impl;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.projecthusky.xua.communication.soap.impl.WsaHeaderValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsaHeaderSoapHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String IN_OUT_PARAM = "InOutExchange";
    private QName mActionHeader;
    private Logger mLogger = LoggerFactory.getLogger(this.getClass());
    private QName mMessageIdHeader;
    private QName mToHeader;
    private WsaHeaderValue mWsaValues;
    public static final String NAMESPACE_SOAPENV_URI = "http://www.w3.org/2003/05/soap-envelope";
    public static final String NAMESPACE_WSA = "wsa";
    public static final String NAMESPACE_WSA_URI = "http://www.w3.org/2005/08/addressing";

    public WsaHeaderSoapHandler(WsaHeaderValue aActionValue) {
        this.mLogger.trace("WSAHeaderSoapHandler()");
        this.mActionHeader = new QName(NAMESPACE_WSA_URI, "Action", NAMESPACE_WSA);
        this.mMessageIdHeader = new QName(NAMESPACE_WSA_URI, "MessageID", NAMESPACE_WSA);
        this.mToHeader = new QName(NAMESPACE_WSA_URI, "To", NAMESPACE_WSA);
        this.mWsaValues = aActionValue;
    }

    public void close(MessageContext context) {
        this.mLogger.trace("close: {}", (Object)context);
    }

    public Set<QName> getHeaders() {
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(this.mActionHeader);
        headers.add(this.mMessageIdHeader);
        headers.add(this.mToHeader);
        this.mLogger.trace("getHeaders: {}", headers);
        return headers;
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.mLogger.error("SOAP Fault: {}", (Object)context);
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        try {
            Boolean outboundProperty = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
            if (outboundProperty.booleanValue()) {
                SOAPMessage soapMessage = context.getMessage();
                SOAPHeader soapHeader = soapMessage.getSOAPHeader();
                this.mLogger.debug("InOutValue: {}", context.get((Object)IN_OUT_PARAM));
                String soapEnvelopPrefix = soapMessage.getSOAPPart().getEnvelope().getPrefix();
                QName mustUnderstandAttribute = new QName(NAMESPACE_SOAPENV_URI, "mustUnderstand", soapEnvelopPrefix);
                soapHeader.addNamespaceDeclaration(NAMESPACE_WSA, NAMESPACE_WSA_URI);
                if (this.mWsaValues.getAction() != null && !"".equals(this.mWsaValues.getAction())) {
                    this.setSOAPHeader(soapHeader, mustUnderstandAttribute, this.mActionHeader, this.mWsaValues.getAction());
                }
                if (this.mWsaValues.getMessageId() != null && !"".equals(this.mWsaValues.getMessageId())) {
                    this.setSOAPHeader(soapHeader, mustUnderstandAttribute, this.mMessageIdHeader, this.mWsaValues.getMessageId());
                }
                if (this.mWsaValues.getTo() != null && !"".equals(this.mWsaValues.getTo())) {
                    this.setSOAPHeader(soapHeader, mustUnderstandAttribute, this.mToHeader, this.mWsaValues.getTo());
                }
            }
        }
        catch (Exception t) {
            this.mLogger.error("error handling inout stuff", (Throwable)t);
            return false;
        }
        return true;
    }

    private void setSOAPHeader(SOAPHeader soapHeader, QName mustUnderstandAttribute, QName headerQName, String value) throws SOAPException {
        SOAPHeaderElement specificHeader = soapHeader.addHeaderElement(headerQName);
        specificHeader.setValue(value);
        if (this.mWsaValues.isMustUnderstand()) {
            specificHeader.addAttribute(mustUnderstandAttribute, "true");
        }
    }
}

