/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import net.shibboleth.shared.xml.XMLParserException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponse;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponseCollection;
import org.opensaml.soap.wstrust.impl.RequestSecurityTokenResponseCollectionUnmarshaller;
import org.projecthusky.xua.communication.clients.XuaClient;
import org.projecthusky.xua.communication.clients.impl.AbstractSoapClient;
import org.projecthusky.xua.communication.config.SoapClientConfig;
import org.projecthusky.xua.communication.config.XuaClientConfig;
import org.projecthusky.xua.communication.soap.impl.WsaHeaderValue;
import org.projecthusky.xua.communication.xua.XUserAssertionRequest;
import org.projecthusky.xua.communication.xua.XUserAssertionResponse;
import org.projecthusky.xua.communication.xua.impl.XUserAssertionResponseBuilderImpl;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.projecthusky.xua.exceptions.ClientSendException;
import org.projecthusky.xua.exceptions.SerializeException;
import org.projecthusky.xua.saml2.Assertion;
import org.projecthusky.xua.saml2.EncryptedAssertion;
import org.projecthusky.xua.serialization.impl.AssertionSerializerImpl;
import org.projecthusky.xua.serialization.impl.EncryptedAssertionSerializerImpl;
import org.projecthusky.xua.serialization.impl.UsernameTokenSerializerImpl;
import org.projecthusky.xua.serialization.impl.XUserAssertionRequestSerializerImpl;
import org.projecthusky.xua.wssecurity.UsernameToken;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SimpleXuaClient
extends AbstractSoapClient<List<XUserAssertionResponse>>
implements XuaClient {
    public SimpleXuaClient(XuaClientConfig clientConfiguration) {
        this.setLogger(LoggerFactory.getLogger(this.getClass()));
        this.setConfig((SoapClientConfig)clientConfiguration);
    }

    private HttpEntity getSoapEntity(SecurityHeaderElement aSecurityHeaderElement, XUserAssertionRequest aRequest, WsaHeaderValue wsHeaders) throws SerializeException, ParserConfigurationException, TransformerException {
        Element envelopElement = this.createEnvelope();
        Element headerAssertionElement = null;
        if (aSecurityHeaderElement instanceof Assertion) {
            Assertion assertion = (Assertion)aSecurityHeaderElement;
            headerAssertionElement = new AssertionSerializerImpl().toXmlElement(assertion);
        } else if (aSecurityHeaderElement instanceof EncryptedAssertion) {
            EncryptedAssertion assertion = (EncryptedAssertion)aSecurityHeaderElement;
            headerAssertionElement = new EncryptedAssertionSerializerImpl().toXmlElement(assertion);
        } else if (aSecurityHeaderElement instanceof UsernameToken) {
            UsernameToken token = (UsernameToken)aSecurityHeaderElement;
            headerAssertionElement = new UsernameTokenSerializerImpl().toXmlElement(token);
        }
        this.createHeader(headerAssertionElement, wsHeaders, envelopElement);
        XUserAssertionRequestSerializerImpl serializer = new XUserAssertionRequestSerializerImpl();
        Element authnRequestElement = serializer.toXmlElement(aRequest);
        this.createBody(authnRequestElement, envelopElement);
        String body = this.createXmlString(envelopElement);
        this.getLogger().debug("SOAP Message\n {}", (Object)body);
        StringEntity stringEntity = new StringEntity(body, "UTF-8");
        stringEntity.setChunked(false);
        return stringEntity;
    }

    @Override
    protected List<XUserAssertionResponse> parseResponse(String httpResponse) throws ClientSendException {
        try {
            Element reponseElement = this.getResponseElement(httpResponse, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestSecurityTokenResponseCollection");
            RequestSecurityTokenResponseCollection wstResponseCollection = (RequestSecurityTokenResponseCollection)new RequestSecurityTokenResponseCollectionUnmarshaller().unmarshall(reponseElement);
            List wstResponses = wstResponseCollection.getRequestSecurityTokenResponses();
            ArrayList<XUserAssertionResponse> retVal = new ArrayList<XUserAssertionResponse>();
            wstResponses.forEach(c -> retVal.add(new XUserAssertionResponseBuilderImpl().create((RequestSecurityTokenResponse)c)));
            return retVal;
        }
        catch (UnsupportedOperationException | TransformerFactoryConfigurationError | XPathExpressionException | XMLParserException | UnmarshallingException e) {
            throw new ClientSendException(e);
        }
    }

    public List<XUserAssertionResponse> send(SecurityHeaderElement aSecurityHeaderElement, XUserAssertionRequest aRequest) throws ClientSendException {
        try {
            HttpPost post = this.getHttpPost();
            WsaHeaderValue wsHeaders = new WsaHeaderValue("urn:uuid:" + UUID.randomUUID().toString(), "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue", null);
            post.setEntity(this.getSoapEntity(aSecurityHeaderElement, aRequest, wsHeaders));
            return (List)this.execute(post);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SerializeException e) {
            throw new ClientSendException(e);
        }
    }
}

