/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.XMLParserException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.projecthusky.xua.authentication.AuthnRequest;
import org.projecthusky.xua.communication.clients.impl.AbstractIdpClient;
import org.projecthusky.xua.communication.config.impl.IdpClientBasicAuthConfigImpl;
import org.projecthusky.xua.deserialization.impl.ResponseDeserializerImpl;
import org.projecthusky.xua.exceptions.ClientSendException;
import org.projecthusky.xua.exceptions.DeserializeException;
import org.projecthusky.xua.exceptions.SerializeException;
import org.projecthusky.xua.saml2.Response;
import org.projecthusky.xua.serialization.impl.AuthnRequestSerializerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdpSoapBindingClientByBasicAuth
extends AbstractIdpClient {
    private static final String SOAPNS = "http://schemas.xmlsoap.org/soap/envelope/";
    private IdpClientBasicAuthConfigImpl config;

    public IdpSoapBindingClientByBasicAuth(IdpClientBasicAuthConfigImpl clientConfiguration) {
        this.config = clientConfiguration;
    }

    private void addBasicAuthentication(HttpPost post) {
        String auth = this.config.getBasicAuthUsername() + ":" + this.config.getBasicAuthPassword();
        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.ISO_8859_1));
        String authHeader = "Basic " + new String(encodedAuth);
        post.setHeader("Authorization", authHeader);
    }

    @Override
    public CloseableHttpClient getHttpClient() throws ClientSendException {
        return HttpClients.createDefault();
    }

    @Override
    public RequestConfig getRequestConfig() {
        return RequestConfig.custom().setAuthenticationEnabled(true).build();
    }

    private HttpEntity getSoapEntity(AuthnRequest aAuthnRequest) throws SerializeException, TransformerException, XMLParserException {
        AuthnRequestSerializerImpl serializer = new AuthnRequestSerializerImpl();
        Element authnRequestElement = serializer.toXmlElement(aAuthnRequest);
        ParserPool docBuilder = XMLObjectProviderRegistrySupport.getParserPool();
        Document soapDoc = docBuilder.newDocument();
        Element envelopElement = soapDoc.createElementNS(SOAPNS, "Envelope");
        soapDoc.appendChild(envelopElement);
        Element soapHeader = soapDoc.createElementNS(SOAPNS, "Header");
        envelopElement.appendChild(soapHeader);
        Element soapBody = soapDoc.createElementNS(SOAPNS, "Body");
        envelopElement.appendChild(soapBody);
        Node importedNode = soapDoc.importNode(authnRequestElement, true);
        soapBody.appendChild(importedNode);
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(soapDoc), new StreamResult(writer));
        String body = writer.toString();
        StringEntity stringEntity = new StringEntity(body, "UTF-8");
        stringEntity.setChunked(true);
        return stringEntity;
    }

    @Override
    Response parseResponse(CloseableHttpResponse response) throws ClientSendException {
        try {
            Document soapDocument = XMLObjectProviderRegistrySupport.getParserPool().parse(response.getEntity().getContent());
            Node responseNode = soapDocument.getFirstChild().getLastChild().getFirstChild();
            Document doc = XMLObjectProviderRegistrySupport.getParserPool().newDocument();
            Node importedNode = doc.importNode(responseNode, true);
            doc.appendChild(importedNode);
            ResponseDeserializerImpl deserializer = new ResponseDeserializerImpl();
            return deserializer.fromXmlElement(doc.getDocumentElement());
        }
        catch (IOException | UnsupportedOperationException | TransformerFactoryConfigurationError | XMLParserException | DeserializeException e) {
            throw new ClientSendException(e);
        }
    }

    public Response send(AuthnRequest aAuthnRequest) throws ClientSendException {
        try {
            HttpPost post = this.getHttpPost(this.config);
            post.setHeader("Content-Type", "text/xml");
            post.setEntity(this.getSoapEntity(aAuthnRequest));
            post.addHeader("Accept", "text/xml");
            this.addBasicAuthentication(post);
            return this.execute(post);
        }
        catch (Exception t) {
            throw new ClientSendException((Throwable)t);
        }
    }
}

