/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import org.projecthusky.xua.communication.clients.IdpClient;
import org.projecthusky.xua.communication.clients.XuaClient;
import org.projecthusky.xua.communication.clients.impl.IdpClientByBrowserAndProtocolHandler;
import org.projecthusky.xua.communication.clients.impl.IdpClientByCert;
import org.projecthusky.xua.communication.clients.impl.IdpClientByProxy;
import org.projecthusky.xua.communication.clients.impl.IdpSoapBindingClientByBasicAuth;
import org.projecthusky.xua.communication.clients.impl.SimpleXuaClient;
import org.projecthusky.xua.communication.config.IdpClientConfig;
import org.projecthusky.xua.communication.config.XuaClientConfig;
import org.projecthusky.xua.communication.config.impl.IdpClientBasicAuthConfigImpl;
import org.projecthusky.xua.communication.config.impl.IdpClientByBrowserAndProtocolHandlerConfigImpl;
import org.projecthusky.xua.communication.config.impl.IdpClientCertificateAuthConfigImpl;
import org.projecthusky.xua.communication.config.impl.IdpClientViaHttpProxyConfigImpl;

public class ClientFactory {
    protected ClientFactory() {
    }

    public static IdpClient getIdpClient(IdpClientConfig clientConfiguration) {
        if (clientConfiguration instanceof IdpClientViaHttpProxyConfigImpl) {
            IdpClientViaHttpProxyConfigImpl idpClientViaHttpProxyConfigImpl = (IdpClientViaHttpProxyConfigImpl)clientConfiguration;
            return new IdpClientByProxy(idpClientViaHttpProxyConfigImpl);
        }
        if (clientConfiguration instanceof IdpClientCertificateAuthConfigImpl) {
            IdpClientCertificateAuthConfigImpl idpClientCertificateAuthConfigImpl = (IdpClientCertificateAuthConfigImpl)clientConfiguration;
            return new IdpClientByCert(idpClientCertificateAuthConfigImpl);
        }
        if (clientConfiguration instanceof IdpClientBasicAuthConfigImpl) {
            IdpClientBasicAuthConfigImpl idpClientBasicAuthConfigImpl = (IdpClientBasicAuthConfigImpl)clientConfiguration;
            return new IdpSoapBindingClientByBasicAuth(idpClientBasicAuthConfigImpl);
        }
        if (clientConfiguration instanceof IdpClientByBrowserAndProtocolHandlerConfigImpl) {
            IdpClientByBrowserAndProtocolHandlerConfigImpl idpClientByBrowserAndProtocolHandlerConfigImpl = (IdpClientByBrowserAndProtocolHandlerConfigImpl)clientConfiguration;
            return new IdpClientByBrowserAndProtocolHandler(idpClientByBrowserAndProtocolHandlerConfigImpl);
        }
        return null;
    }

    public static XuaClient getXuaClient(XuaClientConfig clientConfiguration) {
        return new SimpleXuaClient(clientConfiguration);
    }
}

