/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.XMLParserException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.projecthusky.common.utils.xml.XmlFactories;
import org.projecthusky.xua.communication.config.SoapClientConfig;
import org.projecthusky.xua.communication.soap.impl.WsaHeaderValue;
import org.projecthusky.xua.exceptions.ClientSendException;
import org.projecthusky.xua.exceptions.SoapException;
import org.projecthusky.xua.pki.impl.PkiManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSoapClient<T> {
    private SoapClientConfig config;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void createBody(Element aBodyElement, Element envelopElement) {
        Element soapBody = envelopElement.getOwnerDocument().createElementNS(this.getSoapNs(), "Body");
        envelopElement.appendChild(soapBody);
        Node importedNode = envelopElement.getOwnerDocument().importNode(aBodyElement, true);
        soapBody.appendChild(importedNode);
    }

    protected Element createEnvelope() throws ParserConfigurationException {
        DocumentBuilder docBuilder = XmlFactories.newSafeDocumentBuilder();
        Document soapDoc = docBuilder.newDocument();
        String soapNs = this.getSoapNs();
        Element envelopElement = soapDoc.createElementNS(soapNs, "Envelope");
        soapDoc.appendChild(envelopElement);
        return envelopElement;
    }

    protected void createHeader(Element aSecurityHeaderElement, WsaHeaderValue wsHeaders, Element envelopElement) {
        Element headerElement = envelopElement.getOwnerDocument().createElementNS(this.getSoapNs(), "Header");
        envelopElement.appendChild(headerElement);
        Element headerWsaAction = envelopElement.getOwnerDocument().createElementNS("http://www.w3.org/2005/08/addressing", "Action");
        headerWsaAction.setTextContent(wsHeaders.getAction());
        headerElement.appendChild(headerWsaAction);
        Element headerWsaMessageID = envelopElement.getOwnerDocument().createElementNS("http://www.w3.org/2005/08/addressing", "MessageID");
        headerWsaMessageID.setTextContent(wsHeaders.getMessageId());
        headerElement.appendChild(headerWsaMessageID);
        Element headerSecurityElement = envelopElement.getOwnerDocument().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        headerElement.appendChild(headerSecurityElement);
        if (aSecurityHeaderElement != null) {
            Node importedHeaderNode = envelopElement.getOwnerDocument().importNode(aSecurityHeaderElement, true);
            headerSecurityElement.appendChild(importedHeaderNode);
        }
    }

    protected String createXmlString(Element aEnvelope) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(aEnvelope.getOwnerDocument()), new StreamResult(writer));
        return writer.toString();
    }

    protected T execute(HttpPost post) throws ClientSendException, IOException {
        CloseableHttpClient httpclient = this.getHttpClient();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
        HttpEntity responseEntity = response.getEntity();
        this.logger.debug(responseEntity.getContentType().getValue());
        String content = this.extractResponse(responseEntity);
        this.logger.debug("SOAP Message\n {}", (Object)content);
        if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200) {
            return this.parseResponse(content);
        }
        return this.parseResponseError(content);
    }

    protected String extractResponse(HttpEntity responseEntity) throws ParseException, IOException {
        String content = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
        if (responseEntity.getContentType().getValue().startsWith("multipart")) {
            this.logger.debug("Multiparted Message\n {}", (Object)content);
            byte[] boundary = this.getBoundary(responseEntity.getContentType().getValue());
            this.logger.debug("Boundary: {}", (Object)boundary);
            MultipartStream multipartStream = new MultipartStream((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), boundary, 16384, null);
            boolean nextPart = multipartStream.skipPreamble();
            while (nextPart) {
                String header = multipartStream.readHeaders();
                this.logger.debug("");
                this.logger.debug("Headers:");
                this.logger.debug(header);
                this.logger.debug("Body:");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                multipartStream.readBodyData((OutputStream)out);
                content = out.toString("UTF-8");
                this.logger.debug(content);
                out.close();
                this.logger.debug("");
                nextPart = multipartStream.readBoundary();
            }
        }
        return content;
    }

    protected byte[] getBoundary(String value) {
        String[] splits;
        for (String split : splits = value.split(";")) {
            if (!split.trim().startsWith("boundary")) continue;
            String boundaryWith = split.trim().split("=")[1];
            boundaryWith = boundaryWith.substring(1, boundaryWith.length() - 1);
            return boundaryWith.getBytes();
        }
        return new byte[0];
    }

    protected SoapClientConfig getConfig() {
        return this.config;
    }

    protected CloseableHttpClient getHttpClient() throws ClientSendException {
        if (!StringUtils.isEmpty((CharSequence)this.config.getKeyStore())) {
            CloseableHttpClient closeableHttpClient;
            FileInputStream fis = new FileInputStream(this.config.getKeyStore());
            try {
                PkiManagerImpl pki = new PkiManagerImpl();
                KeyStore keyStore = pki.loadStore(fis, this.config.getKeyStorePassword(), this.config.getKeyStoreType());
                TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
                SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, this.config.getKeyStorePassword().toCharArray()).loadTrustMaterial(keyStore, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
                closeableHttpClient = HttpClients.custom().setSSLContext(sslcontext).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    throw new ClientSendException((Throwable)e);
                }
            }
            fis.close();
            return closeableHttpClient;
        }
        return HttpClients.createDefault();
    }

    protected HttpPost getHttpPost() {
        HttpPost post = new HttpPost(this.config.getUrl());
        post.setConfig(this.getRequestConfig());
        post.setHeader("Content-Type", "application/soap+xml; charset=utf-8");
        return post;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Node getNode(final Element element, String xPathExpression) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("")) {
                    return element.getOwnerDocument().lookupNamespaceURI(null);
                }
                return element.getOwnerDocument().lookupNamespaceURI(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return element.getOwnerDocument().lookupPrefix(namespaceURI);
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return null;
            }
        });
        XPathExpression expr = xPath.compile(xPathExpression);
        return (Node)expr.evaluate(element, XPathConstants.NODE);
    }

    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().build();
    }

    protected Element getResponseElement(String content, String nameSpaceUri, String localName) throws UnsupportedOperationException, XPathExpressionException, XMLParserException {
        Node bodyNode;
        NodeList reponseNodes;
        ParserPool docBuilder = XMLObjectProviderRegistrySupport.getParserPool();
        Document soapDocument = docBuilder.parse((InputStream)new ByteArrayInputStream(content.getBytes()));
        Object prefix = soapDocument.getDocumentElement().getPrefix();
        if (!StringUtils.isEmpty((CharSequence)prefix)) {
            prefix = (String)prefix + ":";
        }
        if ((reponseNodes = ((Element)(bodyNode = this.getNode(soapDocument.getDocumentElement(), "/" + (String)prefix + "Envelope/" + (String)prefix + "Body"))).getElementsByTagNameNS("*", localName)) == null || reponseNodes.getLength() < 1) {
            reponseNodes = ((Element)bodyNode).getElementsByTagNameNS(nameSpaceUri, localName);
        }
        if (reponseNodes.getLength() == 0) {
            throw new XPathExpressionException("No node of type " + localName + " found.");
        }
        Node responseNode = reponseNodes.item(0);
        Document doc = docBuilder.newDocument();
        Node importedNode = doc.importNode(responseNode, true);
        doc.appendChild(importedNode);
        return doc.getDocumentElement();
    }

    protected SoapException getSoapException(Node faultnode) {
        String faultCode = "";
        String faultMessage = "";
        if (faultnode != null) {
            Object prefix = faultnode.getPrefix();
            if (!"".equals(prefix)) {
                prefix = (String)prefix + ":";
            }
            NodeList childs = faultnode.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node child = childs.item(j);
                this.logger.debug("NodeName: {}", (Object)child.getNodeName());
                if ("faultcode".equalsIgnoreCase(child.getNodeName())) {
                    faultCode = child.getTextContent();
                    continue;
                }
                if ("faultstring".equalsIgnoreCase(child.getNodeName())) {
                    faultMessage = child.getTextContent();
                    continue;
                }
                if (((String)prefix + "Code").equalsIgnoreCase(child.getNodeName())) {
                    faultCode = child.getFirstChild().getTextContent();
                    continue;
                }
                if (((String)prefix + "Reason").equalsIgnoreCase(child.getNodeName())) {
                    faultMessage = child.getFirstChild().getTextContent();
                    continue;
                }
                if (!"#text".equalsIgnoreCase(child.getNodeName())) continue;
                faultCode = "Reason";
                faultMessage = child.getTextContent();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)faultCode)) {
            return new SoapException(faultCode, faultMessage);
        }
        return new SoapException("Client", "No inforamtion available");
    }

    private String getSoapNs() {
        if (SoapClientConfig.SoapVersion.SOAP_12.equals((Object)this.config.getSoapVersion())) {
            return "http://www.w3.org/2003/05/soap-envelope";
        }
        return "http://schemas.xmlsoap.org/soap/envelope/";
    }

    protected abstract T parseResponse(String var1) throws ClientSendException;

    protected T parseResponseError(String content) throws ClientSendException {
        this.logger.debug("parseResponseError: {}", (Object)content);
        try {
            String retVal = null;
            if (content.trim().startsWith("<") && content.trim().endsWith(">")) {
                retVal = content;
            } else {
                Pattern regex = Pattern.compile("<([a-zA-Z:]{0,200})Envelope(.{0,10000})>(.{1,100000})</([a-zA-Z:]{0,200})Envelope>");
                Matcher matcher = regex.matcher(content);
                if (matcher.find()) {
                    retVal = matcher.group();
                }
            }
            if (retVal != null) {
                this.paserSoapFault(retVal);
            }
            throw new ClientSendException("Error occurred. No detailed error information available");
        }
        catch (UnsupportedOperationException | TransformerFactoryConfigurationError | XPathExpressionException | XMLParserException | ParseException e) {
            throw new ClientSendException(e);
        }
    }

    private void paserSoapFault(String retVal) throws XPathExpressionException, SoapException, XMLParserException {
        ParserPool docBuilder = XMLObjectProviderRegistrySupport.getParserPool();
        Document document = docBuilder.parse((InputStream)new ByteArrayInputStream(retVal.getBytes()));
        Object prefix = document.getDocumentElement().getPrefix();
        if (!StringUtils.isEmpty((CharSequence)prefix)) {
            prefix = (String)prefix + ":";
        }
        Node faultnode = this.getNode(document.getDocumentElement(), "/" + (String)prefix + "Envelope/" + (String)prefix + "Body/" + (String)prefix + "Fault");
        throw this.getSoapException(faultnode);
    }

    protected void setConfig(SoapClientConfig config) {
        this.config = config;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }
}

