/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.projecthusky.xua.authentication.AuthnRequest;
import org.projecthusky.xua.communication.clients.IdpClient;
import org.projecthusky.xua.communication.config.IdpClientConfig;
import org.projecthusky.xua.deserialization.impl.ResponseDeserializerImpl;
import org.projecthusky.xua.exceptions.ClientSendException;
import org.projecthusky.xua.exceptions.DeserializeException;
import org.projecthusky.xua.exceptions.SerializeException;
import org.projecthusky.xua.saml2.Response;
import org.projecthusky.xua.serialization.impl.AuthnRequestSerializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdpClient
implements IdpClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    Response execute(HttpPost post) throws ClientSendException, IOException {
        CloseableHttpClient httpclient = this.getHttpClient();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
        if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200) {
            return this.parseResponse(response);
        }
        throw new NoHttpResponseException("No valid response found: " + String.valueOf(response));
    }

    public abstract CloseableHttpClient getHttpClient() throws ClientSendException;

    HttpPost getHttpPost(IdpClientConfig config) throws UnsupportedEncodingException {
        HttpPost post = new HttpPost(config.getUrl());
        post.setConfig(this.getRequestConfig());
        return post;
    }

    public abstract RequestConfig getRequestConfig();

    UrlEncodedFormEntity getUrlFormEntity(AuthnRequest aAuthnRequest) throws SerializeException, UnsupportedEncodingException {
        AuthnRequestSerializerImpl serializer = new AuthnRequestSerializerImpl();
        byte[] authnByteArray = serializer.toXmlByteArray(aAuthnRequest);
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("SAMLRequest", Base64.getEncoder().encodeToString(authnByteArray)));
        return new UrlEncodedFormEntity(urlParameters);
    }

    Response parseResponse(CloseableHttpResponse response) throws ClientSendException {
        try {
            String responseEntity = EntityUtils.toString((HttpEntity)response.getEntity());
            this.logger.debug("Response:\n {}", (Object)responseEntity);
            Document doc = Jsoup.parse((String)responseEntity);
            Elements samlElements = doc.getElementsByAttributeValue("name", "SAMLResponse");
            Element samlElement = samlElements.first();
            String samlResponseBase64String = samlElement.attr("value");
            byte[] reponseByteArray = Base64.getDecoder().decode(samlResponseBase64String);
            ResponseDeserializerImpl deserializer = new ResponseDeserializerImpl();
            return deserializer.fromXmlByteArray(reponseByteArray);
        }
        catch (IOException | ParseException | DeserializeException e) {
            throw new ClientSendException(e);
        }
    }
}

