/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.serialization.impl;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.projecthusky.common.utils.xml.XmlFactories;
import org.projecthusky.xua.exceptions.SerializeException;
import org.projecthusky.xua.serialization.OpenSaml2Serializer;
import org.w3c.dom.Element;

public class OpenSaml2SerializerImpl
implements OpenSaml2Serializer {
    @Override
    public Integer getLoadedMarshallerCount() {
        Integer retVal = 0;
        try {
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            if (marshallerFactory != null) {
                retVal = marshallerFactory.getMarshallers().size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public byte[] serializeToByteArray(XMLObject aXmlObject) throws SerializeException {
        return this.serializeToByteArrayOutputStream(aXmlObject).toByteArray();
    }

    private ByteArrayOutputStream serializeToByteArrayOutputStream(XMLObject aXmlObject) throws SerializeException {
        try {
            Element element = this.serializeToXml(aXmlObject);
            Transformer tr = XmlFactories.newTransformer();
            tr.setOutputProperty("indent", "no");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(4));
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            tr.transform(new DOMSource(element), new StreamResult(bas));
            return bas;
        }
        catch (Exception e) {
            throw new SerializeException((Throwable)e);
        }
    }

    @Override
    public String serializeToString(XMLObject aXmlObject) throws SerializeException {
        return this.serializeToByteArrayOutputStream(aXmlObject).toString();
    }

    @Override
    public Element serializeToXml(XMLObject aXmlObject) throws SerializeException {
        try {
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(aXmlObject);
            return marshaller.marshall(aXmlObject);
        }
        catch (NullPointerException | MarshallingException e) {
            throw new SerializeException(e);
        }
    }
}

