/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.saml2.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.SubjectConfirmationDataType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.SubjectConfirmationType;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.core.impl.SubjectConfirmationBuilder;
import org.opensaml.saml.saml2.core.impl.SubjectConfirmationDataBuilder;
import org.projecthusky.xua.core.SecurityObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectConfirmationImpl
extends SubjectConfirmationType
implements SecurityObject<SubjectConfirmation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubjectConfirmationImpl.class);
    private SubjectConfirmation subjectConfirmation;

    protected SubjectConfirmationImpl(SubjectConfirmation aInternalObject) {
        this.subjectConfirmation = aInternalObject;
        this.setSubjectConfirmationData(new SubjectConfirmationDataType());
        this.getAddress();
        this.getInResponseTo();
        this.getMethod();
        this.getNotBefore();
        this.getNotOnOrAfter();
        this.getRecipient();
    }

    protected SubjectConfirmationImpl(SubjectConfirmationType aInternalObject) {
        this.subjectConfirmation = new SubjectConfirmationBuilder().buildObject();
        if (aInternalObject.getSubjectConfirmationData() != null) {
            SubjectConfirmationData subjectConfirmData = new SubjectConfirmationDataBuilder().buildObject();
            subjectConfirmData.setAddress(aInternalObject.getSubjectConfirmationData().getAddress());
            subjectConfirmData.setInResponseTo(aInternalObject.getSubjectConfirmationData().getInResponseTo());
            if (aInternalObject.getSubjectConfirmationData().getNotBefore() != null) {
                subjectConfirmData.setNotBefore(aInternalObject.getSubjectConfirmationData().getNotBefore().toGregorianCalendar().toInstant());
            }
            if (aInternalObject.getSubjectConfirmationData().getNotOnOrAfter() != null) {
                subjectConfirmData.setNotOnOrAfter(aInternalObject.getSubjectConfirmationData().getNotOnOrAfter().toGregorianCalendar().toInstant());
            }
            subjectConfirmData.setRecipient(aInternalObject.getSubjectConfirmationData().getRecipient());
            this.subjectConfirmation.setSubjectConfirmationData(subjectConfirmData);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SubjectConfirmationImpl other = (SubjectConfirmationImpl)((Object)obj);
        return !(this.subjectConfirmation == null ? other.subjectConfirmation != null : !this.subjectConfirmation.equals(other.subjectConfirmation));
    }

    public String getAddress() {
        if (this.subjectConfirmation.getSubjectConfirmationData() != null) {
            this.getSubjectConfirmationData().setAddress(this.subjectConfirmation.getSubjectConfirmationData().getAddress());
            return this.getSubjectConfirmationData().getAddress();
        }
        return "";
    }

    public String getInResponseTo() {
        if (this.subjectConfirmation.getSubjectConfirmationData() != null) {
            this.getSubjectConfirmationData().setInResponseTo(this.subjectConfirmation.getSubjectConfirmationData().getInResponseTo());
            return this.getSubjectConfirmationData().getInResponseTo();
        }
        return "";
    }

    public String getMethod() {
        this.setMethod(this.subjectConfirmation.getMethod());
        return super.getMethod();
    }

    public Calendar getNotBefore() {
        if (this.subjectConfirmation.getSubjectConfirmationData() != null && this.subjectConfirmation.getSubjectConfirmationData().getNotBefore() != null) {
            GregorianCalendar retVal = new GregorianCalendar();
            retVal.setTimeInMillis(this.subjectConfirmation.getSubjectConfirmationData().getNotBefore().toEpochMilli());
            XMLGregorianCalendar xmlGregCal = null;
            try {
                xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(retVal);
                this.getSubjectConfirmationData().setNotBefore(xmlGregCal);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return retVal;
        }
        return Calendar.getInstance();
    }

    public Calendar getNotOnOrAfter() {
        if (this.subjectConfirmation.getSubjectConfirmationData() != null && this.subjectConfirmation.getSubjectConfirmationData().getNotOnOrAfter() != null) {
            GregorianCalendar retVal = new GregorianCalendar();
            retVal.setTimeInMillis(this.subjectConfirmation.getSubjectConfirmationData().getNotOnOrAfter().toEpochMilli());
            XMLGregorianCalendar xmlGregCal = null;
            try {
                xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(retVal);
                this.getSubjectConfirmationData().setNotOnOrAfter(xmlGregCal);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return retVal;
        }
        return Calendar.getInstance();
    }

    public String getRecipient() {
        if (this.subjectConfirmation.getSubjectConfirmationData() != null) {
            this.getSubjectConfirmationData().setRecipient(this.subjectConfirmation.getSubjectConfirmationData().getRecipient());
            return this.getSubjectConfirmationData().getRecipient();
        }
        return "";
    }

    public SubjectConfirmation getWrappedObject() {
        return this.subjectConfirmation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subjectConfirmation == null ? 0 : this.subjectConfirmation.hashCode());
        return result;
    }
}

