/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.saml2.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.projecthusky.xua.core.SecurityObject;
import org.projecthusky.xua.saml2.Assertion;
import org.projecthusky.xua.saml2.EncryptedAssertion;
import org.projecthusky.xua.saml2.Response;
import org.projecthusky.xua.saml2.Status;
import org.projecthusky.xua.saml2.impl.AssertionBuilderImpl;
import org.projecthusky.xua.saml2.impl.EncryptedAssertionBuilderImpl;
import org.projecthusky.xua.saml2.impl.StatusImpl;

public class ResponseImpl
implements Response,
SecurityObject<org.opensaml.saml.saml2.core.Response> {
    private org.opensaml.saml.saml2.core.Response response;

    protected ResponseImpl(org.opensaml.saml.saml2.core.Response response) {
        this.response = response;
    }

    public List<Assertion> getAssertions() {
        List internal = this.response.getAssertions();
        ArrayList<Assertion> retVal = new ArrayList<Assertion>();
        internal.forEach(c -> retVal.add(new AssertionBuilderImpl().create((org.opensaml.saml.saml2.core.Assertion)c)));
        return retVal;
    }

    public String getConsent() {
        return this.response.getConsent();
    }

    public String getDestination() {
        return this.response.getDestination();
    }

    public List<EncryptedAssertion> getEncryptedAssertions() {
        List internal = this.response.getEncryptedAssertions();
        ArrayList<EncryptedAssertion> retVal = new ArrayList<EncryptedAssertion>();
        internal.forEach(c -> retVal.add(new EncryptedAssertionBuilderImpl().create((org.opensaml.saml.saml2.core.EncryptedAssertion)c)));
        return retVal;
    }

    public String getId() {
        return this.response.getID();
    }

    public String getInResponseTo() {
        return this.response.getInResponseTo();
    }

    public Calendar getIssueInstant() {
        Calendar retVal = Calendar.getInstance();
        retVal.setTimeInMillis(this.response.getIssueInstant().toEpochMilli());
        return retVal;
    }

    public String getIssuer() {
        if (this.response.getIssuer() != null) {
            return this.response.getIssuer().getValue();
        }
        return "";
    }

    public Status getStatus() {
        return new StatusImpl(this.response.getStatus());
    }

    public String getVersion() {
        if (this.response.getVersion() != null) {
            return this.response.getVersion().toString();
        }
        return "";
    }

    public org.opensaml.saml.saml2.core.Response getWrappedObject() {
        return this.response;
    }

    public boolean hasSignature() {
        return this.response.getSignature() != null;
    }
}

