/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.saml2.impl;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AuthnContextType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.assertion.AuthnStatementType;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.impl.AuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnStatementBuilder;
import org.projecthusky.xua.core.SecurityObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnStatementImpl
extends AuthnStatementType
implements SecurityObject<AuthnStatement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthnStatementImpl.class);
    private AuthnStatement authnStatement;

    protected AuthnStatementImpl(AuthnStatement aAuthnStatement) {
        this.authnStatement = aAuthnStatement;
    }

    protected AuthnStatementImpl(AuthnStatementType aAuthnStatement) {
        XMLGregorianCalendar xmlGregCal;
        this.authnStatement = new AuthnStatementBuilder().buildObject();
        AuthnContext authnContext = new AuthnContextBuilder().buildObject();
        AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
        for (JAXBElement jaxbElement : aAuthnStatement.getAuthnContext().getContent()) {
            if (jaxbElement == null || !"AuthnContextClassRef".equalsIgnoreCase(jaxbElement.getName().getLocalPart())) continue;
            authnContextClassRef.setURI((String)jaxbElement.getValue());
        }
        authnContext.setAuthnContextClassRef(authnContextClassRef);
        this.authnStatement.setAuthnContext(authnContext);
        if (aAuthnStatement.getAuthnInstant() != null) {
            xmlGregCal = aAuthnStatement.getAuthnInstant();
            this.authnStatement.setAuthnInstant(xmlGregCal.toGregorianCalendar().toInstant());
        }
        this.authnStatement.setSessionIndex(aAuthnStatement.getSessionIndex());
        if (aAuthnStatement.getSessionNotOnOrAfter() != null) {
            xmlGregCal = aAuthnStatement.getSessionNotOnOrAfter();
            this.authnStatement.setSessionNotOnOrAfter(xmlGregCal.toGregorianCalendar().toInstant());
        }
    }

    public AuthnContextType getAuthnContext() {
        if (this.authnStatement.getAuthnContext() != null && this.authnStatement.getAuthnContext().getAuthnContextClassRef() != null) {
            this.authnContext = new AuthnContextType();
            QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef");
            this.authnContext.getContent().add(new JAXBElement(qname, AuthnContextClassRef.class, (Object)this.authnStatement.getAuthnContext().getAuthnContextClassRef()));
            return this.authnContext;
        }
        return null;
    }

    public XMLGregorianCalendar getAuthnInstant() {
        Instant instant = this.authnStatement.getAuthnInstant();
        GregorianCalendar retVal = GregorianCalendar.from(ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()));
        XMLGregorianCalendar xmlGregCal = null;
        try {
            xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(retVal);
            this.setAuthnInstant(xmlGregCal);
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return xmlGregCal;
    }

    public String getSessionIndex() {
        this.sessionIndex = this.authnStatement.getSessionIndex();
        return this.authnStatement.getSessionIndex();
    }

    public XMLGregorianCalendar getSessionNotOnOrAfter() {
        Instant instant = this.authnStatement.getSessionNotOnOrAfter();
        GregorianCalendar retVal = GregorianCalendar.from(ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()));
        XMLGregorianCalendar xmlGregCal = null;
        try {
            xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(retVal);
            this.setAuthnInstant(xmlGregCal);
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return xmlGregCal;
    }

    public AuthnStatement getWrappedObject() {
        return this.authnStatement;
    }
}

