/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.pki.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import org.projecthusky.xua.pki.PkiManager;

public class PkiManagerImpl
implements PkiManager {
    public void addClientKeyAndCert(File privateKeyPemPath, File clientCertPemPath, String alias, KeyStore keyStore, String aKeyPassword) throws KeyStoreException {
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            FileInputStream is = new FileInputStream(clientCertPemPath);
            X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
            Certificate[] chain = new Certificate[]{cer};
            URI keyUri = privateKeyPemPath.toURI();
            String privateKeyContent = new String(Files.readAllBytes(Paths.get(keyUri)), StandardCharsets.UTF_8);
            privateKeyContent = privateKeyContent.replace("\n", "").replace("\r", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            byte[] temp = Base64.getDecoder().decode(privateKeyContent);
            PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(temp);
            PrivateKey privKey = kf.generatePrivate(keySpecPKCS8);
            keyStore.setKeyEntry(alias.toLowerCase(), privKey, aKeyPassword.toCharArray(), chain);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    public void addPublicCert(File publiCertPath, String alias, KeyStore keyStore) throws KeyStoreException {
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            FileInputStream is = new FileInputStream(publiCertPath);
            X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
            keyStore.setCertificateEntry(alias.toLowerCase(), cer);
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw new KeyStoreException(e);
        }
    }

    public KeyStore createNewStore(String storeType) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try {
            keyStore.load(null, null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException(e);
        }
        return keyStore;
    }

    public List<String> listCertificateAliases(KeyStore keyStore) throws KeyStoreException {
        ArrayList<String> retVal = new ArrayList<String>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias) && !keyStore.isKeyEntry(alias)) continue;
            retVal.add(alias.toLowerCase());
        }
        return retVal;
    }

    public List<Certificate> listCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> retVal = new ArrayList<Certificate>();
        List<String> aliases = this.listCertificateAliases(keyStore);
        for (String alias : aliases) {
            retVal.add(keyStore.getCertificate(alias.toLowerCase()));
        }
        return retVal;
    }

    public KeyStore loadStore(InputStream storeInputStream, String storePassword, String storeType) throws KeyStoreException {
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType);
            keyStore.load(storeInputStream, storePassword.toCharArray());
            return keyStore;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException(e);
        }
    }

    public void removeCert(String alias, KeyStore keyStore) throws KeyStoreException {
        if (keyStore.isCertificateEntry(alias.toLowerCase())) {
            keyStore.deleteEntry(alias.toLowerCase());
        }
    }

    public void storeStore(KeyStore keyStore, OutputStream storeOutputStream, String storePassword) throws KeyStoreException {
        try {
            keyStore.store(storeOutputStream, storePassword.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException(e);
        }
    }
}

