/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.deserialization.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.projecthusky.xua.deserialization.OpenSaml2Deserializer;
import org.projecthusky.xua.exceptions.DeserializeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenSaml2DeserializerImpl<T>
implements OpenSaml2Deserializer<T> {
    @Override
    public T deserializeFromByteArray(byte[] aXmlBytes) throws DeserializeException {
        try {
            Element element = this.deserializeFromByteArrayToXmlElement(aXmlBytes);
            return this.deserializeFromXml(element);
        }
        catch (Exception e) {
            throw new DeserializeException((Throwable)e);
        }
    }

    @Override
    public Element deserializeFromByteArrayToXmlElement(byte[] aXmlBytes) throws DeserializeException {
        try {
            Document document = Objects.requireNonNull(XMLObjectProviderRegistrySupport.getParserPool()).parse((InputStream)new ByteArrayInputStream(aXmlBytes));
            return document.getDocumentElement();
        }
        catch (Exception e) {
            throw new DeserializeException((Throwable)e);
        }
    }

    @Override
    public T deserializeFromString(String aXmlString) throws DeserializeException {
        return this.deserializeFromByteArray(aXmlString.getBytes());
    }

    @Override
    public T deserializeFromXml(Element aXmlElement) throws DeserializeException {
        try {
            UnmarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = marshallerFactory.getUnmarshaller(aXmlElement);
            return (T)Objects.requireNonNull(unmarshaller).unmarshall(aXmlElement);
        }
        catch (Exception e) {
            throw new DeserializeException((Throwable)e);
        }
    }
}

