/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.crypt;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.projecthusky.xua.authentication.AuthnRequest;
import org.projecthusky.xua.authentication.impl.AuthnRequestImpl;
import org.projecthusky.xua.crypt.SignCryptModule;
import org.projecthusky.xua.exceptions.SigningException;
import org.projecthusky.xua.saml2.ArtifactResolve;
import org.projecthusky.xua.saml2.impl.ArtifactResolveImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignCryptModuleImpl
implements SignCryptModule {
    private static final Logger LOG = LoggerFactory.getLogger(SignCryptModuleImpl.class);
    private KeyStore keyStore;
    private String keyStorePassword;
    private KeyStore trustStore;
    private String trustStorePassword;

    private BasicX509Credential getSigningCredential(String aSigningAlias) throws SigningException {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(aSigningAlias, new KeyStore.PasswordProtection(this.keyStorePassword.toCharArray()));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            X509Certificate certificate = (X509Certificate)privateKeyEntry.getCertificate();
            LOG.debug(certificate.getIssuerX500Principal().getName());
            BasicX509Credential credential = new BasicX509Credential(certificate, privateKey);
            credential.setEntityId(aSigningAlias);
            return credential;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new SigningException((Throwable)e);
        }
    }

    public void setPki(KeyStore aKeyStore, String aKeyStorePassword, KeyStore aTrustStore, String aTrustStorePassword) {
        this.keyStore = aKeyStore;
        this.keyStorePassword = aKeyStorePassword;
        this.trustStore = aTrustStore;
        this.trustStorePassword = aTrustStorePassword;
    }

    private void sign(SignableXMLObject singningobject, String aSigningAlias) throws SigningException {
        try {
            Signature signature = (Signature)new SignatureBuilder().buildObject(Signature.DEFAULT_ELEMENT_NAME);
            BasicX509Credential signingCredential = this.getSigningCredential(aSigningAlias);
            signature.setSigningCredential((Credential)signingCredential);
            signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
            keyInfoGeneratorFactory.setEmitEntityCertificate(true);
            keyInfoGeneratorFactory.setX509DigestAlgorithmURI("http://www.w3.org/2000/09/xmldsig#sha1");
            if (keyInfoGeneratorFactory.handles((Credential)signingCredential)) {
                KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
                KeyInfo keyInfo = keyInfoGenerator.generate((Credential)signingCredential);
                signature.setKeyInfo(keyInfo);
                singningobject.setSignature(signature);
                XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)singningobject).marshall((XMLObject)singningobject);
                Signer.signObject((Signature)signature);
            }
        }
        catch (MarshallingException | SecurityException | SignatureException e) {
            throw new SigningException(e);
        }
    }

    public void signArtifactResolve(ArtifactResolve artifactResolve, String aSigningAlias) throws SigningException {
        ArtifactResolveImpl concrete = (ArtifactResolveImpl)artifactResolve;
        this.sign((SignableXMLObject)concrete.getWrappedObject(), aSigningAlias);
    }

    public void signAuthnRequest(AuthnRequest aAuthnRequest, String aSigningAlias) throws SigningException {
        AuthnRequestImpl concrete = (AuthnRequestImpl)aAuthnRequest;
        this.sign((SignableXMLObject)concrete.getWrappedObject(), aSigningAlias);
    }
}

