/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.soap.impl;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class LogSoapMessageHandler
implements SOAPHandler<SOAPMessageContext> {
    private Logger mLogger = LoggerFactory.getLogger(this.getClass());
    public static final String MSG_SEPARATOR = "------------------------------------";

    public LogSoapMessageHandler() {
        this.mLogger.debug("LogSoapMessageHandler()");
    }

    public void close(MessageContext context) {
        this.mLogger.debug("close: {}", (Object)context);
    }

    @PreDestroy
    public void destroy() {
        this.mLogger.debug(MSG_SEPARATOR);
        this.mLogger.debug("In Handler {} :destroy()", (Object)this.getClass().getName());
        this.mLogger.debug("Exiting Handler {} :destroy()", (Object)this.getClass().getName());
        this.mLogger.debug(MSG_SEPARATOR);
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleFault(SOAPMessageContext context) {
        try {
            SOAPMessage soapMsg = context.getMessage();
            this.mLogger.debug("SOAP Message: {}", (Object)soapMsg);
        }
        catch (Exception ex) {
            this.mLogger.debug("Error in soap logging", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        this.mLogger.debug("LogSoapMessageHandler.handleMessage()");
        try {
            Boolean outboundProperty = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
            String inout = "";
            inout = outboundProperty != false ? "Request: " : "Response : ";
            SOAPMessage soapMsg = context.getMessage();
            context.put((Object)"soapMsg", (Object)soapMsg);
            context.setScope("soapMsg", MessageContext.Scope.APPLICATION);
            StringWriter sw = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource((Node)soapMsg.getSOAPPart()), new StreamResult(sw));
            this.mLogger.debug("Message: {} {}", (Object)inout, (Object)sw);
        }
        catch (Exception ex) {
            this.mLogger.debug("Error in soap logging", (Throwable)ex);
            return false;
        }
        return true;
    }

    @PostConstruct
    public void init() {
        this.mLogger.debug(MSG_SEPARATOR);
        this.mLogger.debug("In Handler {} : init()", (Object)this.getClass().getName());
        this.mLogger.debug("Exiting Handler {} : init()", (Object)this.getClass().getName());
        this.mLogger.debug(MSG_SEPARATOR);
    }
}

