/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.soap.impl;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.projecthusky.xua.saml2.utils.XmlAppender;
import org.projecthusky.xua.serialization.impl.OpenSaml2SerializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class HeaderAddAssertionSoapHandler
implements SOAPHandler<SOAPMessageContext> {
    private Logger mLogger = LoggerFactory.getLogger(this.getClass());
    private SecurityHeaderElement mSecurityHeaderElement;

    public HeaderAddAssertionSoapHandler(SecurityHeaderElement aSecurityHeaderElement) {
        this.mLogger.debug("AssertionSoapHandler()");
        this.mSecurityHeaderElement = aSecurityHeaderElement;
    }

    public void close(MessageContext context) {
        this.mLogger.debug("close: {}", (Object)context);
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.mLogger.error("SOAP Fault: {}", (Object)context);
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        this.mLogger.debug("AssertionSoapHandler.handleMessage()");
        Boolean outboundProperty = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            try {
                SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
                SOAPFactory factory = SOAPFactory.newInstance();
                SOAPHeader header = envelope.getHeader();
                if (header == null) {
                    header = envelope.addHeader();
                }
                SOAPElement securityElem = factory.createElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
                Element serializedElement = new OpenSaml2SerializerImpl().serializeToXml((XMLObject)this.mSecurityHeaderElement.getWrappedObject());
                XmlAppender.addFragment(serializedElement, (Element)securityElem);
                header.addChildElement(securityElem);
            }
            catch (Exception e) {
                this.mLogger.error("Exception in handler: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return true;
    }
}

