/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.projecthusky.xua.communication.clients.ArtifactResolveClient;
import org.projecthusky.xua.communication.clients.impl.AbstractSoapClient;
import org.projecthusky.xua.communication.config.SoapClientConfig;
import org.projecthusky.xua.communication.soap.impl.WsaHeaderValue;
import org.projecthusky.xua.deserialization.impl.ArtifactResponseDeserializerImpl;
import org.projecthusky.xua.exceptions.ClientSendException;
import org.projecthusky.xua.exceptions.DeserializeException;
import org.projecthusky.xua.saml2.ArtifactResolve;
import org.projecthusky.xua.saml2.ArtifactResponse;
import org.projecthusky.xua.saml2.impl.ArtifactResolveImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleArtifactResolveClient
extends AbstractSoapClient<ArtifactResponse>
implements ArtifactResolveClient {
    public SimpleArtifactResolveClient(SoapClientConfig clientConfiguration) {
        this.setConfig(clientConfiguration);
    }

    private HttpEntity getSoapEntity(ArtifactResolve aArtifactResolve) throws ParserConfigurationException, TransformerException, MarshallingException {
        Element envelopElement = this.createEnvelope();
        WsaHeaderValue wsHeaders = new WsaHeaderValue("urn:uuid:" + UUID.randomUUID().toString(), null, null);
        this.createHeader(null, wsHeaders, envelopElement);
        MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)((ArtifactResolveImpl)aArtifactResolve).getWrappedObject());
        Element policyElement = marshaller.marshall((XMLObject)((ArtifactResolveImpl)aArtifactResolve).getWrappedObject());
        this.createBody(policyElement, envelopElement);
        String body = this.createXmlString(envelopElement);
        this.getLogger().debug("SOAP Message\n {}", (Object)body);
        StringEntity stringEntity = new StringEntity(body, "UTF-8");
        stringEntity.setChunked(false);
        return stringEntity;
    }

    @Override
    protected ArtifactResponse parseResponse(String content) throws ClientSendException {
        try {
            ParserPool docBuilder = XMLObjectProviderRegistrySupport.getParserPool();
            Document soapDocument = docBuilder.parse((InputStream)new ByteArrayInputStream(content.getBytes()));
            Node responseNode = soapDocument.getFirstChild().getLastChild().getFirstChild();
            Document doc = docBuilder.newDocument();
            Node importedNode = doc.importNode(responseNode, true);
            doc.appendChild(importedNode);
            ArtifactResponseDeserializerImpl deserializer = new ArtifactResponseDeserializerImpl();
            return deserializer.fromXmlElement(doc.getDocumentElement());
        }
        catch (UnsupportedOperationException | TransformerFactoryConfigurationError | XMLParserException | DeserializeException e) {
            throw new ClientSendException(e);
        }
    }

    public ArtifactResponse send(ArtifactResolve aArtifactResolve) throws ClientSendException {
        try {
            HttpPost post = this.getHttpPost();
            post.setHeader("Content-Type", "text/xml");
            post.setEntity(this.getSoapEntity(aArtifactResolve));
            post.addHeader("Accept", "text/xml");
            return (ArtifactResponse)this.execute(post);
        }
        catch (Exception t) {
            throw new ClientSendException((Throwable)t);
        }
    }
}

