/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.projecthusky.xua.authentication.AuthnRequest;
import org.projecthusky.xua.communication.clients.impl.AbstractHttpFormIdpClient;
import org.projecthusky.xua.communication.config.impl.IdpClientCertificateAuthConfigImpl;
import org.projecthusky.xua.exceptions.ClientSendException;
import org.projecthusky.xua.saml2.Response;

public class IdpClientByCert
extends AbstractHttpFormIdpClient {
    private IdpClientCertificateAuthConfigImpl config;

    public IdpClientByCert(IdpClientCertificateAuthConfigImpl clientConfiguration) {
        this.config = clientConfiguration;
    }

    @Override
    public CloseableHttpClient getHttpClient() throws ClientSendException {
        try {
            SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(this.config.getClientKeyStore(), this.config.getClientKeyStorePassword()).build();
            return HttpClients.custom().setSSLContext(sslContext).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ClientSendException((Throwable)e);
        }
    }

    @Override
    public RequestConfig getRequestConfig() {
        return RequestConfig.custom().build();
    }

    public Response send(AuthnRequest aAuthnRequest) throws ClientSendException {
        try {
            HttpPost post = this.getHttpPost(aAuthnRequest, this.config);
            return this.execute(post);
        }
        catch (Exception t) {
            throw new ClientSendException((Throwable)t);
        }
    }
}

