/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.communication.clients.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Base64;
import java.util.Calendar;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.SystemUtils;
import org.projecthusky.xua.authentication.AuthnRequest;
import org.projecthusky.xua.communication.clients.IdpClient;
import org.projecthusky.xua.communication.config.impl.IdpClientByBrowserAndProtocolHandlerConfigImpl;
import org.projecthusky.xua.deserialization.impl.ResponseDeserializerImpl;
import org.projecthusky.xua.exceptions.ClientSendException;
import org.projecthusky.xua.exceptions.DeserializeException;
import org.projecthusky.xua.exceptions.SerializeException;
import org.projecthusky.xua.saml2.Response;
import org.projecthusky.xua.serialization.impl.AuthnRequestSerializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpClientByBrowserAndProtocolHandler
implements IdpClient {
    private final IdpClientByBrowserAndProtocolHandlerConfigImpl config;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public IdpClientByBrowserAndProtocolHandler(IdpClientByBrowserAndProtocolHandlerConfigImpl clientConfiguration) {
        this.config = clientConfiguration;
    }

    private void openHtmlFormPage(AuthnRequest aAuthnRequest) throws SerializeException, IOException {
        File tempFile;
        AuthnRequestSerializerImpl serializer = new AuthnRequestSerializerImpl();
        byte[] authnByteArray = serializer.toXmlByteArray(aAuthnRequest);
        String samlRequest = Base64.getEncoder().encodeToString(authnByteArray);
        String template = this.readFromJARFile("/template/authnsubmitform.html");
        template = template.replace("@base64samlrequest@", samlRequest);
        template = template.replace("@bsamlrequesttype@", "SAMLRequest");
        template = template.replace("@idpurl@", this.config.getUrl());
        this.logger.debug("html to send to browser: {}", (Object)template);
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
            tempFile = Files.createTempFile(String.format("saml_%s", UUID.randomUUID().toString()), ".html", attr).toFile();
        } else {
            tempFile = File.createTempFile(String.format("saml_%s", UUID.randomUUID().toString()), ".html");
            boolean permission = tempFile.setWritable(false, true);
            if (permission) {
                permission = tempFile.setReadable(true);
            }
            if (permission) {
                permission = tempFile.setExecutable(false);
            }
            if (!permission) {
                Files.deleteIfExists(tempFile.toPath());
                this.logger.error("Application has no permission to change access rights for files");
            }
        }
        try (FileOutputStream os = new FileOutputStream(tempFile);){
            os.write(template.getBytes());
        }
        this.logger.info("Please open {} in your browser", (Object)tempFile.toURI());
        tempFile.deleteOnExit();
    }

    private Response getResponse(String samlReponse) throws DeserializeException {
        byte[] samlReponseBytes = Base64.getDecoder().decode(samlReponse);
        ResponseDeserializerImpl deserializer = new ResponseDeserializerImpl();
        return deserializer.fromXmlByteArray(samlReponseBytes);
    }

    public String readFromJARFile(String filename) throws IOException {
        String line;
        InputStream is = this.getClass().getResourceAsStream(filename);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        isr.close();
        is.close();
        return sb.toString();
    }

    public Object send(AuthnRequest aAuthnRequest) throws ClientSendException {
        try {
            File tempFile = new File(System.getProperty("java.io.tmpdir"), this.config.getProtocolHandlerName() + ".io");
            Files.deleteIfExists(tempFile.toPath());
            this.openHtmlFormPage(aAuthnRequest);
            return this.startWaitForResponse(tempFile);
        }
        catch (Exception t) {
            throw new ClientSendException((Throwable)t);
        }
    }

    private Object startWaitForResponse(File response) throws IOException, ClientSendException, DeserializeException {
        Calendar end = Calendar.getInstance();
        end.add(12, 2);
        try {
            while (!response.exists() && !Calendar.getInstance().after(end)) {
                Thread.sleep(200L);
            }
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted wait for SAML response", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try (BufferedReader in = new BufferedReader(new FileReader(response));){
            String line = in.readLine();
            Files.deleteIfExists(response.toPath());
            if (line == null) {
                throw new ClientSendException("No SAML response found");
            }
            line = URLDecoder.decode(line, "UTF-8");
            this.logger.info("SAML Response: {}", (Object)line);
            if (IdpClientByBrowserAndProtocolHandlerConfigImpl.SamlRequestType.SAMLART.equals((Object)this.config.getSamlRequestType())) {
                String[] urlSplit = line.split("SAMLart");
                String string = urlSplit[1].substring(1);
                return string;
            }
            String[] urlSplit = line.split("SAMLResponse");
            String samlReponse = urlSplit[1].substring(1);
            Response response2 = this.getResponse(samlReponse);
            return response2;
        }
    }
}

