/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.validation.subject;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.projecthusky.common.utils.OptionalUtils;
import org.projecthusky.communication.ch.enums.stable.Role;
import org.projecthusky.xua.validation.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChEprSubjectConfirmationBearerValidator
implements SubjectConfirmationValidator {
    private static final Logger log = LoggerFactory.getLogger(ChEprSubjectConfirmationBearerValidator.class);

    public String getServicedMethod() {
        return "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    }

    public ValidationResult validate(SubjectConfirmation confirmation, @Nullable Assertion assertion, ValidationContext context) {
        Role role = (Role)context.getDynamicParameters().get("saml2.Statement.ChEprRole");
        if (role != Role.ASSISTANT && role != Role.TECHNICAL_USER) {
            return ValidationResult.VALID;
        }
        NameID nameId = confirmation.getNameID();
        if (nameId == null || nameId.getNameQualifier() == null || nameId.getValue() == null) {
            context.getValidationFailureMessages().add("The SubjectConfirmation NameID is missing");
            return ValidationResult.INVALID;
        }
        if (role == Role.ASSISTANT) {
            if (!"urn:gs1:gln".equals(nameId.getNameQualifier())) {
                context.getValidationFailureMessages().add("The assistant GLN is missing in the SubjectConfirmation");
                return ValidationResult.INVALID;
            }
            String assistantGln = (String)context.getDynamicParameters().get("saml2.Conditions.ChEprAssistantGln");
            if (assistantGln == null || !assistantGln.equals(nameId.getValue())) {
                context.getValidationFailureMessages().add("The assistant GLN in the SubjectConfirmation is different from the one in the DelegationRestrictionType Condition");
                return ValidationResult.INVALID;
            }
        } else {
            if (!"urn:e-health-suisse:technical-user-id".equals(nameId.getNameQualifier())) {
                context.getValidationFailureMessages().add("The technical user unique ID is missing in the SubjectConfirmation");
                return ValidationResult.INVALID;
            }
            String technicalUserUniqueId = (String)context.getDynamicParameters().get("saml2.Conditions.ChEprTcuId");
            if (technicalUserUniqueId == null || !technicalUserUniqueId.equals(ValidationUtils.trimOidUrn(nameId.getValue()))) {
                context.getValidationFailureMessages().add("The technical user unique ID in the SubjectConfirmation is different from the one in the DelegationRestrictionType Condition");
                return ValidationResult.INVALID;
            }
        }
        if (role == Role.ASSISTANT) {
            Optional<String> assistantName = this.extractAssistantName(confirmation);
            if (assistantName.isEmpty()) {
                context.getValidationFailureMessages().add("The assistant name is missing in the SubjectConfirmation");
                return ValidationResult.INVALID;
            }
            context.getDynamicParameters().put("saml2.SubjectConfirmation.ChEprAssistantName", assistantName.get());
        }
        return ValidationResult.VALID;
    }

    Optional<String> extractAssistantName(SubjectConfirmation confirmation) {
        return Optional.ofNullable(confirmation.getSubjectConfirmationData()).map(XMLObject::getOrderedChildren).map(OptionalUtils::getListOnlyElement).map(attribute -> (Attribute)OptionalUtils.castOrNull((Object)attribute, Attribute.class)).filter(attribute -> "urn:oasis:names:tc:xspa:1.0:subject:subject-id".equals(attribute.getName())).map(Attribute::getAttributeValues).map(OptionalUtils::getListOnlyElement).map(ValidationUtils::extractXsValue);
    }
}

