/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.validation.statement;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.impl.AttributeValueImpl;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.utils.OptionalUtils;
import org.projecthusky.common.utils.datatypes.Oids;
import org.projecthusky.communication.ch.enums.stable.PurposeOfUse;
import org.projecthusky.communication.ch.enums.stable.Role;
import org.projecthusky.xua.hl7v3.impl.AbstractImpl;
import org.projecthusky.xua.hl7v3.impl.CodedWithEquivalentImpl;
import org.projecthusky.xua.validation.ValidationUtils;

@ThreadSafe
public class ChEprAttributeStatementValidator
implements StatementValidator {
    public static final String ERRMSG_CONTAINS_INVALID_VALUE = "' contains an invalid value";
    public static final String ERRMSG_ATTRIBUTE = "The attribute '";

    public @NonNull QName getServicedStatement() {
        return AttributeStatement.DEFAULT_ELEMENT_NAME;
    }

    public @NonNull ValidationResult validate(Statement statement, Assertion assertion, ValidationContext context) {
        if (!(statement instanceof AttributeStatement)) {
            return ValidationResult.INDETERMINATE;
        }
        AttributeStatement attributeStatement = (AttributeStatement)statement;
        Role role = (Role)context.getDynamicParameters().get("saml2.Statement.ChEprRole");
        for (Attribute attribute : attributeStatement.getAttributes()) {
            ValidationResult result;
            if ((result = (switch (attribute.getName()) {
                case "urn:oasis:names:tc:xspa:1.0:subject:purposeofuse" -> this.validatePurposeOfUse(attribute, context, role);
                case "urn:ihe:iti:xca:2010:homeCommunityId" -> this.validateHomeCommunityId(attribute, context);
                case "urn:oasis:names:tc:xacml:2.0:resource:resource-id" -> this.validateResourceId(attribute, context);
                case "urn:oasis:names:tc:xspa:1.0:subject:subject-id" -> this.validateSubjectId(attribute, context);
                case "urn:oasis:names:tc:xspa:1.0:subject:organization-id" -> this.validateOrganizationsId(attribute, context, role);
                case "urn:oasis:names:tc:xspa:1.0:subject:organization" -> this.validateOrganizationsName(attribute, context, role);
                case "urn:oasis:names:tc:xacml:2.0:subject:role" -> ValidationResult.VALID;
                default -> ValidationResult.INDETERMINATE;
            })) == ValidationResult.VALID) continue;
            return result;
        }
        return ValidationResult.VALID;
    }

    ValidationResult validatePurposeOfUse(Attribute attribute, ValidationContext context, Role role) {
        PurposeOfUse purposeOfUse = Optional.ofNullable(attribute.getAttributeValues()).map(OptionalUtils::getListOnlyElement).map(xmlObject -> (AttributeValueImpl)OptionalUtils.castOrNull((Object)xmlObject, AttributeValueImpl.class)).map(attributeValue -> attributeValue.getUnknownXMLObjects(new QName("urn:hl7-org:v3", "PurposeOfUse"))).map(OptionalUtils::getListOnlyElement).map(xmlObject -> (CodedWithEquivalentImpl)OptionalUtils.castOrNull((Object)xmlObject, CodedWithEquivalentImpl.class)).filter(p -> "2.16.756.5.30.1.127.3.10.5".equals(p.getCodeSystem())).map(AbstractImpl::getCode).map(PurposeOfUse::getEnum).orElse(null);
        if (purposeOfUse == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse' contains an invalid value");
            return ValidationResult.INVALID;
        }
        if (role == Role.HEALTHCARE_PROFESSIONAL && purposeOfUse != PurposeOfUse.NORMAL_ACCESS && purposeOfUse != PurposeOfUse.EMERGENCY_ACCESS || role == Role.ASSISTANT && purposeOfUse != PurposeOfUse.NORMAL_ACCESS && purposeOfUse != PurposeOfUse.EMERGENCY_ACCESS || role == Role.TECHNICAL_USER && purposeOfUse != PurposeOfUse.AUTOMATIC_UPLOAD || role == Role.PATIENT && purposeOfUse != PurposeOfUse.NORMAL_ACCESS || role == Role.REPRESENTATIVE && purposeOfUse != PurposeOfUse.NORMAL_ACCESS || role == Role.DOCUMENT_ADMINISTRATOR && purposeOfUse != PurposeOfUse.NORMAL_ACCESS || role == Role.POLICY_ADMINISTRATOR && purposeOfUse != PurposeOfUse.NORMAL_ACCESS) {
            context.getValidationFailureMessages().add(String.format("The attribute '%s' contains an illegal value: %s is not allowed for %s", "urn:oasis:names:tc:xspa:1.0:subject:purposeofuse", purposeOfUse, role));
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Statement.ChEprPurposeOfUse", purposeOfUse);
        return ValidationResult.VALID;
    }

    ValidationResult validateHomeCommunityId(Attribute attribute, ValidationContext context) {
        String homeCommunityId = Optional.ofNullable(attribute.getAttributeValues()).map(OptionalUtils::getListOnlyElement).map(ValidationUtils::extractXsValue).orElse(null);
        if (homeCommunityId == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:ihe:iti:xca:2010:homeCommunityId' contains an invalid value");
            return ValidationResult.INVALID;
        }
        homeCommunityId = Oids.normalize((String)homeCommunityId);
        context.getDynamicParameters().put("saml2.Statement.ChEprHomeCommunityId", homeCommunityId);
        return ValidationResult.VALID;
    }

    ValidationResult validateResourceId(Attribute attribute, ValidationContext context) {
        String resourceId = Optional.ofNullable(attribute.getAttributeValues()).map(OptionalUtils::getListOnlyElement).map(ValidationUtils::extractXsValue).orElse(null);
        String suffix = "^^^&" + CodeSystems.SWISS_EPR_SPID.getCodeSystemId() + "&ISO";
        if (resourceId == null || !resourceId.endsWith(suffix)) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xacml:2.0:resource:resource-id' contains an invalid value");
            return ValidationResult.INVALID;
        }
        if ((resourceId = resourceId.substring(0, resourceId.length() - suffix.length())).isBlank()) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xacml:2.0:resource:resource-id' contains an invalid value");
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Statement.ChEprPatientEprSpid", resourceId);
        return ValidationResult.VALID;
    }

    ValidationResult validateSubjectId(Attribute attribute, ValidationContext context) {
        String subjectId = Optional.ofNullable(attribute.getAttributeValues()).map(OptionalUtils::getListOnlyElement).map(ValidationUtils::extractXsValue).orElse(null);
        if (subjectId == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:subject-id' contains an invalid value");
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Statement.ChEprSubjectName", subjectId);
        return ValidationResult.VALID;
    }

    ValidationResult validateOrganizationsId(Attribute attribute, ValidationContext context, Role role) {
        boolean shallBeEmpty = role == Role.POLICY_ADMINISTRATOR || role == Role.DOCUMENT_ADMINISTRATOR || role == Role.PATIENT || role == Role.REPRESENTATIVE;
        List<String> organizationIds = Optional.ofNullable(attribute.getAttributeValues()).orElseGet(Collections::emptyList).stream().map(ValidationUtils::extractXsValue).filter(Objects::nonNull).map(Oids::normalize).toList();
        if (shallBeEmpty) {
            if (organizationIds.isEmpty()) {
                return ValidationResult.VALID;
            }
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization-id' must be empty");
            return ValidationResult.INVALID;
        }
        if (context.getDynamicParameters().containsKey("saml2.Statement.ChEprOrganizationsId")) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization-id' shall not appear multiple times");
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Statement.ChEprOrganizationsId", organizationIds);
        return ValidationResult.VALID;
    }

    ValidationResult validateOrganizationsName(Attribute attribute, ValidationContext context, Role role) {
        boolean shallBeEmpty = role == Role.POLICY_ADMINISTRATOR || role == Role.DOCUMENT_ADMINISTRATOR || role == Role.PATIENT || role == Role.REPRESENTATIVE;
        List<String> organizationNames = Optional.ofNullable(attribute.getAttributeValues()).orElseGet(Collections::emptyList).stream().map(ValidationUtils::extractXsValue).filter(Objects::nonNull).map(Oids::normalize).toList();
        if (shallBeEmpty) {
            if (organizationNames.isEmpty()) {
                return ValidationResult.VALID;
            }
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization' must be empty");
            return ValidationResult.INVALID;
        }
        if (context.getDynamicParameters().containsKey("saml2.Statement.ChEprOrganizationsName")) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization' shall not appear multiple times");
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Statement.ChEprOrganizationsName", organizationNames);
        return ValidationResult.VALID;
    }
}

