/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.validation.condition;

import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.NameID;
import org.projecthusky.common.utils.OptionalUtils;
import org.projecthusky.communication.ch.enums.stable.Role;
import org.projecthusky.xua.validation.ValidationUtils;

@ThreadSafe
public class ChEprDelegationRestrictionConditionValidator
implements ConditionValidator {
    public QName getServicedCondition() {
        return DelegationRestrictionType.TYPE_NAME;
    }

    public ValidationResult validate(Condition condition, @Nullable Assertion assertion, ValidationContext context) {
        if (!(condition instanceof DelegationRestrictionType)) {
            return ValidationResult.INDETERMINATE;
        }
        DelegationRestrictionType delegationRestriction = (DelegationRestrictionType)condition;
        Role role = (Role)context.getDynamicParameters().get("saml2.Statement.ChEprRole");
        if (role != Role.ASSISTANT && role != Role.TECHNICAL_USER) {
            context.getValidationFailureMessages().add("The DelegationRestrictionType Condition shall not appear for other extensions than TCU and ASS");
            return ValidationResult.INVALID;
        }
        NameID nameId = Optional.ofNullable(delegationRestriction.getDelegates()).map(OptionalUtils::getListOnlyElement).map(Delegate::getNameID).filter(n -> "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equals(n.getFormat())).filter(n -> n.getValue() != null).orElse(null);
        if (nameId == null) {
            context.getValidationFailureMessages().add("The DelegationRestrictionType Condition doesn't contain a valid NameID");
            return ValidationResult.INVALID;
        }
        if (role == Role.ASSISTANT) {
            if (!"urn:gs1:gln".equals(nameId.getNameQualifier())) {
                context.getValidationFailureMessages().add("The DelegationRestrictionType Condition doesn't contain the assistant GLN");
                return ValidationResult.INVALID;
            }
            context.getDynamicParameters().put("saml2.Conditions.ChEprAssistantGln", nameId.getValue());
            return ValidationResult.VALID;
        }
        if (!"urn:e-health-suisse:technical-user-id".equals(nameId.getNameQualifier())) {
            context.getValidationFailureMessages().add("The DelegationRestrictionType Condition doesn't contain the technical user unique ID");
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Conditions.ChEprTcuId", ValidationUtils.trimOidUrn(nameId.getValue()));
        return ValidationResult.VALID;
    }
}

