/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.validation.condition;

import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Condition;
import org.projecthusky.common.utils.OptionalUtils;

@ThreadSafe
public class ChEprAudienceRestrictionConditionValidator
implements ConditionValidator {
    public QName getServicedCondition() {
        return AudienceRestriction.DEFAULT_ELEMENT_NAME;
    }

    public ValidationResult validate(Condition condition, @Nullable Assertion assertion, ValidationContext context) {
        if (!(condition instanceof AudienceRestriction)) {
            return ValidationResult.INDETERMINATE;
        }
        AudienceRestriction audienceRestriction = (AudienceRestriction)condition;
        String audienceUri = Optional.ofNullable(audienceRestriction.getAudiences()).map(OptionalUtils::getListOnlyElement).map(XSURI::getURI).orElse(null);
        if (audienceUri == null) {
            context.getValidationFailureMessages().add("The AudienceRestriction Condition doesn't contain a valid URI");
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Conditions.ChEprAudience", audienceUri);
        return ValidationResult.VALID;
    }
}

