/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.validation;

import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.saml2.core.impl.AttributeValueImpl;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static @Nullable String extractXsValue(XMLObject xmlObject) {
        return Optional.of(xmlObject).map(object -> {
            if (object instanceof XSString) {
                XSString xsString = (XSString)object;
                return xsString.getValue();
            }
            if (object instanceof XSURI) {
                XSURI xsUri = (XSURI)object;
                return xsUri.getURI();
            }
            if (object instanceof AttributeValueImpl) {
                AttributeValueImpl attributeValue = (AttributeValueImpl)object;
                return attributeValue.getTextContent();
            }
            return null;
        }).filter(Objects::nonNull).map(String::trim).orElse(null);
    }

    public static @Nullable String trimOidUrn(@Nullable String oid) {
        if (oid == null) {
            return null;
        }
        if (oid.startsWith("urn:oid:")) {
            return oid.substring("urn:oid:".length());
        }
        return oid;
    }
}

