/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.validation;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.projecthusky.communication.ch.enums.stable.PurposeOfUse;
import org.projecthusky.communication.ch.enums.stable.Role;

public class ChEprValidationResult {
    private final ValidationResult result;
    private final ValidationContext context;

    public ChEprValidationResult(ValidationResult result, ValidationContext context) {
        this.result = result;
        this.context = context;
    }

    public static ChEprValidationResult valid(ValidationContext context) {
        return new ChEprValidationResult(ValidationResult.VALID, context);
    }

    public static ChEprValidationResult invalid(ValidationContext context, String message) {
        context.getValidationFailureMessages().add(message);
        return new ChEprValidationResult(ValidationResult.INVALID, context);
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public ValidationContext getContext() {
        return this.context;
    }

    public @Nullable Role getRole() {
        return (Role)this.context.getDynamicParameters().get("saml2.Statement.ChEprRole");
    }

    public @Nullable PurposeOfUse getPurposeOfUse() {
        return (PurposeOfUse)this.context.getDynamicParameters().get("saml2.Statement.ChEprPurposeOfUse");
    }

    public @Nullable String getHomeCommunityId() {
        return (String)this.context.getDynamicParameters().get("saml2.Statement.ChEprHomeCommunityId");
    }

    public @Nullable String getResponsibleSubjectId() {
        return (String)this.context.getDynamicParameters().get("saml2.Conditions.ChEprResponsibleSubjectId");
    }

    public @Nullable String getAssistantGln() {
        return (String)this.context.getDynamicParameters().get("saml2.Conditions.ChEprAssistantGln");
    }

    public @Nullable String getAssistantName() {
        return (String)this.context.getDynamicParameters().get("saml2.SubjectConfirmation.ChEprAssistantName");
    }

    public @Nullable String getTechnicalUserId() {
        return (String)this.context.getDynamicParameters().get("saml2.Conditions.ChEprTcuId");
    }

    public @Nullable String getPatientEprSpid() {
        return (String)this.context.getDynamicParameters().get("saml2.Statement.ChEprPatientEprSpid");
    }

    public @Nullable String getSubjectName() {
        return (String)this.context.getDynamicParameters().get("saml2.Statement.ChEprSubjectName");
    }

    public @Nullable String getAudienceRestriction() {
        return (String)this.context.getDynamicParameters().get("saml2.Conditions.ChEprAudience");
    }

    public List<String> getOrganizationsName() {
        return this.context.getDynamicParameters().getOrDefault("saml2.Statement.ChEprOrganizationsName", new ArrayList());
    }

    public List<String> getOrganizationsId() {
        return this.context.getDynamicParameters().getOrDefault("saml2.Statement.ChEprOrganizationsId", new ArrayList());
    }
}

