/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.xua.validation;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.impl.OneTimeUseConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDType;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.impl.AttributeValueImpl;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.opensaml.storage.impl.StorageServiceReplayCache;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.projecthusky.common.utils.OptionalUtils;
import org.projecthusky.communication.ch.enums.stable.Role;
import org.projecthusky.xua.hl7v3.impl.AbstractImpl;
import org.projecthusky.xua.hl7v3.impl.CodedWithEquivalentImpl;
import org.projecthusky.xua.validation.ChEprValidationResult;
import org.projecthusky.xua.validation.condition.ChEprAudienceRestrictionConditionValidator;
import org.projecthusky.xua.validation.condition.ChEprDelegationRestrictionConditionValidator;
import org.projecthusky.xua.validation.statement.ChEprAttributeStatementValidator;
import org.projecthusky.xua.validation.subject.ChEprSubjectConfirmationBearerValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ChEprAssertionValidator {
    private static final Logger log = LoggerFactory.getLogger(ChEprAssertionValidator.class);
    public static final String ERRMSG_ATTRIBUTE = "The attribute '";
    public static final String ERRMSG_IS_MISSING = "' is missing";
    public static final String NAMESPACE_GS1_GLN = "urn:gs1:gln";
    public static final String ERRMSG_SUBJECT_CONFIRMATION_MISSING = "The SubjectConfirmation is missing";
    private final SAML20AssertionValidator validator;

    public ChEprAssertionValidator(@Nullable Duration oneTimeUseConditionExpires, @Nullable SignatureTrustEngine signatureTrustEngine) throws ComponentInitializationException {
        ArrayList<Object> conditionValidators = new ArrayList<Object>();
        conditionValidators.add(new ChEprAudienceRestrictionConditionValidator());
        conditionValidators.add(new ChEprDelegationRestrictionConditionValidator());
        if (oneTimeUseConditionExpires != null) {
            MemoryStorageService storageService = new MemoryStorageService();
            storageService.setId("memory-storage-saml-onetimeuse");
            storageService.setCleanupInterval(Duration.ofSeconds(900L));
            storageService.initialize();
            StorageServiceReplayCache cache = new StorageServiceReplayCache();
            cache.setStorage((StorageService)storageService);
            cache.doInitialize();
            conditionValidators.add(new OneTimeUseConditionValidator((ReplayCache)cache, oneTimeUseConditionExpires));
        }
        if (signatureTrustEngine == null) {
            log.warn("Using ChEprAssertionValidator without signature validator!");
        }
        this.validator = new SAML20AssertionValidator(conditionValidators, List.of(new ChEprSubjectConfirmationBearerValidator()), List.of(new ChEprAttributeStatementValidator()), null, signatureTrustEngine, null);
    }

    public ChEprValidationResult validate(Assertion assertion, @Nullable Map<String, @Nullable Object> staticParameters) throws AssertionValidationException {
        Objects.requireNonNull(assertion, "assertion shall not be null in validate()");
        HashMap<Object, @Nullable Object> newStaticParameters = staticParameters == null ? new HashMap() : new HashMap<String, Object>(staticParameters);
        newStaticParameters.putIfAbsent("saml2.ClockSkew", Duration.ZERO);
        newStaticParameters.put("saml2.SignatureRequired", true);
        ValidationContext validationContext = new ValidationContext(newStaticParameters);
        ValidationResult result = this.validateRole(assertion, validationContext);
        if (result != ValidationResult.VALID) {
            return new ChEprValidationResult(result, validationContext);
        }
        Role role = (Role)validationContext.getDynamicParameters().get("saml2.Statement.ChEprRole");
        result = this.validateSubject(assertion.getSubject(), validationContext, role);
        if (result != ValidationResult.VALID) {
            return new ChEprValidationResult(result, validationContext);
        }
        result = this.validator.validate(assertion, validationContext);
        if (result != ValidationResult.VALID) {
            return new ChEprValidationResult(result, validationContext);
        }
        validationContext.getDynamicParameters().computeIfAbsent("saml2.Statement.ChEprOrganizationsId", key -> new ArrayList());
        validationContext.getDynamicParameters().computeIfAbsent("saml2.Statement.ChEprOrganizationsName", key -> new ArrayList());
        result = this.validateRequiredAssertions(assertion, validationContext, role);
        return new ChEprValidationResult(result, validationContext);
    }

    ValidationResult validateRole(Assertion assertion, ValidationContext context) {
        Attribute roleAttribute = Optional.ofNullable(assertion.getAttributeStatements()).map(OptionalUtils::getListOnlyElement).map(AttributeStatement::getAttributes).orElse(Collections.emptyList()).stream().filter(a -> "urn:oasis:names:tc:xacml:2.0:subject:role".equals(a.getName())).findAny().orElse(null);
        if (roleAttribute == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xacml:2.0:subject:role' is missing");
            return ValidationResult.INVALID;
        }
        Role role = Optional.ofNullable(roleAttribute.getAttributeValues()).map(OptionalUtils::getListOnlyElement).map(xmlObject -> (AttributeValueImpl)OptionalUtils.castOrNull((Object)xmlObject, AttributeValueImpl.class)).map(attributeValue -> attributeValue.getUnknownXMLObjects(new QName("urn:hl7-org:v3", "Role"))).map(OptionalUtils::getListOnlyElement).map(xmlObject -> (CodedWithEquivalentImpl)OptionalUtils.castOrNull((Object)xmlObject, CodedWithEquivalentImpl.class)).filter(r -> "2.16.756.5.30.1.127.3.10.6".equals(r.getCodeSystem())).map(AbstractImpl::getCode).map(Role::getEnum).filter(r -> r != Role.ASSISTANT && r != Role.TECHNICAL_USER).orElse(null);
        if (role == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xacml:2.0:subject:role' contains an invalid value");
            return ValidationResult.INVALID;
        }
        if (role == Role.HEALTHCARE_PROFESSIONAL && assertion.getConditions() != null) {
            for (Condition condition : assertion.getConditions().getConditions(DelegationRestrictionType.TYPE_NAME)) {
                if (!(condition instanceof DelegationRestrictionType)) continue;
                DelegationRestrictionType delegationRestriction = (DelegationRestrictionType)condition;
                String nameQualifier = Optional.ofNullable(delegationRestriction.getDelegates()).map(OptionalUtils::getListOnlyElement).map(Delegate::getNameID).filter(n -> "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equals(n.getFormat())).map(NameIDType::getNameQualifier).orElse(null);
                if (NAMESPACE_GS1_GLN.equals(nameQualifier)) {
                    role = Role.ASSISTANT;
                    continue;
                }
                if ("urn:e-health-suisse:technical-user-id".equals(nameQualifier)) {
                    role = Role.TECHNICAL_USER;
                    continue;
                }
                return ValidationResult.INVALID;
            }
        }
        context.getDynamicParameters().put("saml2.Statement.ChEprRole", role);
        return ValidationResult.VALID;
    }

    ValidationResult validateSubject(@Nullable Subject subject, ValidationContext context, Role role) {
        if (subject == null) {
            context.getValidationFailureMessages().add("The Subject is missing");
            return ValidationResult.INVALID;
        }
        NameID nameId = subject.getNameID();
        if (nameId == null || nameId.getNameQualifier() == null || nameId.getValue() == null) {
            context.getValidationFailureMessages().add("The Subject NameID is missing");
            return ValidationResult.INVALID;
        }
        if (!(role != Role.HEALTHCARE_PROFESSIONAL && role != Role.ASSISTANT && role != Role.TECHNICAL_USER || NAMESPACE_GS1_GLN.equals(nameId.getNameQualifier()))) {
            context.getValidationFailureMessages().add("The healthcare professional GLN is missing in the Subject");
            return ValidationResult.INVALID;
        }
        if (role == Role.POLICY_ADMINISTRATOR && !"urn:e-health-suisse:policy-administrator-id".equals(nameId.getNameQualifier())) {
            context.getValidationFailureMessages().add("The policy administrator ID is missing in the Subject");
            return ValidationResult.INVALID;
        }
        if (role == Role.DOCUMENT_ADMINISTRATOR && !"urn:e-health-suisse:document-administrator-id".equals(nameId.getNameQualifier())) {
            context.getValidationFailureMessages().add("The document administrator ID is missing in the Subject");
            return ValidationResult.INVALID;
        }
        if (role == Role.PATIENT && !"urn:e-health-suisse:2015:epr-spid".equals(nameId.getNameQualifier())) {
            context.getValidationFailureMessages().add("The patient EPR-SPID is missing in the Subject");
            return ValidationResult.INVALID;
        }
        if (role == Role.REPRESENTATIVE && !"urn:e-health-suisse:representative-id".equals(nameId.getNameQualifier())) {
            context.getValidationFailureMessages().add("The representative ID is missing in the Subject");
            return ValidationResult.INVALID;
        }
        context.getDynamicParameters().put("saml2.Conditions.ChEprResponsibleSubjectId", nameId.getValue());
        return ValidationResult.VALID;
    }

    ValidationResult validateRequiredAssertions(Assertion assertion, ValidationContext context, Role role) {
        if (context.getDynamicParameters().getOrDefault("saml2.Statement.ChEprPurposeOfUse", null) == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:purposeofuse' is missing");
            return ValidationResult.INVALID;
        }
        if (context.getDynamicParameters().getOrDefault("saml2.Statement.ChEprOrganizationsName", null) == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization' is missing");
            return ValidationResult.INVALID;
        }
        if (context.getDynamicParameters().getOrDefault("saml2.Statement.ChEprOrganizationsId", null) == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization-id' is missing");
            return ValidationResult.INVALID;
        }
        if (role == Role.HEALTHCARE_PROFESSIONAL || role == Role.ASSISTANT || role == Role.TECHNICAL_USER) {
            if (((List)context.getDynamicParameters().get("saml2.Statement.ChEprOrganizationsName")).isEmpty()) {
                context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization' shall not be empty");
                return ValidationResult.INVALID;
            }
            if (((List)context.getDynamicParameters().get("saml2.Statement.ChEprOrganizationsId")).isEmpty()) {
                context.getValidationFailureMessages().add("The attribute 'urn:oasis:names:tc:xspa:1.0:subject:organization-id' shall not be empty");
                return ValidationResult.INVALID;
            }
        }
        if (context.getDynamicParameters().getOrDefault("saml2.Statement.ChEprHomeCommunityId", null) == null) {
            context.getValidationFailureMessages().add("The attribute 'urn:ihe:iti:xca:2010:homeCommunityId' is missing");
            return ValidationResult.INVALID;
        }
        if (context.getDynamicParameters().getOrDefault("saml2.Conditions.ChEprResponsibleSubjectId", null) == null) {
            context.getValidationFailureMessages().add("The Subject is missing");
            return ValidationResult.INVALID;
        }
        if (role == Role.ASSISTANT) {
            if (context.getDynamicParameters().getOrDefault("saml2.SubjectConfirmation.ChEprAssistantName", null) == null) {
                context.getValidationFailureMessages().add(ERRMSG_SUBJECT_CONFIRMATION_MISSING);
                return ValidationResult.INVALID;
            }
            if (context.getDynamicParameters().getOrDefault("saml2.Conditions.ChEprAssistantGln", null) == null) {
                context.getValidationFailureMessages().add(ERRMSG_SUBJECT_CONFIRMATION_MISSING);
                return ValidationResult.INVALID;
            }
        }
        if (role == Role.TECHNICAL_USER && context.getDynamicParameters().getOrDefault("saml2.Conditions.ChEprTcuId", null) == null) {
            context.getValidationFailureMessages().add(ERRMSG_SUBJECT_CONFIRMATION_MISSING);
            return ValidationResult.INVALID;
        }
        if (assertion.getConditions() == null || assertion.getConditions().getNotBefore() == null) {
            context.getValidationFailureMessages().add("The Condition NotBefore attribute is missing");
            return ValidationResult.INVALID;
        }
        if (assertion.getConditions().getNotOnOrAfter() == null) {
            context.getValidationFailureMessages().add("The Condition NotOnOrAfter attribute is missing");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }
}

