/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.xd.xdm;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Association;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.requests.ProvideAndRegisterDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.requests.RegisterDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorInfo;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.lcm.SubmitObjectsRequest;
import org.openehealth.ipf.platform.camel.ihe.xds.core.converters.EbXML30Converters;
import org.projecthusky.common.utils.ZipCreator;
import org.projecthusky.communication.utils.XdsUtil;
import org.projecthusky.communication.xd.xdm.DocumentContentAndMetadata;
import org.projecthusky.communication.xd.xdm.IndexHtm;
import org.projecthusky.communication.xd.xdm.ReadmeTxt;
import org.projecthusky.communication.xd.xdm.XdmRetrieveResponseTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XdmContents {
    private static final String XDM_INDEX = "INDEX.HTM";
    private static final String XDM_METADATA = "METADATA.XML";
    private static final String XDM_PAYLOAD_ROOT = "IHE_XDM";
    private static final String XDM_README = "README.TXT";
    private IndexHtm indexHtm;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ReadmeTxt readmeTxt;
    private final XdmRetrieveResponseTypeImpl resp = new XdmRetrieveResponseTypeImpl();
    private List<ProvideAndRegisterDocumentSet> txnData = new LinkedList<ProvideAndRegisterDocumentSet>();
    private ZipFile zipFile;

    public XdmContents() {
    }

    public XdmContents(IndexHtm indexHtm, ReadmeTxt readmeTxt) {
        this();
        this.indexHtm = indexHtm;
        this.readmeTxt = readmeTxt;
    }

    public XdmContents(String filePath) {
        this();
        try {
            this.zipFile = new ZipFile(filePath);
        }
        catch (IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("IO Exception during read of " + filePath, (Throwable)e);
        }
    }

    public XdmContents(String indexHtm, String readmeTxt) {
        this();
        try (FileInputStream isIndexHtm = new FileInputStream(indexHtm);){
            this.indexHtm = new IndexHtm(isIndexHtm);
        }
        catch (IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("IO Exception during reading of INDEX.HTM. ", (Throwable)e);
        }
        try (FileInputStream isReadme = new FileInputStream(readmeTxt);){
            this.readmeTxt = new ReadmeTxt(isReadme);
        }
        catch (IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("IO Exception during reading of README.TXT. ", (Throwable)e);
        }
    }

    public XdmContents(ZipFile zipFile) {
        this();
        try {
            if (zipFile == null) {
                throw new IOException();
            }
            this.zipFile = zipFile;
        }
        catch (IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("IO Exception during read of ZipFile", (Throwable)e);
        }
    }

    private String createMetadataXml(ProvideAndRegisterDocumentSet txnData) throws JAXBException {
        SubmitObjectsRequest submit = null;
        for (Document xdsDoc : txnData.getDocuments()) {
            try {
                InputStream is = xdsDoc.getDataHandler().getInputStream();
                try {
                    DocumentEntry docEntry = xdsDoc.getDocumentEntry();
                    String hash = DigestUtils.sha512Hex((InputStream)xdsDoc.getDataHandler().getInputStream());
                    docEntry.setHash(hash);
                    Long size = IOUtils.toByteArray((InputStream)is).length;
                    docEntry.setSize(size);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                this.log.error("Error calculating hash and size. ", (Throwable)e);
                return null;
            }
        }
        submit = EbXML30Converters.convert((ProvideAndRegisterDocumentSet)txnData).getSubmitObjectsRequest();
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{SubmitObjectsRequest.class}).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF8");
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)submit, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public void createZip(OutputStream outputStream, ProvideAndRegisterDocumentSet txnData) {
        this.txnData.add(txnData);
        ZipCreator zip = new ZipCreator(outputStream);
        try {
            zip.addZipItem("IHE_XDM/");
            zip.addZipItem("IHE_XDM/SUBSET01/");
            int i = 0;
            List docList = txnData.getDocuments();
            for (Document xdsDoc : docList) {
                String filePath = XdsUtil.createXdmDocPathAndName(xdsDoc, ++i);
                xdsDoc.getDocumentEntry().setUri(XdsUtil.createXdmDocName(xdsDoc, i));
                zip.addZipItem(xdsDoc.getDataHandler().getInputStream(), filePath);
            }
            zip.addZipItem(this.indexHtm.getInputStream(), XDM_INDEX);
            zip.addZipItem(this.readmeTxt.getInputStream(), XDM_README);
            String metadataXml = this.createMetadataXml(txnData);
            zip.addZipItem(this.getMetadataXmlInputStream(metadataXml), "IHE_XDM/SUBSET01/METADATA.XML");
            zip.closeZip();
        }
        catch (JAXBException | IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("IO Exception during zip creation. ", e);
        }
    }

    public void createZip(String filePath, ProvideAndRegisterDocumentSet txnData) {
        File targetFile = new File(filePath);
        try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
            this.createZip(outputStream, txnData);
        }
        catch (IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("FileNotFoundException during target file creation. ", (Throwable)e);
        }
    }

    private boolean documentsIntegrityCheck() {
        if (this.isSubmitTransactionDataNull(0)) {
            return false;
        }
        DocumentEntry docMetadata = null;
        String docHash = null;
        long docSize = 0L;
        boolean integrityCheck = true;
        for (int i = 0; i < this.txnData.size(); ++i) {
            for (Document doc : this.txnData.get(i).getDocuments()) {
                docMetadata = doc.getDocumentEntry();
                try (InputStream is = doc.getDataHandler().getInputStream();){
                    docHash = DigestUtils.sha512Hex((InputStream)is);
                    docSize = IOUtils.toByteArray((InputStream)is).length;
                }
                catch (IOException e) {
                    this.log.error("IO Exception during zip document integrity check. ", (Throwable)e);
                }
                if (docMetadata.getHash() == null || !docMetadata.getHash().equals(docHash)) {
                    integrityCheck = this.checkHash(docMetadata, docHash, i);
                }
                if (docMetadata.getSize() != null && docMetadata.getSize() == docSize) continue;
                integrityCheck = this.checkSize(docMetadata, docSize, i);
            }
        }
        return integrityCheck;
    }

    private boolean checkHash(DocumentEntry docMetadata, String docHash, int index) {
        if (docMetadata.getHash() == null || !docMetadata.getHash().equals(docHash)) {
            this.log.warn("Integrity check failed for document hash in Submission Set: {} DocumentEntry with UUID: {}", (Object)index, (Object)docMetadata.getEntryUuid());
            this.resp.setStatus(Status.PARTIAL_SUCCESS);
            ErrorInfo error = new ErrorInfo();
            error.setErrorCode(ErrorCode.NON_IDENTICAL_HASH);
            error.setLocation("Document in submission set: " + index + " with Entry UUID: " + docMetadata.getEntryUuid());
            error.setCustomErrorCode("The hash value of the document does not match the hash value, which is provided in the document metadata.");
            error.setSeverity(Severity.WARNING);
            if (this.resp.getErrorList() == null) {
                this.resp.setErrorList(new LinkedList<ErrorInfo>());
            }
            this.resp.getErrorList().add(error);
            return false;
        }
        return true;
    }

    private boolean checkSize(DocumentEntry docMetadata, long docSize, int index) {
        if (docMetadata.getSize() == null || docMetadata.getSize() != docSize) {
            this.log.warn("Integrity check failed for document size in Submission Set: {}  DocumentEntry with UUID: {}", (Object)index, (Object)docMetadata.getEntryUuid());
            this.resp.setStatus(Status.PARTIAL_SUCCESS);
            ErrorInfo error = new ErrorInfo();
            error.setErrorCode(ErrorCode.NON_IDENTICAL_SIZE);
            error.setLocation("Document in submission set: " + index + " with Entry UUID: " + docMetadata.getEntryUuid());
            error.setCustomErrorCode("The size value of the document does not match the size value, which is provided in the document metadata.");
            error.setSeverity(Severity.WARNING);
            if (this.resp.getErrorList() == null) {
                this.resp.setErrorList(new LinkedList<ErrorInfo>());
            }
            this.resp.getErrorList().add(error);
            return false;
        }
        return true;
    }

    public List<DocumentContentAndMetadata> getDocumentAndMetadataList() {
        return this.getDocumentAndMetadataList(0);
    }

    public List<DocumentContentAndMetadata> getDocumentAndMetadataList(int submissionSetNumber) {
        this.lazyLoadCheck();
        if (this.isSubmitTransactionDataNull(submissionSetNumber)) {
            return new LinkedList<DocumentContentAndMetadata>();
        }
        ProvideAndRegisterDocumentSet std = this.txnData.get(submissionSetNumber);
        ArrayList<DocumentContentAndMetadata> docAndMetaList = new ArrayList<DocumentContentAndMetadata>();
        for (Document xdsDoc : std.getDocuments()) {
            DocumentContentAndMetadata docAndMetadataEntry = new DocumentContentAndMetadata(xdsDoc, xdsDoc.getDocumentEntry());
            docAndMetaList.add(docAndMetadataEntry);
        }
        return docAndMetaList;
    }

    public List<Document> getDocumentList() {
        return this.getDocumentList(0);
    }

    public List<Document> getDocumentList(int submissionSetNumber) {
        this.lazyLoadCheck();
        if (this.isSubmitTransactionDataNull(submissionSetNumber)) {
            return new LinkedList<Document>();
        }
        return this.txnData.get(submissionSetNumber).getDocuments();
    }

    public IndexHtm getIndexHtm() {
        this.lazyLoadCheck();
        return this.indexHtm;
    }

    private InputStream getMetadataXmlInputStream(String metadataXml) {
        try {
            ByteArrayOutputStream bOS = new ByteArrayOutputStream();
            bOS.write(metadataXml.getBytes());
            return new ByteArrayInputStream(bOS.toByteArray());
        }
        catch (IOException e) {
            this.log.error("IOException during reading the Metadata.xml InputStream ", (Throwable)e);
            this.resp.setStatus(Status.FAILURE);
            return null;
        }
    }

    public ReadmeTxt getReadmeTxt() {
        this.lazyLoadCheck();
        return this.readmeTxt;
    }

    private String getSubmissionSetDirspec(String zipEntryName) {
        String[] components;
        String result = null;
        if (zipEntryName != null && (components = zipEntryName.split("[\\\\/]"))[0].equals(XDM_PAYLOAD_ROOT)) {
            result = components[1];
        }
        return result;
    }

    public List<ProvideAndRegisterDocumentSet> getXdmContentsAsIpfSubmitTransactionData() {
        this.lazyLoadCheck();
        return this.txnData;
    }

    public XdmRetrieveResponseTypeImpl getXdmContentsAsOhtXdsResponseType() {
        this.lazyLoadCheck();
        for (int i = 0; i < this.txnData.size(); ++i) {
            this.resp.setAttachments(this.txnData.get(i).getDocuments());
        }
        return this.resp;
    }

    private ZipEntry getXDMZipEntry(ZipFile zipFile, String subsetDirspec, String subsetFilespec, boolean isRootFile) {
        ZipEntry result = null;
        Object zipFilespec = !isRootFile ? "IHE_XDM\\" + subsetDirspec + "\\" + subsetFilespec.replace('/', '\\') : subsetDirspec + subsetFilespec.replace('/', '\\');
        result = zipFile.getEntry((String)zipFilespec);
        if (result == null) {
            zipFilespec = ((String)zipFilespec).replace('\\', '/');
            result = zipFile.getEntry((String)zipFilespec);
        }
        return result;
    }

    private boolean isSubmitTransactionDataNull(int submissionSetNumber) {
        if (submissionSetNumber > this.txnData.size() || submissionSetNumber < 0) {
            return true;
        }
        if (this.txnData.isEmpty()) {
            return true;
        }
        return this.txnData.get(submissionSetNumber) == null;
    }

    private void lazyLoadCheck() {
        if (this.txnData != null && this.zipFile != null && this.txnData.isEmpty()) {
            this.loadXdmArchive();
        }
    }

    private void loadXdmArchive() {
        this.resp.setStatus(Status.SUCCESS);
        HashMap<String, ProvideAndRegisterDocumentSet> results = new HashMap<String, ProvideAndRegisterDocumentSet>();
        try {
            List<String> subsetDirspecs = this.unzip();
            if (!subsetDirspecs.isEmpty()) {
                for (String subsetDirspec : subsetDirspecs) {
                    ProvideAndRegisterDocumentSet metadata;
                    if (results.containsKey(subsetDirspec) || (metadata = this.extractMetadata(subsetDirspec)) == null) continue;
                    results.put(subsetDirspec, metadata);
                }
                this.loadDescriptiveFilesFromZipFile();
            }
        }
        catch (IOException e) {
            this.log.error("IO Error during loading of ZIP File. ", (Throwable)e);
            this.resp.setStatus(Status.FAILURE);
            return;
        }
        catch (Exception e) {
            this.log.error("Exception during loading of ZIP File. ", (Throwable)e);
            this.resp.setStatus(Status.FAILURE);
            return;
        }
        this.txnData = results.values().stream().toList();
        this.documentsIntegrityCheck();
    }

    private List<String> unzip() throws IOException {
        LinkedList<String> results = new LinkedList<String>();
        Enumeration<? extends ZipEntry> zipEntries = this.zipFile.entries();
        ZipEntry zipEntry = null;
        int thresholdEntries = 10000;
        int thresholdSize = 1000000000;
        double thresholdRatio = 10.0;
        int totalSizeArchive = 0;
        int totalEntryArchive = 0;
        while (zipEntries.hasMoreElements()) {
            zipEntry = zipEntries.nextElement();
            ++totalEntryArchive;
            int nBytes = -1;
            byte[] buffer = new byte[2048];
            double totalSizeEntry = 0.0;
            try (BufferedInputStream in = new BufferedInputStream(this.zipFile.getInputStream(zipEntry));){
                while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                    totalSizeEntry += (double)nBytes;
                    totalSizeArchive += nBytes;
                    double compressionRatio = totalSizeEntry / (double)zipEntry.getCompressedSize();
                    if (!(compressionRatio > thresholdRatio)) continue;
                    LinkedList<String> linkedList = new LinkedList<String>();
                    return linkedList;
                }
                if (totalSizeArchive > thresholdSize) {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    return linkedList;
                }
                if (totalEntryArchive > thresholdEntries) {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    return linkedList;
                }
                if (zipEntry.isDirectory() || !zipEntry.getName().startsWith(XDM_PAYLOAD_ROOT)) continue;
                results.add(this.getSubmissionSetDirspec(zipEntry.getName()));
            }
        }
        return results;
    }

    private ProvideAndRegisterDocumentSet extractMetadata(String subsetDirspec) throws IOException, JAXBException {
        ZipEntry metadataEntry = this.getXDMZipEntry(this.zipFile, subsetDirspec, XDM_METADATA, false);
        if (metadataEntry == null) {
            this.log.warn("XDM submission set folder '{}' has no metadata file: {}", (Object)subsetDirspec, (Object)XDM_METADATA);
        } else {
            SubmitObjectsRequest request = null;
            try (InputStream in = this.zipFile.getInputStream(metadataEntry);){
                Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{SubmitObjectsRequest.class}).createUnmarshaller();
                request = (SubmitObjectsRequest)unmarshaller.unmarshal(in);
            }
            if (request != null) {
                return this.getProvideAndRegisterDocumentSet(request, subsetDirspec);
            }
        }
        return null;
    }

    private void loadDescriptiveFilesFromZipFile() {
        try (InputStream isIndexHtm = this.zipFile.getInputStream(this.getXDMZipEntry(this.zipFile, "", XDM_INDEX, true));){
            this.indexHtm = new IndexHtm(isIndexHtm);
        }
        catch (IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("IO Exception during loading INDEX.HTM. ", (Throwable)e);
        }
        try (InputStream isReadme = this.zipFile.getInputStream(this.getXDMZipEntry(this.zipFile, "", XDM_README, true));){
            this.readmeTxt = new ReadmeTxt(isReadme);
        }
        catch (IOException e) {
            this.resp.setStatus(Status.FAILURE);
            this.log.error("IO Exception during loading README.TXT. ", (Throwable)e);
        }
    }

    private ProvideAndRegisterDocumentSet getProvideAndRegisterDocumentSet(SubmitObjectsRequest request, String subsetDirspec) throws IOException {
        ProvideAndRegisterDocumentSet docSet = this.importXDMMetadata(request);
        for (Document xdsDocument : docSet.getDocuments()) {
            DocumentEntry xdsDocumentEntry = xdsDocument.getDocumentEntry();
            String subsetFilespec = xdsDocumentEntry.getUri();
            ZipEntry docZipEntry = this.getXDMZipEntry(this.zipFile, subsetDirspec, subsetFilespec, false);
            if (docZipEntry != null) {
                InputStream docStream = this.zipFile.getInputStream(docZipEntry);
                try {
                    ByteArrayDataSource dataSource = new ByteArrayDataSource(docStream, xdsDocumentEntry.getMimeType());
                    xdsDocument.setDataHandler(new DataHandler((DataSource)dataSource));
                    continue;
                }
                finally {
                    if (docStream != null) {
                        docStream.close();
                    }
                    continue;
                }
            }
            this.log.error("{} in XDM submission folder {} has XDSDocumentEntry.URI '{}' that cannot be found in ZIP", new Object[]{XDM_METADATA, subsetDirspec, xdsDocumentEntry.getUri()});
        }
        return docSet;
    }

    public ProvideAndRegisterDocumentSet importXDMMetadata(SubmitObjectsRequest txnData) {
        ProvideAndRegisterDocumentSet provideAndRegisterDocumentSet = new ProvideAndRegisterDocumentSet();
        RegisterDocumentSet submit = EbXML30Converters.convert((SubmitObjectsRequest)txnData);
        for (DocumentEntry documentEntry : submit.getDocumentEntries()) {
            if (documentEntry == null) continue;
            provideAndRegisterDocumentSet.getDocuments().add(new Document(documentEntry, null));
        }
        for (Association association : submit.getAssociations()) {
            if (association == null) continue;
            provideAndRegisterDocumentSet.getAssociations().add(association);
        }
        for (Folder folder : submit.getFolders()) {
            if (folder == null) continue;
            provideAndRegisterDocumentSet.getFolders().add(folder);
        }
        provideAndRegisterDocumentSet.setSubmissionSet(submit.getSubmissionSet());
        return provideAndRegisterDocumentSet;
    }
}

