/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.xd.xdm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import org.openehealth.ipf.commons.ihe.xds.core.requests.ProvideAndRegisterDocumentSet;
import org.projecthusky.common.enums.EhcVersions;
import org.projecthusky.common.model.VendorInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadmeTxt {
    public static final String TEMPLATE_EN = "Vendor name: {0}\nProduct: {1}\nModule: {2}\nVersion: {3}\nContact info: See {4}\nCreation timestamp: {5}\n";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private InputStream inputStream = null;

    public ReadmeTxt(InputStream readmeTxtStream) {
        this.inputStream = readmeTxtStream;
    }

    public ReadmeTxt(ProvideAndRegisterDocumentSet txnData) {
        this(txnData, new VendorInformation());
    }

    public ReadmeTxt(ProvideAndRegisterDocumentSet txnData, VendorInformation vendorInfo) {
        this.log.debug("Creating the README.TXT file");
        Object[] values = new Object[]{vendorInfo.getVendorName(), vendorInfo.getProductName(), vendorInfo.getModuleName(), String.valueOf(EhcVersions.getCurrentVersion()) + ", Release Date " + EhcVersions.getCurrentVersion().getReleaseDate(), vendorInfo.getContactInformation(), new Date().toString()};
        String str = MessageFormat.format(TEMPLATE_EN, values);
        this.inputStream = new ByteArrayInputStream(str.getBytes());
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

