/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.xd.xdm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.openehealth.ipf.commons.ihe.xds.core.requests.ProvideAndRegisterDocumentSet;
import org.projecthusky.common.model.VendorInformation;
import org.projecthusky.common.utils.XdsMetadataUtil;
import org.projecthusky.communication.utils.XdsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHtm {
    public static final String HTML_FOOTER = "</body>\n</html>";
    public static final String HTML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n   <title>Husky XDM Cross-Enterprise Document Media Interchange</title>\n  </head>\n  <body bgcolor=\"#F1FFFE\">\n    <div align=\"center\">\n      <h1>Husky - XDM Cross-Enterprise Document Media Interchange</h1>\n    </div>\n";
    public static final String HTML_SEPARATOR = "<hr />";
    public static final String TEMPLATE_DE = "<h2>Verwaltende Organisation</h2>\n<p>Informationen zu diesem XDM Paket in Deutsch.<br/>\nDieses XDM Paket wurde erstellt von: {0}. </p>\n<p>Siehe <a target=\"_blank\" href=\"https://github.com/project-husky/husky\">{1}</a></p>\n<h2>Inhalt</h2>\n{2}<p>Dieses Paket enth\u00e4lt {3} Dokumente in 1 Submission Set.</p>\n<h3>README Datei</h3>\n<p>Technische Details zu diesem XDM Paket und dessen Hersteller befinden sich hier: <a target=\"_blank\" href=\"README.TXT\">README.TXT</a>.</p>\n";
    public static final String TEMPLATE_EN = "<h2>Institution</h2>\n<p>Information about this XDM volume in english.<br/>\nThis XDM volume was created by {0}. </p>\n<p>See <a target=\"_blank\" href=\"https://github.com/project-husky/husky\">{1}</a></p>\n<h2>Contents</h2>\n{2}<p>This volume contains {3} Documents in 1 Submission Set.</p>\nh3>README File</h3>\n<p>For technical details about this volume and vendor information, see: <a target=\"_blank\" href=\"README.TXT\">README.TXT</a>.</p>\n";
    public static final String TEMPLATE_FR = "<h2>Organisme de gestion</h2>\n<p>Informations sur ce volume XDM en fran\u00e7ais.<br/>\nCe volume XDM a \u00e9t\u00e9 cr\u00e9\u00e9e par {0}. </p>\n<p>Voir <a target=\"_blank\" href=\"https://github.com/project-husky/husky\">{1}</a></p>\n<h2>Contenu</h2>\n{2}<p>Ce volume contient {3} Dokumente en 1 Submission Set.</p>\n<h3>Fichier README</h3>\n<p>Pour plus de informations techniques au sujet de ce volume et le fournisseur, voir: <a target=\"_blank\" href=\"README.TXT\">README.TXT</a>.</p>\n";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private InputStream inputStream = null;

    public IndexHtm(InputStream indexHtmStream) {
        this.inputStream = indexHtmStream;
    }

    public IndexHtm(ProvideAndRegisterDocumentSet txnData) {
        this(txnData, new VendorInformation());
    }

    public IndexHtm(ProvideAndRegisterDocumentSet txnData, VendorInformation vendorInfo) {
        this.log.debug("Creating the Index.htm file");
        Object str = HTML_HEADER;
        Object[] values = new Object[]{vendorInfo.getVendorName(), vendorInfo.getContactInformation(), this.createContents(txnData), txnData.getDocuments().size()};
        str = (String)str + MessageFormat.format(TEMPLATE_EN, values);
        str = (String)str + HTML_SEPARATOR;
        str = (String)str + MessageFormat.format(TEMPLATE_DE, values);
        str = (String)str + HTML_SEPARATOR;
        str = (String)str + MessageFormat.format(TEMPLATE_FR, values);
        str = (String)str + HTML_FOOTER;
        this.inputStream = new ByteArrayInputStream(((String)str).getBytes(StandardCharsets.UTF_8));
    }

    private String createContents(ProvideAndRegisterDocumentSet txnData) {
        StringBuilder contentsStr = new StringBuilder("<h3>Submission-Set 1</h3>\n<p>Patient ID: " + txnData.getSubmissionSet().getPatientId().getId() + " (" + txnData.getSubmissionSet().getPatientId().getAssigningAuthority().getUniversalId() + ")</p>\n<ul>\n");
        int i = 0;
        for (Document xdsDoc : txnData.getDocuments()) {
            ++i;
            if (xdsDoc == null || xdsDoc.getDocumentEntry() == null) continue;
            DocumentEntry docMetadata = xdsDoc.getDocumentEntry();
            String title = XdsMetadataUtil.convertInternationalStringType((LocalizedString)docMetadata.getTitle());
            if (title == null || "".equals(title)) {
                title = XdsUtil.createXdmDocName(xdsDoc, i);
            }
            contentsStr.append("<li>\n");
            contentsStr.append("Document " + i + ": <a target=\"_blank\" href=\"" + XdsUtil.createXdmDocPathAndName(xdsDoc, i) + "\">" + title + "</a>\n");
            contentsStr.append("</li>\n");
        }
        contentsStr.append("</ul>\n");
        return contentsStr.toString();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

