/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.xd.storedquery;

import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.StoredQuery;
import org.projecthusky.common.enums.DateTimeRangeAttributes;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Person;
import org.projecthusky.common.utils.XdsMetadataUtil;
import org.projecthusky.communication.xd.storedquery.AbstractStoredQuery;
import org.projecthusky.communication.xd.storedquery.DateTimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindDocumentsQuery
extends AbstractStoredQuery {
    private static final Logger log = LoggerFactory.getLogger(FindDocumentsQuery.class);

    public FindDocumentsQuery(Identificator patientId, AvailabilityStatus status) {
        org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery findDocumentsQuery = new org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery();
        findDocumentsQuery.setPatientId(XdsMetadataUtil.convertEhcIdentificator((Identificator)patientId));
        findDocumentsQuery.setStatus(List.of(status));
        this.setIpfStoredQuery((StoredQuery)findDocumentsQuery);
    }

    public FindDocumentsQuery(Identificator patientId, AvailabilityStatus status, Code typeCode, Code classCode, Code formatCode) {
        org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery findDocumentsQuery = new org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery();
        findDocumentsQuery.setPatientId(XdsMetadataUtil.convertEhcIdentificator((Identificator)patientId));
        findDocumentsQuery.setStatus(List.of(status));
        findDocumentsQuery.setClassCodes(XdsMetadataUtil.convertEhcCodeToCode(List.of(classCode)));
        findDocumentsQuery.setFormatCodes(XdsMetadataUtil.convertEhcCodeToCode(List.of(formatCode)));
        findDocumentsQuery.setTypeCodes(XdsMetadataUtil.convertEhcCodeToCode(List.of(typeCode)));
        this.setIpfStoredQuery((StoredQuery)findDocumentsQuery);
    }

    public FindDocumentsQuery(Identificator patientId, List<Code> classCodes, List<DateTimeRange> dateTimeRanges, List<Code> practiceSettingCodes, List<Code> healthCareFacilityCodes, List<Code> confidentialityCodes, List<Code> formatCodes, Person authorPerson, AvailabilityStatus status) {
        org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery findDocumentsQuery = new org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery();
        findDocumentsQuery.setPatientId(XdsMetadataUtil.convertEhcIdentificator((Identificator)patientId));
        findDocumentsQuery.setClassCodes(XdsMetadataUtil.convertEhcCodeToCode(classCodes));
        findDocumentsQuery.setPracticeSettingCodes(XdsMetadataUtil.convertEhcCodeToCode(practiceSettingCodes));
        findDocumentsQuery.setHealthcareFacilityTypeCodes(XdsMetadataUtil.convertEhcCodeToCode(healthCareFacilityCodes));
        findDocumentsQuery.setConfidentialityCodes(XdsMetadataUtil.convertEhcCodeToQueryListCode(confidentialityCodes));
        findDocumentsQuery.setFormatCodes(XdsMetadataUtil.convertEhcCodeToCode(formatCodes));
        if (authorPerson != null) {
            findDocumentsQuery.setTypedAuthorPersons(List.of(authorPerson.getIpfPerson()));
        }
        if (dateTimeRanges != null) {
            for (int index = 0; index < dateTimeRanges.size(); ++index) {
                if (dateTimeRanges.get(index) == null) continue;
                if (dateTimeRanges.get(index).getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.SERVICE_START_TIME)) {
                    findDocumentsQuery.getServiceStartTime().setFrom(dateTimeRanges.get(index).getFromAsUsFormattedString());
                    findDocumentsQuery.getServiceStartTime().setTo(dateTimeRanges.get(index).getToAsUsFormattedString());
                    continue;
                }
                if (!dateTimeRanges.get(index).getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.SERVICE_STOP_TIME)) continue;
                findDocumentsQuery.getServiceStopTime().setFrom(dateTimeRanges.get(index).getFromAsUsFormattedString());
                findDocumentsQuery.getServiceStopTime().setTo(dateTimeRanges.get(index).getToAsUsFormattedString());
            }
        }
        findDocumentsQuery.setStatus(List.of(status));
        this.setIpfStoredQuery((StoredQuery)findDocumentsQuery);
    }

    public void addConfidentialityCodes(List<Code> confidentialityCodes) {
        try {
            ((org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery)this.getIpfQuery()).getConfidentialityCodes().getOuterList().add(XdsMetadataUtil.convertEhcCodeToCode(confidentialityCodes));
        }
        catch (ClassCastException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

