/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.xd.storedquery;

import java.time.ZonedDateTime;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.TimeRange;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.projecthusky.common.enums.DateTimeRangeAttributes;

public class DateTimeRange {
    private TimeRange ipfDtr = new TimeRange();
    DateTimeRangeAttributes dateTimeRangeAttribute;

    public DateTimeRange(DateTimeRangeAttributes name, ZonedDateTime from, ZonedDateTime to) {
        this.ipfDtr.setFrom(new Timestamp(from, null));
        this.ipfDtr.setTo(new Timestamp(to, null));
        this.dateTimeRangeAttribute = name;
    }

    public ZonedDateTime getFrom() {
        return this.ipfDtr.getFrom().getDateTime();
    }

    public String getFromAsUsFormattedString() {
        return this.ipfDtr.getFrom().toHL7();
    }

    public TimeRange getOhtDateTimeRange() {
        return this.ipfDtr;
    }

    public ZonedDateTime getTo() {
        return this.ipfDtr.getTo().getDateTime();
    }

    public String getToAsUsFormattedString() {
        return this.ipfDtr.getTo().toHL7();
    }

    public void setFrom(ZonedDateTime from, Timestamp.Precision precision) {
        this.ipfDtr.setFrom(new Timestamp(from, precision));
    }

    public void setTo(ZonedDateTime to, Timestamp.Precision precision) {
        this.ipfDtr.setTo(new Timestamp(to, precision));
    }

    public DateTimeRangeAttributes getDateTimeRangeAttribute() {
        return this.dateTimeRangeAttribute;
    }
}

