/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.utils;

import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.TimeRange;
import org.projecthusky.common.enums.DocumentDescriptor;
import org.projecthusky.communication.DocDescriptor;
import org.projecthusky.communication.xd.storedquery.DateTimeRange;

public class XdsUtil {
    public static TimeRange[] convertEhcDateTimeRange(DateTimeRange[] dtr) {
        if (dtr == null) {
            return new TimeRange[0];
        }
        TimeRange[] dtrArray = new TimeRange[dtr.length];
        int i = 0;
        for (DateTimeRange dt : dtr) {
            dtrArray[i] = dt.getOhtDateTimeRange();
            ++i;
        }
        return dtrArray;
    }

    public static String createXdmDocName(Document xdsDoc, int docNr) {
        String fileName = "DOC";
        DocumentDescriptor dd = DocumentDescriptor.getDocumentDescriptorForMimeType((String)xdsDoc.getDocumentEntry().getMimeType());
        if (dd.toString().startsWith("UNKNOWN!")) {
            String mimeType = dd.toString().replace("UNKNOWN!", "");
            mimeType = mimeType.substring(mimeType.indexOf("!") + 1, mimeType.length());
            dd = DocumentDescriptor.getDocumentDescriptorForMimeType((String)mimeType);
        }
        String fileNameExtension = DocDescriptor.getFileExtension(dd);
        fileName = fileName.concat(String.format("%5s", docNr).replace(' ', '0'));
        fileName = fileName.concat("." + fileNameExtension.toUpperCase());
        return fileName;
    }

    public static String createXdmDocPathAndName(Document xdsDoc, int docNr) {
        return "IHE_XDM/SUBSET01/" + XdsUtil.createXdmDocName(xdsDoc, docNr);
    }

    private XdsUtil() {
    }
}

