/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.utils;

import java.util.Objects;
import java.util.random.RandomGenerator;

public class Traceparent {
    private final byte version;
    private final long traceIdMostSigBits;
    private final long traceIdLeastSigBits;
    private final long parentId;
    private final byte flags;

    public Traceparent(byte version, long traceIdMostSigBits, long traceIdLeastSigBits, long parentId, byte flags) {
        this.version = version;
        this.traceIdMostSigBits = traceIdMostSigBits;
        this.traceIdLeastSigBits = traceIdLeastSigBits;
        this.parentId = parentId;
        this.flags = flags;
        if (version == -1) {
            throw new IllegalArgumentException("Version ff is invalid");
        }
    }

    public static Traceparent random() {
        RandomGenerator random = RandomGenerator.getDefault();
        return new Traceparent(0, random.nextLong(), random.nextLong(), random.nextLong(), 0);
    }

    public static Traceparent parse(String value) {
        String[] parts = value.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid traceparent format");
        }
        if (!Traceparent.isLowercaseHex(parts[0], 2)) {
            throw new IllegalArgumentException("The traceparent version shall be a two characters string");
        }
        byte version = (byte)Integer.parseInt(parts[0], 16);
        if (!Traceparent.isLowercaseHex(parts[1], 32)) {
            throw new IllegalArgumentException("The traceparent traceId shall be a 32 characters string");
        }
        long traceIdMostSigBits = Long.parseUnsignedLong(parts[1].substring(0, 16), 16);
        long traceIdLeastSigBits = Long.parseUnsignedLong(parts[1].substring(16, 32), 16);
        if (!Traceparent.isLowercaseHex(parts[2], 16)) {
            throw new IllegalArgumentException("The traceparent parentId shall be a 16 characters string");
        }
        long parentId = Long.parseUnsignedLong(parts[2], 16);
        if (!Traceparent.isLowercaseHex(parts[3], 2)) {
            throw new IllegalArgumentException("The traceparent flags shall be a two characters string");
        }
        byte flags = (byte)Integer.parseInt(parts[3], 16);
        return new Traceparent(version, traceIdMostSigBits, traceIdLeastSigBits, parentId, flags);
    }

    public int version() {
        return Byte.toUnsignedInt(this.version);
    }

    public String traceId() {
        return String.format("%016x%016x", this.traceIdMostSigBits, this.traceIdLeastSigBits);
    }

    public String parentId() {
        return String.format("%016x", this.parentId);
    }

    public int flags() {
        return Byte.toUnsignedInt(this.flags);
    }

    public String toString() {
        return String.format("%02x-%s-%s-%02x", this.version, this.traceId(), this.parentId(), this.flags);
    }

    public Traceparent withVersion(String version) {
        if (!Traceparent.isLowercaseHex(version, 2)) {
            throw new IllegalArgumentException("The traceparent version shall be a two characters string");
        }
        return new Traceparent((byte)Integer.parseUnsignedInt(version, 16), this.traceIdMostSigBits, this.traceIdLeastSigBits, this.parentId, this.flags);
    }

    public Traceparent withTraceId(String traceId) {
        if (!Traceparent.isLowercaseHex(traceId, 32)) {
            throw new IllegalArgumentException("The traceparent traceId shall be a 32 characters string");
        }
        long traceIdMostSigBits = Long.parseUnsignedLong(traceId.substring(0, 16), 16);
        long traceIdLeastSigBits = Long.parseUnsignedLong(traceId.substring(16, 32), 16);
        return new Traceparent(this.version, traceIdMostSigBits, traceIdLeastSigBits, this.parentId, this.flags);
    }

    public Traceparent withParentId(String parentId) {
        if (!Traceparent.isLowercaseHex(parentId, 16)) {
            throw new IllegalArgumentException("The traceparent parentId shall be a 16 characters string");
        }
        return new Traceparent(this.version, this.traceIdMostSigBits, this.traceIdLeastSigBits, Long.parseUnsignedLong(parentId, 16), this.flags);
    }

    public Traceparent withFlags(String flags) {
        if (!Traceparent.isLowercaseHex(flags, 2)) {
            throw new IllegalArgumentException("The traceparent flags shall be a two characters string");
        }
        return new Traceparent(this.version, this.traceIdMostSigBits, this.traceIdLeastSigBits, this.parentId, (byte)Integer.parseUnsignedInt(flags, 16));
    }

    public Traceparent withRandomParentId() {
        RandomGenerator random = RandomGenerator.getDefault();
        return new Traceparent(this.version, this.traceIdMostSigBits, this.traceIdLeastSigBits, random.nextLong(), this.flags);
    }

    private static boolean isLowercaseHex(String string, int length) {
        if (string.length() != length) {
            return false;
        }
        return string.chars().noneMatch(c -> c < 48 || c > 102);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Traceparent)) {
            return false;
        }
        Traceparent that = (Traceparent)o;
        return this.version == that.version && this.traceIdMostSigBits == that.traceIdMostSigBits && this.traceIdLeastSigBits == that.traceIdLeastSigBits && this.parentId == that.parentId && this.flags == that.flags;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.traceIdMostSigBits, this.traceIdLeastSigBits, this.parentId, this.flags);
    }
}

