/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.utils;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.ihe.gazelle.hl7v3.coctmt090003UV01.COCTMT090003UV01AssignedEntity;
import net.ihe.gazelle.hl7v3.coctmt090003UV01.COCTMT090003UV01Organization;
import net.ihe.gazelle.hl7v3.coctmt150002UV01.COCTMT150002UV01Organization;
import net.ihe.gazelle.hl7v3.coctmt150003UV03.COCTMT150003UV03ContactParty;
import net.ihe.gazelle.hl7v3.coctmt150003UV03.COCTMT150003UV03Organization;
import net.ihe.gazelle.hl7v3.datatypes.AD;
import net.ihe.gazelle.hl7v3.datatypes.AdxpAdditionalLocator;
import net.ihe.gazelle.hl7v3.datatypes.AdxpCity;
import net.ihe.gazelle.hl7v3.datatypes.AdxpCountry;
import net.ihe.gazelle.hl7v3.datatypes.AdxpCounty;
import net.ihe.gazelle.hl7v3.datatypes.AdxpHouseNumberNumeric;
import net.ihe.gazelle.hl7v3.datatypes.AdxpPostalCode;
import net.ihe.gazelle.hl7v3.datatypes.AdxpState;
import net.ihe.gazelle.hl7v3.datatypes.AdxpStreetAddressLine;
import net.ihe.gazelle.hl7v3.datatypes.AdxpStreetName;
import net.ihe.gazelle.hl7v3.datatypes.BL;
import net.ihe.gazelle.hl7v3.datatypes.CD;
import net.ihe.gazelle.hl7v3.datatypes.CE;
import net.ihe.gazelle.hl7v3.datatypes.CS;
import net.ihe.gazelle.hl7v3.datatypes.EN;
import net.ihe.gazelle.hl7v3.datatypes.EnFamily;
import net.ihe.gazelle.hl7v3.datatypes.EnGiven;
import net.ihe.gazelle.hl7v3.datatypes.EnPrefix;
import net.ihe.gazelle.hl7v3.datatypes.EnSuffix;
import net.ihe.gazelle.hl7v3.datatypes.II;
import net.ihe.gazelle.hl7v3.datatypes.INT;
import net.ihe.gazelle.hl7v3.datatypes.IVLTS;
import net.ihe.gazelle.hl7v3.datatypes.ON;
import net.ihe.gazelle.hl7v3.datatypes.PN;
import net.ihe.gazelle.hl7v3.datatypes.ST;
import net.ihe.gazelle.hl7v3.datatypes.TEL;
import net.ihe.gazelle.hl7v3.datatypes.TS;
import net.ihe.gazelle.hl7v3.mccimt000100UV01.MCCIMT000100UV01Agent;
import net.ihe.gazelle.hl7v3.mccimt000100UV01.MCCIMT000100UV01Device;
import net.ihe.gazelle.hl7v3.mccimt000100UV01.MCCIMT000100UV01Organization;
import net.ihe.gazelle.hl7v3.mccimt000100UV01.MCCIMT000100UV01Receiver;
import net.ihe.gazelle.hl7v3.mccimt000100UV01.MCCIMT000100UV01Sender;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Agent;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Device;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Organization;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Receiver;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Sender;
import net.ihe.gazelle.hl7v3.mfmimt700701UV01.MFMIMT700701UV01Custodian;
import net.ihe.gazelle.hl7v3.voc.CommunicationFunctionType;
import net.ihe.gazelle.hl7v3.voc.EntityClassDevice;
import net.ihe.gazelle.hl7v3.voc.EntityClassOrganization;
import net.ihe.gazelle.hl7v3.voc.EntityDeterminer;
import net.ihe.gazelle.hl7v3.voc.HomeAddressUse;
import net.ihe.gazelle.hl7v3.voc.NullFlavor;
import net.ihe.gazelle.hl7v3.voc.ParticipationType;
import net.ihe.gazelle.hl7v3.voc.RoleClassAgent;
import net.ihe.gazelle.hl7v3.voc.RoleClassAssignedEntity;
import net.ihe.gazelle.hl7v3.voc.RoleClassContact;
import net.ihe.gazelle.hl7v3.voc.WorkPlaceAddressUse;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.StringType;

public class PixPdqV3Utils {
    static int sequence = 0;

    private PixPdqV3Utils() {
        throw new IllegalStateException("This is a utility class!");
    }

    public static String[] adToStringArray(AD ad) {
        String[] addressArray = new String[9];
        if (null != ad.getStreetAddressLine() && !ad.getStreetAddressLine().isEmpty()) {
            addressArray[0] = PixPdqV3Utils.getMixedValue(((AdxpStreetAddressLine)ad.getStreetAddressLine().get(0)).getMixed());
        }
        if (null != ad.getAdditionalLocator() && !ad.getAdditionalLocator().isEmpty()) {
            addressArray[1] = PixPdqV3Utils.getMixedValue(((AdxpAdditionalLocator)ad.getAdditionalLocator().get(0)).getMixed());
        }
        if (null != ad.getCity() && !ad.getCity().isEmpty()) {
            addressArray[2] = PixPdqV3Utils.getMixedValue(((AdxpCity)ad.getCity().get(0)).getMixed());
        }
        if (null != ad.getState() && !ad.getState().isEmpty()) {
            addressArray[3] = PixPdqV3Utils.getMixedValue(((AdxpState)ad.getState().get(0)).getMixed());
        }
        if (null != ad.getPostalCode() && !ad.getPostalCode().isEmpty()) {
            addressArray[4] = PixPdqV3Utils.getMixedValue(((AdxpPostalCode)ad.getPostalCode().get(0)).getMixed());
        }
        if (null != ad.getCountry() && !ad.getCountry().isEmpty()) {
            addressArray[5] = PixPdqV3Utils.getMixedValue(((AdxpCountry)ad.getCountry().get(0)).getMixed());
        }
        if (null != ad.getCounty() && !ad.getCounty().isEmpty()) {
            addressArray[8] = PixPdqV3Utils.getMixedValue(((AdxpCounty)ad.getCounty().get(0)).getMixed());
        }
        return addressArray;
    }

    public static II copyII(II sourceII) {
        return PixPdqV3Utils.createII(sourceII.getRoot(), sourceII.getExtension(), sourceII.getAssigningAuthorityName());
    }

    public static AD createAd(Address address) {
        AD addressAD = new AD();
        boolean addressAdded = false;
        if (PixPdqV3Utils.addStreetAddressLinesToAd(address.getLine(), addressAD)) {
            addressAdded = true;
        }
        if (PixPdqV3Utils.addStreetNameToAd(address.getExtensionString("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName"), addressAD)) {
            addressAdded = true;
        }
        if (PixPdqV3Utils.addHouseNumberToAd(address.getExtensionString("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber"), addressAD)) {
            addressAdded = true;
        }
        if (PixPdqV3Utils.addCityToAd(address.getCity(), addressAD)) {
            addressAdded = true;
        }
        if (PixPdqV3Utils.addCountryToAd(address.getCountry(), addressAD)) {
            addressAdded = true;
        }
        if (PixPdqV3Utils.addStateToAd(address.getState(), addressAD)) {
            addressAdded = true;
        }
        if (PixPdqV3Utils.addZipToAd(address.getPostalCode(), addressAD)) {
            addressAdded = true;
        }
        if (address.getUseElement() != null && address.getUseElement().getValue() != null) {
            if (Address.AddressUse.HOME.equals(address.getUseElement().getValue())) {
                addressAD.setUse(HomeAddressUse.H.value());
            } else if (Address.AddressUse.WORK.equals(address.getUseElement().getValue())) {
                addressAD.setUse(WorkPlaceAddressUse.WP.value());
            }
        }
        if (!addressAdded) {
            addressAD = null;
        }
        return addressAD;
    }

    private static boolean addZipToAd(String addressZip, AD addressAD) {
        if (addressZip != null && !addressZip.isEmpty()) {
            AdxpPostalCode zipCode = new AdxpPostalCode();
            zipCode.addMixed((Serializable)((Object)addressZip));
            addressAD.addPostalCode(zipCode);
            return true;
        }
        return false;
    }

    public static boolean addCountyToAd(String addressCounty, AD addressAD) {
        if (addressCounty != null && !addressCounty.isEmpty()) {
            AdxpCounty county = new AdxpCounty();
            county.addMixed((Serializable)((Object)addressCounty));
            addressAD.addCounty(county);
            return true;
        }
        return false;
    }

    private static boolean addStateToAd(String addressState, AD addressAD) {
        if (addressState != null && !addressState.isEmpty()) {
            AdxpState state = new AdxpState();
            state.addMixed((Serializable)((Object)addressState));
            addressAD.addState(state);
            return true;
        }
        return false;
    }

    private static boolean addCountryToAd(String addressCountry, AD addressAD) {
        if (addressCountry != null && !addressCountry.isEmpty()) {
            AdxpCountry country = new AdxpCountry();
            country.addMixed((Serializable)((Object)addressCountry));
            addressAD.addCountry(country);
            return true;
        }
        return false;
    }

    private static boolean addCityToAd(String addressCity, AD addressAD) {
        if (addressCity != null && !addressCity.equals("")) {
            AdxpCity city = new AdxpCity();
            city.addMixed((Serializable)((Object)addressCity));
            addressAD.addCity(city);
            return true;
        }
        return false;
    }

    private static boolean addStreetAddressLinesToAd(List<StringType> addressStreetAddressLines, AD addressAD) {
        for (StringType addressStreetAddress : addressStreetAddressLines) {
            if (addressStreetAddress == null || addressStreetAddress.getValue() == null || ((String)addressStreetAddress.getValue()).equals("")) continue;
            AdxpStreetAddressLine streetAddress = new AdxpStreetAddressLine();
            streetAddress.addMixed((Serializable)addressStreetAddress.getValue());
            addressAD.addStreetAddressLine(streetAddress);
            return true;
        }
        return false;
    }

    private static boolean addStreetNameToAd(String addressStreetName, AD addressAD) {
        if (addressStreetName != null && !addressStreetName.equals("")) {
            AdxpStreetName streetName = new AdxpStreetName();
            streetName.addMixed((Serializable)((Object)addressStreetName));
            addressAD.addStreetName(streetName);
            return true;
        }
        return false;
    }

    private static boolean addHouseNumberToAd(String addressHouseNumber, AD addressAD) {
        if (addressHouseNumber != null && !addressHouseNumber.equals("")) {
            AdxpHouseNumberNumeric houseNumber = new AdxpHouseNumberNumeric();
            houseNumber.addMixed((Serializable)((Object)addressHouseNumber));
            addressAD.addHouseNumberNumeric(houseNumber);
            return true;
        }
        return false;
    }

    public static BL createBL(boolean value) {
        BL bl = new BL();
        bl.setValue(Boolean.valueOf(value));
        return bl;
    }

    public static CD createCD(String code, String codeSystem, String codeSystemName, String displayValue) {
        CD cd = new CD();
        if (null != code && !code.isEmpty()) {
            cd.setCode(code);
        }
        if (null != codeSystem && !codeSystem.isEmpty()) {
            cd.setCodeSystem(codeSystem);
        }
        if (null != codeSystemName && !codeSystemName.isEmpty()) {
            cd.setCodeSystemName(codeSystemName);
        }
        if (null != displayValue && !displayValue.isEmpty()) {
            cd.setDisplayName(displayValue);
        }
        return cd;
    }

    public static CE createCE(String code) {
        return PixPdqV3Utils.createCE(code, "", "", "");
    }

    public static CE createCE(String code, String codeSystem, String codeSystemName, String displayValue) {
        CE ce = new CE();
        if (null != code && !code.isEmpty()) {
            ce.setCode(code);
        }
        if (null != codeSystem && !codeSystem.isEmpty()) {
            ce.setCodeSystem(codeSystem);
        }
        if (null != codeSystemName && !codeSystemName.isEmpty()) {
            ce.setCodeSystemName(codeSystemName);
        }
        if (null != displayValue && !displayValue.isEmpty()) {
            ce.setDisplayName(displayValue);
        }
        return ce;
    }

    public static COCTMT150002UV01Organization createCOCTMT150002UV01Organization(String root) {
        COCTMT150002UV01Organization organization = new COCTMT150002UV01Organization();
        organization.setClassCode(EntityClassOrganization.ORG);
        organization.setDeterminerCode(EntityDeterminer.INSTANCE);
        organization.getId().add(PixPdqV3Utils.createII(root, "", ""));
        return organization;
    }

    public static COCTMT150003UV03Organization createCOCTMT150003UV03Organization(String organizationOID, String organizationName, String telecomValue) {
        return PixPdqV3Utils.createCOCTMT150003UV03Organization(List.of(organizationOID), organizationName, telecomValue);
    }

    public static COCTMT150003UV03Organization createCOCTMT150003UV03Organization(List<String> organizationIdentifiers, String organizationName, String telecomValue) {
        COCTMT150003UV03Organization organization = new COCTMT150003UV03Organization();
        organization.setClassCode(EntityClassOrganization.ORG);
        organization.setDeterminerCode(EntityDeterminer.INSTANCE);
        for (String organizationOID : organizationIdentifiers) {
            organization.getId().add(PixPdqV3Utils.createII(organizationOID, "", ""));
        }
        ON on = new ON();
        on.getMixed().add(organizationName);
        organization.getName().add(on);
        COCTMT150003UV03ContactParty contactParty = new COCTMT150003UV03ContactParty();
        contactParty.setClassCode(RoleClassContact.CON);
        contactParty.getTelecom().add(PixPdqV3Utils.createTEL(telecomValue, ""));
        organization.getContactParty().add(contactParty);
        return organization;
    }

    public static CS createCS(String code) {
        CS cs = new CS();
        cs.setCode(code);
        return cs;
    }

    public static EN createEN(String family, String given, String other, String suffix, String prefix) {
        EN en = new EN();
        if (family != null && !family.isEmpty()) {
            EnFamily familyName = new EnFamily();
            familyName.addMixed((Serializable)((Object)family));
            en.addFamily(familyName);
        }
        if (given != null && !given.isEmpty()) {
            EnGiven givenName = new EnGiven();
            givenName.addMixed((Serializable)((Object)given));
            en.addGiven(givenName);
        }
        if (other != null && !other.isEmpty()) {
            EnGiven givenName2 = new EnGiven();
            givenName2.addMixed((Serializable)((Object)other));
            en.addGiven(givenName2);
        }
        if (suffix != null && !suffix.isEmpty()) {
            EnSuffix suffixname = new EnSuffix();
            suffixname.addMixed((Serializable)((Object)suffix));
            en.addSuffix(suffixname);
        }
        if (prefix != null && !prefix.isEmpty()) {
            EnPrefix prefixname = new EnPrefix();
            prefixname.addMixed((Serializable)((Object)prefix));
            en.addPrefix(prefixname);
        }
        return en;
    }

    public static II createII(String root, String extension, String namespace) {
        II idII = new II();
        if (null != root && !root.isEmpty()) {
            idII.setRoot(root);
        }
        if (null != extension && !extension.isEmpty()) {
            idII.setExtension(extension);
        }
        if (null != namespace && !namespace.isEmpty()) {
            idII.setAssigningAuthorityName(namespace);
        }
        return idII;
    }

    public static II createIINullFlavor(String nullFlavorType) {
        II idII = new II();
        idII.setNullFlavor(NullFlavor.fromValue((String)nullFlavorType));
        return idII;
    }

    public static II createIIwithUniqueExtension(String root) {
        Object extension = String.valueOf(System.currentTimeMillis()) + String.valueOf(++sequence);
        if (((String)extension).length() > 16) {
            extension = ((String)extension).substring(((String)extension).length() - 16, ((String)extension).length());
        }
        return PixPdqV3Utils.createII(root, (String)extension, "");
    }

    public static INT createINT1(Integer i) {
        INT int1 = new INT();
        int1.setValue(i);
        return int1;
    }

    public static IVLTS createIVLTS(String date) {
        IVLTS ivlts = new IVLTS();
        ivlts.setValue(date);
        return ivlts;
    }

    public static MCCIMT000100UV01Device createMCCIMT000100UV01Device(String applicationOID, String facilityOID) {
        MCCIMT000100UV01Device device = new MCCIMT000100UV01Device();
        device.setClassCode(EntityClassDevice.DEV);
        device.setDeterminerCode(EntityDeterminer.INSTANCE);
        device.getId().add(PixPdqV3Utils.createII(applicationOID, "", ""));
        if (facilityOID != null && !facilityOID.equals("")) {
            MCCIMT000100UV01Agent asAgent = new MCCIMT000100UV01Agent();
            asAgent.setClassCode(RoleClassAgent.AGNT);
            MCCIMT000100UV01Organization senderRepresentedOrganization = new MCCIMT000100UV01Organization();
            senderRepresentedOrganization.setClassCode(EntityClassOrganization.ORG);
            senderRepresentedOrganization.setDeterminerCode(EntityDeterminer.INSTANCE);
            senderRepresentedOrganization.getId().add(PixPdqV3Utils.createII(facilityOID, "", ""));
            asAgent.setRepresentedOrganization(senderRepresentedOrganization);
            device.setAsAgent(asAgent);
        }
        return device;
    }

    public static MCCIMT000100UV01Receiver createMCCIMT000100UV01Receiver(String applicationOID, String facilityOID) {
        MCCIMT000100UV01Receiver receiver = new MCCIMT000100UV01Receiver();
        CommunicationFunctionType receivercft = CommunicationFunctionType.RCV;
        receiver.setTypeCode(receivercft);
        receiver.setDevice(PixPdqV3Utils.createMCCIMT000100UV01Device(applicationOID, facilityOID));
        return receiver;
    }

    public static MCCIMT000100UV01Sender createMCCIMT000100UV01Sender(String applicationOID, String facilityOID) {
        MCCIMT000100UV01Sender sender = new MCCIMT000100UV01Sender();
        CommunicationFunctionType senderCFT = CommunicationFunctionType.SND;
        sender.setTypeCode(senderCFT);
        sender.setDevice(PixPdqV3Utils.createMCCIMT000100UV01Device(applicationOID, facilityOID));
        return sender;
    }

    public static MCCIMT000300UV01Device createMCCIMT000300UV01Device(String applicationOID, String facilityOID) {
        MCCIMT000300UV01Device device = new MCCIMT000300UV01Device();
        device.setClassCode(EntityClassDevice.DEV);
        device.setDeterminerCode(EntityDeterminer.INSTANCE);
        device.getId().add(PixPdqV3Utils.createII(applicationOID, "", ""));
        if (facilityOID != null && !facilityOID.equals("")) {
            MCCIMT000300UV01Agent asAgent = new MCCIMT000300UV01Agent();
            asAgent.setClassCode(RoleClassAgent.AGNT);
            MCCIMT000300UV01Organization senderRepresentedOrganization = new MCCIMT000300UV01Organization();
            senderRepresentedOrganization.setClassCode(EntityClassOrganization.ORG);
            senderRepresentedOrganization.setDeterminerCode(EntityDeterminer.INSTANCE);
            senderRepresentedOrganization.addId(PixPdqV3Utils.createII(facilityOID, "", ""));
            asAgent.setRepresentedOrganization(senderRepresentedOrganization);
            device.setAsAgent(asAgent);
        }
        return device;
    }

    public static MCCIMT000300UV01Receiver createMCCIMT000300UV01Receiver(String applicationOID, String facilityOID) {
        MCCIMT000300UV01Receiver receiver = new MCCIMT000300UV01Receiver();
        CommunicationFunctionType receivercft = CommunicationFunctionType.RCV;
        receiver.setTypeCode(receivercft);
        receiver.setDevice(PixPdqV3Utils.createMCCIMT000300UV01Device(applicationOID, facilityOID));
        return receiver;
    }

    public static MCCIMT000300UV01Sender createMCCIMT000300UV01Sender(String applicationOID, String facilityOID) {
        MCCIMT000300UV01Sender sender = new MCCIMT000300UV01Sender();
        CommunicationFunctionType senderCFT = CommunicationFunctionType.SND;
        sender.setTypeCode(senderCFT);
        sender.setDevice(PixPdqV3Utils.createMCCIMT000300UV01Device(applicationOID, facilityOID));
        return sender;
    }

    public static PN createPN(String family, String given, String other, String suffix, String prefix) {
        PN pn = new PN();
        if (family != null && !family.isEmpty()) {
            EnFamily familyName = new EnFamily();
            familyName.addMixed((Serializable)((Object)family));
            pn.addFamily(familyName);
        }
        if (given != null && !given.isEmpty()) {
            EnGiven givenName = new EnGiven();
            givenName.addMixed((Serializable)((Object)given));
            pn.addGiven(givenName);
        }
        if (other != null && !other.isEmpty()) {
            EnGiven givenName2 = new EnGiven();
            givenName2.addMixed((Serializable)((Object)other));
            pn.addGiven(givenName2);
        }
        if (suffix != null && !suffix.isEmpty()) {
            EnSuffix suffixname = new EnSuffix();
            suffixname.addMixed((Serializable)((Object)suffix));
            pn.addSuffix(suffixname);
        }
        if (prefix != null && !prefix.isEmpty()) {
            EnPrefix prefixname = new EnPrefix();
            prefixname.addMixed((Serializable)((Object)prefix));
            pn.addPrefix(prefixname);
        }
        return pn;
    }

    public static PN createPN(String familyName, String givenName, String suffixName, String prefixName) {
        return PixPdqV3Utils.createPN(familyName, givenName, null, suffixName, prefixName);
    }

    @Deprecated
    public static MFMIMT700701UV01Custodian createRegistrationCustodian(String organizationOID, String organizationName) {
        MFMIMT700701UV01Custodian custodian = new MFMIMT700701UV01Custodian();
        custodian.setTypeCode(ParticipationType.CST);
        COCTMT090003UV01AssignedEntity assignedEntity = new COCTMT090003UV01AssignedEntity();
        custodian.setAssignedEntity(assignedEntity);
        assignedEntity.setClassCode(RoleClassAssignedEntity.ASSIGNED);
        assignedEntity.addId(PixPdqV3Utils.createII(organizationOID, "", ""));
        COCTMT090003UV01Organization assignedOrganization = new COCTMT090003UV01Organization();
        assignedEntity.setAssignedOrganization(assignedOrganization);
        assignedOrganization.setClassCode(EntityClassOrganization.ORG);
        assignedOrganization.setDeterminerCode(EntityDeterminer.INSTANCE);
        EN name = new EN();
        name.setMixed(List.of(organizationName));
        assignedOrganization.setName(List.of(name));
        return custodian;
    }

    public static MFMIMT700701UV01Custodian createRegistrationCustodian(List<String> organizationOids, String organizationName) {
        MFMIMT700701UV01Custodian custodian = new MFMIMT700701UV01Custodian();
        custodian.setTypeCode(ParticipationType.CST);
        COCTMT090003UV01AssignedEntity assignedEntity = new COCTMT090003UV01AssignedEntity();
        custodian.setAssignedEntity(assignedEntity);
        assignedEntity.setClassCode(RoleClassAssignedEntity.ASSIGNED);
        for (String organizationOid : organizationOids) {
            assignedEntity.addId(PixPdqV3Utils.createII(organizationOid, "", ""));
        }
        COCTMT090003UV01Organization assignedOrganization = new COCTMT090003UV01Organization();
        assignedEntity.setAssignedOrganization(assignedOrganization);
        assignedOrganization.setClassCode(EntityClassOrganization.ORG);
        assignedOrganization.setDeterminerCode(EntityDeterminer.INSTANCE);
        EN name = new EN();
        name.setMixed(List.of(organizationName));
        assignedOrganization.setName(List.of(name));
        return custodian;
    }

    public static ST createST(String text) {
        ST semanticsText = new ST();
        semanticsText.addMixed((Serializable)((Object)text));
        return semanticsText;
    }

    public static TEL createTEL(String telecomValue, String useValue) {
        TEL returnTEL = new TEL();
        returnTEL.setValue(telecomValue);
        if (null != useValue) {
            if ("WP".equalsIgnoreCase(useValue)) {
                returnTEL.setUse(WorkPlaceAddressUse.WP.value());
            } else if ("HP".equalsIgnoreCase(useValue)) {
                returnTEL.setUse(HomeAddressUse.HP.value());
            }
        }
        return returnTEL;
    }

    public static TS createTS(String value) {
        TS ts = new TS();
        ts.setValue(value);
        return ts;
    }

    public static TS createTSCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return PixPdqV3Utils.createTS(dateFormat.format(new Date()));
    }

    public static String[] enToStringArray(EN en) {
        String[] patientName = new String[5];
        if (null != en.getFamily() && !en.getFamily().isEmpty()) {
            patientName[0] = PixPdqV3Utils.getMixedValue(((EnFamily)en.getFamily().get(0)).getMixed());
        }
        if (null != en.getGiven() && !en.getGiven().isEmpty()) {
            patientName[1] = PixPdqV3Utils.getMixedValue(((EnGiven)en.getGiven().get(0)).getMixed());
            if (en.getGiven().size() > 1) {
                patientName[2] = PixPdqV3Utils.getMixedValue(((EnGiven)en.getGiven().get(1)).getMixed());
            }
        }
        if (null != en.getSuffix() && !en.getSuffix().isEmpty()) {
            patientName[3] = PixPdqV3Utils.getMixedValue(((EnSuffix)en.getSuffix().get(0)).getMixed());
        }
        if (null != en.getPrefix() && !en.getPrefix().isEmpty()) {
            patientName[4] = PixPdqV3Utils.getMixedValue(((EnPrefix)en.getPrefix().get(0)).getMixed());
        }
        return patientName;
    }

    private static String getMixedValue(List<Serializable> mixed) {
        Serializable serializable;
        String returnValue = "";
        if (!mixed.isEmpty() && (serializable = mixed.get(0)) instanceof String) {
            String mixedStr;
            returnValue = mixedStr = (String)((Object)serializable);
        }
        return returnValue;
    }

    public static String getTelecomByUseCode(List<TEL> telecom, String useCode) {
        String telephoneNumber = "";
        for (int i = 0; i < telecom.size(); ++i) {
            TEL currentTEL = telecom.get(i);
            if (null == currentTEL.getUse() || currentTEL.getUse().isEmpty() || !currentTEL.getUse().equalsIgnoreCase(useCode)) continue;
            telephoneNumber = currentTEL.getValue();
            break;
        }
        return telephoneNumber;
    }

    public static String[] iiToStringArray(II id) {
        String[] array = new String[]{id.getExtension(), id.getAssigningAuthorityName(), id.getRoot(), ""};
        return array;
    }

    public static String[] pnToStringArray(PN pn) {
        String[] patientName = new String[5];
        if (null != pn.getFamily() && !pn.getFamily().isEmpty()) {
            patientName[0] = PixPdqV3Utils.getMixedValue(((EnFamily)pn.getFamily().get(0)).getMixed());
        }
        if (null != pn.getGiven() && !pn.getGiven().isEmpty()) {
            patientName[1] = PixPdqV3Utils.getMixedValue(((EnGiven)pn.getGiven().get(0)).getMixed());
            if (pn.getGiven().size() > 1) {
                patientName[2] = PixPdqV3Utils.getMixedValue(((EnGiven)pn.getGiven().get(1)).getMixed());
            }
        }
        if (null != pn.getSuffix() && !pn.getSuffix().isEmpty()) {
            patientName[3] = PixPdqV3Utils.getMixedValue(((EnSuffix)pn.getSuffix().get(0)).getMixed());
        }
        if (null != pn.getPrefix() && !pn.getPrefix().isEmpty()) {
            patientName[4] = PixPdqV3Utils.getMixedValue(((EnPrefix)pn.getPrefix().get(0)).getMixed());
        }
        return patientName;
    }
}

